#!/bin/bash
# The first argument is Slakh2100 dataset directory (optional).
# The second argument is workspace directory (optional).

if [ $# -eq 0 ]; then
    MUSDB18_DATASET_DIR="./datasets/musdb18/dataset_root"    # Default dataset directory
    WORKSPACE="./workspaces/jointist"    # Default workspace directory
elif [ $# -eq 1 ]; then
    MUSDB18_DATASET_DIR=$1    
    WORKSPACE="./workspaces/jointist"
elif [ $# -eq 2 ]; then
    MUSDB18_DATASET_DIR=$1
    WORKSPACE=$2
fi

for SOURCE_TYPE in 'vocals' 'bass' 'drums' 'other'
do
    WAVEFORM_HDF5S_DIR=$WORKSPACE"/hdf5s/musdb18_${SOURCE_TYPE}/waveforms"
    mkdir $WAVEFORM_HDF5S_DIR -p

    # Pack audio files into hdf5 files.
    python3 jointist/dataset_creation/create_musdb18.py pack_audios_to_hdf5s \
        --dataset_root=$MUSDB18_DATASET_DIR \
        --source_type=$SOURCE_TYPE \
        --hdf5s_dir=$WAVEFORM_HDF5S_DIR
done
