export HTTP_PROXY="http://bj-rd-proxy.byted.org:3128"
export HTTPS_PROXY=$HTTP_PROXY
export NO_PROXY="localhost,127.0.0.1,10.*.*.*,*.byted.org"
 
# # Download and install Anaconda
hdfs dfs -get hdfs://haruna/home/byte_speech_sv/user/kinwaicheuk/Anaconda3-2021.05-Linux-x86_64.sh
bash Anaconda3-2021.05-Linux-x86_64.sh -b -f

source ~/anaconda3/etc/profile.d/conda.sh # allow to use conda inside this bash script
yes | conda create -n jointist python=3.8.10
conda init # make conda accessible from terminal

conda activate jointist
pip install -r requirements.txt

echo downloading example songs...
hdfs dfs -get hdfs://haruna/home/byte_speech_sv/user/kinwaicheuk/Jointist_Demo/songs.tar.gz # downloading example mp3s
echo downloading model weights...
hdfs dfs -get hdfs://haruna/home/byte_speech_sv/user/kinwaicheuk/Jointist_Demo/* # downloadaing model weights
echo download finished!
echo unzipping songs and model weights...
tar -xvf songs.tar.gz
tar -xvf weights.tar.gz
echo unzipping finished!

# To transcribe your own songs, you can specify the location of your audio files
# In this example, the demo songs are located at /opt/tiger/kinwai/jointist/songs
# Other audio formats such as wav and flac are all supported (torchaudio.load is the loading backend)
# To load other audio formats, simply change the audio_ext
echo ===========example code for transcription==============
echo python pred_jointist.py audio_path=/opt/tiger/kinwai/jointist/songs audio_ext=mp3
python pred_jointist.py audio_path=/opt/tiger/kinwai/jointist/songs audio_ext=mp3

echo ===========example code for transcription+source separation==============
echo python pred_jointist_ss.py audio_path=/opt/tiger/kinwai/jointist/songs audio_ext=mp3
python pred_jointist_ss.py audio_path=/opt/tiger/kinwai/jointist/songs audio_ext=mp3