# PARL
## Predictability-Aware Reinforcement Learning

We implemented PARL agents based on Stable Baselines3 agents. Algorithms currently supported are CAPPO and CASAC. The hyperparemeters used across the paper can be found in the .yml parameter files in the root folder.
To train PARL agents with pre-tuned hyperparameters, simpy run

python train_parl.py env_name steps k seed algorithm

Example:

python train_parl.py HalfCheetah-v4 100000 0.5 0 CAPPO

## Loading agents and evaluating entropies + rewards

The script load_agents.py loads a pair of agents and plots the trajectories. To run it, place the models and environment files you want to test in a 'folder' and run:

python load_agents.py folder

We supply the trained models used to generate the trajectory plots in Section 5 of the paper, in the folder 'paper_models'.


## Conda Env

We provide a yml file with the environment dependencies. You can install it via:
conda env create -f parl.yml

and activate it:

conda activate parl
