# Graph Matching Networks

This is a PyTorch re-implementation of the following ICML 2019 paper. If you feel this project helpful to your research, please give a star.

> Yujia Li, Chenjie Gu, Thomas Dullien, Oriol Vinyals, Pushmeet Kohli. *Graph Matching Networks for Learning the Similarity of Graph Structured Objects*. ICML 2019. [[arXiv\]](https://arxiv.org/abs/1904.12787).

## Requirements

torch >= 1.2.0

networkx>=2.3  

numpy>=1.16.4  

six>=1.12

## Usage

The code includes:

- an example implementation of the model,
- an example graph similarity learning task,
- an example training loop.


Please use `./run.sh` to run.

## References:

[Deepmind-research](https://github.com/deepmind/deepmind-research/tree/master/graph_matching_networks) (using TensorFlow and Sonnet)
