# 🔍 RePIC: Reinforced Post-Training for Personalizing Multi-Modal Language Models (NeurIPS 2025 Submission #5072)

> ⛔ **Note**: This repository is intended for **reviewers only**. The code and data are provided strictly for reviewing purposes.

## 📦 Installation Guide (Inference Only)

Our codebase has been tested on **CUDA 12.4**. Please follow the instructions below:

```bash
# Create and activate conda environment
conda create -n RePIC python=3.11 -y
conda activate RePIC

# Install CUDA 12.4 toolkit
conda install nvidia/label/cuda-12.4.0::cuda-toolkit

# Setup permissions and dependencies
chmod 755 *.sh
bash ./setup.sh

# Set up kernel
conda install ipykernel -y
python -m ipykernel install --user --name RePIC --display-name RePIC
```

> ⚠️ If installation fails, it may be due to issues with the `flash_attention_2` library.  
Please refer to the official [Qwen2.5-VL repository](https://github.com/QwenLM/Qwen2.5-VL) for alternative inference guidance.

We have only tested inference with the **`flash_attention_2`** setup. Logs and example outputs are included in [`inference_example.ipynb`](./inference_example.ipynb).

---

## 🖼️ Visualization Example

You can run the `gradio_example_2_concept.ipynb` and `gradio_example_4_concept.ipynb` notebooks for **visualization with pre-generated captions** without installing the environmental settings.

> 📌 Note: We curated the database and query images for a 4-concept setting, and for a 2-concept setting, all evaluation images are credited to [RAP-MLLM](https://arxiv.org/abs/2410.13360).

Feel free to try it out!

---

## 🧪 Inference Example

The `inference_example.ipynb` notebook contains:
- Scripts to run **inference with your own queries**
- Reproducible code for **Figure 1, Figure A.1 and Figure A.2** in our paper

---

## 🏋️ Training & Evaluation

Training and evaluation code is currently **under construction**.  
We plan to release it as open source in the near future!

---

## 📁 Data Download

You can download our **5K dataset** used for training and evaluation here:

📎 [Google Drive Link](https://drive.google.com/file/d/1DKPmLI58NZUpSUFEUgzpUmMKKPK3Oguc/view?usp=sharing)

> ✅ Note: We only used a **2K subset** of this dataset for training purposes.

---

## 🙏 Acknowledgements

We gratefully acknowledge the following open-source repositories and resources that supported our work:

- 🔗 [VLM-R1 (Om-AI-Lab)](https://github.com/om-ai-lab/VLM-R1)  
- 🔗 [Qwen2.5-VL (QwenLM)](https://github.com/QwenLM/Qwen2.5-VL)