task_registry = {}

def register(name=None):
    def decorator(func):
        task_name = name if name else func.__name__
        task_registry[task_name] = func
        return func
    return decorator

# Import all task modules to execute the decorators
from . import addition, multiplication, maze, copy, boolean  # Import other task modules similarly

# Expose the registry
__all__ = ['task_registry', 'register']
