from numpy.random import Generator
from tasks import register
import string
import numpy as np

@register()
def parity(rng: Generator, l: list[int]):
    l = rng.integers(*l)
    inp = rng.integers(0, 2, size=l)
    return ''.join(map(str, inp)) + '=', str(sum(inp) % 2), None

@register()
def majority(rng: Generator, l: list[int]):
    l = rng.integers(*l)
    inp = rng.integers(0, 2, size=l)
    return ''.join(map(str, inp)) + '=', str(int(sum(inp) > l // 2)), None
