problem_data = [
  {
    "question": "A stock broker followed the stock prices of a certain set of companies. On Tuesday, how much more did Jonas Incorporated's stock cost than White and Company's stock?",
    "choices": null,
    "answer": "8",
    "unit": "$",
    "table_title": "Stock prices",
    "table": "Company | Tuesday | Wednesday\nThompson Corporation | $6 | $20\nJonas Incorporated | $10 | $7\nWhite and Company | $2 | $14\nWatson and Partners | $17 | $19\nComputer Data Company | $6 | $3",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Tuesday column. Find the numbers in this column for Jonas Incorporated and White and Company.\n\nJonas Incorporated: $10.00\nWhite and Company: $2.00\n\nNow subtract:\n\n$10.00 \u2212 $2.00 = $8.00\n\nOn Tuesday Jonas Incorporated's stock cost $8 more than White and Company's stock.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "25151",
    "path": "data"
  },
  {
    "question": "How much money does Kylie need to buy a ticket for a Mediterranean cruise and a ticket for an Australian cruise?",
    "choices": null,
    "answer": "4,761",
    "unit": "$",
    "table_title": null,
    "table": "ticket for an Australian cruise | $1,826.00\nticket for a Mediterranean cruise | $2,935.00\nticket for a Caribbean cruise | $3,876.00\nticket for an Alaskan cruise | $2,161.00\nticket for a Hawaiian cruise | $2,539.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a ticket for a Mediterranean cruise and the price of a ticket for an Australian cruise:\n\n$2,935.00 + $1,826.00 = $4,761.00\n\nKylie needs $4,761.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "30042",
    "path": "data"
  },
  {
    "question": "A girl compared the ages of her cousins. Which cousin is the oldest?",
    "choices": [
      "Isabella",
      "Leslie",
      "Marshall",
      "Anne"
    ],
    "answer": "Leslie",
    "unit": null,
    "table_title": "Ages of cousins",
    "table": "Name | Age (years)\nIsabella | 15\nLeslie | 17\nMarshall | 11\nAnne | 12",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 17.\n\nNow find the corresponding name. Leslie corresponds to 17.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "24203",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $1,350, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$840 | 20,400 | 19,300\n$1,010 | 16,100 | 19,500\n$1,180 | 11,800 | 19,700\n$1,350 | 7,500 | 19,900\n$1,520 | 3,200 | 20,100",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $1,350, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "13172",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the train depart from the restaurant district?",
    "choices": [
      "1:05 P.M.",
      "11:10 A.M.",
      "11:05 A.M.",
      "10:20 A.M."
    ],
    "answer": "11:05 A.M.",
    "unit": null,
    "table_title": "Subway train schedule",
    "table": "Location | Time\ndowntown | 10:15 A.M.\nwaterfront | 10:20 A.M.\nrestaurant district | 11:05 A.M.\ntheater district | 11:10 A.M.\nuniversity | 11:25 A.M.\nbaseball stadium | 11:35 A.M.\nfootball stadium | 12:25 P.M.\nindustrial district | 1:05 P.M.",
    "row_num": 9,
    "column_num": 2,
    "solution": "Find the restaurant district on the schedule. Find the departure time for the restaurant district.\n\nrestaurant district: 11:05 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "14872",
    "path": "data"
  },
  {
    "question": "Each box has 5 cranberry bars. How many cranberry bars are in 3 boxes?",
    "choices": null,
    "answer": "15",
    "unit": null,
    "table_title": null,
    "table": "Number of boxes | Number of cranberry bars\n1 | 5\n2 | 10\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 15 cranberry bars in 3 boxes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "15832",
    "path": "data"
  },
  {
    "question": "A farmer wrote down how many kilograms of cherries were sold in the past 5 days. What is the mode of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Cherries sold",
    "table": "Day | Kilograms\nMonday | 10\nTuesday | 7\nWednesday | 10\nThursday | 7\nFriday | 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 7, 10, 7, 7\n\nFirst, arrange the numbers from least to greatest:\n\n7, 7, 7, 10, 10\n\nNow count how many times each number appears.\n\n7 appears 3 times.\n10 appears 2 times.\n\nThe number that appears most often is 7.\n\nThe mode is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "16524",
    "path": "data"
  },
  {
    "question": "Darnel bought 4+4/5 kilograms of coriander. How much did he spend?",
    "choices": null,
    "answer": "14.40",
    "unit": "$",
    "table_title": null,
    "table": "cumin | $3 per kg\nturmeric | $2 per kg\npaprika | $4 per kg\ncoriander | $3 per kg\npepper | $3 per kg\ncinnamon | $3 per kg",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the coriander. Multiply the price per kilogram by the number of kilograms.\n$3 \u00d7 4\\frac{4}{5} = $3 \u00d7 4.8 = $14.40\nHe spent $14.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "7946",
    "path": "data"
  },
  {
    "question": "The Japanese club made a table showing the ages of its members. What is the median of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Club members' ages",
    "table": "Name | Age (years)\nFernando | 7\nAriel | 10\nVicky | 8\nLiam | 6\nTim | 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 10, 8, 6, 7\n\nFirst, arrange the numbers from least to greatest:\n\n6, 7, 7, 8, 10\n\nNow find the number in the middle.\n\n6, 7, 7, 8, 10\n\nThe number in the middle is 7.\n\nThe median is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "30457",
    "path": "data"
  },
  {
    "question": "How much money does Frank need to buy a loaf of bread and a package of chocolate cookies?",
    "choices": null,
    "answer": "6.59",
    "unit": "$",
    "table_title": null,
    "table": "bag of chocolate chips | $2.79\nloaf of bread | $2.59\npackage of chocolate cookies | $4.00\nbox of lemon cookies | $2.86",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a loaf of bread and the price of a package of chocolate cookies:\n\n$2.59 + $4.00 = $6.59\n\nFrank needs $6.59.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "19807",
    "path": "data"
  },
  {
    "question": "Some companies compared how many phone calls they made. Which company made the fewest phone calls?",
    "choices": [
      "Tad's Coffee Company",
      "Northside Cycles",
      "Despain Accounting",
      "Brave New Day Corporation"
    ],
    "answer": "Northside Cycles",
    "unit": null,
    "table_title": "Phone calls",
    "table": "Company | Number of phone calls\nTad's Coffee Company | 851\nNorthside Cycles | 815\nDespain Accounting | 818\nBrave New Day Corporation | 888",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 815.\n\nNow find the corresponding company. Northside Cycles corresponds to 815.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "35188",
    "path": "data"
  },
  {
    "question": "Gabriel looked at his calendar to figure out how much time he spent babysitting each month. What is the range of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Hours of babysitting",
    "table": "Month | Hours\nApril | 4\nMay | 6\nJune | 8\nJuly | 7\nAugust | 2\nSeptember | 3\nOctober | 9\nNovember | 2",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n4, 6, 8, 7, 2, 3, 9, 2\n\nFirst, find the greatest number. The greatest number is 9.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n9 \u2212 2 = 7\n\nThe range is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "5879",
    "path": "data"
  },
  {
    "question": "Reba has $0.13. How much money will Reba have left if she buys a green colored pencil and a purple colored pencil?",
    "choices": null,
    "answer": "0.06",
    "unit": "$",
    "table_title": null,
    "table": "purple colored pencil | $0.05\nthin blue marker | $0.06\npackage of crayons | $0.07\ngreen colored pencil | $0.02\nred ballpoint pen | $0.07\npink eraser | $0.09",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of a green colored pencil and a purple colored pencil.\n\n$0.02 + $0.05 = $0.07\n\nNow subtract the total cost from the starting amount.\n\n$0.13 - $0.07 = $0.06\n\nReba will have $0.06 left.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "33958",
    "path": "data"
  },
  {
    "question": "How much more does a pair of khaki pants cost than a red sweater?",
    "choices": null,
    "answer": "1.26",
    "unit": "$",
    "table_title": null,
    "table": "pair of khaki pants | $11.91\nred sweater | $10.65\npair of brown pants | $19.25\ngray sweatshirt | $17.45",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a red sweater from the price of a pair of khaki pants.\n\n$11.91 - $10.65 = $1.26\n\nA pair of khaki pants costs $1.26 more than a red sweater.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "26571",
    "path": "data"
  },
  {
    "question": "The county released data about how many schools there are in each town. What is the range of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Schools in each town",
    "table": "Town | Number of schools\nRiverside | 4\nGreenwood | 7\nMarion | 9\nAshland | 3\nColumbia | 6\nSalem | 4\nWatertown | 7",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n4, 7, 9, 3, 6, 4, 7\n\nFirst, find the greatest number. The greatest number is 9.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n9 \u2212 3 = 6\n\nThe range is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "2885",
    "path": "data"
  },
  {
    "question": "A curious student at Oakland High compared the amount of homework recently assigned by each of his teachers. On Wednesday, how much more homework did Ms. Bernard assign than Mrs. Pavlova?",
    "choices": null,
    "answer": "11",
    "unit": "minutes",
    "table_title": "Minutes of homework",
    "table": "Teacher | Wednesday | Thursday\nMrs. Pavlova | 9 | 20\nMr. Gutierrez | 17 | 18\nMr. Paola | 11 | 19\nMr. Kim | 13 | 6\nMs. Bernard | 20 | 9",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Wednesday column. Find the numbers in this column for Ms. Bernard and Mrs. Pavlova.\n\nMs. Bernard: 20\nMrs. Pavlova: 9\n\nNow subtract:\n\n20 \u2212 9 = 11\n\nOn Wednesday, Ms. Bernard assigned 11 more minutes of homework than Mrs. Pavlova.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "10662",
    "path": "data"
  },
  {
    "question": "At their family reunion, the Santiago family recorded everyone's age. What is the age of the oldest person?",
    "choices": null,
    "answer": "79",
    "unit": "years old",
    "table_title": "Ages",
    "table": "Stem | Leaf \n4 | 3, 4\n5 | 0, 2, 4, 6\n6 | 3\n7 | 0, 0, 0, 5, 9",
    "row_num": 5,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 7.\n\nNow find the highest leaf in the last row. The highest leaf is 9.\n\nThe age of the oldest person has a stem of 7 and a leaf of 9. Write the stem first, then the leaf: 79.\n\nThe age of the oldest person is 79 years old.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "277",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "x | y\n16 | 18\n13 | 13\n1 | 10\n13 | 0",
    "row_num": 5,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nThe x-value 13 is paired with multiple y-values, so the relation is not a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "27864",
    "path": "data"
  },
  {
    "question": "As part of a project for health class, Elise surveyed local delis about the kinds of sandwiches sold. How many sandwiches did Sandwich City sell?",
    "choices": null,
    "answer": "22",
    "unit": "sandwiches",
    "table_title": "Sandwich sales",
    "table": "Shop | Tuna sandwiches | Vegetarian sandwiches\nSandwich City | 19 | 3\nAlexandra's Deli | 1 | 7\nJoe's Diner | 2 | 15",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the row for Sandwich City. Add the numbers in the Sandwich City row.\n\nAdd:\n\n19 + 3 = 22\n\nSandwich City sold 22 sandwiches.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "31944",
    "path": "data"
  },
  {
    "question": "Some candy companies compared how many pieces of candy they have produced. Which company has produced the most candy?",
    "choices": [
      "Goodman Candies",
      "Sugary Candies",
      "Tasty Treats",
      "Chocolate and More"
    ],
    "answer": "Goodman Candies",
    "unit": null,
    "table_title": "Candy production",
    "table": "Company | Number of pieces of candy\nGoodman Candies | 881\nSugary Candies | 867\nTasty Treats | 876\nChocolate and More | 868",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 881.\n\nNow find the corresponding company. Goodman Candies corresponds to 881.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "20642",
    "path": "data"
  },
  {
    "question": "What is the total cost for 3 pounds of oysters, 4 pounds of mussels, and 3 pounds of shrimp?",
    "choices": null,
    "answer": "47",
    "unit": "$",
    "table_title": null,
    "table": "crab meat | $5 per lb\nlobster meat | $12 per lb\nshrimp | $4 per lb\noysters | $5 per lb\nmussels | $5 per lb",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the oysters. Multiply:\n\n$5 \u00d7 3 = $15\n\nFind the cost of the mussels. Multiply:\n\n$5 \u00d7 4 = $20\n\nFind the cost of the shrimp. Multiply:\n\n$4 \u00d7 3 = $12\n\nNow find the total cost by adding:\n\n$15 + $20 + $12 = $47\n\nThe total cost is $47.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "5810",
    "path": "data"
  },
  {
    "question": "If Hanson buys 1.2 pounds of cherry ice cream, how much will he spend?",
    "choices": null,
    "answer": "2.40",
    "unit": "$",
    "table_title": null,
    "table": "mint ice cream | $2/lb\ndouble chocolate ice cream | $3/lb\ncookie dough ice cream | $6/lb\ncoffee ice cream | $4/lb\ncherry ice cream | $2/lb\nstrawberry ice cream | $4/lb",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the cherry ice cream. Multiply the price per pound by the number of pounds.\n$2 \u00d7 1.2 = $2.40\nHe will spend $2.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "34533",
    "path": "data"
  },
  {
    "question": "Kenji, an employee at Long's Convenience Store, looked at the sales of each of its soda products. How much more did the convenience store make from Sweet Sips sales on Thursday than on Friday?",
    "choices": null,
    "answer": "6",
    "unit": "$",
    "table_title": "Convenience store beverage sales",
    "table": "Beverage | Thursday | Friday\nRefresh Mineral Water | $14 | $4\nSweet Sips | $18 | $12\nNature's Nectar | $4 | $18\nBrenner's Juices | $3 | $5",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the Sweet Sips row. Find the numbers in this row for Thursday and Friday.\n\nThursday: $18.00\nFriday: $12.00\n\nNow subtract:\n\n$18.00 \u2212 $12.00 = $6.00\n\nThe convenience store made $6 more from Sweet Sips sales on Thursday than on Friday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "24310",
    "path": "data"
  },
  {
    "question": "Emir has $2.19. How much money will Emir have left if he buys a football helmet key chain and a pumpkin key chain?",
    "choices": null,
    "answer": "0.41",
    "unit": "$",
    "table_title": null,
    "table": "pumpkin key chain | $0.89\ncat key chain | $0.68\nfootball helmet key chain | $0.89\ntennis ball key chain | $0.76\npuppy key chain | $0.75\ncartoon character key chain | $0.82",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of a football helmet key chain and a pumpkin key chain.\n\n$0.89 + $0.89 = $1.78\n\nNow subtract the total cost from the starting amount.\n\n$2.19 - $1.78 = $0.41\n\nEmir will have $0.41 left.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "19855",
    "path": "data"
  },
  {
    "question": "How much more does a dark gray shell cost than a spiral snail shell?",
    "choices": null,
    "answer": "0.78",
    "unit": "$",
    "table_title": null,
    "table": "dark gray shell | $0.99\norange cone shell | $0.35\nspiral snail shell | $0.21\nwhole sand dollar | $0.56",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a spiral snail shell from the price of a dark gray shell.\n\n$0.99 - $0.21 = $0.78\n\nA dark gray shell costs $0.78 more than a spiral snail shell.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "16470",
    "path": "data"
  },
  {
    "question": "A dog show enthusiast recorded the weight of the winning dog at recent dog shows. According to the table, what was the rate of change between 2012 and 2013?",
    "choices": null,
    "answer": "6",
    "unit": "kilograms per year",
    "table_title": "Weight of winning dog at a dog show",
    "table": "Year | Weight (kg)\n2010 | 28\n2011 | 31\n2012 | 17\n2013 | 23\n2014 | 31",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{23 kilograms - 17 kilograms}{2013 - 2012}\n = \\frac{23 kilograms - 17 kilograms}{1 year}\n = \\frac{6 kilograms}{1 year}\n = 6 kilograms per year\nThe rate of change between 2012 and 2013 was 6 kilograms per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "28379",
    "path": "data"
  },
  {
    "question": "Some friends compared the sizes of their sticker collections. Who has the most stickers?",
    "choices": [
      "Alan",
      "Ted",
      "Ernesto",
      "Florence"
    ],
    "answer": "Alan",
    "unit": null,
    "table_title": "Sticker collections",
    "table": "Name | Number of stickers\nAlan | 881\nTed | 828\nErnesto | 812\nFlorence | 821",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 881.\n\nNow find the corresponding name. Alan corresponds to 881.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "15180",
    "path": "data"
  },
  {
    "question": "How much money does Trent need to buy 3 Palomino horses and 2 Andalusian horses?",
    "choices": null,
    "answer": "31,439",
    "unit": "$",
    "table_title": null,
    "table": "Thoroughbred horse | $6,567.00\nPalomino horse | $6,223.00\nClydesdale horse | $6,032.00\nAndalusian horse | $6,385.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of 3 Palomino horses.\n\n$6,223.00 \u00d7 3 = $18,669.00\n\nFind the cost of 2 Andalusian horses.\n\n$6,385.00 \u00d7 2 = $12,770.00\n\nNow find the total cost.\n\n$18,669.00 + $12,770.00 = $31,439.00\n\nTrent needs $31,439.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "20146",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "x | y\n0 | 6\n6 | 20\n6 | 8",
    "row_num": 4,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nThe x-value 6 is paired with multiple y-values, so the relation is not a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "17992",
    "path": "data"
  },
  {
    "question": "The city recorded how many fire hydrants there are on each street. What is the mean of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Fire hydrants",
    "table": "Street | Number of hydrants\nCedar Street | 8\nRose Street | 7\nLemon Street | 5\nOak Street | 4\nPine Street | 10\nAspen Street | 1\nMaple Street | 6\nElm Street | 7",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n8, 7, 5, 4, 10, 1, 6, 7\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n8 + 7 + 5 + 4 + 10 + 1 + 6 + 7 = 48\n\nNow divide the sum by the number of numbers:\n\n48 \u00f7 8 = 6\n\nThe mean is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "27351",
    "path": "data"
  },
  {
    "question": "For an economics project, Becky determined the cost of ferry rides for bicycles and cars. Which charges more for a car, the Southport-Fort Fisher ferry or the Seattle-Bremerton ferry?",
    "choices": [
      "Seattle-Bremerton",
      "Southport-Fort Fisher"
    ],
    "answer": "Seattle-Bremerton",
    "unit": null,
    "table_title": "Ferry fares",
    "table": "Ferry | Car | Bicycle\nSeattle-Bremerton | $12 | $8\nFauntleroy-Vashon | $15 | $5\nOcracoke | $15 | $3\nSouthport-Fort Fisher | $5 | $2\nMukilteu-Clinton | $7 | $5",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Car column. Compare the numbers in this column for Southport-Fort Fisher and Seattle-Bremerton.\n\n$12.00 is more than $5.00. The Seattle-Bremerton ferry charges more for a car.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "7941",
    "path": "data"
  },
  {
    "question": "A dog show enthusiast recorded the weight of the winning dog at recent dog shows. According to the table, what was the rate of change between 2015 and 2016?",
    "choices": null,
    "answer": "-17",
    "unit": "kilograms per year",
    "table_title": "Weight of winning dog at a dog show",
    "table": "Year | Weight (kg)\n2012 | 11\n2013 | 27\n2014 | 31\n2015 | 28\n2016 | 11",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{11 kilograms - 28 kilograms}{2016 - 2015}\n = \\frac{11 kilograms - 28 kilograms}{1 year}\n = \\frac{-17 kilograms}{1 year}\n = -17 kilograms per year\nThe rate of change between 2015 and 2016 was - 17 kilograms per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "19761",
    "path": "data"
  },
  {
    "question": "Zachary's school reported how many members each sports team had. What is the mean of the numbers?",
    "choices": null,
    "answer": "21",
    "unit": null,
    "table_title": "Sports team membership",
    "table": "Team | Number of members\nbasketball team | 17\ntrack team | 19\nsoccer team | 19\nbaseball team | 24\nsoftball team | 19\nwrestling team | 26\nvolleyball team | 16\nswimming team | 28",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n17, 19, 19, 24, 19, 26, 16, 28\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n17 + 19 + 19 + 24 + 19 + 26 + 16 + 28 = 168\n\nNow divide the sum by the number of numbers:\n\n168 \u00f7 8 = 21\n\nThe mean is 21.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "22373",
    "path": "data"
  },
  {
    "question": "A Technical Assistance Manager monitored his customers' wait times. What is the shortest wait time?",
    "choices": null,
    "answer": "36",
    "unit": "minutes",
    "table_title": "Technical assistance wait times (minutes)",
    "table": "Stem | Leaf \n3 | 6\n4 | 9\n5 | \n6 | \n7 | 3\n8 | 0, 0, 1, 1, 6",
    "row_num": 7,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 3.\n\nNow find the lowest leaf in the first row. The lowest leaf is 6.\n\nThe shortest wait time has a stem of 3 and a leaf of 6. Write the stem first, then the leaf: 36.\n\nThe shortest wait time is 36 minutes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "27430",
    "path": "data"
  },
  {
    "question": "This is Sandra's complete financial record for December. How much money did Sandra spend on December 29?",
    "choices": null,
    "answer": "7.80",
    "unit": "$",
    "table_title": null,
    "table": "Date | Description | Received | Expenses | Available Funds\n | Balance: end of November | | | $328.20\n12/5 | wrapping paper | | $4.95 | $323.25\n12/16 | watching Ms. Gilmore's cat | $15.00 | | $338.25\n12/29 | calendar | | $7.80 | $330.45",
    "row_num": 5,
    "column_num": 5,
    "solution": "Look at the 12/29 row. The expenses were $7.80. So, Sandra spent $7.80 on December 29.\n",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "14549",
    "path": "data"
  },
  {
    "question": "How much would it cost to buy 5 pounds of chili peppers and 2 pounds of Anaheim peppers?",
    "choices": null,
    "answer": "17.60",
    "unit": "$",
    "table_title": null,
    "table": "green bell peppers | $0.87 per lb\npurple bell peppers | $0.96 per lb\nchili peppers | $2.68 per lb\nhabanero peppers | $2.10 per lb\nAnaheim peppers | $2.10 per lb\nred bell peppers | $1.82 per lb",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the chili peppers. Multiply:\n\n$2.68 \u00d7 5 = $13.40\n\nFind the cost of the Anaheim peppers. Multiply:\n\n$2.10 \u00d7 2 = $4.20\n\nNow find the total cost by adding:\n\n$13.40 + $4.20 = $17.60\n\nIt would cost $17.60.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "17312",
    "path": "data"
  },
  {
    "question": "Jen wrote down how many pages she read over the past 4 days. On which day did Jen read the most pages?",
    "choices": [
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "answer": "Sunday",
    "unit": null,
    "table_title": "Pages read",
    "table": "Day | Number of pages\nThursday | 292\nFriday | 228\nSaturday | 289\nSunday | 298",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 298.\n\nNow find the corresponding day. Sunday corresponds to 298.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "15833",
    "path": "data"
  },
  {
    "question": "Each shelf has 2 pairs of jeans. How many pairs of jeans are on 5 shelves?",
    "choices": null,
    "answer": "10",
    "unit": "pairs of jeans",
    "table_title": null,
    "table": "Number of shelves | Number of pairs of jeans\n1 | 2\n2 | 4\n3 | 6\n4 | 8\n5 | ?",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 10 pairs of jeans on 5 shelves.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "37173",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which class begins at 11.15 A.M.?",
    "choices": [
      "Computer Programming class",
      "Chemistry class",
      "Basketball class",
      "Geometry class"
    ],
    "answer": "Geometry class",
    "unit": null,
    "table_title": "Class schedule",
    "table": "Subject | Begin | End\nBasketball | 8:30 A.M. | 9:35 A.M.\nComputer Programming | 9:40 A.M. | 11:00 A.M.\nGeometry | 11:15 A.M. | 11:55 A.M.\nAncient Greek | 12:35 P.M. | 1:05 P.M.\nCell Biology | 1:10 P.M. | 1:40 P.M.\nChinese | 1:45 P.M. | 2:40 P.M.\nChemistry | 2:45 P.M. | 3:50 P.M.\nAmerican History | 4:15 P.M. | 5:20 P.M.\nArchitecture | 5:45 P.M. | 6:45 P.M.",
    "row_num": 10,
    "column_num": 3,
    "solution": "Find 11:15 A. M. on the schedule. Geometry class begins at 11:15 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 3,
    "split": "dev",
    "pid": "16413",
    "path": "data"
  },
  {
    "question": "A furniture store kept a record of how many couches it sold each day. On which day did the furniture store sell the most couches?",
    "choices": [
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday"
    ],
    "answer": "Thursday",
    "unit": null,
    "table_title": "Couches sold",
    "table": "Day | Number of couches\nTuesday | 17\nWednesday | 10\nThursday | 18\nFriday | 14",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 18.\n\nNow find the corresponding day. Thursday corresponds to 18.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "34428",
    "path": "data"
  },
  {
    "question": "The city library monitored the number of books checked out each day. How many more books were checked out on Friday than on Monday?",
    "choices": null,
    "answer": "425",
    "unit": "books",
    "table_title": "Books checked out",
    "table": "Day | Number of books\nMonday | 193\nTuesday | 731\nWednesday | 300\nThursday | 510\nFriday | 618",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nFriday: 618\nMonday: 193\n\nNow subtract: 618 - 193 = 425.\n\n425 more books were checked out on Friday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "13142",
    "path": "data"
  },
  {
    "question": "A drawing class was assigned a final project where students had to choose one art medium and one subject. The teacher kept track of the types of projects submitted. What is the probability that a randomly selected student chose to draw a plant and used chalk? Simplify any fractions.",
    "choices": null,
    "answer": "2/7",
    "unit": null,
    "table_title": null,
    "table": " | Acrylic paint | Chalk\nA plant | 2 | 4\nAn insect | 3 | 5",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the student chose to draw a plant\" and B be the event \"the student used chalk\".\nTo find the probability that a student chose to draw a plant and used chalk, first identify the sample space and the event.\nThe outcomes in the sample space are the different students. Each student is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the student chose to draw a plant and used chalk\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the student chose to draw a plant and used chalk\", so look at the table to see how many students chose to draw a plant and used chalk.\nThe number of students who chose to draw a plant and used chalk is 4.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of students.\n2 + 3 + 4 + 5 = 14\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{4}{14}\n = \\frac{2}{7}\nThe probability that a student chose to draw a plant and used chalk is \\frac{2}{7}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "5152",
    "path": "data"
  },
  {
    "question": "Nicholas has $195.50. Does he have enough to buy a silver coat rack and a crystal vase?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "silver coat rack | $99.96\nlamp | $99.04\ncrystal vase | $92.49\ncrystal sculpture | $88.68\nceramic vase | $87.41\nchandelier | $95.57",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a silver coat rack and the price of a crystal vase:\n\n$99.96 + $92.49 = $192.45\n\n$192.45 is less than $195.50. Nicholas does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "32259",
    "path": "data"
  },
  {
    "question": "The librarian at the public library counted the number of books on each shelf. What is the largest number of books?",
    "choices": null,
    "answer": "90",
    "unit": "books",
    "table_title": "Books per shelf",
    "table": "Stem | Leaf \n3 | 7\n4 | 5, 7\n5 | 4, 5\n6 | 0, 2, 2, 5, 6\n7 | 1, 4, 5, 5, 6, 6\n8 | 0, 2, 2, 3, 3, 6, 9, 9\n9 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe largest number of books has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe largest number of books is 90 books.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "17645",
    "path": "data"
  },
  {
    "question": "A journalist attended a crossword puzzle competition which attracts contestants from different countries. The competition ends when a contestant has accurately completed five different crossword puzzles. For her story, the journalist recorded the home country and final score of each contestant. What is the probability that a randomly selected contestant scored exactly 80 points and is from Brazil? Simplify any fractions.",
    "choices": null,
    "answer": "1/2",
    "unit": null,
    "table_title": null,
    "table": " | Argentina | Brazil\n80 points | 1 | 7\n85 points | 4 | 2",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the contestant scored exactly 80 points\" and B be the event \"the contestant is from Brazil\".\nTo find the probability that a contestant scored exactly 80 points and is from Brazil, first identify the sample space and the event.\nThe outcomes in the sample space are the different contestants. Each contestant is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the contestant scored exactly 80 points and is from Brazil\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the contestant scored exactly 80 points and is from Brazil\", so look at the table to see how many contestants scored exactly 80 points and are from Brazil.\nThe number of contestants who scored exactly 80 points and are from Brazil is 7.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of contestants.\n1 + 4 + 7 + 2 = 14\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{7}{14}\n = \\frac{1}{2}\nThe probability that a contestant scored exactly 80 points and is from Brazil is \\frac{1}{2}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "32840",
    "path": "data"
  },
  {
    "question": "How much money does Jenny need to buy 5 orders of grilled eggplant and 8 orders of pasta with pesto sauce?",
    "choices": null,
    "answer": "143.48",
    "unit": "$",
    "table_title": null,
    "table": "ravioli | $10.66\nlasagna | $14.94\ngrilled eggplant | $11.08\npasta with pesto sauce | $11.01",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of 5 orders of grilled eggplant.\n\n$11.08 \u00d7 5 = $55.40\n\nFind the cost of 8 orders of pasta with pesto sauce.\n\n$11.01 \u00d7 8 = $88.08\n\nNow find the total cost.\n\n$55.40 + $88.08 = $143.48\n\nJenny needs $143.48.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "31188",
    "path": "data"
  },
  {
    "question": "Dr. McLean, a zoo director, researched ticket prices at other zoos around the country. How much does a child ticket to the Bronx Zoo cost?",
    "choices": null,
    "answer": "11",
    "unit": "$",
    "table_title": "Zoo ticket prices",
    "table": "Zoo | Child | Senior\nBrookfield | $8 | $8\nSan Francisco | $9 | $12\nBronx | $11 | $13",
    "row_num": 4,
    "column_num": 3,
    "solution": "First, find the row for Bronx. Then find the number in the Child column.\n\nThis number is $11.00. A child ticket to the Bronx Zoo cost $11.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "14809",
    "path": "data"
  },
  {
    "question": "The teachers at a middle school counted how many computers they had in their classrooms. What is the mean of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Computers in classrooms",
    "table": "Teacher | Number of computers\nMr. Watson | 6\nMr. Schmidt | 6\nMs. Cohen | 3\nMrs. Jansen | 4\nMr. Morales | 9\nMr. Lim | 2",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 6, 3, 4, 9, 2\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n6 + 6 + 3 + 4 + 9 + 2 = 30\n\nNow divide the sum by the number of numbers:\n\n30 \u00f7 6 = 5\n\nThe mean is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "27708",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n16 | 11\n17 | 15\n18 | 19",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{15 - 11}{17 - 16}\n = \\frac{4}{1}\n = 4\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{19 - 15}{18 - 17}\n = \\frac{4}{1}\n = 4\nThe two rates of change are the same.\nIf you checked the rate of change between rows 1 and 3, you would find that it is also 4.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "22574",
    "path": "data"
  },
  {
    "question": "Newberry Flooring tracked the number of broken tiles in each shipment it received last year. What is the smallest number of broken tiles?",
    "choices": null,
    "answer": "40",
    "unit": "broken tiles",
    "table_title": "Broken tiles per shipment",
    "table": "Stem | Leaf \n4 | 0, 2, 7\n5 | 1, 1, 1\n6 | 0, 1, 1\n7 | 0, 2, 4, 7\n8 | 0, 2, 6\n9 | 0, 0",
    "row_num": 7,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 4.\n\nNow find the lowest leaf in the first row. The lowest leaf is 0.\n\nThe smallest number of broken tiles has a stem of 4 and a leaf of 0. Write the stem first, then the leaf: 40.\n\nThe smallest number of broken tiles is 40 broken tiles.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "29883",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the bus depart from the old building?",
    "choices": [
      "9:55 A.M.",
      "11:00 A.M.",
      "3:45 P.M.",
      "1:20 P.M."
    ],
    "answer": "1:20 P.M.",
    "unit": null,
    "table_title": "Tour bus schedule",
    "table": "Location | Arrive | Depart\nthe riverfront | 7:35 A.M. | 8:00 A.M.\nthe zoo | 8:35 A.M. | 9:20 A.M.\nthe aquarium | 9:25 A.M. | 9:55 A.M.\nart museum | 10:15 A.M. | 11:00 A.M.\nskyscraper | 11:50 A.M. | 11:55 A.M.\nold building | 12:35 P.M. | 1:20 P.M.\nscience museum | 1:55 P.M. | 2:10 P.M.\ndowntown | 2:50 P.M. | 3:20 P.M.\nlandmark sculpture | 3:35 P.M. | 3:45 P.M.",
    "row_num": 10,
    "column_num": 3,
    "solution": "Find the old building on the schedule. Find the departure time for the old building.\n\nold building: 1:20 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "23978",
    "path": "data"
  },
  {
    "question": "How much money does Sophie need to buy a set of dishes and a serving platter?",
    "choices": null,
    "answer": "53.11",
    "unit": "$",
    "table_title": null,
    "table": "coffee pot | $10.57\napron | $12.23\ncasserole dish | $19.96\nset of forks | $11.07\nset of dishes | $40.88\nserving platter | $12.23",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a set of dishes and the price of a serving platter:\n\n$40.88 + $12.23 = $53.11\n\nSophie needs $53.11.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "24434",
    "path": "data"
  },
  {
    "question": "Jennifer buys 3/4 of a pound of peanuts. What is the total cost?",
    "choices": null,
    "answer": "1.50",
    "unit": "$",
    "table_title": null,
    "table": "almonds | $9/pound\nhazelnuts | $6/pound\npeanuts | $2/pound\ncashews | $12/pound\nwalnuts | $11/pound\npecans | $6/pound",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the peanuts. Multiply the price per pound by the number of pounds.\n$2 \u00d7 \\frac{3}{4} = $2 \u00d7 0.75 = $1.50\nThe total cost is $1.50.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "14066",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. At which stop does the train arrive at 11.05 A.M.?",
    "choices": [
      "Jackson Boulevard",
      "Hill Road",
      "Birch Road",
      "Lincoln Street"
    ],
    "answer": "Birch Road",
    "unit": null,
    "table_title": "Subway train schedule",
    "table": "Location | Time\nNorth Avenue | 10:40 A.M.\nBirch Road | 11:05 A.M.\nGreen Avenue | 11:35 A.M.\nJefferson Boulevard | 11:55 A.M.\nLincoln Street | 12:20 P.M.\nEast Avenue | 12:35 P.M.\nHill Road | 12:55 P.M.\nJackson Boulevard | 1:35 P.M.\nDogwood Avenue | 2:05 P.M.",
    "row_num": 10,
    "column_num": 2,
    "solution": "Find 11:05 A. M. on the schedule. The train arrives at Birch Road at 11:05 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "35190",
    "path": "data"
  },
  {
    "question": "Use the data to answer the question below. Is the following statement about our solar system true or false? Jupiter's volume is more than 1,000 times as great as Earth's volume.",
    "choices": [
      "true",
      "false"
    ],
    "answer": "true",
    "unit": null,
    "table_title": "Planet Volume (billions of km3) Primary composition",
    "table": "Mercury | 60 rock\nVenus | 930 rock\nEarth | 1,090 rock\nMars | 160 rock\nJupiter | 1,431,280 gas\nSaturn | 827,130 gas\nUranus | 68,330 ice\nNeptune | 62,530 ice",
    "row_num": 8,
    "column_num": 2,
    "solution": "To determine if this statement is true, calculate the value of 1,000 times the volume of Earth.\n\n1,000 \u00b7 1,090 billion km^3 = 1,090,000 billion km^3\n\nThen compare the result to the volume of Jupiter. Jupiter's volume is 1,431,280 billion km^3, which is more than 1,090,000 billion km^3. So, Jupiter's volume is more than 1,000 times as great as Earth's volume.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 6,
    "split": "dev",
    "pid": "37404",
    "path": "data"
  },
  {
    "question": "How much money does Maureen need to buy 4 tickets for an Alaskan cruise and 7 tickets for a Caribbean cruise?",
    "choices": null,
    "answer": "36,287",
    "unit": "$",
    "table_title": null,
    "table": "ticket for a Mexican cruise | $7,154\nticket for an Alaskan cruise | $3,708\nticket for a Caribbean cruise | $3,065\nticket for an Atlantic cruise | $3,541\nticket for an Australian cruise | $2,568\nticket for a South American cruise | $2,193",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of 4 tickets for an Alaskan cruise.\n\n$3,708 \u00d7 4 = $14,832\n\nFind the cost of 7 tickets for a Caribbean cruise.\n\n$3,065 \u00d7 7 = $21,455\n\nNow find the total cost.\n\n$14,832 + $21,455 = $36,287\n\nMaureen needs $36,287.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "8284",
    "path": "data"
  },
  {
    "question": "Leslie has $11.00. Does she have enough to buy poached eggs and a spinach omelette?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "poached eggs | $6.00\negg sandwich | $5.00\nbowl of oatmeal | $5.00\nbowl of berries | $2.00\nspinach omelette | $6.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of poached eggs and the price of a spinach omelette:\n\n$6.00 + $6.00 = $12.00\n\n$12.00 is more than $11.00. Leslie does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "36979",
    "path": "data"
  },
  {
    "question": "A food critic counted the number of menu items at each restaurant in town. How many restaurants have fewer than 90 menu items?",
    "choices": null,
    "answer": "16",
    "unit": "restaurants",
    "table_title": "Menu items per restaurant",
    "table": "Stem | Leaf \n1 | 4, 5, 6\n2 | 2, 4\n3 | 3\n4 | 2, 8, 8\n5 | 0, 1\n6 | 6, 7\n7 | 0\n8 | 0, 6\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, 4, 5, 6, 7, and 8.\n\nYou counted 16 leaves, which are blue in the stem-and-leaf plot above. 16 restaurants have fewer than 90 menu items.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "8329",
    "path": "data"
  },
  {
    "question": "Each laundry basket has 5 turtleneck sweaters. How many turtleneck sweaters are in 6 laundry baskets?",
    "choices": null,
    "answer": "30",
    "unit": "turtleneck sweaters",
    "table_title": null,
    "table": "Number of laundry baskets | Number of turtleneck sweaters\n1 | 5\n2 | 10\n3 | 15\n4 | 20\n5 | 25\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 30 turtleneck sweaters in 6 laundry baskets.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "19565",
    "path": "data"
  },
  {
    "question": "A vendor who sold bread at farmers' markets counted the number of leftover loaves at the end of each day. According to the table, what was the rate of change between Tuesday and Wednesday?",
    "choices": null,
    "answer": "19",
    "unit": "loaves per day",
    "table_title": "Loaves of leftover bread",
    "table": "Day | Leftover loaves\nSunday | 7\nMonday | 27\nTuesday | 8\nWednesday | 27\nThursday | 44",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{27 loaves - 8 loaves}{1 day}\n = \\frac{19 loaves}{1 day}\n = 19 loaves per day\nThe rate of change between Tuesday and Wednesday was 19 loaves per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "6356",
    "path": "data"
  },
  {
    "question": "How much money does Pablo need to buy 2 sets of dishes?",
    "choices": null,
    "answer": "110",
    "unit": "$",
    "table_title": null,
    "table": "apron | $17.00\nbaking dish | $11.00\ncasserole dish | $16.00\nset of dishes | $55.00\nfrying pan | $50.00\nteapot | $33.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of 2 sets of dishes by multiplying 2 times the price of a set of dishes.\n\n$55.00 \u00d7 2 = $110.00\n\nPablo needs $110.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "26703",
    "path": "data"
  },
  {
    "question": "How much more does a whole sand dollar cost than a purple clam shell?",
    "choices": null,
    "answer": "0.55",
    "unit": "$",
    "table_title": null,
    "table": "pink and white striped shell | $0.80\npurple clam shell | $0.18\nscallop shell | $0.55\nwhole sand dollar | $0.73",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a purple clam shell from the price of a whole sand dollar.\n\n$0.73 - $0.18 = $0.55\n\nA whole sand dollar costs $0.55 more than a purple clam shell.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "28007",
    "path": "data"
  },
  {
    "question": "How much money does Abby need to buy 6 pig key chains and a puppy key chain?",
    "choices": null,
    "answer": "4",
    "unit": "$",
    "table_title": null,
    "table": "pig key chain | $0.55\nsoccer ball key chain | $0.93\nhorse key chain | $0.99\nbasketball key chain | $0.71\npuppy key chain | $0.70\ncat key chain | $0.77",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of 6 pig key chains.\n\n$0.55 \u00d7 6 = $3.30\n\nNow find the total cost.\n\n$3.30 + $0.70 = $4.00\n\nAbby needs $4.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "16626",
    "path": "data"
  },
  {
    "question": "A gymnast jotted down the number of cartwheels she did each day. What is the mode of the numbers?",
    "choices": null,
    "answer": "10",
    "unit": null,
    "table_title": "Doing cartwheels",
    "table": "Day | Number of cartwheels\nThursday | 5\nFriday | 10\nSaturday | 3\nSunday | 10\nMonday | 10\nTuesday | 3\nWednesday | 5",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 10, 3, 10, 10, 3, 5\n\nFirst, arrange the numbers from least to greatest:\n\n3, 3, 5, 5, 10, 10, 10\n\nNow count how many times each number appears.\n\n3 appears 2 times.\n5 appears 2 times.\n10 appears 3 times.\n\nThe number that appears most often is 10.\n\nThe mode is 10.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "22681",
    "path": "data"
  },
  {
    "question": "Jasmine went on a camping trip and logged the number of miles she hiked each day. What is the mean of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Miles hiked",
    "table": "Day | Number of miles\nTuesday | 7\nWednesday | 2\nThursday | 5\nFriday | 9\nSaturday | 9\nSunday | 4",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 2, 5, 9, 9, 4\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n7 + 2 + 5 + 9 + 9 + 4 = 36\n\nNow divide the sum by the number of numbers:\n\n36 \u00f7 6 = 6\n\nThe mean is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "25731",
    "path": "data"
  },
  {
    "question": "Rob was the lucky journalist assigned to cover the Best Beard Competition. He recorded the contestants' beard colors in his notepad. Rob also noted if the contestants were signed up for the mustache competition later in the day. What is the probability that a randomly selected contestant has a grey beard and is only in the beard competition? Simplify any fractions.",
    "choices": null,
    "answer": "2/11",
    "unit": null,
    "table_title": null,
    "table": " | Only in the beard competition | Also in the mustache competition\nRed beard | 2 | 4\nGrey beard | 2 | 3",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the contestant has a grey beard\" and B be the event \"the contestant is only in the beard competition\".\nTo find the probability that a contestant has a grey beard and is only in the beard competition, first identify the sample space and the event.\nThe outcomes in the sample space are the different contestants. Each contestant is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the contestant has a grey beard and is only in the beard competition\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the contestant has a grey beard and is only in the beard competition\", so look at the table to see how many contestants have a grey beard and are only in the beard competition.\nThe number of contestants who have a grey beard and are only in the beard competition is 2.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of contestants.\n2 + 2 + 4 + 3 = 11\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{2}{11}\nThe probability that a contestant has a grey beard and is only in the beard competition is \\frac{2}{11}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "26211",
    "path": "data"
  },
  {
    "question": "The Somerville Middle School fundraising committee found out how many sweatshirts students already had, in order to decide whether to sell sweatshirts for a fundraiser. How many students are there in all?",
    "choices": null,
    "answer": "75",
    "unit": null,
    "table_title": "Sweatshirts",
    "table": "Number of sweatshirts | Frequency\n0 | 9\n1 | 5\n2 | 10\n3 | 19\n4 | 20\n5 | 12",
    "row_num": 7,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n9 + 5 + 10 + 19 + 20 + 12 = 75\n\nThere are 75 students in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "21740",
    "path": "data"
  },
  {
    "question": "A food magazine published a listing of local restaurant ratings. How many restaurants were rated at least 30 points but fewer than 40 points?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Restaurant ratings",
    "table": "Stem | Leaf \n1 | 3, 8\n2 | 5, 6, 9\n3 | 3, 6, 8, 9\n4 | 2",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count all the leaves in the row with stem 3.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plot above. 4 restaurants were rated at least 30 points but fewer than 40 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "24285",
    "path": "data"
  },
  {
    "question": "The members of the track team compared how many miles they ran last week. What is the mode of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Running miles",
    "table": "Name | Miles\nAlbert | 3\nBruce | 5\nDana | 1\nTim | 3\nKelsey | 1\nEmir | 5\nLorenzo | 7\nWalter | 3",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n3, 5, 1, 3, 1, 5, 7, 3\n\nFirst, arrange the numbers from least to greatest:\n\n1, 1, 3, 3, 3, 5, 5, 7\n\nNow count how many times each number appears.\n\n1 appears 2 times.\n3 appears 3 times.\n5 appears 2 times.\n7 appears 1 time.\n\nThe number that appears most often is 3.\n\nThe mode is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "11266",
    "path": "data"
  },
  {
    "question": "Adam purchased 3.6 pounds of strawberry ice cream. What was the total cost?",
    "choices": null,
    "answer": "14.40",
    "unit": "$",
    "table_title": null,
    "table": "strawberry ice cream | $4 per pound\ncoffee ice cream | $4 per pound\ncherry ice cream | $6 per pound\ncookie dough ice cream | $5 per pound\nmint ice cream | $3 per pound",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the strawberry ice cream. Multiply the price per pound by the number of pounds.\n$4 \u00d7 3.6 = $14.40\nThe total cost was $14.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "925",
    "path": "data"
  },
  {
    "question": "A zoologist counted the number of reptiles at each of the state's zoos. How many lizards are there at the Eastern Zoo?",
    "choices": null,
    "answer": "17",
    "unit": "lizards",
    "table_title": "Reptiles in zoos",
    "table": "Zoo | Lizards | Turtles\nEastern Zoo | 17 | 15\nPacific Zoo | 12 | 4\nNorthside Zoo | 9 | 12",
    "row_num": 4,
    "column_num": 3,
    "solution": "First, find the row for Eastern Zoo. Then find the number in the Lizards column.\n\nThis number is 17. The Eastern Zoo has 17 lizards.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "37631",
    "path": "data"
  },
  {
    "question": "A cable company analyst paid attention to how many new customers it had each day. On which day did the cable company have the most new customers?",
    "choices": [
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday"
    ],
    "answer": "Saturday",
    "unit": null,
    "table_title": "New cable customers",
    "table": "Day | Number of new customers\nWednesday | 31\nThursday | 30\nFriday | 34\nSaturday | 36",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 36.\n\nNow find the corresponding day. Saturday corresponds to 36.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "24728",
    "path": "data"
  },
  {
    "question": "A shipping company keeps track of the number of boxes in each shipment they send out. How many shipments had exactly 51 boxes?",
    "choices": null,
    "answer": "0",
    "unit": "shipments",
    "table_title": "Boxes per shipment",
    "table": "Stem | Leaf \n1 | 0, 1, 4\n2 | \n3 | \n4 | 3, 9\n5 | 7, 7\n6 | 4, 6",
    "row_num": 7,
    "column_num": 2,
    "solution": "For the number 51, the stem is 5, and the leaf is 1. Find the row where the stem is 5. In that row, count all the leaves equal to 1.\n\nYou counted 0 leaves. 0 shipments had exactly 51 boxes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "21494",
    "path": "data"
  },
  {
    "question": "Lorenzo just downloaded the new game Gem Excavator on his phone. In the first level, Lorenzo gains points for each green gem he finds. However, he loses points for each red gem he finds. The table shows how the gems affect Lorenzo's points. Which color gem affects Lorenzo's points less?",
    "choices": [
      "green",
      "red"
    ],
    "answer": "green",
    "unit": null,
    "table_title": null,
    "table": "Gem color | Change in points\nGreen | 25\nRed | -40",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find the gem that affects Lorenzo's points less, use absolute value. Absolute value tells you how much Lorenzo's points change for each color gem.\nGreen: |25| = 25\nRed: |-40| = 40\nLorenzo gains 25 points for each green gem he finds, and he loses 40 points for each red gem he finds. So, the green gems affect Lorenzo's points less.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "10925",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $640, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$640 | 16,300 | 4,400\n$830 | 13,500 | 5,000\n$1,020 | 10,700 | 5,600\n$1,210 | 7,900 | 6,200\n$1,400 | 5,100 | 6,800",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $640, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "16870",
    "path": "data"
  },
  {
    "question": "Kristen has $14.50. Does she have enough to buy a blue tank top and a pink sweater?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "pink sweater | $5.46\nblack skirt | $8.08\nblue tank top | $8.97\npair of sandals | $6.61\ndenim skirt | $3.01",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a blue tank top and the price of a pink sweater:\n\n$8.97 + $5.46 = $14.43\n\n$14.43 is less than $14.50. Kristen does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "27219",
    "path": "data"
  },
  {
    "question": "A creative writing class compiled a list of their favorite superheroes. They listed each superhero's superpower and personality flaw. What is the probability that a randomly selected superhero is lazy and can read minds? Simplify any fractions.",
    "choices": null,
    "answer": "1/5",
    "unit": null,
    "table_title": null,
    "table": " | Fly | Read minds\nForgetful | 2 | 4\nLazy | 2 | 2",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the superhero is lazy\" and B be the event \"the superhero can read minds\".\nTo find the probability that a superhero is lazy and can read minds, first identify the sample space and the event.\nThe outcomes in the sample space are the different superheroes. Each superhero is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the superhero is lazy and can read minds\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the superhero is lazy and can read minds\", so look at the table to see how many superheroes are lazy and can read minds.\nThe number of superheroes who are lazy and can read minds is 2.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of superheroes.\n2 + 2 + 4 + 2 = 10\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{2}{10}\n = \\frac{1}{5}\nThe probability that a superhero is lazy and can read minds is \\frac{1}{5}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "4950",
    "path": "data"
  },
  {
    "question": "David has $161. How much money will David have left if he buys a lawn mower and a wooden bench?",
    "choices": null,
    "answer": "11",
    "unit": "$",
    "table_title": null,
    "table": "lawn ornament | $90\nbeach umbrella | $85\nlawn chair | $17\nwooden bench | $68\nlawn mower | $82",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of a lawn mower and a wooden bench.\n\n$82 + $68 = $150\n\nNow subtract the total cost from the starting amount.\n\n$161 - $150 = $11\n\nDavid will have $11 left.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "21211",
    "path": "data"
  },
  {
    "question": "A business magazine surveyed its readers about their commute times. How many commutes are at least 40 minutes but less than 90 minutes?",
    "choices": null,
    "answer": "9",
    "unit": "commutes",
    "table_title": "Commute time (minutes)",
    "table": "Stem | Leaf \n1 | 5\n2 | 6, 8\n3 | 1\n4 | 1, 4\n5 | 1, 3\n6 | 3, 6, 9\n7 | 1\n8 | 8",
    "row_num": 9,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 4, 5, 6, 7, and 8.\n\nYou counted 9 leaves, which are blue in the stem-and-leaf plot above. 9 commutes are at least 40 minutes but less than 90 minutes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "29068",
    "path": "data"
  },
  {
    "question": "Each crate has 2 boxes of blueberries. How many boxes of blueberries are in 3 crates?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": null,
    "table": "Number of crates | Number of boxes of blueberries\n1 | 2\n2 | 4\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 6 boxes of blueberries in 3 crates.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "14912",
    "path": "data"
  },
  {
    "question": "Miss Pruitt ran a sit-up competition among her P.E. students and monitored how many sit-ups each students could do. What is the smallest number of sit-ups done?",
    "choices": null,
    "answer": "12",
    "unit": "sit-ups",
    "table_title": "Sit-up competition (number of sit-ups)",
    "table": "Stem | Leaf \n1 | 2, 7\n2 | 2\n3 | 1, 7\n4 | \n5 | 6\n6 | 4, 5, 9\n7 | \n8 | \n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 1.\n\nNow find the lowest leaf in the first row. The lowest leaf is 2.\n\nThe smallest number of sit-ups done has a stem of 1 and a leaf of 2. Write the stem first, then the leaf: 12.\n\nThe smallest number of sit-ups done is 12 sit-ups.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "16212",
    "path": "data"
  },
  {
    "question": "As part of a statistics project, a math class weighed all the children who were willing to participate. How many children weighed exactly 49 pounds?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Children's weights (lbs)",
    "table": "Stem | Leaf \n1 | 0, 6, 6, 8, 8\n2 | \n3 | 0, 4, 4, 5, 6, 6, 6\n4 | 9, 9",
    "row_num": 5,
    "column_num": 2,
    "solution": "For the number 49, the stem is 4, and the leaf is 9. Find the row where the stem is 4. In that row, count all the leaves equal to 9.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 children weighed exactly 49 pounds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "391",
    "path": "data"
  },
  {
    "question": "A food industry researcher compiled the revenues of several pizzerias. Which restaurant made the most from pizza sales?",
    "choices": [
      "Taste of New York",
      "Pizza, Pasta and More",
      "Pizzeria Italiano",
      "Arnold's Pizzeria"
    ],
    "answer": "Taste of New York",
    "unit": null,
    "table_title": "Pizza sales",
    "table": "Restaurant | Pepperoni pizzas | Vegetarian pizzas\nPizzeria Italiano | $20 | $6\nTaste of New York | $14 | $18\nPizza, Pasta and More | $7 | $9\nPizzas Only | $11 | $12\nArnold's Pizzeria | $7 | $5",
    "row_num": 6,
    "column_num": 3,
    "solution": "Add the numbers in each row.\n\nPizzeria Italiano: $20.00 + $6.00 = $26.00\nTaste of New York: $14.00 + $18.00 = $32.00\nPizza, Pasta and More: $7.00 + $9.00 = $16.00\nPizzas Only: $11.00 + $12.00 = $23.00\nArnold's Pizzeria: $7.00 + $5.00 = $12.00\n\nThe greatest sum is $32.00, which is the total for the Taste of New York row. Taste of New York made the most from pizza sales.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "33509",
    "path": "data"
  },
  {
    "question": "Some friends played golf and compared their scores. What is the mode of the numbers?",
    "choices": null,
    "answer": "84",
    "unit": null,
    "table_title": "Golf scores",
    "table": "Name | Score\nFred | 84\nJayce | 83\nMiles | 91\nHaley | 83\nSeth | 84\nNoah | 84",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n84, 83, 91, 83, 84, 84\n\nFirst, arrange the numbers from least to greatest:\n\n83, 83, 84, 84, 84, 91\n\nNow count how many times each number appears.\n\n83 appears 2 times.\n84 appears 3 times.\n91 appears 1 time.\n\nThe number that appears most often is 84.\n\nThe mode is 84.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "2244",
    "path": "data"
  },
  {
    "question": "For a science fair project, Stefan tracked the temperature each day. How many temperature readings were at least 10\u00b0C but less than 50\u00b0C?",
    "choices": null,
    "answer": "20",
    "unit": "temperature readings",
    "table_title": "Daily temperatures (\u00b0C)",
    "table": "Stem | Leaf \n1 | 0, 3, 4, 5\n2 | 2, 2, 4, 4, 4, 5, 9\n3 | 2, 7, 7, 7, 8, 8\n4 | 0, 1, 1",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, and 4.\n\nYou counted 20 leaves, which are blue in the stem-and-leaf plot above. 20 temperature readings were at least 10\u00b0C but less than 50\u00b0C.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "27343",
    "path": "data"
  },
  {
    "question": "Nora has $1.00. Does she have enough to buy a pink and white striped shell and a shiny gold shell?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "shiny gold shell | $0.17\ndark gray shell | $0.82\npink and white striped shell | $0.89\nbeautiful yellow shell | $0.31",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a pink and white striped shell and the price of a shiny gold shell:\n\n$0.89 + $0.17 = $1.06\n\n$1.06 is more than $1.00. Nora does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "6736",
    "path": "data"
  },
  {
    "question": "Martha tracked how many laps she ran in the past 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Laps ran",
    "table": "Day | Number of laps\nSaturday | 8\nSunday | 5\nMonday | 7\nTuesday | 6\nWednesday | 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n8, 5, 7, 6, 7\n\nFirst, arrange the numbers from least to greatest:\n\n5, 6, 7, 7, 8\n\nNow find the number in the middle.\n\n5, 6, 7, 7, 8\n\nThe number in the middle is 7.\n\nThe median is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "36215",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does Biology class end?",
    "choices": [
      "7:30 A.M.",
      "2:55 P.M.",
      "8:45 A.M.",
      "8:05 A.M."
    ],
    "answer": "8:05 A.M.",
    "unit": null,
    "table_title": "Class schedule",
    "table": "Subject | Begin | End\nBiology | 7:30 A.M. | 8:05 A.M.\nMath | 8:15 A.M. | 8:45 A.M.\nAstronomy | 8:50 A.M. | 9:50 A.M.\nPhysics | 9:55 A.M. | 10:50 A.M.\nHistory | 10:55 A.M. | 11:50 A.M.\nArt | 12:00 P.M. | 12:45 P.M.\nMusic | 12:50 P.M. | 1:50 P.M.\nHealth | 1:55 P.M. | 2:55 P.M.\nChemistry | 3:00 P.M. | 3:50 P.M.",
    "row_num": 10,
    "column_num": 3,
    "solution": "Find Biology class on the schedule. Find the end time for Biology class.\n\nBiology: 8:05 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "25910",
    "path": "data"
  },
  {
    "question": "Ellie went to the store. She bought 3.1 kilograms of hamburger buns. How much did she spend?",
    "choices": null,
    "answer": "12.40",
    "unit": "$",
    "table_title": null,
    "table": "spelt rolls | $6 per kilogram\nrye rolls | $5 per kilogram\nhamburger buns | $4 per kilogram\nwheat rolls | $6 per kilogram\nFrench rolls | $7 per kilogram",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the hamburger buns. Multiply the price per kilogram by the number of kilograms.\n$4 \u00d7 3.1 = $12.40\nShe spent $12.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "1015",
    "path": "data"
  },
  {
    "question": "Brian purchased 2.2 kilograms of almond butter. What was the total cost?",
    "choices": null,
    "answer": "4.40",
    "unit": "$",
    "table_title": null,
    "table": "almond butter | $2 per kg\npeanut butter | $3 per kg\ncashew butter | $3 per kg\nwalnut butter | $3 per kg\nmacadamia nut butter | $3 per kg",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the almond butter. Multiply the price per kilogram by the number of kilograms.\n$2 \u00d7 2.2 = $4.40\nThe total cost was $4.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "22783",
    "path": "data"
  },
  {
    "question": "How much more does a brownie cost than a blueberry muffin?",
    "choices": null,
    "answer": "0.31",
    "unit": "$",
    "table_title": null,
    "table": "brownie | $0.99\nmuffin | $0.73\ncupcake | $0.51\nchocolate-chip cookie | $0.63\nblueberry muffin | $0.68",
    "row_num": 5,
    "column_num": 2,
    "solution": "Subtract the price of a blueberry muffin from the price of a brownie.\n\n$0.99 - $0.68 = $0.31\n\nA brownie costs $0.31 more than a blueberry muffin.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "4070",
    "path": "data"
  },
  {
    "question": "While doing a project for P. E. class, Jonathan researched the number of athletes competing in an international sporting event. What is the smallest number of athletes?",
    "choices": null,
    "answer": "29",
    "unit": "athletes",
    "table_title": "Athletes per country",
    "table": "Stem | Leaf \n2 | 9\n3 | 1, 4, 8, 8\n4 | 0\n5 | 3, 9\n6 | 1, 7\n7 | 3\n8 | 1, 5",
    "row_num": 8,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 2.\n\nNow find the lowest leaf in the first row. The lowest leaf is 9.\n\nThe smallest number of athletes has a stem of 2 and a leaf of 9. Write the stem first, then the leaf: 29.\n\nThe smallest number of athletes is 29 athletes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "31894",
    "path": "data"
  },
  {
    "question": "Kira counted the number of pairs of shoes for sale at each of the shoe stores in the mall. How many stores have at least 40 pairs of shoes but fewer than 90 pairs of shoes?",
    "choices": null,
    "answer": "18",
    "unit": "stores",
    "table_title": "Pairs of shoes per store",
    "table": "Stem | Leaf \n3 | 3, 4, 4, 5\n4 | 1, 6, 7\n5 | 0, 2, 2, 3, 3, 4, 8, 9\n6 | 0, 5, 6, 8\n7 | 9\n8 | 0, 5\n9 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 4, 5, 6, 7, and 8.\n\nYou counted 18 leaves, which are blue in the stem-and-leaf plot above. 18 stores have at least 40 pairs of shoes but fewer than 90 pairs of shoes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "13434",
    "path": "data"
  },
  {
    "question": "The school cafeteria asked students about their favorite sandwiches before updating the lunch menu. Did more upper elementary students vote for chicken salad sandwiches or turkey sandwiches?",
    "choices": [
      "turkey",
      "chicken salad"
    ],
    "answer": "chicken salad",
    "unit": null,
    "table_title": "Favorite sandwiches",
    "table": "Sandwich | Upper elementary students | Lower elementary students\nChicken salad | 13 | 19\nCheese | 12 | 19\nTurkey | 8 | 15\nRoast beef | 6 | 20",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the Upper elementary students column. Compare the numbers in this column for chicken salad and turkey.\n\n13 is more than 8. More upper elementary students voted for chicken salad sandwiches.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "14136",
    "path": "data"
  },
  {
    "question": "Gabrielle has $49.00. Does she have enough to buy a pair of brown pants and a pink sweater?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "pair of brown pants | $26.91\npair of tennis shoes | $33.27\npair of sweat pants | $11.11\nblack skirt | $14.45\npair of jeans | $32.12\npink sweater | $20.81",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a pair of brown pants and the price of a pink sweater:\n\n$26.91 + $20.81 = $47.72\n\n$47.72 is less than $49.00. Gabrielle does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "25215",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which event ends at 12.25 P.M.?",
    "choices": [
      "bear lecture",
      "insect show",
      "reptile show",
      "koala feeding"
    ],
    "answer": "bear lecture",
    "unit": null,
    "table_title": "Zoo schedule",
    "table": "Event | Begin | End\nbird show | 10:30 A.M. | 11:05 A.M.\nbear lecture | 11:20 A.M. | 12:25 P.M.\ninsect show | 1:50 P.M. | 3:10 P.M.\nkoala feeding | 4:15 P.M. | 5:00 P.M.\nreptile show | 5:25 P.M. | 5:55 P.M.",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find 12:25 P. M. on the schedule. The bear lecture ends at 12:25 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "28349",
    "path": "data"
  },
  {
    "question": "The transportation company tracked the number of train tickets sold in the past 5 days. How many train tickets were sold in all on Tuesday and Saturday?",
    "choices": null,
    "answer": "6,103",
    "unit": "tickets",
    "table_title": "Train tickets sold",
    "table": "Day | Number of tickets\nTuesday | 4,815\nWednesday | 3,764\nThursday | 3,686\nFriday | 3,358\nSaturday | 1,288",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nTuesday: 4,815\nSaturday: 1,288\n\nNow add: 4,815 + 1,288 = 6,103.\n\n6,103 train tickets were sold on Tuesday and Saturday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "14964",
    "path": "data"
  },
  {
    "question": "A pizza chef recalled how many pizzas she had made during the past 7 days. What is the mean of the numbers?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Pizzas made",
    "table": "Day | Number of pizzas\nSunday | 2\nMonday | 9\nTuesday | 0\nWednesday | 0\nThursday | 0\nFriday | 2\nSaturday | 1",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 9, 0, 0, 0, 2, 1\n\nFirst, count how many numbers are in the group.\n\nThere are 7 numbers.\n\nNow add all the numbers together:\n\n2 + 9 + 0 + 0 + 0 + 2 + 1 = 14\n\nNow divide the sum by the number of numbers:\n\n14 \u00f7 7 = 2\n\nThe mean is 2.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "24858",
    "path": "data"
  },
  {
    "question": "What is the total cost for 1 kilogram of chicken?",
    "choices": null,
    "answer": "4",
    "unit": "$",
    "table_title": null,
    "table": "beef | $4/kg\nchicken | $4/kg\npork | $2/kg\nham | $3/kg",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the chicken. Multiply the price per kilogram by the number of kilograms.\n\n$4 \u00d7 1 = $4\n\nThe total cost is $4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "34115",
    "path": "data"
  },
  {
    "question": "Each shopping bag has 5 pairs of jeans. How many pairs of jeans are in 3 shopping bags?",
    "choices": null,
    "answer": "15",
    "unit": "pairs of jeans",
    "table_title": null,
    "table": "Number of shopping bags | Number of pairs of jeans\n1 | 5\n2 | 10\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 15 pairs of jeans in 3 shopping bags.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "10763",
    "path": "data"
  },
  {
    "question": "A real estate agent tracked the number of homes recently sold in each of the nearby cities she served. In New Hamburg, how many more homes sold in 2006 than in 2007?",
    "choices": null,
    "answer": "2",
    "unit": "homes",
    "table_title": "Homes sold",
    "table": "City | 2006 | 2007\nNew Hamburg | 12 | 10\nBriggs Corner | 14 | 10\nMelville | 12 | 10\nPennytown | 12 | 12",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the New Hamburg row. Find the numbers in this row for 2006 and 2007.\n\n2006: 12\n2007: 10\n\nNow subtract:\n\n12 \u2212 10 = 2\n\nIn New Hamburg, 2 more homes sold in 2006 than in 2007.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "29256",
    "path": "data"
  },
  {
    "question": "Dominic has $24. Does he have enough to buy a book about art and a book about snakes?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "book about snakes | $10\nbook about art | $15\nbook about Australia | $19\nbook about soccer | $21\nbook about cars | $18\nbook about Antarctica | $22",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a book about art and the price of a book about snakes:\n\n$15 + $10 = $25\n\n$25 is more than $24. Dominic does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "30575",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $485, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$395 | 20,700 | 10,500\n$485 | 17,100 | 13,400\n$575 | 13,500 | 16,300\n$665 | 9,900 | 19,200\n$755 | 6,300 | 22,100",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $485, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "26707",
    "path": "data"
  },
  {
    "question": "An economist tracked the amount of per-capita aid sent from the U.S. to various countries during the 1900s. Per capita, how much more aid did Algeria receive in 1975 than in 1985?",
    "choices": null,
    "answer": "3",
    "unit": "$",
    "table_title": "Aid received per capita from the U.S.",
    "table": "Country | 1975 | 1985\nPakistan | $9 | $8\nNepal | $3 | $14\nAlgeria | $11 | $8",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the Algeria row. Find the numbers in this row for 1975 and 1985.\n\n1975: $11.00\n1985: $8.00\n\nNow subtract:\n\n$11.00 \u2212 $8.00 = $3.00\n\nPer capita, Algeria received $3 more in aid in 1975 than in 1985.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "29415",
    "path": "data"
  },
  {
    "question": "Mackenzie's P.E. class participated in a push-up competition, and Mackenzie wrote down how many push-ups each person could do. How many people did at least 55 push-ups?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": "Push-up competition (number of push-ups)",
    "table": "Stem | Leaf \n2 | 4, 4, 7, 8\n3 | 5, 6\n4 | 1, 3, 9, 9\n5 | 2, 5\n6 | 0, 3, 6\n7 | 0, 0, 2, 9\n8 | 7, 8, 9\n9 | 0",
    "row_num": 9,
    "column_num": 2,
    "solution": "Find the row with stem 5. Count all the leaves greater than or equal to 5.\n\nCount all the leaves in the rows with stems 6, 7, 8, and 9.\n\nYou counted 12 leaves, which are blue in the stem-and-leaf plots above. 12 people did at least 55 push-ups.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "28888",
    "path": "data"
  },
  {
    "question": "A vendor who sold bread at farmers' markets counted the number of leftover loaves at the end of each day. According to the table, what was the rate of change between Wednesday and Thursday?",
    "choices": null,
    "answer": "-4",
    "unit": "loaves per day",
    "table_title": "Loaves of leftover bread",
    "table": "Day | Leftover loaves\nMonday | 20\nTuesday | 21\nWednesday | 28\nThursday | 24\nFriday | 27",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{24 loaves - 28 loaves}{1 day}\n = \\frac{-4 loaves}{1 day}\n = -4 loaves per day\nThe rate of change between Wednesday and Thursday was - 4 loaves per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "32227",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $660, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$420 | 17,500 | 2,700\n$500 | 15,000 | 6,300\n$580 | 12,500 | 9,900\n$660 | 10,000 | 13,500\n$740 | 7,500 | 17,100",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $660, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "4390",
    "path": "data"
  },
  {
    "question": "Some friends compared the sizes of their stuffed animal collections. How many more stuffed animals does Zack have than Ann?",
    "choices": null,
    "answer": "268",
    "unit": "stuffed animals",
    "table_title": "Stuffed animal collections",
    "table": "Name | Number of stuffed animals\nRoy | 270\nZack | 698\nAnn | 430",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nZack: 698\nAnn: 430\n\nNow subtract: 698 - 430 = 268.\n\nZack has 268 more stuffed animals.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "2717",
    "path": "data"
  },
  {
    "question": "The county released data about how many schools there are in each town. What is the mode of the numbers?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Schools in each town",
    "table": "Town | Number of schools\nMayfield | 9\nRiverside | 2\nWatertown | 2\nGreenwood | 1\nSpringfield | 1\nChesterton | 2",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 2, 2, 1, 1, 2\n\nFirst, arrange the numbers from least to greatest:\n\n1, 1, 2, 2, 2, 9\n\nNow count how many times each number appears.\n\n1 appears 2 times.\n2 appears 3 times.\n9 appears 1 time.\n\nThe number that appears most often is 2.\n\nThe mode is 2.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "16661",
    "path": "data"
  },
  {
    "question": "A mail carrier counted how many pieces of mail he delivered each day. On which day did the mail carrier deliver the most pieces of mail?",
    "choices": [
      "Saturday",
      "Monday",
      "Tuesday",
      "Wednesday"
    ],
    "answer": "Wednesday",
    "unit": null,
    "table_title": "Pieces of mail delivered",
    "table": "Day | Number of pieces of mail\nSaturday | 268\nMonday | 269\nTuesday | 228\nWednesday | 286",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 286.\n\nNow find the corresponding day. Wednesday corresponds to 286.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "18316",
    "path": "data"
  },
  {
    "question": "Karen looked at her calendar to figure out how much time she spent babysitting each month. What is the mode of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Hours of babysitting",
    "table": "Month | Hours\nJuly | 5\nAugust | 6\nSeptember | 6\nOctober | 5\nNovember | 2\nDecember | 3\nJanuary | 5\nFebruary | 3",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 6, 6, 5, 2, 3, 5, 3\n\nFirst, arrange the numbers from least to greatest:\n\n2, 3, 3, 5, 5, 5, 6, 6\n\nNow count how many times each number appears.\n\n2 appears 1 time.\n3 appears 2 times.\n5 appears 3 times.\n6 appears 2 times.\n\nThe number that appears most often is 5.\n\nThe mode is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "19858",
    "path": "data"
  },
  {
    "question": "While working as a summer camp counselor, Eva monitored how many candy necklaces each child made. How many children did not make any candy necklaces?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Making candy necklaces",
    "table": "Candy necklaces made | Frequency\n0 | 6\n1 | 2\n2 | 12\n3 | 13\n4 | 0",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row for 0 candy necklaces and read the frequency. The frequency is 6.\n\n6 children did not make any candy necklaces.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "2819",
    "path": "data"
  },
  {
    "question": "The advertising agency counted the number of billboards in each city in the state. How many cities have at least 83 billboards but fewer than 90 billboards?",
    "choices": null,
    "answer": "2",
    "unit": "cities",
    "table_title": "Billboards per city",
    "table": "Stem | Leaf \n3 | 4, 5, 7, 7\n4 | 3, 9\n5 | 0, 7, 9\n6 | 0, 1, 2, 5, 8\n7 | 0\n8 | 3, 9\n9 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "Find the row with stem 8. Count all the leaves greater than or equal to 3.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 cities have at least 83 billboards but fewer than 90 billboards.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "2826",
    "path": "data"
  },
  {
    "question": "Three of the sports teams from Middletown High School decided to raise funds to buy new sports equipment. What fraction of the funds were raised by the water polo team? Simplify your answer.",
    "choices": null,
    "answer": "65/204",
    "unit": null,
    "table_title": "Sports equipment fundraising",
    "table": "Team | Funds raised ($)\nTrack | 640\nWater polo | 650\nTennis | 750",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find how much money was raised by the water polo.\n\n650\n\nFind how much money were raised in total.\n\n640 + 650 + 750 = 2,040\n\nDivide 650 by2,040.\n\n\\frac{650}{2,040}\n\nReduce the fraction.\n\n\\frac{650}{2,040} \u2192 \\frac{65}{204}\n\n\\frac{65}{204} of Find how much money was raised by the water polo.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "28833",
    "path": "data"
  },
  {
    "question": "An economics student recorded the amount of per-capita aid that the U.S. gave to various countries during the 1900s. In 1990, how much more aid per capita did Algeria receive than Afghanistan?",
    "choices": null,
    "answer": "3",
    "unit": "$",
    "table_title": "Aid received per capita from the U.S.",
    "table": "Country | 1980 | 1990\nAlgeria | $9 | $10\nAfghanistan | $2 | $7\nLibya | $5 | $5",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the 1990 column. Find the numbers in this column for Algeria and Afghanistan.\n\nAlgeria: $10.00\nAfghanistan: $7.00\n\nNow subtract:\n\n$10.00 \u2212 $7.00 = $3.00\n\nIn 1990, Algeria received $3 more aid per capita than Afghanistan received.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "14412",
    "path": "data"
  },
  {
    "question": "How much money does Lena need to buy 6 chocolate cheesecakes and 5 birthday cakes?",
    "choices": null,
    "answer": "164.14",
    "unit": "$",
    "table_title": null,
    "table": "birthday cake | $19.04\ncherry pie | $13.90\ncarrot cake | $26.20\napple pie | $14.68\nblueberry cheesecake | $28.94\nchocolate cheesecake | $11.49",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of 6 chocolate cheesecakes.\n\n$11.49 \u00d7 6 = $68.94\n\nFind the cost of 5 birthday cakes.\n\n$19.04 \u00d7 5 = $95.20\n\nNow find the total cost.\n\n$68.94 + $95.20 = $164.14\n\nLena needs $164.14.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "34689",
    "path": "data"
  },
  {
    "question": "A grocery store recorded how many customers visited the store each day. How many more customers did the store have on Friday than on Thursday?",
    "choices": null,
    "answer": "291",
    "unit": "customers",
    "table_title": "Grocery store customers",
    "table": "Day | Number of customers\nMonday | 426\nTuesday | 800\nWednesday | 660\nThursday | 248\nFriday | 539",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nFriday: 539\nThursday: 248\n\nNow subtract: 539 - 248 = 291.\n\nThe store had 291 more customers on Friday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "2752",
    "path": "data"
  },
  {
    "question": "Pamela has $15,446.00. How much money will Pamela have left if she buys a pair of designer boots and a pair of designer shoes?",
    "choices": null,
    "answer": "3,111",
    "unit": "$",
    "table_title": null,
    "table": "designer watch | $3,441.00\ndesigner handbag | $9,907.00\ndesigner ball gown | $6,815.00\ndesigner coat | $4,846.00\npair of designer shoes | $9,889.00\npair of designer boots | $2,446.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of a pair of designer boots and a pair of designer shoes.\n\n$2,446.00 + $9,889.00 = $12,335.00\n\nNow subtract the total cost from the starting amount.\n\n$15,446.00 - $12,335.00 = $3,111.00\n\nPamela will have $3,111.00 left.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "12303",
    "path": "data"
  },
  {
    "question": "Brett kept track of how many boxes of cookies he sold over the past 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Boxes of cookies sold",
    "table": "Day | Number of boxes\nWednesday | 8\nThursday | 8\nFriday | 7\nSaturday | 9\nSunday | 8",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n8, 8, 7, 9, 8\n\nFirst, arrange the numbers from least to greatest:\n\n7, 8, 8, 8, 9\n\nNow find the number in the middle.\n\n7, 8, 8, 8, 9\n\nThe number in the middle is 8.\n\nThe median is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "11898",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Scarlett is at the baseball stadium at 8.30 A.M. How soon can she get to downtown?",
    "choices": [
      "2:30 P.M.",
      "11:45 A.M.",
      "12:30 P.M.",
      "4:00 P.M."
    ],
    "answer": "2:30 P.M.",
    "unit": null,
    "table_title": "Subway train schedule",
    "table": "baseball stadium | 8:15 A.M. | 9:15 A.M. | 10:45 A.M.\nshopping district | 9:15 A.M. | 10:15 A.M. | 11:45 A.M.\nwaterfront | 10:00 A.M. | 11:00 A.M. | 12:30 P.M.\nindustrial district | 10:45 A.M. | 11:45 A.M. | 1:15 P.M.\nfootball stadium | 11:30 A.M. | 12:30 P.M. | 2:00 P.M.\ncivic center | 12:15 P.M. | 1:15 P.M. | 2:45 P.M.\nart gallery district | 12:45 P.M. | 1:45 P.M. | 3:15 P.M.\ndowntown | 1:30 P.M. | 2:30 P.M. | 4:00 P.M.",
    "row_num": 8,
    "column_num": 4,
    "solution": "Look at the row for the baseball stadium. Find the next train departing from the baseball stadium after 8:30 A. M. This train departs from the baseball stadium at 9:15 A. M.\n\nLook down the column until you find the row for downtown.\n\nScarlett will get to downtown at 2:30 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "7507",
    "path": "data"
  },
  {
    "question": "Lacey went to the store. She bought 1+1/4 pounds of rocky road ice cream. How much did she spend?",
    "choices": null,
    "answer": "2.50",
    "unit": "$",
    "table_title": null,
    "table": "chocolate ice cream | $6 per pound\nNeapolitan ice cream | $4 per pound\nrocky road ice cream | $2 per pound\nbutter pecan ice cream | $5 per pound\nvanilla ice cream | $6 per pound",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the rocky road ice cream. Multiply the price per pound by the number of pounds.\n$2 \u00d7 1\\frac{1}{4} = $2 \u00d7 1.25 = $2.50\nShe spent $2.50.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "25218",
    "path": "data"
  },
  {
    "question": "How much money does Josiah need to buy 6 tickets for a Hawaiian cruise and 4 tickets for an Atlantic cruise?",
    "choices": null,
    "answer": "2,750",
    "unit": "$",
    "table_title": null,
    "table": "ticket for an Alaskan cruise | $151.00\nticket for a Caribbean cruise | $845.00\nticket for a Hawaiian cruise | $135.00\nticket for an Atlantic cruise | $485.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of 6 tickets for a Hawaiian cruise.\n\n$135.00 \u00d7 6 = $810.00\n\nFind the cost of 4 tickets for an Atlantic cruise.\n\n$485.00 \u00d7 4 = $1,940.00\n\nNow find the total cost.\n\n$810.00 + $1,940.00 = $2,750.00\n\nJosiah needs $2,750.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "3310",
    "path": "data"
  },
  {
    "question": "Some students compared how many blocks they live from school. What is the mode of the numbers?",
    "choices": null,
    "answer": "10",
    "unit": null,
    "table_title": "Blocks from school",
    "table": "Name | Number of blocks\nMabel | 10\nShane | 16\nLily | 16\nFrank | 10\nAkira | 10\nRussell | 12",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 16, 16, 10, 10, 12\n\nFirst, arrange the numbers from least to greatest:\n\n10, 10, 10, 12, 16, 16\n\nNow count how many times each number appears.\n\n10 appears 3 times.\n12 appears 1 time.\n16 appears 2 times.\n\nThe number that appears most often is 10.\n\nThe mode is 10.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "32676",
    "path": "data"
  },
  {
    "question": "Kenneth, a huge fan, tracked the scores on his favorite radio quiz show. How many people scored 5?",
    "choices": null,
    "answer": "15",
    "unit": null,
    "table_title": "Scores on a radio quiz show",
    "table": "Score | Frequency\n0 | 20\n1 | 12\n2 | 0\n3 | 8\n4 | 10\n5 | 15",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row for 5 and read the frequency. The frequency is 15.\n\n15 people scored 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "28310",
    "path": "data"
  },
  {
    "question": "An ice cream shop kept track of how many ice cream cones it sold in the past 7 days. What is the mode of the numbers?",
    "choices": null,
    "answer": "90",
    "unit": null,
    "table_title": "Ice cream cones sold",
    "table": "Day | Number of ice cream cones\nSunday | 90\nMonday | 92\nTuesday | 90\nWednesday | 97\nThursday | 97\nFriday | 90\nSaturday | 92",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n90, 92, 90, 97, 97, 90, 92\n\nFirst, arrange the numbers from least to greatest:\n\n90, 90, 90, 92, 92, 97, 97\n\nNow count how many times each number appears.\n\n90 appears 3 times.\n92 appears 2 times.\n97 appears 2 times.\n\nThe number that appears most often is 90.\n\nThe mode is 90.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "13262",
    "path": "data"
  },
  {
    "question": "The movie critic liked to count the number of actors in each movie she saw. What is the largest number of actors?",
    "choices": null,
    "answer": "79",
    "unit": "actors",
    "table_title": "Actors per movie",
    "table": "Stem | Leaf \n1 | 2\n2 | 2, 7, 8\n3 | \n4 | 6, 8\n5 | 1, 3, 4, 6, 6, 9\n6 | 1, 6, 6, 6\n7 | 3, 3, 9",
    "row_num": 8,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 7.\n\nNow find the highest leaf in the last row. The highest leaf is 9.\n\nThe largest number of actors has a stem of 7 and a leaf of 9. Write the stem first, then the leaf: 79.\n\nThe largest number of actors is 79 actors.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "12358",
    "path": "data"
  },
  {
    "question": "While looking through an almanac at the library, Marie noticed some data showing the population density of various states. How many people per square mile lived in Idaho in 2000?",
    "choices": null,
    "answer": "15",
    "unit": "people per square mile",
    "table_title": "Population per square mile",
    "table": "State | 1990 | 2000\nNevada | 10 | 18\nWyoming | 4 | 5\nIdaho | 12 | 15\nNew Mexico | 12 | 15\nNorth Dakota | 9 | 9",
    "row_num": 6,
    "column_num": 3,
    "solution": "First, find the row for Idaho. Then find the number in the 2000 column.\n\nThis number is 15. In 2000, Idaho had 15 people per square mile.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "9555",
    "path": "data"
  },
  {
    "question": "How much money does Terrell need to buy 8 Caribbean vacation packages and 5 European vacation packages?",
    "choices": null,
    "answer": "63,635",
    "unit": "$",
    "table_title": null,
    "table": "Hawaiian vacation package | $1,525\nCaribbean vacation package | $3,040\nAfrican safari vacation package | $8,233\nEuropean vacation package | $7,863\nAustralian vacation package | $7,475\nJamaican vacation package | $2,897",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of 8 Caribbean vacation packages.\n\n$3,040 \u00d7 8 = $24,320\n\nFind the cost of 5 European vacation packages.\n\n$7,863 \u00d7 5 = $39,315\n\nNow find the total cost.\n\n$24,320 + $39,315 = $63,635\n\nTerrell needs $63,635.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "5460",
    "path": "data"
  },
  {
    "question": "In science class, Kari is learning about places with extreme temperatures. She learns that the highest temperature ever recorded was in Death Valley, California. She also learns that the lowest temperature ever recorded was in Vostok Station, Antarctica. The record-setting temperatures of the two locations are shown in the table. Which location's temperature was further from zero?",
    "choices": [
      "Death Valley",
      "Vostok Station"
    ],
    "answer": "Death Valley",
    "unit": null,
    "table_title": null,
    "table": "Location | Temperature (\u00b0F)\nDeath Valley | 134\nVostok Station | -128",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive number means the temperature was above zero. A negative number means the temperature was below zero.\nTo find which temperature was further from zero, use absolute value. Absolute value tells you how far a temperature is from zero.\nDeath Valley: |134| = 134\nVostok Station: |-128| = 128\nThe temperature of Death Valley was further from zero. It was 134 degrees above zero.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "38357",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Keith just missed the 12.45 P.M. bus at the science museum. What time is the next bus?",
    "choices": [
      "2:45 P.M.",
      "1:00 P.M.",
      "2:00 P.M.",
      "12:45 P.M."
    ],
    "answer": "1:00 P.M.",
    "unit": null,
    "table_title": "Bus schedule",
    "table": "the movie theater | 9:00 A.M. | 9:15 A.M. | 10:30 A.M. | 10:45 A.M.\nthe library | 10:00 A.M. | 10:15 A.M. | 11:30 A.M. | 11:45 A.M.\nthe doctor's office | 11:00 A.M. | 11:15 A.M. | 12:30 P.M. | 12:45 P.M.\nthe science museum | 11:15 A.M. | 11:30 A.M. | 12:45 P.M. | 1:00 P.M.\nthe grocery store | 11:45 A.M. | 12:00 P.M. | 1:15 P.M. | 1:30 P.M.\nthe school | 12:15 P.M. | 12:30 P.M. | 1:45 P.M. | 2:00 P.M.\nthe mall | 1:00 P.M. | 1:15 P.M. | 2:30 P.M. | 2:45 P.M.",
    "row_num": 7,
    "column_num": 5,
    "solution": "Find 12:45 P. M. in the row for the science museum.\n\nLook for the next bus in that row.\n\nThe next bus is at 1:00 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "31849",
    "path": "data"
  },
  {
    "question": "Three of the sports teams from Lowell High School decided to raise funds to buy new sports equipment. What fraction of the funds were raised by the track team? Simplify your answer.",
    "choices": null,
    "answer": "21/55",
    "unit": null,
    "table_title": "Sports equipment fundraising",
    "table": "Team | Funds raised ($)\nTrack | 630\nWater polo | 510\nBasketball | 510",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find how much money was raised by the track.\n\n630\n\nFind how much money were raised in total.\n\n630 + 510 + 510 = 1,650\n\nDivide 630 by1,650.\n\n\\frac{630}{1,650}\n\nReduce the fraction.\n\n\\frac{630}{1,650} \u2192 \\frac{21}{55}\n\n\\frac{21}{55} of Find how much money was raised by the track.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "32851",
    "path": "data"
  },
  {
    "question": "Pete kept a log of how many minutes he spent practicing skiing over the past 4 days. On which day did Pete practice the most?",
    "choices": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday"
    ],
    "answer": "Tuesday",
    "unit": null,
    "table_title": "Minutes spent practicing",
    "table": "Day | Minutes\nMonday | 158\nTuesday | 185\nWednesday | 119\nThursday | 151",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 185.\n\nNow find the corresponding day. Tuesday corresponds to 185.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "4573",
    "path": "data"
  },
  {
    "question": "Gina graphed the daily low temperature for 5 days. What is the mode of the numbers?",
    "choices": null,
    "answer": "10",
    "unit": null,
    "table_title": "Daily low temperature",
    "table": "Day | Temperature (\u00c2\u00b0C)\nWednesday | 12\nThursday | 10\nFriday | 12\nSaturday | 10\nSunday | 10",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n12, 10, 12, 10, 10\n\nFirst, arrange the numbers from least to greatest:\n\n10, 10, 10, 12, 12\n\nNow count how many times each number appears.\n\n10 appears 3 times.\n12 appears 2 times.\n\nThe number that appears most often is 10.\n\nThe mode is 10.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "2454",
    "path": "data"
  },
  {
    "question": "How much more does a designer watch cost than a designer ball gown?",
    "choices": null,
    "answer": "1,666",
    "unit": "$",
    "table_title": null,
    "table": "designer watch | $8,441\npair of designer shoes | $9,181\ndesigner handbag | $3,647\ndesigner ball gown | $6,775\npair of designer boots | $2,223",
    "row_num": 5,
    "column_num": 2,
    "solution": "Subtract the price of a designer ball gown from the price of a designer watch.\n\n$8,441 - $6,775 = $1,666\n\nA designer watch costs $1,666 more than a designer ball gown.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "27757",
    "path": "data"
  },
  {
    "question": "Some students visited nearby zoos to record the number of bears kept there. How many bears are there at the Atlantic Zoo?",
    "choices": null,
    "answer": "14",
    "unit": "bears",
    "table_title": "Bears in zoos",
    "table": "Zoo | Brown bears | Grizzly bears\nMountain Zoo | 9 | 3\nEastern Zoo | 14 | 16\nAtlantic Zoo | 6 | 8",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the row for Atlantic Zoo. Add the numbers in the Atlantic Zoo row.\n\nAdd:\n\n6 + 8 = 14\n\nThe Atlantic Zoo has 14 bears.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "3884",
    "path": "data"
  },
  {
    "question": "Students who graduate from McMillan University can receive Latin honors if they excelled in their studies. What fraction of students receiving honors graduated magna cum laude? Simplify your answer.",
    "choices": null,
    "answer": "5/18",
    "unit": null,
    "table_title": "Honors",
    "table": "Rank | Number of graduates\nCum laude | 70\nSumma cum laude | 99\nMagna cum laude | 65",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find how many students graduated magna cum laude.\n\n65\n\nFind how many students graduated with honors in total.\n\n70 + 99 + 65 = 234\n\nDivide 65 by234.\n\n\\frac{65}{234}\n\nReduce the fraction.\n\n\\frac{65}{234} \u2192 \\frac{5}{18}\n\n\\frac{5}{18} of students graduated magna cum laude.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "6597",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "x | y\n14 | 11\n17 | 9\n6 | 6",
    "row_num": 4,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nEach of the x-values is paired with only one y-value, so the relation is a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "13264",
    "path": "data"
  },
  {
    "question": "Harper bought 3/4 of a pound of Golden Wonder potatoes. How much did she spend?",
    "choices": null,
    "answer": "3",
    "unit": "$",
    "table_title": null,
    "table": "Golden Wonder potatoes | $4 per pound\nRooster potatoes | $1 per pound\nRusset Burbank potatoes | $2 per pound\nKing Edward potatoes | $4 per pound\nYukon Gold potatoes | $4 per pound\nRed Pontiac potatoes | $3 per pound",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the Golden Wonder potatoes. Multiply the price per pound by the number of pounds.\n$4 \u00d7 \\frac{3}{4} = $4 \u00d7 0.75 = $3\nShe spent $3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "172",
    "path": "data"
  },
  {
    "question": "Austin went to the store. He bought 1.9 pounds of kidney beans. How much did he spend?",
    "choices": null,
    "answer": "1.90",
    "unit": "$",
    "table_title": null,
    "table": "garbanzo beans | $2/pound\nsoybeans | $1/pound\nlima beans | $2/pound\nkidney beans | $1/pound\nlentils | $2/pound",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the kidney beans. Multiply the price per pound by the number of pounds.\n$1 \u00d7 1.9 = $1.90\nHe spent $1.90.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "27155",
    "path": "data"
  },
  {
    "question": "A donut shop recorded how many donuts it sold in the past 5 days. How many more donuts did the shop sell on Wednesday than on Tuesday?",
    "choices": null,
    "answer": "1,207",
    "unit": "donuts",
    "table_title": "Donuts sold",
    "table": "Day | Number of donuts\nSaturday | 5,435\nSunday | 1,622\nMonday | 6,753\nTuesday | 2,819\nWednesday | 4,026",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nWednesday: 4,026\nTuesday: 2,819\n\nNow subtract: 4,026 - 2,819 = 1,207.\n\nThe shop sold 1,207 more donuts on Wednesday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "13004",
    "path": "data"
  },
  {
    "question": "Each room has 5 tables. How many tables are in 4 rooms?",
    "choices": null,
    "answer": "20",
    "unit": null,
    "table_title": null,
    "table": "Number of rooms | Number of tables\n1 | 5\n2 | 10\n3 | 15\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 20 tables in 4 rooms.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "12366",
    "path": "data"
  },
  {
    "question": "Clare counted the number of cookies eaten by each customer at last week's bake sale. How many customers are there in all?",
    "choices": null,
    "answer": "69",
    "unit": null,
    "table_title": "Eating cookies last week",
    "table": "Cookies eaten | Frequency\n1 | 13\n2 | 20\n3 | 4\n4 | 14\n5 | 17\n6 | 1",
    "row_num": 7,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n13 + 20 + 4 + 14 + 17 + 1 = 69\n\nThere are 69 customers in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "12948",
    "path": "data"
  },
  {
    "question": "In hopes of raising more funds for arts education, some parents in the Newport School District publicized the current per-student arts education budget. According to the table, what was the rate of change between 2017 and 2018?",
    "choices": null,
    "answer": "2",
    "unit": "$, per year",
    "table_title": "Newport arts education budget",
    "table": "Year | Per-student budget\n2017 | $44\n2018 | $46\n2019 | $47\n2020 | $35\n2021 | $39",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{$46 - $44}{2018 - 2017}\n = \\frac{$46 - $44}{1 year}\n = \\frac{$2}{1 year}\n = $2 per year\nThe rate of change between 2017 and 2018 was $2 per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "18794",
    "path": "data"
  },
  {
    "question": "How much money does Shelley need to buy a denim skirt and a pink sweater?",
    "choices": null,
    "answer": "13",
    "unit": "$",
    "table_title": null,
    "table": "pair of shorts | $5.00\ndenim skirt | $9.00\npink sweater | $4.00\npair of white socks | $4.00\nplaid scarf | $3.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a denim skirt and the price of a pink sweater:\n\n$9.00 + $4.00 = $13.00\n\nShelley needs $13.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "30959",
    "path": "data"
  },
  {
    "question": "The Hillsboro Chamber of Commerce compared the local dealerships' vehicle sales. What fraction of the vehicles were sold by Truck Town? Simplify your answer.",
    "choices": null,
    "answer": "26/75",
    "unit": null,
    "table_title": "Vehicle sales",
    "table": "Dealership | Number of vehicles\nLedbetter Auto Mall | 950\nRV City | 220\nTruck Town | 780\nTri-City Cars | 80\nOther | 220",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find how many vehicles were sold by Truck Town.\n\n780\n\nFind how many vehicles were sold in total.\n\n950 + 220 + 780 + 80 + 220 = 2,250\n\nDivide 780 by2,250.\n\n\\frac{780}{2,250}\n\nReduce the fraction.\n\n\\frac{780}{2,250} \u2192 \\frac{26}{75}\n\n\\frac{26}{75} of vehicles were sold by Truck Town.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "20235",
    "path": "data"
  },
  {
    "question": "Each kitchen cabinet has 10 teacups. How many teacups are in 4 kitchen cabinets?",
    "choices": null,
    "answer": "40",
    "unit": null,
    "table_title": null,
    "table": "Number of kitchen cabinets | Number of teacups\n1 | 10\n2 | 20\n3 | 30\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 40 teacups in 4 kitchen cabinets.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "479",
    "path": "data"
  },
  {
    "question": "Zach, a journalism student, counted the number of pages in several major magazines. How many magazines had at least 80 pages but less than 100 pages?",
    "choices": null,
    "answer": "3",
    "unit": "magazines",
    "table_title": "Pages per magazine",
    "table": "Stem | Leaf \n1 | 4\n2 | \n3 | 0\n4 | 9\n5 | 5\n6 | 2, 4, 5\n7 | 7\n8 | 3, 4\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 8 and 9.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plot above. 3 magazines had at least 80 pages but less than 100 pages.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "28576",
    "path": "data"
  },
  {
    "question": "Avery graphed the amount of snow that fell in the last 7 days. What is the median of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Daily snowfall",
    "table": "Day | Snowfall (inches)\nWednesday | 5\nThursday | 2\nFriday | 7\nSaturday | 5\nSunday | 6\nMonday | 0\nTuesday | 3",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 2, 7, 5, 6, 0, 3\n\nFirst, arrange the numbers from least to greatest:\n\n0, 2, 3, 5, 5, 6, 7\n\nNow find the number in the middle.\n\n0, 2, 3, 5, 5, 6, 7\n\nThe number in the middle is 5.\n\nThe median is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "11714",
    "path": "data"
  },
  {
    "question": "Jayden has two dogs, Sprinkles and Champ. He is concerned because Sprinkles keeps eating Champ's food. Jayden asks their vet how much each dog's weight has changed since their last visit. Which dog's weight has changed the most?",
    "choices": [
      "Sprinkles",
      "Champ"
    ],
    "answer": "Champ",
    "unit": null,
    "table_title": null,
    "table": "Dog | Weight change (oz.)\nSprinkles | 5\nChamp | -6",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find which dog's weight changed the most, use absolute value. Absolute value tells you how much each dog's weight has changed.\nSprinkles: |5| = 5\nChamp: |-6| = 6\nChamp's weight has changed the most. He has lost 6 ounces.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "29941",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Brittany got on the train at the waterfront at 11.45 A.M. What time will she get to the university?",
    "choices": [
      "10:30 A.M.",
      "12:45 P.M.",
      "10:15 A.M.",
      "1:45 P.M."
    ],
    "answer": "12:45 P.M.",
    "unit": null,
    "table_title": "Subway train schedule",
    "table": "downtown | 10:15 A.M. | 10:30 A.M. | 10:45 A.M.\nwaterfront | 11:15 A.M. | 11:30 A.M. | 11:45 A.M.\nuniversity | 12:15 P.M. | 12:30 P.M. | 12:45 P.M.\nhistory museum | 1:15 P.M. | 1:30 P.M. | 1:45 P.M.",
    "row_num": 4,
    "column_num": 4,
    "solution": "Find 11:45 A. M. in the row for the waterfront. That column shows the schedule for the train that Brittany is on.\n\nLook down the column until you find the row for the university.\n\nBrittany will get to the university at 12:45 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "13803",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n3 | 16\n4 | 9\n5 | 2",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{9 - 16}{4 - 3}\n = \\frac{-7}{1}\n = -7\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{2 - 16}{5 - 3}\n = \\frac{-14}{2}\n = -7\nThe two rates of change are the same.\n7.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "36827",
    "path": "data"
  },
  {
    "question": "The employees at Chase's Construction monitored the number of cracked window panes in each shipment they received. How many shipments had exactly 64 cracked window panes?",
    "choices": null,
    "answer": "3",
    "unit": "shipments",
    "table_title": "Cracked window panes per shipment",
    "table": "Stem | Leaf \n5 | 1, 2, 9\n6 | 4, 4, 4\n7 | 1\n8 | 5, 5, 8, 8",
    "row_num": 5,
    "column_num": 2,
    "solution": "For the number 64, the stem is 6, and the leaf is 4. Find the row where the stem is 6. In that row, count all the leaves equal to 4.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plot above. 3 shipments had exactly 64 cracked window panes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "17130",
    "path": "data"
  },
  {
    "question": "Sofia has $1.00. Does she have enough to buy a red kazoo and a plastic horse?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "tiny doll | $0.55\nwooden block | $0.38\nplastic horse | $0.29\nred kazoo | $0.43\ncolorful pinwheel | $0.91",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a red kazoo and the price of a plastic horse:\n\n$0.43 + $0.29 = $0.72\n\n$0.72 is less than $1.00. Sofia does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 4,
    "split": "dev",
    "pid": "38176",
    "path": "data"
  },
  {
    "question": "A school interested in expanding its playground counted the number of times that students went down the slide during recess. How many students went down the slide fewer than 2 times?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": "Going down the slide at recess",
    "table": "Number of times | Frequency\n0 | 12\n1 | 0\n2 | 4\n3 | 16\n4 | 20",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the rows for 0 and 1 time. Add the frequencies for these rows.\n\nAdd:\n\n12 + 0 = 12\n\n12 students went down the slide fewer than 2 times.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "3567",
    "path": "data"
  },
  {
    "question": "How much money does Kimi need to buy a hot air balloon ride and an airplane ride?",
    "choices": null,
    "answer": "815",
    "unit": "$",
    "table_title": null,
    "table": "race car ride | $926\nairplane ride | $128\njet ski ride | $861\nhot air balloon ride | $687",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a hot air balloon ride and the price of an airplane ride:\n\n$687 + $128 = $815\n\nKimi needs $815.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "22134",
    "path": "data"
  },
  {
    "question": "Rhianna has $5,233. Does she have enough to buy a French horn and a flute?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "flute | $2,573\ncello | $9,766\ntrumpet | $2,360\ntrombone | $1,023\nFrench horn | $2,809\npiano | $9,279",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a French horn and the price of a flute:\n\n$2,809 + $2,573 = $5,382\n\n$5,382 is more than $5,233. Rhianna does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 7,
    "split": "dev",
    "pid": "17838",
    "path": "data"
  },
  {
    "question": "Some friends played a trivia game and recorded their scores. What is the median of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Trivia game scores",
    "table": "Name | Score\nFelix | 3\nAdele | 8\nCindy | 10\nKelsey | 5\nMeg | 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n3, 8, 10, 5, 7\n\nFirst, arrange the numbers from least to greatest:\n\n3, 5, 7, 8, 10\n\nNow find the number in the middle.\n\n3, 5, 7, 8, 10\n\nThe number in the middle is 7.\n\nThe median is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "20365",
    "path": "data"
  },
  {
    "question": "Dominic's Candies has been studying how much chocolate people have been eating in different countries. In 2005, how much more chocolate did Austria consume per capita than Sweden?",
    "choices": null,
    "answer": "2",
    "unit": "kg",
    "table_title": "Chocolate consumption per capita (kg)",
    "table": "Country | 2002 | 2005\nAustria | 8 | 9\nSweden | 8 | 7\nSwitzerland | 11 | 10\nDenmark | 9 | 8",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the 2005 column. Find the numbers in this column for Austria and Sweden.\n\nAustria: 9\nSweden: 7\n\nNow subtract:\n\n9 \u2212 7 = 2\n\nIn 2005, Austria consumed 2 kilograms more chocolate per capita than Sweden.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "23294",
    "path": "data"
  },
  {
    "question": "How much money does Christina need to buy a bag of cat treats and a dog bowl?",
    "choices": null,
    "answer": "13",
    "unit": "$",
    "table_title": null,
    "table": "box of dog biscuits | $8.00\ndog bowl | $7.00\nbag of cat treats | $6.00\ndog leash | $6.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a bag of cat treats and the price of a dog bowl:\n\n$6.00 + $7.00 = $13.00\n\nChristina needs $13.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "28256",
    "path": "data"
  },
  {
    "question": "Polly, a soup chef at a new restaurant, kept track of the first week's soup sales. What is the probability that a randomly selected soup was split pea and was ordered in a cup? Simplify any fractions.",
    "choices": null,
    "answer": "2/5",
    "unit": null,
    "table_title": null,
    "table": " | Cup | Bowl\nSplit pea | 4 | 2\nChicken noodle | 2 | 2",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the soup was split pea\" and B be the event \"the soup was ordered in a cup\".\nTo find the probability that a soup was split pea and was ordered in a cup, first identify the sample space and the event.\nThe outcomes in the sample space are the different soups. Each soup is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the soup was split pea and was ordered in a cup\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the soup was split pea and was ordered in a cup\", so look at the table to see how many soups were split pea and were ordered in a cup.\nThe number of soups that were split pea and were ordered in a cup is 4.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of soups.\n4 + 2 + 2 + 2 = 10\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{4}{10}\n = \\frac{2}{5}\nThe probability that a soup was split pea and was ordered in a cup is \\frac{2}{5}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "13093",
    "path": "data"
  },
  {
    "question": "The parks department compared how many basketball hoops there are at each park. What is the range of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Basketball hoops",
    "table": "Park | Number of basketball hoops\nOtter Park | 5\nWestfield Park | 2\nRiverfront Park | 5\nLinden Park | 3\nPalm Park | 9\nMooreland Park | 5\nHeron Park | 4",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 2, 5, 3, 9, 5, 4\n\nFirst, find the greatest number. The greatest number is 9.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n9 \u2212 2 = 7\n\nThe range is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "29817",
    "path": "data"
  },
  {
    "question": "Robert graphed the daily low temperature for 7 days. What is the median of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Daily low temperature",
    "table": "Day | Temperature (\u00c2\u00b0C)\nFriday | 5\nSaturday | 8\nSunday | 5\nMonday | 8\nTuesday | 8\nWednesday | 6\nThursday | 6",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 8, 5, 8, 8, 6, 6\n\nFirst, arrange the numbers from least to greatest:\n\n5, 5, 6, 6, 8, 8, 8\n\nNow find the number in the middle.\n\n5, 5, 6, 6, 8, 8, 8\n\nThe number in the middle is 6.\n\nThe median is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "20103",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n7 | 17\n8 | 13\n9 | 9",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{13 - 17}{8 - 7}\n = \\frac{-4}{1}\n = -4\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{9 - 13}{9 - 8}\n = \\frac{-4}{1}\n = -4\nThe two rates of change are the same.\n4.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "27363",
    "path": "data"
  },
  {
    "question": "For an assignment, Melissa looked at which countries got the most Nobel Prizes in various decades. How many Nobel Prize winners did Italy have in the 1970s?",
    "choices": null,
    "answer": "2",
    "unit": "Nobel Prize winners",
    "table_title": "Nobel Prize winners",
    "table": "Country | 1960s | 1970s\nGermany | 10 | 9\nItaly | 2 | 2\nJapan | 2 | 2\nRussia | 4 | 5",
    "row_num": 5,
    "column_num": 3,
    "solution": "First, find the row for Italy. Then find the number in the 1970 s column.\n\nThis number is 2. Italy had 2 Nobel Prize winners in the 1970 s.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "3269",
    "path": "data"
  },
  {
    "question": "Jenna's Candies has been studying how much chocolate people have been eating in different countries. Which country consumed the least chocolate per capita in 2002?",
    "choices": [
      "Belgium",
      "Poland",
      "Denmark",
      "Norway"
    ],
    "answer": "Poland",
    "unit": null,
    "table_title": "Chocolate consumption per capita (kg)",
    "table": "Country | 2002 | 2005\nBelgium | 8 | 11\nDenmark | 9 | 8\nNorway | 8 | 9\nSwitzerland | 11 | 10\nPoland | 3 | 4",
    "row_num": 6,
    "column_num": 3,
    "solution": "Look at the numbers in the 2002 column. Find the least number in this column.\n\nThe least number is 3, which is in the Poland row. Poland consumed the least chocolate per capita in 2002.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "8697",
    "path": "data"
  },
  {
    "question": "Hannah counted the number of pieces of pepperoni on each pizza she made. What is the largest number of pieces of pepperoni?",
    "choices": null,
    "answer": "47",
    "unit": "pieces of pepperoni",
    "table_title": "Pieces of pepperoni per pizza",
    "table": "Stem | Leaf \n0 | 4, 5, 7, 7\n1 | 0, 2, 2, 3, 4, 5, 5, 8\n2 | 6, 6, 7, 8\n3 | 4\n4 | 2, 3, 3, 4, 5, 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 4.\n\nNow find the highest leaf in the last row. The highest leaf is 7.\n\nThe largest number of pieces of pepperoni has a stem of 4 and a leaf of 7. Write the stem first, then the leaf: 47.\n\nThe largest number of pieces of pepperoni is 47 pieces of pepperoni.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "9908",
    "path": "data"
  },
  {
    "question": "After growing tired of squinting while driving, Adele went shopping for a pair of sunglasses. She tried on glasses with different frames and lenses. What is the probability that a randomly selected pair of sunglasses has regular lenses and browline frames? Simplify any fractions.",
    "choices": null,
    "answer": "1/9",
    "unit": null,
    "table_title": null,
    "table": " | Cat eye frames | Browline frames\nPolarized lenses | 4 | 6\nRegular lenses | 6 | 2",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the pair of sunglasses has regular lenses\" and B be the event \"the pair of sunglasses has browline frames\".\nTo find the probability that a pair of sunglasses has regular lenses and browline frames, first identify the sample space and the event.\nThe outcomes in the sample space are the different pairs of sunglasses. Each pair of sunglasses is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the pair of sunglasses has regular lenses and browline frames\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the pair of sunglasses has regular lenses and browline frames\", so look at the table to see how many pairs of sunglasses have regular lenses and browline frames.\nThe number of pairs of sunglasses that have regular lenses and browline frames is 2.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of pairs of sunglasses.\n4 + 6 + 6 + 2 = 18\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{2}{18}\n = \\frac{1}{9}\nThe probability that a pair of sunglasses has regular lenses and browline frames is \\frac{1}{9}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "12115",
    "path": "data"
  },
  {
    "question": "The owner of a bed and breakfast inn recalled how many guests the inn had hosted each day. What is the median of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Inn guests",
    "table": "Day | Number of guests\nFriday | 4\nSaturday | 8\nSunday | 2\nMonday | 9\nTuesday | 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n4, 8, 2, 9, 7\n\nFirst, arrange the numbers from least to greatest:\n\n2, 4, 7, 8, 9\n\nNow find the number in the middle.\n\n2, 4, 7, 8, 9\n\nThe number in the middle is 7.\n\nThe median is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "4708",
    "path": "data"
  },
  {
    "question": "Cindy records the number of pairs of sandals owned by each of her classmates. How many students own at least 3 pairs of sandals?",
    "choices": null,
    "answer": "28",
    "unit": null,
    "table_title": "Pairs of sandals",
    "table": "Number of pairs of sandals | Frequency\n0 | 8\n1 | 20\n2 | 4\n3 | 10\n4 | 11\n5 | 7",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the rows for 3, 4, and 5 pairs of sandals. Add the frequencies for these rows.\n\nAdd:\n\n10 + 11 + 7 = 28\n\n28 students own at least 3 pairs of sandals.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "27702",
    "path": "data"
  },
  {
    "question": "In a recent election at Bennett University, four people ran for student body president. What fraction of votes were for Eve? Simplify your answer.",
    "choices": null,
    "answer": "5/19",
    "unit": null,
    "table_title": "Election results",
    "table": "Candidate | Votes\nSanjay | 730\nGordon | 570\nFrank | 940\nEve | 800",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find how many votes were for Eve.\n\n800\n\nFind how many votes there were in total.\n\n730 + 570 + 940 + 800 = 3,040\n\nDivide 800 by 3,040.\n\n\\frac{800}{3,040}\n\nReduce the fraction.\n\n\\frac{800}{3,040} \u2192 \\frac{5}{19}\n\n\\frac{5}{19} of votes were for Eve.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "28311",
    "path": "data"
  },
  {
    "question": "A Technical Assistance Manager monitored his customers' wait times. How many people waited for exactly 48 minutes?",
    "choices": null,
    "answer": "1",
    "unit": "people",
    "table_title": "Technical assistance wait times (minutes)",
    "table": "Stem | Leaf \n2 | 5, 6\n3 | \n4 | 1, 3, 4, 7, 8\n5 | \n6 | 7, 8, 9\n7 | 4, 4, 4, 8\n8 | 0\n9 | 0",
    "row_num": 9,
    "column_num": 2,
    "solution": "For the number 48, the stem is 4, and the leaf is 8. Find the row where the stem is 4. In that row, count all the leaves equal to 8.\n\nYou counted 1 leaf, which is blue in the stem-and-leaf plot above. 1 person waited for exactly 48 minutes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "3180",
    "path": "data"
  },
  {
    "question": "A philanthropic organization compared the amounts of money that its members donated to certain causes. Who donated more money to arts education, Tisha or Tom?",
    "choices": [
      "Tisha",
      "Tom"
    ],
    "answer": "Tisha",
    "unit": null,
    "table_title": "Donations",
    "table": "Person | Clean water | Arts education\nTom | $1 | $15\nAustin | $3 | $4\nTisha | $8 | $18\nJackie | $10 | $16\nLindsey | $8 | $8",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Arts education column. Compare the numbers in this column for Tisha and Tom.\n\n$18.00 is more than $15.00. Tisha donated more money to arts education.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "27193",
    "path": "data"
  },
  {
    "question": "Some companies compared how many phone calls they made. Which company made the most phone calls?",
    "choices": [
      "Henderson Co.",
      "Brave New Day Corporation",
      "Reardon Corporation",
      "Tad's Coffee Company"
    ],
    "answer": "Reardon Corporation",
    "unit": null,
    "table_title": "Phone calls",
    "table": "Company | Number of phone calls\nHenderson Co. | 912\nBrave New Day Corporation | 921\nReardon Corporation | 991\nTad's Coffee Company | 929",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 991.\n\nNow find the corresponding company. Reardon Corporation corresponds to 991.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "1310",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n2 | 19\n3 | 11\n4 | 3",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{11 - 19}{3 - 2}\n = \\frac{-8}{1}\n = -8\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{3 - 11}{4 - 3}\n = \\frac{-8}{1}\n = -8\nThe two rates of change are the same.\n8.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "32127",
    "path": "data"
  },
  {
    "question": "In science class, Jeanette is measuring the temperature of different chemical mixtures. The temperatures of two mixtures are shown in the table. Which mixture's temperature is closest to zero?",
    "choices": [
      "bromine mixture",
      "acetone mixture"
    ],
    "answer": "bromine mixture",
    "unit": null,
    "table_title": null,
    "table": "Mixture | Temperature (\u00b0C)\nBromine mixture | -4\nAcetone mixture | 5",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive number means the temperature is above zero. A negative number means the temperature is below zero.\nTo find the temperature closest to zero, use absolute value. The absolute value of a temperature tells you how far it is from zero.\nBromine mixture: |-4| = 4\nAcetone mixture: |5| = 5\nThe temperature of the bromine mixture is closest to zero. It is only 4 degrees below zero.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "28850",
    "path": "data"
  },
  {
    "question": "Some students compared how many clubs they belong to. What is the median of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Clubs",
    "table": "Name | Number of clubs\nOlivia | 10\nChase | 2\nKeenan | 1\nBrandon | 9\nJoy | 7\nRachel | 8\nLexi | 2",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 2, 1, 9, 7, 8, 2\n\nFirst, arrange the numbers from least to greatest:\n\n1, 2, 2, 7, 8, 9, 10\n\nNow find the number in the middle.\n\n1, 2, 2, 7, 8, 9, 10\n\nThe number in the middle is 7.\n\nThe median is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "35577",
    "path": "data"
  },
  {
    "question": "Eli jotted down how many minutes he spent practicing piano in the past 4 days. On which day did Eli practice the least?",
    "choices": [
      "Friday",
      "Saturday",
      "Sunday",
      "Monday"
    ],
    "answer": "Saturday",
    "unit": null,
    "table_title": "Minutes spent practicing",
    "table": "Day | Minutes\nFriday | 46\nSaturday | 43\nSunday | 48\nMonday | 49",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 43.\n\nNow find the corresponding day. Saturday corresponds to 43.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "15535",
    "path": "data"
  },
  {
    "question": "An amusement park manager looked up the number of ride tickets sold in the past 4 days. How many tickets did the amusement park sell in total on Tuesday and Thursday?",
    "choices": null,
    "answer": "9,563",
    "unit": "tickets",
    "table_title": "Tickets sold",
    "table": "Day | Number of tickets\nMonday | 8,613\nTuesday | 5,071\nWednesday | 3,699\nThursday | 4,492",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nTuesday: 5,071\nThursday: 4,492\n\nNow add: 5,071 + 4,492 = 9,563.\n\nThe amusement park sold 9,563 tickets on Tuesday and Thursday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "32118",
    "path": "data"
  },
  {
    "question": "Jada joined a book club to spend more quality time with her cousin. At the first meeting, club members recorded how many hours a week they typically read and whether they preferred e-readers or paperback books. What is the probability that a randomly selected club member prefers e-readers and reads about 1 hour per week? Simplify any fractions.",
    "choices": null,
    "answer": "5/16",
    "unit": null,
    "table_title": null,
    "table": " | About 1 hour per week | About 3 hours per week\nE-readers | 5 | 4\nPaperback books | 4 | 3",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the club member prefers e-readers\" and B be the event \"the club member reads about 1 hour per week\".\nTo find the probability that a club member prefers e-readers and reads about 1 hour per week, first identify the sample space and the event.\nThe outcomes in the sample space are the different club members. Each club member is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the club member prefers e-readers and reads about 1 hour per week\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the club member prefers e-readers and reads about 1 hour per week\", so look at the table to see how many club members prefer e-readers and read about 1 hour per week.\nThe number of club members who prefer e-readers and read about 1 hour per week is 5.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of club members.\n5 + 4 + 4 + 3 = 16\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{5}{16}\nThe probability that a club member prefers e-readers and reads about 1 hour per week is \\frac{5}{16}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "21189",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $300, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$190 | 3,500 | 10,300\n$300 | 3,400 | 13,200\n$410 | 3,300 | 16,100\n$520 | 3,200 | 19,000\n$630 | 3,100 | 21,900",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $300, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "35680",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n0 | 1\n1 | 9\n2 | 17",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{9 - 1}{1 - 0}\n = \\frac{8}{1}\n = 8\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{17 - 9}{2 - 1}\n = \\frac{8}{1}\n = 8\nThe two rates of change are the same.\nIf you checked the rate of change between rows 1 and 3, you would find that it is also 8.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "30582",
    "path": "data"
  },
  {
    "question": "Ling has $5.00. Does she have enough to buy a serving platter and a cutting board?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "baking dish | $6.00\ncutting board | $3.00\nserving platter | $4.00\nlarge plate | $2.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a serving platter and the price of a cutting board:\n\n$4.00 + $3.00 = $7.00\n\n$7.00 is more than $5.00. Ling does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "5662",
    "path": "data"
  },
  {
    "question": "Ashley graphed the daily low temperature for 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Daily low temperature",
    "table": "Day | Temperature (\u00c2\u00b0C)\nMonday | 6\nTuesday | 10\nWednesday | 4\nThursday | 8\nFriday | 8",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 10, 4, 8, 8\n\nFirst, arrange the numbers from least to greatest:\n\n4, 6, 8, 8, 10\n\nNow find the number in the middle.\n\n4, 6, 8, 8, 10\n\nThe number in the middle is 8.\n\nThe median is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "10007",
    "path": "data"
  },
  {
    "question": "A newspaper researched how many grocery stores there are in each town. What is the range of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Grocery stores in each town",
    "table": "Town | Number of stores\nWatertown | 2\nSalem | 10\nAshland | 2\nRichmond | 5\nChesterton | 8\nMarion | 4",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 10, 2, 5, 8, 4\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 2 = 8\n\nThe range is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "3686",
    "path": "data"
  },
  {
    "question": "A pet store owner had his staff count the number of fish in each tank. How many tanks have at least 36 fish?",
    "choices": null,
    "answer": "8",
    "unit": "tanks",
    "table_title": "Fish per tank",
    "table": "Stem | Leaf \n3 | 0, 2\n4 | \n5 | 1, 6, 7\n6 | 2\n7 | 3, 5, 8, 9",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row with stem 3. Count all the leaves greater than or equal to 6.\n\nCount all the leaves in the rows with stems 4, 5, 6, and 7.\n\nYou counted 8 leaves, which are blue in the stem-and-leaf plots above. 8 tanks have at least 36 fish.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "25180",
    "path": "data"
  },
  {
    "question": "An agricultural agency is researching how much cheese people have been eating in different parts of the world. How much cheese was consumed per capita in Germany in 2006?",
    "choices": null,
    "answer": "20",
    "unit": "kg",
    "table_title": "Cheese consumption per capita (kg)",
    "table": "Country | 1996 | 2006\nAustralia | 10 | 10\nGermany | 12 | 20\nCanada | 10 | 11\nAustria | 10 | 17\nArgentina | 11 | 11",
    "row_num": 6,
    "column_num": 3,
    "solution": "First, find the row for Germany. Then find the number in the 2006 column.\n\nThis number is 20. In 2006, people in Germany consumed 20 kilograms of cheese per capita.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "3003",
    "path": "data"
  },
  {
    "question": "Gavin counted the number of words per page in his new book. How many pages have at least 30 words but fewer than 81 words?",
    "choices": null,
    "answer": "4",
    "unit": "pages",
    "table_title": "Words per page",
    "table": "Stem | Leaf \n1 | 1, 3\n2 | 3\n3 | \n4 | 2\n5 | \n6 | 8\n7 | 7, 8\n8 | 2\n9 | 0, 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 3, 4, 5, 6, and 7.\n\nIn the row with stem 8, count all the leaves less than 1.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plots above. 4 pages have at least 30 words but fewer than 81 words.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "7590",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which stop does the ferry depart from at 6.50 A.M.?",
    "choices": [
      "Seagull Port",
      "Grassy Beach",
      "Sandy Shores",
      "Bay Harbor"
    ],
    "answer": "Seagull Port",
    "unit": null,
    "table_title": "Ferry schedule",
    "table": "Location | Arrive | Depart\nSeagull Port | 6:35 A.M. | 6:50 A.M.\nPebble Town | 7:45 A.M. | 8:15 A.M.\nGrassy Beach | 9:25 A.M. | 9:45 A.M.\nFoggy Port | 10:15 A.M. | 10:40 A.M.\nBeach Town | 11:45 A.M. | 11:50 A.M.\nSandy Shores | 1:20 P.M. | 1:25 P.M.\nCliff View | 2:25 P.M. | 2:50 P.M.\nRocky Port | 3:10 P.M. | 3:40 P.M.\nCrest View | 4:15 P.M. | 4:20 P.M.\nBay Harbor | 5:20 P.M. | 5:30 P.M.",
    "row_num": 11,
    "column_num": 3,
    "solution": "Find 6:50 A. M. on the schedule. The ferry departs from Seagull Port at 6:50 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "31415",
    "path": "data"
  },
  {
    "question": "A county agency recorded the money donated to several charitable causes over time. How much more money was raised for medical research in June than in May?",
    "choices": null,
    "answer": "11",
    "unit": "$",
    "table_title": "Donations received",
    "table": "Cause | May | June\nHunger | $12 | $14\nEducation | $10 | $7\nParks | $20 | $20\nMedical research | $7 | $18\nAnimals | $1 | $8",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Medical research row. Find the numbers in this row for June and May.\n\nJune: $18.00\nMay: $7.00\n\nNow subtract:\n\n$18.00 \u2212 $7.00 = $11.00\n\n$11 more was raised for medical research in June than in May.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "10312",
    "path": "data"
  },
  {
    "question": "Lorenzo kept track of the number of games his soccer team won each year. According to the table, what was the rate of change between 2011 and 2012?",
    "choices": null,
    "answer": "3",
    "unit": "games per year",
    "table_title": "Games won by Lorenzo's soccer team",
    "table": "Year | Games won\n2010 | 45\n2011 | 30\n2012 | 33\n2013 | 44\n2014 | 31",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{33 games - 30 games}{2012 - 2011}\n = \\frac{33 games - 30 games}{1 year}\n = \\frac{3 games}{1 year}\n = 3 games per year\nThe rate of change between 2011 and 2012 was 3 games per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "239",
    "path": "data"
  },
  {
    "question": "A pumpkin patch monitored the number of pumpkins sold each day. What is the range of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Pumpkins sold",
    "table": "Day | Number of pumpkins\nWednesday | 32\nThursday | 32\nFriday | 32\nSaturday | 31\nSunday | 35\nMonday | 30\nTuesday | 31",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n32, 32, 32, 31, 35, 30, 31\n\nFirst, find the greatest number. The greatest number is 35.\n\nNext, find the least number. The least number is 30.\n\nSubtract the least number from the greatest number:\n\n35 \u2212 30 = 5\n\nThe range is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "8474",
    "path": "data"
  },
  {
    "question": "A donut shop recorded how many donuts it sold in the past 5 days. How many more donuts did the shop sell on Sunday than on Thursday?",
    "choices": null,
    "answer": "328",
    "unit": "donuts",
    "table_title": "Donuts sold",
    "table": "Day | Number of donuts\nWednesday | 656\nThursday | 197\nFriday | 419\nSaturday | 767\nSunday | 525",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nSunday: 525\nThursday: 197\n\nNow subtract: 525 - 197 = 328.\n\nThe shop sold 328 more donuts on Sunday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "38331",
    "path": "data"
  },
  {
    "question": "Felix's class recorded how many states each student has visited. What is the range of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "States visited",
    "table": "Name | Number of states\nFelix | 1\nLiz | 3\nRudy | 8\nNina | 9\nEvelyn | 1\nDylan | 1\nMason | 3\nChandler | 7",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n1, 3, 8, 9, 1, 1, 3, 7\n\nFirst, find the greatest number. The greatest number is 9.\n\nNext, find the least number. The least number is 1.\n\nSubtract the least number from the greatest number:\n\n9 \u2212 1 = 8\n\nThe range is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "11664",
    "path": "data"
  },
  {
    "question": "An Idaho farmer has been monitoring crop prices over time. Per cwt, how much did Timothy seed cost in 2006?",
    "choices": null,
    "answer": "11",
    "unit": "$",
    "table_title": "Idaho crop prices per cwt",
    "table": "Crop | 2005 | 2006\nApples | $18 | $19\nTimothy seed | $7 | $11\nPeas | $6 | $8",
    "row_num": 4,
    "column_num": 3,
    "solution": "First, find the row for Timothy seed. Then find the number in the 2006 column.\n\nThis number is $11.00. In 2006, Timothy seed cost $11 per cwt.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "22132",
    "path": "data"
  },
  {
    "question": "Look at Felicia's pay stub. Felicia lives in a state without state income tax. How much payroll tax did Felicia pay in total?",
    "choices": null,
    "answer": "453.06",
    "unit": "$",
    "table_title": null,
    "table": "Employee | Pay period |\nFelicia Singer | August 16-31 |\nTotal earnings | | $2,110.00\nFederal income tax | $291.66 |\nOther taxes | $161.40 |\nTotal taxes | | ?\nPay after taxes | | ?",
    "row_num": 7,
    "column_num": 3,
    "solution": "To find the total payroll tax, add the federal income tax and the other taxes.\nThe federal income tax is $291.66. The other taxes are $161.40. Add.\n$291.66 + $161.40 = $453.06\nFelicia paid a total of $453.06 in payroll tax.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "31485",
    "path": "data"
  },
  {
    "question": "A car dealership tracked the number of cars sold each month. What is the median of the numbers?",
    "choices": null,
    "answer": "39",
    "unit": null,
    "table_title": "Cars sold",
    "table": "Month | Number of cars\nJanuary | 38\nFebruary | 41\nMarch | 39\nApril | 61\nMay | 36",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n38, 41, 39, 61, 36\n\nFirst, arrange the numbers from least to greatest:\n\n36, 38, 39, 41, 61\n\nNow find the number in the middle.\n\n36, 38, 39, 41, 61\n\nThe number in the middle is 39.\n\nThe median is 39.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "10316",
    "path": "data"
  },
  {
    "question": "Paula spent a week at the beach and recorded the number of shells she found each day. According to the table, what was the rate of change between Sunday and Monday?",
    "choices": null,
    "answer": "0",
    "unit": "shells per day",
    "table_title": "Shells Paula found",
    "table": "Day | Number of shells\nSunday | 6\nMonday | 6\nTuesday | 4\nWednesday | 1\nThursday | 3",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{6 shells - 6 shells}{1 day}\n = \\frac{0 shells}{1 day}\n = 0 shells per day\nThe rate of change between Sunday and Monday was 0 shells per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "27056",
    "path": "data"
  },
  {
    "question": "A grocery store tracked how many bananas it sold each day. On which day did the grocery store sell the most bananas?",
    "choices": [
      "Friday",
      "Saturday",
      "Sunday",
      "Monday"
    ],
    "answer": "Friday",
    "unit": null,
    "table_title": "Bananas sold",
    "table": "Day | Number of bananas\nFriday | 884\nSaturday | 838\nSunday | 834\nMonday | 849",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 884.\n\nNow find the corresponding day. Friday corresponds to 884.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "30386",
    "path": "data"
  },
  {
    "question": "An environmental agency examined how many trees were planted by different organizations. What is the mode of the numbers?",
    "choices": null,
    "answer": "76",
    "unit": null,
    "table_title": "Trees planted",
    "table": "Organization | Number of trees planted\nDreaming Green | 76\nMake it Green | 60\nLet it Grow | 60\nPlant It | 76\nAcorns to Oaks | 72\nTrees for All | 76\nHeal the Earth | 76\nNew Planet | 72",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n76, 60, 60, 76, 72, 76, 76, 72\n\nFirst, arrange the numbers from least to greatest:\n\n60, 60, 72, 72, 76, 76, 76, 76\n\nNow count how many times each number appears.\n\n60 appears 2 times.\n72 appears 2 times.\n76 appears 4 times.\n\nThe number that appears most often is 76.\n\nThe mode is 76.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "17566",
    "path": "data"
  },
  {
    "question": "How much money does Addison need to buy a ticket for an Atlantic cruise and a ticket for a South American cruise?",
    "choices": null,
    "answer": "1,374",
    "unit": "$",
    "table_title": null,
    "table": "ticket for a South American cruise | $786.00\nticket for an Alaskan cruise | $577.00\nticket for an Atlantic cruise | $588.00\nticket for a Hawaiian cruise | $731.00\nticket for a Mediterranean cruise | $510.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a ticket for an Atlantic cruise and the price of a ticket for a South American cruise:\n\n$588.00 + $786.00 = $1,374.00\n\nAddison needs $1,374.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "2317",
    "path": "data"
  },
  {
    "question": "How much money does Quinn need to buy a denim skirt and a gray sweatshirt?",
    "choices": null,
    "answer": "26",
    "unit": "$",
    "table_title": null,
    "table": "gray sweatshirt | $15\ndenim skirt | $11\npair of brown pants | $15\ngreen dress | $43",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a denim skirt and the price of a gray sweatshirt:\n\n$11 + $15 = $26\n\nQuinn needs $26.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "30855",
    "path": "data"
  },
  {
    "question": "The members of the swimming team compared how many laps they swam yesterday. Who swam the most laps?",
    "choices": [
      "Cara",
      "Alec",
      "Rose",
      "Bridgette"
    ],
    "answer": "Rose",
    "unit": null,
    "table_title": "Swimming laps",
    "table": "Name | Laps\nCara | 67\nAlec | 61\nRose | 68\nBridgette | 60",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 68.\n\nNow find the corresponding name. Rose corresponds to 68.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "34851",
    "path": "data"
  },
  {
    "question": "How much money does Jada need to buy 7 coffee tables?",
    "choices": null,
    "answer": "296.10",
    "unit": "$",
    "table_title": null,
    "table": "coffee table | $42.30\nwooden stool | $13.35\nhammock | $41.05\nbookcase | $27.30\nset of bunk beds | $65.38\nrocking chair | $95.10",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of 7 coffee tables by multiplying 7 times the price of a coffee table.\n\n$42.30 \u00d7 7 = $296.10\n\nJada needs $296.10.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "2138",
    "path": "data"
  },
  {
    "question": "Lorenzo counted the number of pieces of pepperoni on each pizza he made. What is the smallest number of pieces of pepperoni?",
    "choices": null,
    "answer": "12",
    "unit": "pieces of pepperoni",
    "table_title": "Pieces of pepperoni per pizza",
    "table": "Stem | Leaf \n1 | 2, 4, 9\n2 | 1, 2, 2, 4, 7\n3 | 0, 1, 2\n4 | 5, 7, 8, 9",
    "row_num": 5,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 1.\n\nNow find the lowest leaf in the first row. The lowest leaf is 2.\n\nThe smallest number of pieces of pepperoni has a stem of 1 and a leaf of 2. Write the stem first, then the leaf: 12.\n\nThe smallest number of pieces of pepperoni is 12 pieces of pepperoni.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "13952",
    "path": "data"
  },
  {
    "question": "The members of the swimming team compared how many laps they swam yesterday. What is the median of the numbers?",
    "choices": null,
    "answer": "91",
    "unit": null,
    "table_title": "Swimming laps",
    "table": "Name | Laps\nSally | 91\nLouis | 99\nAlvin | 90\nDiane | 98\nBaldwin | 89",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n91, 99, 90, 98, 89\n\nFirst, arrange the numbers from least to greatest:\n\n89, 90, 91, 98, 99\n\nNow find the number in the middle.\n\n89, 90, 91, 98, 99\n\nThe number in the middle is 91.\n\nThe median is 91.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "30737",
    "path": "data"
  },
  {
    "question": "An author recorded how many words she wrote in the past 3 days. How many words in total did the author write on Thursday and Friday?",
    "choices": null,
    "answer": "8,830",
    "unit": "words",
    "table_title": "Words written",
    "table": "Day | Number of words\nThursday | 7,143\nFriday | 1,687\nSaturday | 1,691",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nThursday: 7,143\nFriday: 1,687\n\nNow add: 7,143 + 1,687 = 8,830.\n\nThe author wrote 8,830 words on Thursday and Friday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "35748",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the beginning ballet class end?",
    "choices": [
      "1:35 P.M.",
      "12:30 P.M.",
      "7:05 P.M.",
      "10:45 A.M."
    ],
    "answer": "1:35 P.M.",
    "unit": null,
    "table_title": "Dance studio schedule",
    "table": "Class | Begin | End\nballroom dance | 8:20 A.M. | 9:45 A.M.\nhip hop dance | 9:55 A.M. | 10:45 A.M.\nadvanced ballet | 10:55 A.M. | 12:25 P.M.\nbeginning ballet | 12:30 P.M. | 1:35 P.M.\ntap dance | 1:50 P.M. | 2:55 P.M.\njazz dance | 3:10 P.M. | 4:00 P.M.\nintermediate ballet | 4:05 P.M. | 5:25 P.M.\nsalsa dance | 5:40 P.M. | 7:05 P.M.",
    "row_num": 9,
    "column_num": 3,
    "solution": "Find the beginning ballet class on the schedule. Find the end time for the beginning ballet class.\n\nbeginning ballet: 1:35 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "12870",
    "path": "data"
  },
  {
    "question": "The students in Mr. Lloyd's class recorded the number of siblings that each has. How many students in the class have exactly 6 siblings?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": "Siblings",
    "table": "Number of siblings | Frequency\n0 | 10\n1 | 14\n2 | 16\n3 | 3\n4 | 8\n5 | 7\n6 | 12",
    "row_num": 8,
    "column_num": 2,
    "solution": "Find the row for 6 siblings and read the frequency. The frequency is 12.\n\nThere are 12 students who have exactly 6 siblings.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "14837",
    "path": "data"
  },
  {
    "question": "How much money does Tom need to buy a piece of copper and a piece of black mica?",
    "choices": null,
    "answer": "1.42",
    "unit": "$",
    "table_title": null,
    "table": "piece of green slate | $0.88\npiece of copper | $0.97\npiece of black mica | $0.45\npiece of polished granite | $0.10\npiece of red sandstone | $0.51",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a piece of copper and the price of a piece of black mica:\n\n$0.97 + $0.45 = $1.42\n\nTom needs $1.42.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "22625",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "nonlinear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n8 | 18\n9 | 12\n10 | 4",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{12 - 18}{9 - 8}\n = \\frac{-6}{1}\n = -6\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{4 - 12}{10 - 9}\n = \\frac{-8}{1}\n = -8\nThe rate of change is not the same for each pair of points. So, the function does not have a constant rate of change.\nThe function is nonlinear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "22529",
    "path": "data"
  },
  {
    "question": "Layla has $11.00. Does she have enough to buy a cookie sheet and a casserole dish?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "large plate | $2.00\nmixing bowl | $5.00\ncookie sheet | $8.00\ncasserole dish | $5.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a cookie sheet and the price of a casserole dish:\n\n$8.00 + $5.00 = $13.00\n\n$13.00 is more than $11.00. Layla does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "34073",
    "path": "data"
  },
  {
    "question": "Students who graduate from Leonard University can receive Latin honors if they excelled in their studies. What fraction of students receiving honors graduated summa cum laude? Simplify your answer.",
    "choices": null,
    "answer": "1/10",
    "unit": null,
    "table_title": "Honors",
    "table": "Rank | Number of graduates\nSumma cum laude | 10\nMagna cum laude | 81\nCum laude | 9",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find how many students graduated summa cum laude.\n\n10\n\nFind how many students graduated with honors in total.\n\n10 + 81 + 9 = 100\n\nDivide 10 by100.\n\n\\frac{10}{100}\n\nReduce the fraction.\n\n\\frac{10}{100} \u2192 \\frac{1}{10}\n\n\\frac{1}{10} of students graduated summa cum laude.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "24331",
    "path": "data"
  },
  {
    "question": "Carla counted the number of pairs of shoes for sale at each of the shoe stores in the mall. How many stores have at least 30 pairs of shoes?",
    "choices": null,
    "answer": "9",
    "unit": "stores",
    "table_title": "Pairs of shoes per store",
    "table": "Stem | Leaf \n1 | 9\n2 | 2, 4, 5, 5, 6\n3 | \n4 | 2, 7\n5 | 2, 3, 9\n6 | 3\n7 | \n8 | 1, 3, 9",
    "row_num": 9,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 3, 4, 5, 6, 7, and 8.\n\nYou counted 9 leaves, which are blue in the stem-and-leaf plot above. 9 stores have at least 30 pairs of shoes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "23388",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the whale feeding begin?",
    "choices": [
      "3:10 P.M.",
      "2:45 P.M.",
      "4:25 P.M.",
      "5:40 P.M."
    ],
    "answer": "4:25 P.M.",
    "unit": null,
    "table_title": "Aquarium schedule",
    "table": "Event | Begin | End\nstarfish demonstration | 9:25 A.M. | 10:45 A.M.\noctopus lecture | 11:40 A.M. | 12:15 P.M.\notter feeding | 1:10 P.M. | 2:30 P.M.\njellyfish lecture | 2:25 P.M. | 3:10 P.M.\ncoral reef demonstration | 2:45 P.M. | 3:15 P.M.\nwhale feeding | 4:25 P.M. | 5:40 P.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find the whale feeding on the schedule. Find the beginning time for the whale feeding.\n\nwhale feeding: 4:25 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "27467",
    "path": "data"
  },
  {
    "question": "During health class, the students reported the number of times they ate fast food last month. How many students ate fast food exactly 5 times last month?",
    "choices": null,
    "answer": "11",
    "unit": null,
    "table_title": "Eating fast food last month",
    "table": "Times eaten | Frequency\n0 | 12\n1 | 9\n2 | 2\n3 | 1\n4 | 13\n5 | 11",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row for 5 times and read the frequency. The frequency is 11.\n\n11 students ate fast food exactly 5 times last month.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "6155",
    "path": "data"
  },
  {
    "question": "How much money does Christine need to buy a muffin and a pickle?",
    "choices": null,
    "answer": "1.16",
    "unit": "$",
    "table_title": null,
    "table": "piece of cornbread | $0.84\nchocolate-chip cookie | $0.63\nmuffin | $0.72\nbag of peanuts | $0.78\npickle | $0.44",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a muffin and the price of a pickle:\n\n$0.72 + $0.44 = $1.16\n\nChristine needs $1.16.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 3,
    "split": "dev",
    "pid": "2289",
    "path": "data"
  },
  {
    "question": "Principal Roth reported the state test scores from some students at his school. How many students scored exactly 68 points?",
    "choices": null,
    "answer": "3",
    "unit": "students",
    "table_title": "Test scores",
    "table": "Stem | Leaf \n0 | 8\n1 | 4, 4, 5, 7\n2 | \n3 | \n4 | 6\n5 | \n6 | 0, 1, 2, 7, 8, 8, 8\n7 | 0",
    "row_num": 9,
    "column_num": 2,
    "solution": "For the number 68, the stem is 6, and the leaf is 8. Find the row where the stem is 6. In that row, count all the leaves equal to 8.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plot above. 3 students scored exactly 68 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "12138",
    "path": "data"
  },
  {
    "question": "How much money does Ellie need to buy 2 pairs of boots and 2 pairs of brown pants?",
    "choices": null,
    "answer": "146",
    "unit": "$",
    "table_title": null,
    "table": "pair of jeans | $38\npair of boots | $45\ndenim skirt | $17\npurple dress | $14\npair of brown pants | $28\nwinter jacket | $53",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of 2 pairs of boots.\n\n$45 \u00d7 2 = $90\n\nFind the cost of 2 pairs of brown pants.\n\n$28 \u00d7 2 = $56\n\nNow find the total cost.\n\n$90 + $56 = $146\n\nEllie needs $146.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "2251",
    "path": "data"
  },
  {
    "question": "How much money does Sandeep need to buy 8 cucumbers?",
    "choices": null,
    "answer": "8.40",
    "unit": "$",
    "table_title": null,
    "table": "pumpkin | $2.41\nred pepper | $1.33\nyellow pepper | $1.22\ncucumber | $1.05",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of 8 cucumbers by multiplying 8 times the price of a cucumber.\n\n$1.05 \u00d7 8 = $8.40\n\nSandeep needs $8.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "29118",
    "path": "data"
  },
  {
    "question": "How much money does Lee need to buy 6 pairs of shoes and a pair of tennis shoes?",
    "choices": null,
    "answer": "130.23",
    "unit": "$",
    "table_title": null,
    "table": "pair of shoes | $19.80\npair of boots | $40.32\nblack jacket | $19.06\npair of tennis shoes | $11.43\ngray sweatshirt | $18.14",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of 6 pairs of shoes.\n\n$19.80 \u00d7 6 = $118.80\n\nNow find the total cost.\n\n$118.80 + $11.43 = $130.23\n\nLee needs $130.23.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "23948",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which event begins at 11.45 A.M.?",
    "choices": [
      "swimming competition",
      "lunch",
      "softball game",
      "soccer game"
    ],
    "answer": "softball game",
    "unit": null,
    "table_title": "School picnic schedule",
    "table": "Event | Begin | End\nsoccer game | 10:20 A.M. | 11:10 A.M.\nkickball game | 11:10 A.M. | 11:30 A.M.\nsoftball game | 11:45 A.M. | 12:25 P.M.\nswimming competition | 12:15 P.M. | 12:35 P.M.\nlunch | 12:40 P.M. | 1:30 P.M.\npie-eating contest | 1:35 P.M. | 2:05 P.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find 11:45 A. M. on the schedule. The softball game begins at 11:45 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "10971",
    "path": "data"
  },
  {
    "question": "As part of a statistics project, a math class weighed all the children who were willing to participate. What is the weight of the lightest child?",
    "choices": null,
    "answer": "10",
    "unit": "pounds",
    "table_title": "Children's weights (lbs)",
    "table": "Stem | Leaf \n1 | 0\n2 | 1, 3, 7\n3 | 3, 5\n4 | \n5 | 7\n6 | 2, 5, 8",
    "row_num": 7,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 1.\n\nNow find the lowest leaf in the first row. The lowest leaf is 0.\n\nThe weight of the lightest child has a stem of 1 and a leaf of 0. Write the stem first, then the leaf: 10.\n\nThe weight of the lightest child is 10 pounds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "117",
    "path": "data"
  },
  {
    "question": "Adam's coach wrote down how many kilometers he had run over the past 7 days. What is the median of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Kilometers run",
    "table": "Day | Kilometers\nThursday | 9\nFriday | 10\nSaturday | 7\nSunday | 7\nMonday | 2\nTuesday | 4\nWednesday | 5",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 10, 7, 7, 2, 4, 5\n\nFirst, arrange the numbers from least to greatest:\n\n2, 4, 5, 7, 7, 9, 10\n\nNow find the number in the middle.\n\n2, 4, 5, 7, 7, 9, 10\n\nThe number in the middle is 7.\n\nThe median is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "25149",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "nonlinear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n11 | 5\n12 | 6\n13 | 14",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{6 - 5}{12 - 11}\n = \\frac{1}{1}\n = 1\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{14 - 5}{13 - 11}\n = \\frac{9}{2}\n = 4\\frac{1}{2}\nThe rate of change is not the same for each pair of points. So, the function does not have a constant rate of change.\nThe function is nonlinear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "2614",
    "path": "data"
  },
  {
    "question": "A mail carrier counted how many pieces of mail she delivered each day. On which day did the mail carrier deliver the fewest pieces of mail?",
    "choices": [
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday"
    ],
    "answer": "Thursday",
    "unit": null,
    "table_title": "Pieces of mail delivered",
    "table": "Day | Number of pieces of mail\nWednesday | 574\nThursday | 545\nFriday | 547\nSaturday | 557",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 545.\n\nNow find the corresponding day. Thursday corresponds to 545.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "34154",
    "path": "data"
  },
  {
    "question": "An athlete counted how many autographs he signed each day. What is the median of the numbers?",
    "choices": null,
    "answer": "30",
    "unit": null,
    "table_title": "Autographs signed",
    "table": "Day | Number of autographs\nSaturday | 28\nSunday | 35\nMonday | 32\nTuesday | 29\nWednesday | 30",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n28, 35, 32, 29, 30\n\nFirst, arrange the numbers from least to greatest:\n\n28, 29, 30, 32, 35\n\nNow find the number in the middle.\n\n28, 29, 30, 32, 35\n\nThe number in the middle is 30.\n\nThe median is 30.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "7633",
    "path": "data"
  },
  {
    "question": "Brenna's coach wrote down how many kilometers she had run over the past 5 days. What is the mode of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Kilometers run",
    "table": "Day | Kilometers\nMonday | 6\nTuesday | 1\nWednesday | 6\nThursday | 6\nFriday | 1",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 1, 6, 6, 1\n\nFirst, arrange the numbers from least to greatest:\n\n1, 1, 6, 6, 6\n\nNow count how many times each number appears.\n\n1 appears 2 times.\n6 appears 3 times.\n\nThe number that appears most often is 6.\n\nThe mode is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "30005",
    "path": "data"
  },
  {
    "question": "Tisha has $1,394.00. How much money will Tisha have left if she buys a cello and a guitar?",
    "choices": null,
    "answer": "433",
    "unit": "$",
    "table_title": null,
    "table": "guitar | $671.00\ncello | $290.00\norgan | $167.00\ntuba | $863.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of a cello and a guitar.\n\n$290.00 + $671.00 = $961.00\n\nNow subtract the total cost from the starting amount.\n\n$1,394.00 - $961.00 = $433.00\n\nTisha will have $433.00 left.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "19434",
    "path": "data"
  },
  {
    "question": "A newspaper researched how many grocery stores there are in each town. What is the range of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Grocery stores in each town",
    "table": "Town | Number of stores\nMayfield | 6\nWatertown | 9\nSpringfield | 4\nColumbia | 7\nSalem | 6\nAshland | 5\nMarion | 3\nChesterton | 9",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 9, 4, 7, 6, 5, 3, 9\n\nFirst, find the greatest number. The greatest number is 9.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n9 \u2212 3 = 6\n\nThe range is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "17093",
    "path": "data"
  },
  {
    "question": "Some teachers compared how many years they have been teaching. What is the mean of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Years of teaching",
    "table": "Teacher | Number of years\nMrs. Ramirez | 3\nMr. Park | 1\nMiss Watson | 2\nMs. Chan | 6\nMr. Gutierrez | 8\nMr. Boone | 7\nMr. Nakamura | 1",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n3, 1, 2, 6, 8, 7, 1\n\nFirst, count how many numbers are in the group.\n\nThere are 7 numbers.\n\nNow add all the numbers together:\n\n3 + 1 + 2 + 6 + 8 + 7 + 1 = 28\n\nNow divide the sum by the number of numbers:\n\n28 \u00f7 7 = 4\n\nThe mean is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "1178",
    "path": "data"
  },
  {
    "question": "A reporter counted the number of masks local artists made for this year's masquerade ball. How many artists are there in all?",
    "choices": null,
    "answer": "66",
    "unit": null,
    "table_title": "Making paper masks",
    "table": "Masks made | Frequency\n1 | 3\n2 | 14\n3 | 20\n4 | 12\n5 | 10\n6 | 7",
    "row_num": 7,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n3 + 14 + 20 + 12 + 10 + 7 = 66\n\nThere are 66 artists in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "12891",
    "path": "data"
  },
  {
    "question": "Baldwin kept track of how many kilometers he walked during the past 7 days. What is the range of the numbers?",
    "choices": null,
    "answer": "10",
    "unit": null,
    "table_title": "Kilometers walked",
    "table": "Day | Kilometers\nThursday | 0\nFriday | 10\nSaturday | 9\nSunday | 7\nMonday | 4\nTuesday | 7\nWednesday | 7",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n0, 10, 9, 7, 4, 7, 7\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 0.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 0 = 10\n\nThe range is 10.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "24993",
    "path": "data"
  },
  {
    "question": "For an economics project, Ellen determined the cost of ferry rides for bicycles and cars. How much does it cost to take a bicycle on the Fauntleroy-Vashon ferry?",
    "choices": null,
    "answer": "5",
    "unit": "$",
    "table_title": "Ferry fares",
    "table": "Ferry | Car | Bicycle\nSeattle-Bremerton | $12 | $8\nFauntleroy-Vashon | $15 | $5\nOcracoke | $15 | $3\nSouthport-Fort Fisher | $5 | $2\nMukilteu-Clinton | $7 | $5",
    "row_num": 6,
    "column_num": 3,
    "solution": "First, find the row for Fauntleroy-Vashon. Then find the number in the Bicycle column.\n\nThis number is $5.00. It costs $5 to take a bicycle on the Fauntleroy-Vashon ferry.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "36655",
    "path": "data"
  },
  {
    "question": "Walter's family went on a road trip and counted the number of cars they saw each day. What is the median of the numbers?",
    "choices": null,
    "answer": "63",
    "unit": null,
    "table_title": "Number of cars",
    "table": "Day | Number of cars\nSunday | 63\nMonday | 69\nTuesday | 71\nWednesday | 53\nThursday | 51",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n63, 69, 71, 53, 51\n\nFirst, arrange the numbers from least to greatest:\n\n51, 53, 63, 69, 71\n\nNow find the number in the middle.\n\n51, 53, 63, 69, 71\n\nThe number in the middle is 63.\n\nThe median is 63.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "4120",
    "path": "data"
  },
  {
    "question": "Carla wrote down how many pages she read over the past 4 days. How many more pages did Carla read on Wednesday than on Friday?",
    "choices": null,
    "answer": "63",
    "unit": "pages",
    "table_title": "Pages read",
    "table": "Day | Number of pages\nWednesday | 195\nThursday | 299\nFriday | 132\nSaturday | 227",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nWednesday: 195\nFriday: 132\n\nNow subtract: 195 - 132 = 63.\n\nCarla read 63 more pages on Wednesday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "22771",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "x | y\n2 | 14\n4 | 12\n4 | 10",
    "row_num": 4,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nThe x-value 4 is paired with multiple y-values, so the relation is not a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "16225",
    "path": "data"
  },
  {
    "question": "How much money does Kate need to buy a book about baseball and a book about dinosaurs?",
    "choices": null,
    "answer": "36",
    "unit": "$",
    "table_title": null,
    "table": "book about the Olympics | $14\nbook about dinosaurs | $15\nbook about baseball | $21\nbook about snakes | $24\nbook about art | $22",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a book about baseball and the price of a book about dinosaurs:\n\n$21 + $15 = $36\n\nKate needs $36.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "3592",
    "path": "data"
  },
  {
    "question": "Estelle kept a driving log to see how many miles she drove each day. What is the mean of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Miles driven",
    "table": "Day | Number of miles\nSunday | 4\nMonday | 4\nTuesday | 6\nWednesday | 8\nThursday | 1\nFriday | 1",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n4, 4, 6, 8, 1, 1\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n4 + 4 + 6 + 8 + 1 + 1 = 24\n\nNow divide the sum by the number of numbers:\n\n24 \u00f7 6 = 4\n\nThe mean is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "22150",
    "path": "data"
  },
  {
    "question": "A vendor who sold bread at farmers' markets counted the number of leftover loaves at the end of each day. According to the table, what was the rate of change between Sunday and Monday?",
    "choices": null,
    "answer": "7",
    "unit": "loaves per day",
    "table_title": "Loaves of leftover bread",
    "table": "Day | Leftover loaves\nSunday | 17\nMonday | 24\nTuesday | 20\nWednesday | 20\nThursday | 23",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{24 loaves - 17 loaves}{1 day}\n = \\frac{7 loaves}{1 day}\n = 7 loaves per day\nThe rate of change between Sunday and Monday was 7 loaves per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "22232",
    "path": "data"
  },
  {
    "question": "Some friends played a trivia game and recorded their scores. What is the mean of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Trivia game scores",
    "table": "Name | Score\nBarry | 7\nEve | 9\nJanice | 8\nTara | 8\nPreston | 7\nAaliyah | 9\nCody | 10\nSpencer | 6",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 9, 8, 8, 7, 9, 10, 6\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n7 + 9 + 8 + 8 + 7 + 9 + 10 + 6 = 64\n\nNow divide the sum by the number of numbers:\n\n64 \u00f7 8 = 8\n\nThe mean is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "32234",
    "path": "data"
  },
  {
    "question": "Mrs. Hickman, the science teacher, informed her students of their scores on Monday's test. How many students scored at least 40 points but fewer than 50 points?",
    "choices": null,
    "answer": "2",
    "unit": "students",
    "table_title": "Science test scores",
    "table": "Stem | Leaf \n2 | 0, 2\n3 | \n4 | 6, 8\n5 | 9\n6 | \n7 | 3\n8 | \n9 | 0",
    "row_num": 9,
    "column_num": 2,
    "solution": "Count all the leaves in the row with stem 4.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 students scored at least 40 points but fewer than 50 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "31544",
    "path": "data"
  },
  {
    "question": "The train conductor made sure to count the number of passengers on each train. How many trains had exactly 33 passengers?",
    "choices": null,
    "answer": "0",
    "unit": "trains",
    "table_title": "Passengers per train",
    "table": "Stem | Leaf \n2 | 0, 1, 5, 6, 7, 9\n3 | 7, 7\n4 | 0, 2, 6, 7\n5 | 0, 2, 6, 7, 7\n6 | 2, 6, 9",
    "row_num": 6,
    "column_num": 2,
    "solution": "For the number 33, the stem is 3, and the leaf is 3. Find the row where the stem is 3. In that row, count all the leaves equal to 3.\n\nYou counted 0 leaves. 0 trains had exactly 33 passengers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "33063",
    "path": "data"
  },
  {
    "question": "Jonathan, a doctor's office receptionist, tracked the average waiting time at the office each month. According to the table, what was the rate of change between November and December?",
    "choices": null,
    "answer": "2",
    "unit": "minutes per month",
    "table_title": "Average waiting time at a doctor's office",
    "table": "Month | Waiting time (minutes)\nAugust | 22\nSeptember | 16\nOctober | 11\nNovember | 26\nDecember | 28",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{28 minutes - 26 minutes}{1 month}\n = \\frac{2 minutes}{1 month}\n = 2 minutes per month\nThe rate of change between November and December was 2 minutes per month.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "15292",
    "path": "data"
  },
  {
    "question": "A county agency recorded the money donated to several charitable causes over time. How much more money was raised for medical research in May than in June?",
    "choices": null,
    "answer": "5",
    "unit": "$",
    "table_title": "Donations received",
    "table": "Cause | May | June\nEducation | $17 | $14\nMedical research | $12 | $7\nAnimals | $19 | $4",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the Medical research row. Find the numbers in this row for May and June.\n\nMay: $12.00\nJune: $7.00\n\nNow subtract:\n\n$12.00 \u2212 $7.00 = $5.00\n\n$5 more was raised for medical research in May than in June.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "28812",
    "path": "data"
  },
  {
    "question": "A pottery factory kept track of the number of broken plates per shipment last week. What is the largest number of broken plates?",
    "choices": null,
    "answer": "59",
    "unit": "broken plates",
    "table_title": "Broken plates per shipment",
    "table": "Stem | Leaf \n2 | 0, 0, 3, 4, 5, 7, 7\n3 | 1\n4 | 0, 4, 7, 7, 7, 9\n5 | 3, 4, 5, 5, 9, 9",
    "row_num": 5,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 5.\n\nNow find the highest leaf in the last row. The highest leaf is 9.\n\nThe largest number of broken plates has a stem of 5 and a leaf of 9. Write the stem first, then the leaf: 59.\n\nThe largest number of broken plates is 59 broken plates.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "34312",
    "path": "data"
  },
  {
    "question": "Mia's classmates recorded how many books they read last year. What is the mode of the numbers?",
    "choices": null,
    "answer": "89",
    "unit": null,
    "table_title": "Books read",
    "table": "Name | Number of books\nMia | 87\nXavier | 91\nIsaiah | 91\nEmma | 89\nTony | 93\nDonald | 89\nNoah | 89\nLiz | 87",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n87, 91, 91, 89, 93, 89, 89, 87\n\nFirst, arrange the numbers from least to greatest:\n\n87, 87, 89, 89, 89, 91, 91, 93\n\nNow count how many times each number appears.\n\n87 appears 2 times.\n89 appears 3 times.\n91 appears 2 times.\n93 appears 1 time.\n\nThe number that appears most often is 89.\n\nThe mode is 89.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "16389",
    "path": "data"
  },
  {
    "question": "Emmet paid attention to how many flowers he planted in the garden during the past 6 days. What is the range of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Flowers plants",
    "table": "Day | Number of flowers\nFriday | 5\nSaturday | 2\nSunday | 10\nMonday | 6\nTuesday | 7\nWednesday | 5",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 2, 10, 6, 7, 5\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 2 = 8\n\nThe range is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "32797",
    "path": "data"
  },
  {
    "question": "A stock broker followed the stock prices of a certain set of companies. On Wednesday, how much more did Thompson Corporation's stock cost than Jonas Incorporated's stock?",
    "choices": null,
    "answer": "10",
    "unit": "$",
    "table_title": "Stock prices",
    "table": "Company | Wednesday | Thursday\nWatson and Partners | $15 | $7\nThompson Corporation | $17 | $5\nComputer Data Company | $1 | $18\nJonas Incorporated | $7 | $1",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the Wednesday column. Find the numbers in this column for Thompson Corporation and Jonas Incorporated.\n\nThompson Corporation: $17.00\nJonas Incorporated: $7.00\n\nNow subtract:\n\n$17.00 \u2212 $7.00 = $10.00\n\nOn Wednesday Thompson Corporation's stock cost $10 more than Jonas Incorporated's stock.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "12158",
    "path": "data"
  },
  {
    "question": "Look at Carl's pay stub. Carl lives in a state without state income tax. How much payroll tax did Carl pay in total?",
    "choices": null,
    "answer": "611.26",
    "unit": "$",
    "table_title": null,
    "table": "Employee | Pay period |\nCarl Welborn | November |\nTotal earnings | | $3,193.00\nFederal income tax | $367.00 |\nOther taxes | $244.26 |\nTotal taxes | | ?\nPay after taxes | | ?",
    "row_num": 7,
    "column_num": 3,
    "solution": "To find the total payroll tax, add the federal income tax and the other taxes.\nThe federal income tax is $367.00. The other taxes are $244.26. Add.\n$367.00 + $244.26 = $611.26\nCarl paid a total of $611.26 in payroll tax.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "22479",
    "path": "data"
  },
  {
    "question": "Mr. Hickman, a P.E. teacher, wrote down how much weight each of his students could lift. How many people lifted at least 40 pounds but less than 90 pounds?",
    "choices": null,
    "answer": "13",
    "unit": null,
    "table_title": "Weight lifting results (lbs)",
    "table": "Stem | Leaf \n3 | 4, 4, 4, 7\n4 | 3, 6\n5 | 5, 6, 9\n6 | 1, 4, 9\n7 | 3, 5\n8 | 3, 6, 7\n9 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 4, 5, 6, 7, and 8.\n\nYou counted 13 leaves, which are blue in the stem-and-leaf plot above. 13 people lifted at least 40 pounds but less than 90 pounds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "20544",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the train depart from the civic center?",
    "choices": [
      "9:05 A.M.",
      "9:45 A.M.",
      "1:25 P.M.",
      "12:40 P.M."
    ],
    "answer": "12:40 P.M.",
    "unit": null,
    "table_title": "Subway train schedule",
    "table": "Location | Time\ntheater district | 8:10 A.M.\nshopping district | 8:50 A.M.\nindustrial district | 9:05 A.M.\nfootball stadium | 9:45 A.M.\ncity park | 10:10 A.M.\nrestaurant district | 10:30 A.M.\nuniversity | 11:05 A.M.\ndowntown | 11:55 A.M.\ncivic center | 12:40 P.M.\nhistory museum | 1:25 P.M.",
    "row_num": 11,
    "column_num": 2,
    "solution": "Find the civic center on the schedule. Find the departure time for the civic center.\n\ncivic center: 12:40 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "7201",
    "path": "data"
  },
  {
    "question": "Dillon paid attention to how many comic strips he read in the past 5 days. What is the range of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Comic strips read",
    "table": "Day | Number of comic strips\nThursday | 3\nFriday | 8\nSaturday | 5\nSunday | 2\nMonday | 2",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n3, 8, 5, 2, 2\n\nFirst, find the greatest number. The greatest number is 8.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n8 \u2212 2 = 6\n\nThe range is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "13700",
    "path": "data"
  },
  {
    "question": "After a field trip to the park, students in Mrs. Peterson's art class counted the number of leaf rubbings they had made. How many students are there in all?",
    "choices": null,
    "answer": "37",
    "unit": null,
    "table_title": "Making leaf rubbings",
    "table": "Leaf rubbings made | Frequency\n0 | 13\n1 | 15\n2 | 3\n3 | 6",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n13 + 15 + 3 + 6 = 37\n\nThere are 37 students in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "13520",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "x | y\n19 | 14\n6 | 13\n20 | 3\n18 | 12",
    "row_num": 5,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nEach of the x-values is paired with only one y-value, so the relation is a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "32545",
    "path": "data"
  },
  {
    "question": "Some pizza restaurants compared their pizza sales. Which restaurant sold the fewest pizza slices?",
    "choices": [
      "Deep Dish by Dan",
      "The Real Chicago",
      "Pizzas Only",
      "New York Slice"
    ],
    "answer": "Deep Dish by Dan",
    "unit": null,
    "table_title": "Pizza slices sold",
    "table": "Restaurant | Number of slices sold\nDeep Dish by Dan | 51\nThe Real Chicago | 52\nPizzas Only | 57\nNew York Slice | 56",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 51.\n\nNow find the corresponding restaurant. Deep Dish by Dan corresponds to 51.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "3432",
    "path": "data"
  },
  {
    "question": "Lacey's class recorded how many cans of food each student collected for their canned food drive. What is the mean of the numbers?",
    "choices": null,
    "answer": "96",
    "unit": null,
    "table_title": "Cans of food collected",
    "table": "Name | Number of cans of food\nLacey | 90\nWill | 96\nDwayne | 98\nSusan | 97\nHector | 100\nNathan | 95",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n90, 96, 98, 97, 100, 95\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n90 + 96 + 98 + 97 + 100 + 95 = 576\n\nNow divide the sum by the number of numbers:\n\n576 \u00f7 6 = 96\n\nThe mean is 96.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "26105",
    "path": "data"
  },
  {
    "question": "A statistician analyzed the number of runs scored by players last season. How many players are there in all?",
    "choices": null,
    "answer": "66",
    "unit": null,
    "table_title": "Baseball runs scored last season",
    "table": "Runs scored | Frequency\n0 | 20\n1 | 19\n2 | 2\n3 | 4\n4 | 18\n5 | 3",
    "row_num": 7,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n20 + 19 + 2 + 4 + 18 + 3 = 66\n\nThere are 66 players in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "9404",
    "path": "data"
  },
  {
    "question": "A marketing research firm asked people how many times they visited the mall last month. How many people went to the mall once last month?",
    "choices": null,
    "answer": "13",
    "unit": null,
    "table_title": "Trips to the mall last month",
    "table": "Number of trips | Frequency\n0 | 1\n1 | 13\n2 | 5\n3 | 17\n4 | 14\n5 | 18\n6 | 19",
    "row_num": 8,
    "column_num": 2,
    "solution": "Find the row for 1 time and read the frequency. The frequency is 13.\n\n13 people went to the mall exactly once last month.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "6541",
    "path": "data"
  },
  {
    "question": "Ted, a candy store employee, placed peppermint candies into jars of various sizes. How many jars had at least 25 peppermint candies but fewer than 38 peppermint candies?",
    "choices": null,
    "answer": "3",
    "unit": "jars",
    "table_title": "Peppermint candies per jar",
    "table": "Stem | Leaf \n1 | 8, 8\n2 | 1, 8, 9\n3 | 6\n4 | 1, 3\n5 | \n6 | \n7 | \n8 | 1\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Find the row with stem 2. Count all the leaves greater than or equal to 5.\n\nIn the row with stem 3, count all the leaves less than 8.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plots above. 3 jars had at least 25 peppermint candies but fewer than 38 peppermint candies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "30045",
    "path": "data"
  },
  {
    "question": "Mrs. Watson kept track of her students' scores on last year's final exam. How many students scored at least 10 points?",
    "choices": null,
    "answer": "22",
    "unit": "students",
    "table_title": "Final exam scores",
    "table": "Stem | Leaf \n1 | 8\n2 | 1, 3, 6, 8, 9, 9\n3 | 1, 4, 4, 9, 9, 9\n4 | 4\n5 | 2, 3, 3, 4, 4, 5, 9, 9",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, 4, and 5.\n\nYou counted 22 leaves, which are blue in the stem-and-leaf plot above. 22 students scored at least 10 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "37883",
    "path": "data"
  },
  {
    "question": "The advertising agency counted the number of billboards in each city in the state. What is the largest number of billboards?",
    "choices": null,
    "answer": "86",
    "unit": "billboards",
    "table_title": "Billboards per city",
    "table": "Stem | Leaf \n1 | 8\n2 | 2, 5\n3 | 5, 8, 9\n4 | \n5 | 0\n6 | \n7 | \n8 | 6",
    "row_num": 9,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 8.\n\nNow find the highest leaf in the last row. The highest leaf is 6.\n\nThe largest number of billboards has a stem of 8 and a leaf of 6. Write the stem first, then the leaf: 86.\n\nThe largest number of billboards is 86 billboards.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "23423",
    "path": "data"
  },
  {
    "question": "Mitch has $1,155. Does he have enough to buy an antique wicker chair and an antique maplewood rocking chair?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "antique pine chest of drawers | $582\nantique teak wood end table | $414\nantique hand-painted trunk | $753\nantique maplewood rocking chair | $285\nantique birchwood dining table | $763\nantique wicker chair | $862",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of an antique wicker chair and the price of an antique maplewood rocking chair:\n\n$862 + $285 = $1,147\n\n$1,147 is less than $1,155. Mitch does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "6282",
    "path": "data"
  },
  {
    "question": "How much money does Elizabeth need to buy a pink conch shell and a pink and white striped shell?",
    "choices": null,
    "answer": "0.16",
    "unit": "$",
    "table_title": null,
    "table": "pink and white striped shell | $0.09\norange cone shell | $0.09\nbeautiful yellow shell | $0.09\ndark gray shell | $0.05\nspiral snail shell | $0.06\npink conch shell | $0.07",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a pink conch shell and the price of a pink and white striped shell:\n\n$0.07 + $0.09 = $0.16\n\nElizabeth needs $0.16.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 3,
    "split": "dev",
    "pid": "26880",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the cross-country ski tour end?",
    "choices": [
      "10:15 A.M.",
      "4:30 P.M.",
      "3:00 P.M.",
      "11:55 A.M."
    ],
    "answer": "4:30 P.M.",
    "unit": null,
    "table_title": "Winter lodge schedule",
    "table": "Activity | Begin | End\nbeginning snowboard class | 9:15 A.M. | 10:15 A.M.\nintermediate ski class | 10:55 A.M. | 11:55 A.M.\nfamily ice skating | 12:35 P.M. | 1:50 P.M.\nfigure skating | 1:55 P.M. | 2:50 P.M.\ncross-country ski tour | 3:00 P.M. | 4:30 P.M.\nsnowshoe adventure | 4:45 P.M. | 5:25 P.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find the cross-country ski tour on the schedule. Find the end time for the cross-country ski tour.\n\ncross-country ski tour: 4:30 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "23200",
    "path": "data"
  },
  {
    "question": "A bus driver paid attention to how many passengers his bus had each day. How many more passengers did the bus have on Monday than on Sunday?",
    "choices": null,
    "answer": "154",
    "unit": "people",
    "table_title": "People on the bus",
    "table": "Day | Number of people\nSunday | 304\nMonday | 458\nTuesday | 578\nWednesday | 194",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nMonday: 458\nSunday: 304\n\nNow subtract: 458 - 304 = 154.\n\nThe bus had 154 more passengers on Monday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "10934",
    "path": "data"
  },
  {
    "question": "How much more does a blue sweater cost than a pair of sweat pants?",
    "choices": null,
    "answer": "2.71",
    "unit": "$",
    "table_title": null,
    "table": "pair of sweat pants | $18.27\nblue sweater | $20.98\ngreen sweatshirt | $21.73\nwinter jacket | $11.65\npair of jeans | $24.87\npair of shoes | $18.01",
    "row_num": 6,
    "column_num": 2,
    "solution": "Subtract the price of a pair of sweat pants from the price of a blue sweater.\n\n$20.98 - $18.27 = $2.71\n\nA blue sweater costs $2.71 more than a pair of sweat pants.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "1898",
    "path": "data"
  },
  {
    "question": "Each package has 10 pens. How many pens are in 5 packages?",
    "choices": null,
    "answer": "50",
    "unit": null,
    "table_title": null,
    "table": "Number of packages | Number of pens\n1 | 10\n2 | 20\n3 | 30\n4 | 40\n5 | ?",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 50 pens in 5 packages.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "23030",
    "path": "data"
  },
  {
    "question": "A volunteer for the local running club counted the number of participants at each race. What is the largest number of participants?",
    "choices": null,
    "answer": "80",
    "unit": "participants",
    "table_title": "Participants per race",
    "table": "Stem | Leaf \n2 | 2\n3 | 2, 4, 5, 7\n4 | 4, 8\n5 | 1, 4, 4, 8\n6 | \n7 | 5, 8\n8 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 8.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe largest number of participants has a stem of 8 and a leaf of 0. Write the stem first, then the leaf: 80.\n\nThe largest number of participants is 80 participants.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "18122",
    "path": "data"
  },
  {
    "question": "How much money does Daniel need to buy a jar of applesauce and a can of soup?",
    "choices": null,
    "answer": "1.50",
    "unit": "$",
    "table_title": null,
    "table": "jar of applesauce | $0.82\njar of olives | $0.78\ncan of peaches | $0.78\ncan of soup | $0.68",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a jar of applesauce and the price of a can of soup:\n\n$0.82 + $0.68 = $1.50\n\nDaniel needs $1.50.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 3,
    "split": "dev",
    "pid": "12700",
    "path": "data"
  },
  {
    "question": "The houses in Sophia's town get their water from a local reservoir. Sophia and a group of engineers monitor the water level for safety and health reasons. The change in water level over two months is shown in the table. During which month did the water level change more?",
    "choices": [
      "April",
      "May"
    ],
    "answer": "April",
    "unit": null,
    "table_title": null,
    "table": "Month | Change in water level (in.)\nApril | -6\nMay | 4",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive change means the water level went up. A negative change means the water level went down.\nTo find the month the water level changed more, use absolute value. Absolute value tells you how much the water level changed each month.\nApril: |-6| = 6\nMay: |4| = 4\nThe water level went down 6 inches in April, and it only went up 4 inches in May. The water level changed more in April.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "25893",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "x | y\n20 | 0\n14 | 11\n14 | 14\n14 | 1",
    "row_num": 5,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nThe x-value 14 is paired with multiple y-values, so the relation is not a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "36114",
    "path": "data"
  },
  {
    "question": "The school district compared how many swings each elementary school has. What is the range of the numbers?",
    "choices": null,
    "answer": "11",
    "unit": null,
    "table_title": "Swings",
    "table": "School | Number of swings\nHillside Elementary | 10\nValley Elementary | 2\nJefferson Elementary | 9\nSierra Elementary | 13\nRoseville Elementary | 10",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 2, 9, 13, 10\n\nFirst, find the greatest number. The greatest number is 13.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n13 \u2212 2 = 11\n\nThe range is 11.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "2144",
    "path": "data"
  },
  {
    "question": "A garden supply store kept track of how many lawn mowers it sold in the past 6 days. What is the mode of the numbers?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Lawn mowers sold",
    "table": "Day | Number of lawn mowers\nWednesday | 6\nThursday | 2\nFriday | 6\nSaturday | 2\nSunday | 2\nMonday | 8",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 2, 6, 2, 2, 8\n\nFirst, arrange the numbers from least to greatest:\n\n2, 2, 2, 6, 6, 8\n\nNow count how many times each number appears.\n\n2 appears 3 times.\n6 appears 2 times.\n8 appears 1 time.\n\nThe number that appears most often is 2.\n\nThe mode is 2.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "34508",
    "path": "data"
  },
  {
    "question": "The employee at the department store counted the number of ties on each tie rack. How many racks have fewer than 60 ties?",
    "choices": null,
    "answer": "8",
    "unit": "racks",
    "table_title": "Ties per rack",
    "table": "Stem | Leaf \n1 | 0, 0\n2 | \n3 | 3\n4 | 6, 7, 9\n5 | 0, 1\n6 | \n7 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, 4, and 5.\n\nYou counted 8 leaves, which are blue in the stem-and-leaf plot above. 8 racks have fewer than 60 ties.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "21025",
    "path": "data"
  },
  {
    "question": "Brianna was a spectator at her town's air guitar competition. Contestants were allowed to play either the acoustic or electric air guitar, but not both. Brianna recorded which type of guitar each contestant played. She also counted the number of contestants wearing different kinds of pants, as there were some interesting stylistic choices. What is the probability that a randomly selected contestant was dressed in velvet and played an electric guitar? Simplify any fractions.",
    "choices": null,
    "answer": "1/8",
    "unit": null,
    "table_title": null,
    "table": " | Acoustic guitar | Electric guitar\nLeather | 5 | 4\nVelvet | 5 | 2",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the contestant was dressed in velvet\" and B be the event \"the contestant played an electric guitar\".\nTo find the probability that a contestant was dressed in velvet and played an electric guitar, first identify the sample space and the event.\nThe outcomes in the sample space are the different contestants. Each contestant is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the contestant was dressed in velvet and played an electric guitar\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the contestant was dressed in velvet and played an electric guitar\", so look at the table to see how many contestants were dressed in velvet and played an electric guitar.\nThe number of contestants who were dressed in velvet and played an electric guitar is 2.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of contestants.\n5 + 5 + 4 + 2 = 16\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{2}{16}\n = \\frac{1}{8}\nThe probability that a contestant was dressed in velvet and played an electric guitar is \\frac{1}{8}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "29992",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "x | y\n0 | 3\n7 | 2\n7 | 6",
    "row_num": 4,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nThe x-value 7 is paired with multiple y-values, so the relation is not a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "4140",
    "path": "data"
  },
  {
    "question": "A girl compared the ages of her cousins. What is the range of the numbers?",
    "choices": null,
    "answer": "10",
    "unit": null,
    "table_title": "Ages of cousins",
    "table": "Name | Age (years)\nIsabella | 10\nPablo | 7\nBrian | 7\nLena | 4\nTisha | 6\nMackenzie | 14",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 7, 7, 4, 6, 14\n\nFirst, find the greatest number. The greatest number is 14.\n\nNext, find the least number. The least number is 4.\n\nSubtract the least number from the greatest number:\n\n14 \u2212 4 = 10\n\nThe range is 10.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "15612",
    "path": "data"
  },
  {
    "question": "The city recorded how many fire hydrants there are on each street. What is the mode of the numbers?",
    "choices": null,
    "answer": "1",
    "unit": null,
    "table_title": "Fire hydrants",
    "table": "Street | Number of hydrants\nRose Street | 3\nMaple Street | 1\nElm Street | 10\nFir Street | 3\nAspen Street | 1\nPine Street | 10\nOak Street | 1\nCedar Street | 2",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n3, 1, 10, 3, 1, 10, 1, 2\n\nFirst, arrange the numbers from least to greatest:\n\n1, 1, 1, 2, 3, 3, 10, 10\n\nNow count how many times each number appears.\n\n1 appears 3 times.\n2 appears 1 time.\n3 appears 2 times.\n10 appears 2 times.\n\nThe number that appears most often is 1.\n\nThe mode is 1.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "32507",
    "path": "data"
  },
  {
    "question": "Gavin has $8,733.00. Does he have enough to buy a trailer and a sailboat?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "trailer | $3,116.00\ngolf cart | $4,602.00\nconvertible | $2,026.00\nsailboat | $6,003.00\njet ski | $7,863.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a trailer and the price of a sailboat:\n\n$3,116.00 + $6,003.00 = $9,119.00\n\n$9,119.00 is more than $8,733.00. Gavin does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 4,
    "split": "dev",
    "pid": "24161",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $230, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$230 | 23,300 | 1,700\n$370 | 22,100 | 3,200\n$510 | 20,900 | 4,700\n$650 | 19,700 | 6,200\n$790 | 18,500 | 7,700",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $230, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "20917",
    "path": "data"
  },
  {
    "question": "A food manufacturer surveyed consumers about their macaroni and cheese consumption. How many people ate macaroni and cheese fewer than 2 times?",
    "choices": null,
    "answer": "9",
    "unit": null,
    "table_title": "Eating macaroni and cheese last month",
    "table": "Times eaten | Frequency\n0 | 0\n1 | 9\n2 | 15\n3 | 17\n4 | 5",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the rows for 0 and 1 time. Add the frequencies for these rows.\n\nAdd:\n\n0 + 9 = 9\n\n9 people ate macaroni and cheese fewer than 2 times.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "10045",
    "path": "data"
  },
  {
    "question": "How much money does Daniel need to buy an alligator key chain and a globe key chain?",
    "choices": null,
    "answer": "1.44",
    "unit": "$",
    "table_title": null,
    "table": "rainbow key chain | $0.76\npig key chain | $0.76\nfootball helmet key chain | $0.62\nalligator key chain | $0.89\nglobe key chain | $0.55\npumpkin key chain | $0.76",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of an alligator key chain and the price of a globe key chain:\n\n$0.89 + $0.55 = $1.44\n\nDaniel needs $1.44.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 3,
    "split": "dev",
    "pid": "37632",
    "path": "data"
  },
  {
    "question": "Each package has 10 juice boxes. How many juice boxes are in 4 packages?",
    "choices": null,
    "answer": "40",
    "unit": "juice boxes",
    "table_title": null,
    "table": "Number of packages | Number of juice boxes\n1 | 10\n2 | 20\n3 | 30\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 40 juice boxes in 4 packages.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "7278",
    "path": "data"
  },
  {
    "question": "A pretzel stand owner kept track of the number of pretzels sold during the past 4 days. How many more pretzels did the stand sell on Saturday than on Sunday?",
    "choices": null,
    "answer": "569",
    "unit": "pretzels",
    "table_title": "Pretzels sold",
    "table": "Day | Number of pretzels\nThursday | 707\nFriday | 176\nSaturday | 845\nSunday | 276",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nSaturday: 845\nSunday: 276\n\nNow subtract: 845 - 276 = 569.\n\nThe stand sold 569 more pretzels on Saturday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "1712",
    "path": "data"
  },
  {
    "question": "Jeanette kept a tally of the number of emails she received each day for a week. According to the table, what was the rate of change between Wednesday and Thursday?",
    "choices": null,
    "answer": "2",
    "unit": "emails per day",
    "table_title": "Emails Jeanette received",
    "table": "Day | Emails\nMonday | 8\nTuesday | 2\nWednesday | 8\nThursday | 10\nFriday | 0",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{10 emails - 8 emails}{1 day}\n = \\frac{2 emails}{1 day}\n = 2 emails per day\nThe rate of change between Wednesday and Thursday was 2 emails per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "12040",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does Big Action Movie III end?",
    "choices": [
      "11:10 A.M.",
      "2:55 P.M.",
      "2:10 P.M.",
      "1:45 P.M."
    ],
    "answer": "2:55 P.M.",
    "unit": null,
    "table_title": "Movie schedule",
    "table": "Movie | Begin | End\nAdventures in the Universe IV | 7:55 A.M. | 10:05 A.M.\nWildlife in the Wild: Elephants | 9:05 A.M. | 11:10 A.M.\nFido and Mittens are Best Pals | 10:25 A.M. | 12:15 P.M.\nKung Fu Madness | 11:40 A.M. | 2:40 P.M.\nBig Action Movie III | 1:45 P.M. | 2:55 P.M.\nDangerous Duck in Cartoon City | 2:05 P.M. | 3:05 P.M.\nLaugh Ha Ha, a Comedy | 2:10 P.M. | 4:50 P.M.\nThe Caped Hero Returns | 4:15 P.M. | 6:25 P.M.\nPirates in Pirate Ships | 5:50 P.M. | 6:55 P.M.\nThe Wizard in the Cereal Box | 6:10 P.M. | 8:15 P.M.",
    "row_num": 11,
    "column_num": 3,
    "solution": "Find Big Action Movie III on the schedule. Find the end time for Big Action Movie III.\n\nBig Action Movie III: 2:55 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "32068",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n2 | 16\n3 | 17\n4 | 18",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{17 - 16}{3 - 2}\n = \\frac{1}{1}\n = 1\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{18 - 16}{4 - 2}\n = \\frac{2}{2}\n = 1\nThe two rates of change are the same.\nIf you checked the rate of change between rows 2 and 3, you would find that it is also 1.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "8433",
    "path": "data"
  },
  {
    "question": "A pottery factory kept track of the number of broken plates per shipment last week. How many shipments had exactly 51 broken plates?",
    "choices": null,
    "answer": "1",
    "unit": null,
    "table_title": "Broken plates per shipment",
    "table": "Stem | Leaf \n3 | 0, 7\n4 | 3, 4, 7\n5 | 1\n6 | 7, 7, 7\n7 | 0, 7\n8 | 9",
    "row_num": 7,
    "column_num": 2,
    "solution": "For the number 51, the stem is 5, and the leaf is 1. Find the row where the stem is 5. In that row, count all the leaves equal to 1.\n\nYou counted 1 leaf, which is blue in the stem-and-leaf plot above. 1 shipment had exactly 51 broken plates.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "29913",
    "path": "data"
  },
  {
    "question": "At a candy factory, butterscotch candies were packaged into bags of different sizes. How many bags had exactly 44 butterscotch candies?",
    "choices": null,
    "answer": "0",
    "unit": "bags",
    "table_title": "Butterscotch candies per bag",
    "table": "Stem | Leaf \n2 | 4\n3 | 0, 2, 9\n4 | 2\n5 | 2, 6\n6 | 5\n7 | \n8 | 0\n9 | 0",
    "row_num": 9,
    "column_num": 2,
    "solution": "For the number 44, the stem is 4, and the leaf is 4. Find the row where the stem is 4. In that row, count all the leaves equal to 4.\n\nYou counted 0 leaves. 0 bags had exactly 44 butterscotch candies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "20580",
    "path": "data"
  },
  {
    "question": "Some friends played a trivia game and recorded their scores. What is the median of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Trivia game scores",
    "table": "Name | Score\nMariana | 5\nIsabelle | 3\nRuth | 6\nLeah | 5\nJanice | 2",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 3, 6, 5, 2\n\nFirst, arrange the numbers from least to greatest:\n\n2, 3, 5, 5, 6\n\nNow find the number in the middle.\n\n2, 3, 5, 5, 6\n\nThe number in the middle is 5.\n\nThe median is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "21326",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which class ends at 2.55 P.M.?",
    "choices": [
      "Weightlifting class",
      "Ballet class",
      "Badminton class",
      "Social Dance class"
    ],
    "answer": "Ballet class",
    "unit": null,
    "table_title": "Gym teacher's schedule",
    "table": "Class | Begin | End\nTennis | 7:30 A.M. | 8:45 A.M.\nWeightlifting | 9:00 A.M. | 10:35 A.M.\nFloor Hockey | 10:40 A.M. | 11:35 A.M.\nSwimming | 11:40 A.M. | 12:10 P.M.\nSocial Dance | 12:25 P.M. | 1:05 P.M.\nBallet | 1:15 P.M. | 2:55 P.M.\nBadminton | 3:10 P.M. | 4:40 P.M.",
    "row_num": 8,
    "column_num": 3,
    "solution": "Find 2:55 P. M. on the schedule. Ballet class ends at 2:55 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 3,
    "split": "dev",
    "pid": "22571",
    "path": "data"
  },
  {
    "question": "The financial aid office at Olsen University produced an internal report on the number of students receiving scholarships. According to the table, what was the rate of change between 2009 and 2010?",
    "choices": null,
    "answer": "3",
    "unit": "students per year",
    "table_title": "Students receiving scholarships",
    "table": "Year | Students\n2008 | 17\n2009 | 18\n2010 | 21\n2011 | 20\n2012 | 20",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{21 students - 18 students}{2010 - 2009}\n = \\frac{21 students - 18 students}{1 year}\n = \\frac{3 students}{1 year}\n = 3 students per year\nThe rate of change between 2009 and 2010 was 3 students per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "3959",
    "path": "data"
  },
  {
    "question": "An author kept a log of how many pages he wrote in the past 6 days. What is the mean of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Pages written",
    "table": "Day | Number of pages\nWednesday | 2\nThursday | 2\nFriday | 7\nSaturday | 6\nSunday | 7\nMonday | 6",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 2, 7, 6, 7, 6\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n2 + 2 + 7 + 6 + 7 + 6 = 30\n\nNow divide the sum by the number of numbers:\n\n30 \u00f7 6 = 5\n\nThe mean is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "36721",
    "path": "data"
  },
  {
    "question": "This is Duncan's complete financial record for July. On July 5, how much money did Duncan make?",
    "choices": null,
    "answer": "15",
    "unit": "$",
    "table_title": null,
    "table": "Date | Description | Received | Expenses | Available Funds\n | Balance: end of June | | | $450.70\n7/5 | cleaning the Lynches' pool | $15.00 | | $465.70\n7/17 | bottle of water | | $1.50 | $464.20\n7/29 | swim trunks | | $16.80 | $447.40",
    "row_num": 5,
    "column_num": 5,
    "solution": "Look at the 7/5 row. The amount received was $15.00. So, Duncan made $15.00 on July 5.\n",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "6670",
    "path": "data"
  },
  {
    "question": "What is the total cost for 4 kilograms of glass and 5 kilograms of cardboard?",
    "choices": null,
    "answer": "4.90",
    "unit": "$",
    "table_title": null,
    "table": "newspaper | $0.68/kilogram\nmixed paper | $0.81/kilogram\nplastic scrap | $0.37/kilogram\nglass | $0.55/kilogram\ntin | $1.06/kilogram\ncardboard | $0.54/kilogram",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the glass. Multiply:\n\n$0.55 \u00d7 4 = $2.20\n\nFind the cost of the cardboard. Multiply:\n\n$0.54 \u00d7 5 = $2.70\n\nNow find the total cost by adding:\n\n$2.20 + $2.70 = $4.90\n\nThe total cost is $4.90.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "28963",
    "path": "data"
  },
  {
    "question": "Luther has $1.00. Does he have enough to buy a palm tree magnet and a picture of a shark?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "small stuffed otter | $0.80\npicture of a shark | $0.40\nsouvenir cup | $0.28\npalm tree magnet | $0.67",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a palm tree magnet and the price of a picture of a shark:\n\n$0.67 + $0.40 = $1.07\n\n$1.07 is more than $1.00. Luther does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "11727",
    "path": "data"
  },
  {
    "question": "Each apartment has 10 rooms. How many rooms are in 4 apartments?",
    "choices": null,
    "answer": "40",
    "unit": null,
    "table_title": null,
    "table": "Number of apartments | Number of rooms\n1 | 10\n2 | 20\n3 | 30\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 40 rooms in 4 apartments.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "30324",
    "path": "data"
  },
  {
    "question": "The employee at the department store counted the number of ties on each tie rack. What is the smallest number of ties?",
    "choices": null,
    "answer": "10",
    "unit": "ties",
    "table_title": "Ties per rack",
    "table": "Stem | Leaf \n1 | 0, 1, 2, 6\n2 | 8\n3 | 6, 7, 8\n4 | 4, 9\n5 | 1, 7, 8, 9\n6 | 1, 2, 3, 4, 6\n7 | 1, 4, 5, 7",
    "row_num": 8,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 1.\n\nNow find the lowest leaf in the first row. The lowest leaf is 0.\n\nThe smallest number of ties has a stem of 1 and a leaf of 0. Write the stem first, then the leaf: 10.\n\nThe smallest number of ties is 10 ties.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "23841",
    "path": "data"
  },
  {
    "question": "How much money does Anita need to buy a surfboard and a racing bike?",
    "choices": null,
    "answer": "1,464",
    "unit": "$",
    "table_title": null,
    "table": "set of golf clubs | $559\nsurfboard | $484\nracing bike | $980\nriver raft | $504\nmountain bike | $330",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a surfboard and the price of a racing bike:\n\n$484 + $980 = $1,464\n\nAnita needs $1,464.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "36686",
    "path": "data"
  },
  {
    "question": "What is the total cost for 5 pounds of picture hooks and 5 pounds of t-pins?",
    "choices": null,
    "answer": "20",
    "unit": "$",
    "table_title": null,
    "table": "picture hooks | $2 per lb\nteeth hooks | $4 per lb\nsafety pins | $3 per lb\nt-pins | $2 per lb\npushpins | $2 per lb",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the picture hooks. Multiply:\n\n$2 \u00d7 5 = $10\n\nFind the cost of the t-pins. Multiply:\n\n$2 \u00d7 5 = $10\n\nNow find the total cost by adding:\n\n$10 + $10 = $20\n\nThe total cost is $20.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "29473",
    "path": "data"
  },
  {
    "question": "Aaron kept a driving log to see how many miles he drove each day. On which day did Aaron drive the fewest miles?",
    "choices": [
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday"
    ],
    "answer": "Thursday",
    "unit": null,
    "table_title": "Miles driven",
    "table": "Day | Number of miles\nTuesday | 68\nWednesday | 65\nThursday | 64\nFriday | 67",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 64.\n\nNow find the corresponding day. Thursday corresponds to 64.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "36660",
    "path": "data"
  },
  {
    "question": "An architecture student measured the heights of all the buildings downtown. How many buildings are at least 20 meters tall but less than 30 meters tall?",
    "choices": null,
    "answer": "3",
    "unit": "buildings",
    "table_title": "Building heights (meters)",
    "table": "Stem | Leaf \n1 | 2, 2, 3, 5, 5\n2 | 3, 6, 9\n3 | 1\n4 | 1, 7\n5 | 9\n6 | 8, 9\n7 | 5, 7, 8, 8, 9",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the row with stem 2.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plot above. 3 buildings are at least 20 meters tall but less than 30 meters tall.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "12510",
    "path": "data"
  },
  {
    "question": "In science class, Rhianna is measuring the temperature of different chemical mixtures. The temperatures of two mixtures are shown in the table. Which mixture's temperature is closest to zero?",
    "choices": [
      "bromine mixture",
      "acetone mixture"
    ],
    "answer": "bromine mixture",
    "unit": null,
    "table_title": null,
    "table": "Mixture | Temperature (\u00b0C)\nBromine mixture | -4\nAcetone mixture | 5",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive number means the temperature is above zero. A negative number means the temperature is below zero.\nTo find the temperature closest to zero, use absolute value. The absolute value of a temperature tells you how far it is from zero.\nBromine mixture: |-4| = 4\nAcetone mixture: |5| = 5\nThe temperature of the bromine mixture is closest to zero. It is only 4 degrees below zero.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "37010",
    "path": "data"
  },
  {
    "question": "Matt has $1.74. How much money will Matt have left if he buys a fake red rose and a pack of white tissue paper?",
    "choices": null,
    "answer": "0.85",
    "unit": "$",
    "table_title": null,
    "table": "fake yellow daisy | $0.43\npack of white tissue paper | $0.68\npack of yellow tissue paper | $0.92\nfake red rose | $0.21",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of a fake red rose and a pack of white tissue paper.\n\n$0.21 + $0.68 = $0.89\n\nNow subtract the total cost from the starting amount.\n\n$1.74 - $0.89 = $0.85\n\nMatt will have $0.85 left.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "26581",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $255, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$105 | 15,800 | 8,200\n$155 | 12,100 | 9,900\n$205 | 8,400 | 11,600\n$255 | 4,700 | 13,300\n$305 | 1,000 | 15,000",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $255, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "1578",
    "path": "data"
  },
  {
    "question": "Mrs. Morgan hosts an annual art contest for kids, and she keeps a record of the number of entries each year. According to the table, what was the rate of change between 2011 and 2012?",
    "choices": null,
    "answer": "-7",
    "unit": "entries per year",
    "table_title": "Art contest entries",
    "table": "Year | Number of entries\n2008 | 39\n2009 | 36\n2010 | 20\n2011 | 27\n2012 | 20",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{20 entries - 27 entries}{2012 - 2011}\n = \\frac{20 entries - 27 entries}{1 year}\n = \\frac{-7 entries}{1 year}\n = -7 entries per year\nThe rate of change between 2011 and 2012 was - 7 entries per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "29745",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does Recess end?",
    "choices": [
      "6:15 A.M.",
      "2:50 P.M.",
      "1:35 P.M.",
      "7:20 A.M."
    ],
    "answer": "7:20 A.M.",
    "unit": null,
    "table_title": "Class schedule",
    "table": "Subject | Begin | End\nRecess | 6:15 A.M. | 7:20 A.M.\nOrchestra | 7:30 A.M. | 8:40 A.M.\nArt | 8:45 A.M. | 9:35 A.M.\nHandwriting | 9:45 A.M. | 10:20 A.M.\nGym | 10:30 A.M. | 11:15 A.M.\nChoir | 11:20 A.M. | 12:25 P.M.\nScience | 12:35 P.M. | 1:35 P.M.\nReading | 1:40 P.M. | 2:50 P.M.",
    "row_num": 9,
    "column_num": 3,
    "solution": "Find Recess on the schedule. Find the end time for Recess.\n\nRecess: 7:20 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "24909",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Gina got on the train at the art gallery district at 1.00 P.M. What time will she get to the baseball stadium?",
    "choices": [
      "1:45 P.M.",
      "1:30 P.M.",
      "12:00 P.M.",
      "12:30 P.M."
    ],
    "answer": "1:45 P.M.",
    "unit": null,
    "table_title": "Subway train schedule",
    "table": "city park | 9:45 A.M. | 10:45 A.M. | 11:00 A.M.\nwaterfront | 10:45 A.M. | 11:45 A.M. | 12:00 P.M.\nart gallery district | 11:45 A.M. | 12:45 P.M. | 1:00 P.M.\nbaseball stadium | 12:30 P.M. | 1:30 P.M. | 1:45 P.M.\nuniversity | 1:00 P.M. | 2:00 P.M. | 2:15 P.M.",
    "row_num": 5,
    "column_num": 4,
    "solution": "Find 1:00 P. M. in the row for the art gallery district. That column shows the schedule for the train that Gina is on.\n\nLook down the column until you find the row for the baseball stadium.\n\nGina will get to the baseball stadium at 1:45 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "8049",
    "path": "data"
  },
  {
    "question": "For an economics project, Judith determined the cost of ferry rides for bicycles and cars. How much higher is the fare for a car on the Fauntleroy-Vashon ferry than on the Mukilteu-Clinton ferry?",
    "choices": null,
    "answer": "8",
    "unit": "$",
    "table_title": "Ferry fares",
    "table": "Ferry | Bicycle | Car\nMukilteu-Clinton | $5 | $7\nFauntleroy-Vashon | $5 | $15\nSouthport-Fort Fisher | $2 | $5",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the Car column. Find the numbers in this column for Fauntleroy-Vashon and Mukilteu-Clinton.\n\nFauntleroy-Vashon: $15.00\nMukilteu-Clinton: $7.00\n\nNow subtract:\n\n$15.00 \u2212 $7.00 = $8.00\n\nThe fare for a car is $8 more on the Fauntleroy-Vashon ferry than on the Mukilteu-Clinton ferry.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "31717",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which event begins at 12.25 P.M.?",
    "choices": [
      "men's rings event",
      "men's vault event",
      "men's parallel bars event",
      "women's floor exercise event"
    ],
    "answer": "men's vault event",
    "unit": null,
    "table_title": "Gymnastics meet schedule",
    "table": "Event | Begin | End\nmen's parallel bars | 10:35 A.M. | 11:25 A.M.\nmen's floor exercise | 11:05 A.M. | 11:50 A.M.\nwomen's floor exercise | 12:05 P.M. | 12:35 P.M.\nmen's vault | 12:25 P.M. | 1:10 P.M.\nwomen's balance beam | 1:25 P.M. | 2:20 P.M.\nwomen's uneven bars | 2:25 P.M. | 3:00 P.M.\nwomen's vault | 2:45 P.M. | 3:40 P.M.\nmen's rings | 3:35 P.M. | 3:55 P.M.\nmen's high bar | 4:05 P.M. | 4:40 P.M.\nmen's pommel horse | 4:50 P.M. | 5:35 P.M.",
    "row_num": 11,
    "column_num": 3,
    "solution": "Find 12:25 P. M. on the schedule. The men's vault event begins at 12:25 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 3,
    "split": "dev",
    "pid": "880",
    "path": "data"
  },
  {
    "question": "Hansen counted the number of problems on each of his tests. How many tests had at least 25 problems but fewer than 77 problems?",
    "choices": null,
    "answer": "4",
    "unit": "tests",
    "table_title": "Problems per test",
    "table": "Stem | Leaf \n2 | 6\n3 | 7\n4 | \n5 | \n6 | 3, 7\n7 | 8\n8 | 4",
    "row_num": 8,
    "column_num": 2,
    "solution": "Find the row with stem 2. Count all the leaves greater than or equal to 5.\n\nCount all the leaves in the rows with stems 3, 4, 5, and 6.\n\nIn the row with stem 7, count all the leaves less than 7.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plots above. 4 tests had at least 25 problems but fewer than 77 problems.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "26823",
    "path": "data"
  },
  {
    "question": "The players on a quiz show received the following scores. What is the mean of the numbers?",
    "choices": null,
    "answer": "20",
    "unit": null,
    "table_title": "Quiz show scores",
    "table": "Name | Score\nCarmen | 22\nEduardo | 21\nLorenzo | 21\nHarry | 28\nNora | 26\nKimberly | 15\nDarius | 13\nBrett | 14",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n22, 21, 21, 28, 26, 15, 13, 14\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n22 + 21 + 21 + 28 + 26 + 15 + 13 + 14 = 160\n\nNow divide the sum by the number of numbers:\n\n160 \u00f7 8 = 20\n\nThe mean is 20.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "2010",
    "path": "data"
  },
  {
    "question": "At a swim meet, Brian noted the size of various swim teams. How many teams have exactly 56 swimmers?",
    "choices": null,
    "answer": "3",
    "unit": "teams",
    "table_title": "Swimming team sizes (number of swimmers)",
    "table": "Stem | Leaf \n2 | 2, 4, 6\n3 | 4, 8\n4 | 9\n5 | 0, 6, 6, 6, 7, 7, 8\n6 | 4\n7 | 2, 3, 8\n8 | 6, 9\n9 | 0",
    "row_num": 9,
    "column_num": 2,
    "solution": "For the number 56, the stem is 5, and the leaf is 6. Find the row where the stem is 5. In that row, count all the leaves equal to 6.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plot above. 3 teams have exactly 56 swimmers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "35381",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $125, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$95 | 19,800 | 4,800\n$125 | 15,500 | 8,200\n$155 | 11,200 | 11,600\n$185 | 6,900 | 15,000\n$215 | 2,600 | 18,400",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $125, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "23495",
    "path": "data"
  },
  {
    "question": "Warren attended a music store's banjo sale. He counted the types of banjos and made note of their discounts. What is the probability that a randomly selected banjo has 5 strings and is 25% off? Simplify any fractions.",
    "choices": null,
    "answer": "1/3",
    "unit": null,
    "table_title": null,
    "table": " | 25% off | 50% off\n4 strings | 3 | 4\n5 strings | 5 | 3",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the banjo has 5 strings\" and B be the event \"the banjo is 25% off\".\nTo find the probability that a banjo has 5 strings and is 25% off, first identify the sample space and the event.\nThe outcomes in the sample space are the different banjos. Each banjo is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the banjo has 5 strings and is 25% off\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the banjo has 5 strings and is 25% off\", so look at the table to see how many banjos have 5 strings and are 25% off.\nThe number of banjos that have 5 strings and are 25% off is 5.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of banjos.\n3 + 5 + 4 + 3 = 15\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{5}{15}\n = \\frac{1}{3}\nThe probability that a banjo has 5 strings and is 25% off is \\frac{1}{3}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "21137",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $755, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$515 | 18,500 | 16,000\n$635 | 15,500 | 17,200\n$755 | 12,500 | 18,400\n$875 | 9,500 | 19,600\n$995 | 6,500 | 20,800",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $755, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "29695",
    "path": "data"
  },
  {
    "question": "Wanda buys 1/5 of a pound of tortillas. How much does she spend?",
    "choices": null,
    "answer": "1.60",
    "unit": "$",
    "table_title": null,
    "table": "spelt rolls | $8/pound\ntortillas | $8/pound\nFrench rolls | $18/pound\nrye rolls | $15/pound",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the tortillas. Multiply the price per pound by the number of pounds.\n$8 \u00d7 \\frac{1}{5} = $8 \u00d7 0.2 = $1.60\nShe spends $1.60.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "28014",
    "path": "data"
  },
  {
    "question": "Zeke has $109.00. Does he have enough to buy a hockey stick and a softball glove?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "football | $11.98\nfishing pole | $13.36\nsoftball glove | $13.86\nswimsuit | $17.94\nbasketball jersey | $11.20\nhockey stick | $93.38",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a hockey stick and the price of a softball glove:\n\n$93.38 + $13.86 = $107.24\n\n$107.24 is less than $109.00. Zeke does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "14118",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "x | y\n2 | 18\n2 | 19\n14 | 12",
    "row_num": 4,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nThe x-value 2 is paired with multiple y-values, so the relation is not a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "13326",
    "path": "data"
  },
  {
    "question": "A sandwich shop in Danville polled its customers regarding their favorite sandwiches. What fraction of customers preferred chicken sandwiches? Simplify your answer.",
    "choices": null,
    "answer": "37/164",
    "unit": null,
    "table_title": "Sandwich preference",
    "table": "Sandwich | Number of customers\nPastrami | 290\nCheese | 630\nChicken | 370\nOther | 350",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find how many customers preferred chicken sandwiches.\n\n370\n\nFind how many customers participated in the poll in total.\n\n290 + 630 + 370 + 350 = 1,640\n\nDivide 370 by1,640.\n\n\\frac{370}{1,640}\n\nReduce the fraction.\n\n\\frac{370}{1,640} \u2192 \\frac{37}{164}\n\n\\frac{37}{164} of customers preferred chicken sandwiches.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "15013",
    "path": "data"
  },
  {
    "question": "Judy wants to buy 7/10 of a pound of Jordan almonds. How much will she spend?",
    "choices": null,
    "answer": "4.20",
    "unit": "$",
    "table_title": null,
    "table": "unsalted almonds | $3 per pound\nhoney-roasted almonds | $5 per pound\nJordan almonds | $6 per pound\nchocolate-covered almonds | $5 per pound\nyogurt-covered almonds | $4 per pound\nsalted almonds | $2 per pound",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the Jordan almonds. Multiply the price per pound by the number of pounds.\n$6 \u00d7 \\frac{7}{10} = $6 \u00d7 0.7 = $4.20\nShe will spend $4.20.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "6798",
    "path": "data"
  },
  {
    "question": "Some friends went bowling and kept track of their scores. How many more points did Mike score than Irma?",
    "choices": null,
    "answer": "20",
    "unit": "points",
    "table_title": "Bowling scores",
    "table": "Name | Score\nAmanda | 117\nSam | 236\nIrma | 144\nMike | 164",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nMike: 164\nIrma: 144\n\nNow subtract: 164 - 144 = 20.\n\nMike scored 20 more points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "3866",
    "path": "data"
  },
  {
    "question": "Winston has $54. Does he have enough to buy a rabbit and a cockatoo?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "tarantula | $48\ncockatoo | $31\nrabbit | $23\nchameleon | $72\nscorpion | $26",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a rabbit and the price of a cockatoo:\n\n$23 + $31 = $54\n\nSince Winston has $54, he has just enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 7,
    "split": "dev",
    "pid": "35928",
    "path": "data"
  },
  {
    "question": "Judy is a physical therapist who specializes in leg injuries. Her patients differ in age and type of injury. What is the probability that a randomly selected patient is 0-12 years old and suffers from knee pain? Simplify any fractions.",
    "choices": null,
    "answer": "2/7",
    "unit": null,
    "table_title": null,
    "table": " | Knee pain | Ankle pain\n0-12 years old | 4 | 2\n13-19 years old | 4 | 4",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the patient is 0-12 years old\" and B be the event \"the patient suffers from knee pain\".\nTo find the probability that a patient is 0-12 years old and suffers from knee pain, first identify the sample space and the event.\nThe outcomes in the sample space are the different patients. Each patient is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the patient is 0-12 years old and suffers from knee pain\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the patient is 0-12 years old and suffers from knee pain\", so look at the table to see how many patients are 0-12 years old and suffer from knee pain.\nThe number of patients who are 0-12 years old and suffer from knee pain is 4.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of patients.\n4 + 4 + 2 + 4 = 14\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{4}{14}\n = \\frac{2}{7}\nThe probability that a patient is 0-12 years old and suffers from knee pain is \\frac{2}{7}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "5332",
    "path": "data"
  },
  {
    "question": "Joel wants to make sure he completes all his homework this week. He made a frequency chart showing the questions he has to answer. Joel can answer one-fourth of his English questions and all of his social studies questions while still at school. Altogether, how many questions is that?",
    "choices": null,
    "answer": "18",
    "unit": "questions",
    "table_title": "Homework questions",
    "table": "Subject | Frequency\nsocial studies | 15\nmath | 19\nEnglish | 12\nscience | 17",
    "row_num": 5,
    "column_num": 2,
    "solution": "Step 1: Find how many English questions Joel can answer at school.\nJoel has 12 English questions, and he can answer one-fourth of them at school. Divide 12 by 4.\n12\u00f74 = 3\nJoel can answer 3 English questions at school.\nStep 2: Find how many total questions Joel can answer at school.\nJoel has 15 social studies questions, and he can answer all of them at school. So, add 3 English questions and 15 social studies questions.\n3 + 15 = 18\nJoel can answer 18 questions at school.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "33030",
    "path": "data"
  },
  {
    "question": "Dr. Durham, a zoo director, researched ticket prices at other zoos around the country. Which charges more for a child ticket, the Houston Zoo or the Cleveland Zoo?",
    "choices": [
      "Cleveland",
      "Houston"
    ],
    "answer": "Cleveland",
    "unit": null,
    "table_title": "Zoo ticket prices",
    "table": "Zoo | Child | Senior\nCleveland | $7 | $10\nDenver | $7 | $9\nSan Francisco | $9 | $12\nHouston | $6 | $6\nCentral Florida | $7 | $9",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Child column. Compare the numbers in this column for Houston and Cleveland.\n\n$7.00 is more than $6.00. The Cleveland Zoo charges more for a child.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "1886",
    "path": "data"
  },
  {
    "question": "Each bouquet has 2 carnations. How many carnations are in 3 bouquets?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": null,
    "table": "Number of bouquets | Number of carnations\n1 | 2\n2 | 4\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 6 carnations in 3 bouquets.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "14149",
    "path": "data"
  },
  {
    "question": "Mr. Lee asked his students to each write a poem about his or her favorite season. He recorded the seasons they wrote about in a frequency chart. Which season was the least popular to write about?",
    "choices": [
      "spring",
      "summer",
      "fall",
      "winter"
    ],
    "answer": "winter",
    "unit": null,
    "table_title": "Favorite season",
    "table": "Season | Frequency\nspring | 5\nsummer | 11\nfall | 6\nwinter | 3",
    "row_num": 5,
    "column_num": 2,
    "solution": "The smallest number in the frequency chart is 3.\nSo, winter was the least popular to write about.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "37043",
    "path": "data"
  },
  {
    "question": "For a math assignment, Colette researched the scores of the people competing on her favorite quiz show. How many people scored fewer than 71 points?",
    "choices": null,
    "answer": "6",
    "unit": "people",
    "table_title": "Quiz show scores",
    "table": "Stem | Leaf \n1 | 4\n2 | \n3 | 2, 2\n4 | \n5 | \n6 | 4, 5, 8\n7 | 8",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, 4, 5, and 6.\n\nIn the row with stem 7, count all the leaves less than 1.\n\nYou counted 6 leaves, which are blue in the stem-and-leaf plots above. 6 people scored fewer than 71 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "20400",
    "path": "data"
  },
  {
    "question": "Each restaurant table has 10 cups. How many cups are on 6 restaurant tables?",
    "choices": null,
    "answer": "60",
    "unit": "cups",
    "table_title": null,
    "table": "Number of restaurant tables | Number of cups\n1 | 10\n2 | 20\n3 | 30\n4 | 40\n5 | 50\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 60 cups on 6 restaurant tables.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "22491",
    "path": "data"
  },
  {
    "question": "Shelby is looking at the price of new cell phones online. Her favorite company, OrangeTech, has a special this weekend. Shelby can add an upgrade to a phone for an additional cost, or she can buy a used phone to get a discount. The change in price for each option is shown in the table. Which option results in a greater change in price?",
    "choices": [
      "adding an upgrade",
      "buying a used phone"
    ],
    "answer": "buying a used phone",
    "unit": null,
    "table_title": null,
    "table": "Option | Change in phone price\nAdd an upgrade | $60\nBuy a used phone | -$75",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find the option that results in a greater change in price, use absolute value. Absolute value tells you how much the price changes.\nAdd an upgrade: |$60| = $60\nBuy a used phone: |-$75| = $75\nBuying a used phone results in a greater change in price. It reduces the price by $75.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 6,
    "split": "dev",
    "pid": "7115",
    "path": "data"
  },
  {
    "question": "Erin decided to record the temperature every morning when she woke up. How many temperature readings were at least 0\u00b0C?",
    "choices": null,
    "answer": "22",
    "unit": "temperature readings",
    "table_title": "Daily temperatures (\u00b0C)",
    "table": "Stem | Leaf \n0 | 1, 2, 6, 7, 9\n1 | 0, 1, 3, 4\n2 | 0, 5, 7, 9, 9\n3 | 0, 1, 2, 4, 4, 8, 8, 9",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 0, 1, 2, and 3.\n\nYou counted 22 leaves, which are blue in the stem-and-leaf plot above. 22 temperature readings were at least 0\u00b0C.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "18200",
    "path": "data"
  },
  {
    "question": "A law firm in Fairfax kept track of how many hours were billed by each partner last year. What fraction of the hours were billed by Regan? Simplify your answer.",
    "choices": null,
    "answer": "71/416",
    "unit": null,
    "table_title": "Law firm hours billed",
    "table": "Partner | Hours billed\nRegan | 710\nKaylee | 900\nEdna | 800\nLevi | 760\nDarrell | 990",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find how many hours were billed by Regan.\n\n710\n\nFind how many hours were billed in total.\n\n710 + 900 + 800 + 760 + 990 = 4,160\n\nDivide 710 by 4,160.\n\n\\frac{710}{4,160}\n\nReduce the fraction.\n\n\\frac{710}{4,160} \u2192 \\frac{71}{416}\n\n\\frac{71}{416} of hours were billed by Regan.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "18519",
    "path": "data"
  },
  {
    "question": "The members of the track team compared how many miles they ran last week. What is the range of the numbers?",
    "choices": null,
    "answer": "16",
    "unit": null,
    "table_title": "Running miles",
    "table": "Name | Miles\nEstelle | 7\nFelix | 4\nPablo | 3\nZeke | 15\nHassan | 11\nArianna | 7\nNicole | 19\nBryant | 15",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 4, 3, 15, 11, 7, 19, 15\n\nFirst, find the greatest number. The greatest number is 19.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n19 \u2212 3 = 16\n\nThe range is 16.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "8943",
    "path": "data"
  },
  {
    "question": "This table shows information about two occupations. In which occupation would you be more likely to handle a call with a dissatisfied customer?",
    "choices": [
      "customer service representative",
      "social media manager"
    ],
    "answer": "customer service representative",
    "unit": null,
    "table_title": null,
    "table": "| Customer service representative | Social media manager\nDescription | Customer service representatives answer customer questions and resolve issues with a product or service. | Social media managers represent a company on different social media platforms and respond to user questions and comments.\nTypical education required | High school diploma | Bachelor's degree in public relations, communications, business, or a related field\nMedian income | $34,500 per year | $50,500 per year",
    "row_num": 4,
    "column_num": 3,
    "solution": "Look at the description for each occupation.\nSocial media managers represent a company on different social media platforms. They make posts and respond to customer comments, but they work online and wouldn't need to talk to customers over the phone.\nCustomer service representatives answer customer questions and resolve issues with a product or service. They often answer phone calls about a product, so they would be more likely to handle a call with a dissatisfied customer.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "13526",
    "path": "data"
  },
  {
    "question": "Nellie's classmates revealed how many science articles they read. What is the mean of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Science articles read",
    "table": "Name | Number of science articles\nNellie | 3\nMelissa | 6\nBrendan | 9\nSebastian | 6\nRoy | 10\nCamilla | 8\nOscar | 9\nJasper | 5",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n3, 6, 9, 6, 10, 8, 9, 5\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n3 + 6 + 9 + 6 + 10 + 8 + 9 + 5 = 56\n\nNow divide the sum by the number of numbers:\n\n56 \u00f7 8 = 7\n\nThe mean is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "9635",
    "path": "data"
  },
  {
    "question": "How much money does Kimberly need to buy 3 winter jackets and 5 yellow skirts?",
    "choices": null,
    "answer": "179",
    "unit": "$",
    "table_title": null,
    "table": "winter jacket | $43.00\nyellow skirt | $10.00\npink sweater | $11.00\npair of boots | $39.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of 3 winter jackets.\n\n$43.00 \u00d7 3 = $129.00\n\nFind the cost of 5 yellow skirts.\n\n$10.00 \u00d7 5 = $50.00\n\nNow find the total cost.\n\n$129.00 + $50.00 = $179.00\n\nKimberly needs $179.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "35628",
    "path": "data"
  },
  {
    "question": "Some friends compared the sizes of their sticker collections. What is the mean of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Sticker collections",
    "table": "Name | Number of stickers\nKeith | 5\nDalton | 6\nFranklin | 10\nMitch | 10\nJenna | 7\nLillian | 10",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 6, 10, 10, 7, 10\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n5 + 6 + 10 + 10 + 7 + 10 = 48\n\nNow divide the sum by the number of numbers:\n\n48 \u00f7 6 = 8\n\nThe mean is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "7609",
    "path": "data"
  },
  {
    "question": "A pretzel stand owner kept track of the number of pretzels sold during the past 4 days. On which day did the stand sell the most pretzels?",
    "choices": [
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday"
    ],
    "answer": "Tuesday",
    "unit": null,
    "table_title": "Pretzels sold",
    "table": "Day | Number of pretzels\nTuesday | 995\nWednesday | 945\nThursday | 949\nFriday | 959",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 995.\n\nNow find the corresponding day. Tuesday corresponds to 995.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "29020",
    "path": "data"
  },
  {
    "question": "A pottery factory kept track of the number of broken plates per shipment last week. What is the largest number of broken plates?",
    "choices": null,
    "answer": "90",
    "unit": "broken plates",
    "table_title": "Broken plates per shipment",
    "table": "Stem | Leaf \n4 | 2, 3, 5, 6\n5 | 1, 5, 6\n6 | 0, 1, 2, 4, 7\n7 | 3, 3, 5, 6, 9\n8 | 3, 5, 7\n9 | 0",
    "row_num": 7,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe largest number of broken plates has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe largest number of broken plates is 90 broken plates.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "24324",
    "path": "data"
  },
  {
    "question": "Several students participated in a race. Which runner took the longest?",
    "choices": [
      "Kenji",
      "Tony",
      "Jeanette",
      "Brenda"
    ],
    "answer": "Jeanette",
    "unit": null,
    "table_title": "Race results",
    "table": "Runner | Time (minutes)\nKenji | 30\nTony | 31\nJeanette | 38\nBrenda | 34",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 38.\n\nNow find the corresponding runner. Jeanette corresponds to 38.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "35587",
    "path": "data"
  },
  {
    "question": "Dr. Kline, a zoo director, researched ticket prices at other zoos around the country. How much does a child ticket to the Minnesota Zoo cost?",
    "choices": null,
    "answer": "10",
    "unit": "$",
    "table_title": "Zoo ticket prices",
    "table": "Zoo | Adult | Child\nSouthern Nevada | $8 | $6\nMinnesota | $16 | $10\nOakland | $10 | $7\nLos Angeles | $13 | $8\nBrookfield | $12 | $8",
    "row_num": 6,
    "column_num": 3,
    "solution": "First, find the row for Minnesota. Then find the number in the Child column.\n\nThis number is $10.00. A child ticket to the Minnesota Zoo cost $10.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "15541",
    "path": "data"
  },
  {
    "question": "Each vase has 5 poppies. How many poppies are in 6 vases?",
    "choices": null,
    "answer": "30",
    "unit": "poppies",
    "table_title": null,
    "table": "Number of vases | Number of poppies\n1 | 5\n2 | 10\n3 | 15\n4 | 20\n5 | 25\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 30 poppies in 6 vases.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "27211",
    "path": "data"
  },
  {
    "question": "A toy store employee counted the number of toys in each bin in the sale section. How many bins had at least 10 toys but fewer than 20 toys?",
    "choices": null,
    "answer": "4",
    "unit": "bins",
    "table_title": "Toys per bin",
    "table": "Stem | Leaf \n1 | 0, 3, 8, 9\n2 | 2\n3 | 5, 7\n4 | 0, 5, 8\n5 | 0",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count all the leaves in the row with stem 1.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plot above. 4 bins had at least 10 toys but fewer than 20 toys.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "32414",
    "path": "data"
  },
  {
    "question": "How much money does Pablo need to buy 3 butterscotch candies?",
    "choices": null,
    "answer": "0.30",
    "unit": "$",
    "table_title": null,
    "table": "chocolate-covered cherry | $0.15\ngumball | $0.22\npiece of licorice | $0.20\ngummy worm | $0.14\nbutterscotch candy | $0.10\ngummy bear | $0.14",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of 3 butterscotch candies by multiplying 3 times the price of a butterscotch candy.\n\n$0.10 \u00d7 3 = $0.30\n\nPablo needs $0.30.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "23911",
    "path": "data"
  },
  {
    "question": "As part of a statistics project, a math class weighed all the children who were willing to participate. How many children weighed at least 42 pounds but less than 60 pounds?",
    "choices": null,
    "answer": "4",
    "unit": "children",
    "table_title": "Children's weights (lbs)",
    "table": "Stem | Leaf \n3 | 1, 1, 3, 5, 5, 8, 8\n4 | 2, 2, 9\n5 | 6\n6 | 0",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the row with stem 4. Count all the leaves greater than or equal to 2.\n\nCount all the leaves in the row with stem 5.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plots above. 4 children weighed at least 42 pounds but less than 60 pounds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "29088",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the train arrive at Rollercoaster Land?",
    "choices": [
      "1:00 A.M.",
      "2:55 A.M.",
      "11:40 P.M.",
      "4:10 A.M."
    ],
    "answer": "11:40 P.M.",
    "unit": null,
    "table_title": "Train schedule",
    "table": "Location | Arrive | Depart\nChickenville | 10:40 P.M. | 11:10 P.M.\nRollercoaster Land | 11:40 P.M. | 12:00 A.M.\nFloral Gardens | 1:00 A.M. | 1:10 A.M.\nMagician Village | 2:00 A.M. | 2:20 A.M.\nComfy Pillows Resort | 2:55 A.M. | 3:10 A.M.\nCity of Green Trees | 4:10 A.M. | 4:35 A.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find Rollercoaster Land on the schedule. Find the arrival time for Rollercoaster Land.\n\nRollercoaster Land: 11:40 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "5211",
    "path": "data"
  },
  {
    "question": "Tessa counted the number of peanuts in each bag of trail mix. How many bags had at least 10 peanuts?",
    "choices": null,
    "answer": "18",
    "unit": "bags",
    "table_title": "Peanuts per bag of trail mix",
    "table": "Stem | Leaf \n1 | 1, 7, 8, 8\n2 | 0\n3 | 4, 5, 8\n4 | \n5 | 0, 2, 6, 8\n6 | \n7 | 1, 5\n8 | 0, 2, 9\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, 4, 5, 6, 7, 8, and 9.\n\nYou counted 18 leaves, which are blue in the stem-and-leaf plot above. 18 bags had at least 10 peanuts.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "29714",
    "path": "data"
  },
  {
    "question": "Each package has 10 apples. How many apples are in 6 packages?",
    "choices": null,
    "answer": "60",
    "unit": null,
    "table_title": null,
    "table": "Number of packages | Number of apples\n1 | 10\n2 | 20\n3 | 30\n4 | 40\n5 | 50\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 60 apples in 6 packages.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "31144",
    "path": "data"
  },
  {
    "question": "The employees at Sam's Construction monitored the number of cracked window panes in each shipment they received. How many shipments had less than 30 cracked window panes?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Cracked window panes per shipment",
    "table": "Stem | Leaf \n1 | 0, 1, 3, 4\n2 | 3, 4, 6\n3 | 4\n4 | 1, 2, 5, 9\n5 | 0, 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1 and 2.\n\nYou counted 7 leaves, which are blue in the stem-and-leaf plot above. 7 shipments had less than 30 cracked window panes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "16453",
    "path": "data"
  },
  {
    "question": "A girl compared the ages of her cousins. What is the range of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Ages of cousins",
    "table": "Name | Age (years)\nLauren | 19\nMartin | 16\nClara | 19\nEve | 17\nJonathan | 15\nBryan | 19\nTommy | 17\nAshley | 19",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n19, 16, 19, 17, 15, 19, 17, 19\n\nFirst, find the greatest number. The greatest number is 19.\n\nNext, find the least number. The least number is 15.\n\nSubtract the least number from the greatest number:\n\n19 \u2212 15 = 4\n\nThe range is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "26333",
    "path": "data"
  },
  {
    "question": "Cody looked at his calendar to figure out how much time he spent babysitting each month. What is the range of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Hours of babysitting",
    "table": "Month | Hours\nJuly | 7\nAugust | 10\nSeptember | 9\nOctober | 9\nNovember | 9\nDecember | 7\nJanuary | 7\nFebruary | 9",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 10, 9, 9, 9, 7, 7, 9\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 7.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 7 = 3\n\nThe range is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "35506",
    "path": "data"
  },
  {
    "question": "How much money does Marcy need to buy an emerald pendant and a pearl necklace?",
    "choices": null,
    "answer": "15,516",
    "unit": "$",
    "table_title": null,
    "table": "pearl necklace | $9,747.00\nemerald ring | $4,518.00\nopal pendant | $3,633.00\nemerald pendant | $5,769.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of an emerald pendant and the price of a pearl necklace:\n\n$5,769.00 + $9,747.00 = $15,516.00\n\nMarcy needs $15,516.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "29294",
    "path": "data"
  },
  {
    "question": "Some friends played miniature golf and wrote down their scores. How many more strokes did Isaiah take than Edward?",
    "choices": null,
    "answer": "32",
    "unit": "strokes",
    "table_title": "Miniature golf scores",
    "table": "Name | Score\nKendrick | 154\nEdward | 112\nIsaiah | 144\nNeil | 130",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nIsaiah: 144\nEdward: 112\n\nNow subtract: 144 - 112 = 32.\n\nIsaiah took 32 more strokes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "26089",
    "path": "data"
  },
  {
    "question": "How much money does Lily need to buy a big blue button and a sewing needle?",
    "choices": null,
    "answer": "0.14",
    "unit": "$",
    "table_title": null,
    "table": "sewing needle | $0.06\nbig blue button | $0.08\nsilver bow | $0.02\nsmall yellow button | $0.06\nshiny red button | $0.06\npair of googly eyes | $0.05",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a big blue button and the price of a sewing needle:\n\n$0.08 + $0.06 = $0.14\n\nLily needs $0.14.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "26152",
    "path": "data"
  },
  {
    "question": "Darell, an employee at Camacho's Convenience Store, looked at the sales of each of its soda products. On Sunday, which beverage had the lowest sales?",
    "choices": [
      "Krazy Kola",
      "Refresh Mineral Water",
      "Fizzy Fun"
    ],
    "answer": "Krazy Kola",
    "unit": null,
    "table_title": "Convenience store beverage sales",
    "table": "Beverage | Saturday | Sunday\nRefresh Mineral Water | $3 | $13\nFizzy Fun | $19 | $9\nKrazy Kola | $20 | $8",
    "row_num": 4,
    "column_num": 3,
    "solution": "Look at the numbers in the Sunday column. Find the least number in this column.\n\nThe least number is $8.00, which is in the Krazy Kola row. On Sunday, Krazy Kola had the lowest sales.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "33306",
    "path": "data"
  },
  {
    "question": "Julie likes watching the show Engineering Marvels. In last night's episode, the engineering team visited a tall skyscraper and a deep mine. A banner at the bottom of the screen showed the elevation of each location the team visited. Which location is closer to sea level?",
    "choices": [
      "top of the skyscraper",
      "bottom of the mine"
    ],
    "answer": "bottom of the mine",
    "unit": null,
    "table_title": null,
    "table": "Location | Elevation (m)\nTop of the skyscraper | 275\nBottom of the mine | -260",
    "row_num": 3,
    "column_num": 2,
    "solution": "The top of the skyscraper has a positive elevation, so it is above sea level. The bottom of the mine has a negative elevation, so it is below sea level.\nTo find the location closer to sea level, use absolute value. Absolute value tells you how far each location is from sea level.\nTop of the skyscraper: |275| = 275\nBottom of the mine: |-260| = 260\nThe top of the skyscraper is 275 meters above sea level, but the bottom of the mine is only260 meters below sea level. The bottom of the mine is closer to sea level.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "29560",
    "path": "data"
  },
  {
    "question": "The school district compared how many swings each elementary school has. Which school has the fewest swings?",
    "choices": [
      "Hillside Elementary",
      "Valley Elementary",
      "Roseville Elementary",
      "Lincoln Elementary"
    ],
    "answer": "Valley Elementary",
    "unit": null,
    "table_title": "Swings",
    "table": "School | Number of swings\nHillside Elementary | 16\nValley Elementary | 12\nRoseville Elementary | 18\nLincoln Elementary | 17",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 12.\n\nNow find the corresponding school. Valley Elementary corresponds to 12.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "25175",
    "path": "data"
  },
  {
    "question": "Nancy buys 3 pounds of Dijon mustard and 2 pounds of mustard. How much does she spend?",
    "choices": null,
    "answer": "18",
    "unit": "$",
    "table_title": null,
    "table": "hot sauce | $3/lb\nmustard | $6/lb\nmayonnaise | $6/lb\nDijon mustard | $2/lb",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the Dijon mustard. Multiply:\n\n$2 \u00d7 3 = $6\n\nFind the cost of the mustard. Multiply:\n\n$6 \u00d7 2 = $12\n\nNow find the total cost by adding:\n\n$6 + $12 = $18\n\nShe spends $18.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "20486",
    "path": "data"
  },
  {
    "question": "Baldwin has $23.00. Does he have enough to buy a pepperoni pizza and baked chicken?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "pepperoni pizza | $13.00\nlasagna | $12.00\nbaked chicken | $10.00\nravioli | $12.00\nbaked ziti | $15.00\npasta with clams | $13.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a pepperoni pizza and the price of baked chicken:\n\n$13.00 + $10.00 = $23.00\n\nSince Baldwin has $23.00, he has just enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "10901",
    "path": "data"
  },
  {
    "question": "A Technical Assistance Manager monitored his customers' wait times. What is the longest wait time?",
    "choices": null,
    "answer": "90",
    "unit": "minutes",
    "table_title": "Technical assistance wait times (minutes)",
    "table": "Stem | Leaf \n5 | 1, 2, 4, 5, 6\n6 | 1, 2, 3, 5, 7, 8\n7 | 1, 1, 2, 5, 9\n8 | 1, 7, 9\n9 | 0",
    "row_num": 6,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe longest wait time has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe longest wait time is 90 minutes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "22631",
    "path": "data"
  },
  {
    "question": "In order to complete their model of a futuristic highway, students in Ms. Becky's design class find out how many toy cars each student can bring to class. How many students have more than 2 toy cars?",
    "choices": null,
    "answer": "20",
    "unit": null,
    "table_title": "Toy cars",
    "table": "Number of toy cars | Frequency\n0 | 9\n1 | 7\n2 | 3\n3 | 0\n4 | 20",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the rows for 3 and 4 toy cars. Add the frequencies for these rows.\n\nAdd:\n\n0 + 20 = 20\n\n20 students have more than 2 toy cars.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "5326",
    "path": "data"
  },
  {
    "question": "How much money does Valentina need to buy a basketball ticket and a golf ticket?",
    "choices": null,
    "answer": "26.35",
    "unit": "$",
    "table_title": null,
    "table": "hockey ticket | $18.72\nsoccer ticket | $14.03\ngolf ticket | $13.98\nfootball ticket | $77.15\nbasketball ticket | $12.37",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a basketball ticket and the price of a golf ticket:\n\n$12.37 + $13.98 = $26.35\n\nValentina needs $26.35.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "20827",
    "path": "data"
  },
  {
    "question": "An archer recalled how many times he hit the bull's-eye in the past 4 days. On which day did the archer hit the most bull's-eyes?",
    "choices": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday"
    ],
    "answer": "Wednesday",
    "unit": null,
    "table_title": "Bull's-eyes",
    "table": "Day | Number of bull's-eyes\nMonday | 14\nTuesday | 18\nWednesday | 19\nThursday | 12",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 19.\n\nNow find the corresponding day. Wednesday corresponds to 19.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "32933",
    "path": "data"
  },
  {
    "question": "A restaurant's average food preparation time was tracked from day to day as part of an efficiency improvement program. According to the table, what was the rate of change between Wednesday and Thursday?",
    "choices": null,
    "answer": "-2",
    "unit": "minutes per day",
    "table_title": "Average food preparation time",
    "table": "Day | Food preparation time (minutes)\nMonday | 42\nTuesday | 32\nWednesday | 45\nThursday | 43\nFriday | 42",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{43 minutes - 45 minutes}{1 day}\n = \\frac{-2 minutes}{1 day}\n = -2 minutes per day\nThe rate of change between Wednesday and Thursday was - 2 minutes per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "37250",
    "path": "data"
  },
  {
    "question": "How much money does Emily need to buy an antique cast-iron bench and an antique cedar cabinet?",
    "choices": null,
    "answer": "1,598",
    "unit": "$",
    "table_title": null,
    "table": "antique cedar cabinet | $611\nantique fir wood bed | $921\nantique mahogany armoire | $768\nantique cast-iron bench | $987\nantique rosewood corner cabinet | $978",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of an antique cast-iron bench and the price of an antique cedar cabinet:\n\n$987 + $611 = $1,598\n\nEmily needs $1,598.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "36292",
    "path": "data"
  },
  {
    "question": "The parks department compared how many basketball hoops there are at each park. What is the range of the numbers?",
    "choices": null,
    "answer": "9",
    "unit": null,
    "table_title": "Basketball hoops",
    "table": "Park | Number of basketball hoops\nLinden Park | 9\nWestfield Park | 10\nOtter Park | 1\nKelly Park | 10\nHeron Park | 5\nPinehurst Park | 6\nCrestview Park | 4\nRiverfront Park | 5",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 10, 1, 10, 5, 6, 4, 5\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 1.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 1 = 9\n\nThe range is 9.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "2216",
    "path": "data"
  },
  {
    "question": "How much money does Jamie need to buy a program signed by a famous dancer and a photograph signed by a famous singer?",
    "choices": null,
    "answer": "70.39",
    "unit": "$",
    "table_title": null,
    "table": "photograph signed by a famous movie star | $98.62\nprogram signed by a famous dancer | $12.04\nphotograph signed by a famous singer | $58.35\nphotograph signed by a famous television star | $86.06\nDVD signed by a famous comedian | $80.28",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a program signed by a famous dancer and the price of a photograph signed by a famous singer:\n\n$12.04 + $58.35 = $70.39\n\nJamie needs $70.39.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "21832",
    "path": "data"
  },
  {
    "question": "A dog show enthusiast recorded the weight of the winning dog at recent dog shows. According to the table, what was the rate of change between 2007 and 2008?",
    "choices": null,
    "answer": "5",
    "unit": "kilograms per year",
    "table_title": "Weight of winning dog at a dog show",
    "table": "Year | Weight (kg)\n2007 | 22\n2008 | 27\n2009 | 25\n2010 | 36\n2011 | 25",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{27 kilograms - 22 kilograms}{2008 - 2007}\n = \\frac{27 kilograms - 22 kilograms}{1 year}\n = \\frac{5 kilograms}{1 year}\n = 5 kilograms per year\nThe rate of change between 2007 and 2008 was 5 kilograms per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "4667",
    "path": "data"
  },
  {
    "question": "The players on a quiz show received the following scores. What is the range of the numbers?",
    "choices": null,
    "answer": "20",
    "unit": null,
    "table_title": "Quiz show scores",
    "table": "Name | Score\nSharon | 15\nEmma | 27\nFranco | 28\nHeather | 35\nAmy | 20\nRon | 23\nTristan | 18\nJaden | 24",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n15, 27, 28, 35, 20, 23, 18, 24\n\nFirst, find the greatest number. The greatest number is 35.\n\nNext, find the least number. The least number is 15.\n\nSubtract the least number from the greatest number:\n\n35 \u2212 15 = 20\n\nThe range is 20.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "12960",
    "path": "data"
  },
  {
    "question": "How much more does a hedgehog cost than a tree frog?",
    "choices": null,
    "answer": "27.88",
    "unit": "$",
    "table_title": null,
    "table": "chameleon | $96.75\nrabbit | $98.17\nhedgehog | $86.27\ntree frog | $58.39",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a tree frog from the price of a hedgehog.\n\n$86.27 - $58.39 = $27.88\n\nA hedgehog costs $27.88 more than a tree frog.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "4787",
    "path": "data"
  },
  {
    "question": "Every year Lancaster has a citywide relay and reports the winning times. According to the table, what was the rate of change between 2010 and 2011?",
    "choices": null,
    "answer": "-5",
    "unit": "minutes per year",
    "table_title": "Winning relay times",
    "table": "Year | Winning time (minutes)\n2007 | 30\n2008 | 35\n2009 | 31\n2010 | 34\n2011 | 29",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{29 minutes - 34 minutes}{2011 - 2010}\n = \\frac{29 minutes - 34 minutes}{1 year}\n = \\frac{-5 minutes}{1 year}\n = -5 minutes per year\nThe rate of change between 2010 and 2011 was - 5 minutes per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "8895",
    "path": "data"
  },
  {
    "question": "The table shows checking account features and fees for two banks in Yellowbridge. Mrs. Seewald is looking for a new bank to open savings and checking accounts. She has 5 grandchildren in college and uses a mobile app to send each one money by person-to-person transfer once a month. Mrs. Seewald does not maintain an average balance of $800 in her checking account. She needs overdraft protection about once a month because she spends more money than is in her checking account. Which bank is the better choice for Mrs. Seewald?",
    "choices": [
      "Riverwalk Bank",
      "Trust Security Bank"
    ],
    "answer": "Riverwalk Bank",
    "unit": null,
    "table_title": null,
    "table": " | Riverwalk Bank | Trust Security Bank\nChecking account services | Free with minimum average monthly balance of $800; Otherwise, $10 per month | $12 per month\nOverdraft protection | $39 per incident | $35 per incident\nPerson-to-person transfers | Free with mobile app; Otherwise, $0.80 per transfer | $0.50 per transfer",
    "row_num": 4,
    "column_num": 3,
    "solution": "To determine which bank is the better choice for Mrs. Seewald, compare the fees each bank would charge her. See which bank would charge her less.\n\nFind the fees Mrs. Seewald should expect to pay in one month at Riverwalk Bank.\nSince Mrs. Seewald does not expect to have an $800 average monthly balance, there is a $10 fee for having the checking account.\nThere is a $39 overdraft protection fee for 1 incident.\nSince she uses a mobile app, there is no fee for person-to-person transfers.\n\nIn all, Mrs. Seewald should expect to pay $10 + $39 = $49 per month at Riverwalk Bank.\n\nFind the fees Mrs. Seewald should expect to pay in one month at Trust Security Bank.\nThere is a $12 fee for having the checking account.\nThere is a $35 overdraft protection fee for 1 incident.\nThere is a $0.50 fee for each of her 5 person-to-person transfers. So, she expects to pay $0.50 \u00b7 5 = $2.50 in fees for the person-to-person transfers.\n\nIn all, Mrs. Seewald should expect to pay $12 + $35 + $2.50 = $49.50 per month at Trust Security Bank.\n\nMrs. Seewald should expect to pay $49 per month at Riverwalk Bank or $49.50 per month at Trust Security Bank. Riverwalk Bank is the better choice for Mrs. Seewald.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "4479",
    "path": "data"
  },
  {
    "question": "Some farmers compared how many tractors they own. What is the mean of the numbers?",
    "choices": null,
    "answer": "17",
    "unit": null,
    "table_title": "Tractors",
    "table": "Farmer | Number of tractors\nFarmer Rob | 20\nFarmer Allison | 20\nFarmer Andy | 14\nFarmer John | 17\nFarmer Walt | 16\nFarmer Judy | 15",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n20, 20, 14, 17, 16, 15\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n20 + 20 + 14 + 17 + 16 + 15 = 102\n\nNow divide the sum by the number of numbers:\n\n102 \u00f7 6 = 17\n\nThe mean is 17.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "18114",
    "path": "data"
  },
  {
    "question": "In science class, Clara is learning about places with extreme temperatures. She learns that the highest temperature ever recorded was in Death Valley, California. She also learns that the lowest temperature ever recorded was in Vostok Station, Antarctica. The record-setting temperatures of the two locations are shown in the table. Which location's temperature was further from zero?",
    "choices": [
      "Death Valley",
      "Vostok Station"
    ],
    "answer": "Death Valley",
    "unit": null,
    "table_title": null,
    "table": "Location | Temperature (\u00b0F)\nDeath Valley | 134\nVostok Station | -128",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive number means the temperature was above zero. A negative number means the temperature was below zero.\nTo find which temperature was further from zero, use absolute value. Absolute value tells you how far a temperature is from zero.\nDeath Valley: |134| = 134\nVostok Station: |-128| = 128\nThe temperature of Death Valley was further from zero. It was 134 degrees above zero.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "23956",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "nonlinear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n14 | 20\n15 | 10\n16 | 2",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{10 - 20}{15 - 14}\n = \\frac{-10}{1}\n = -10\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{2 - 20}{16 - 14}\n = \\frac{-18}{2}\n = -9\nThe rate of change is not the same for each pair of points. So, the function does not have a constant rate of change.\nThe function is nonlinear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "8548",
    "path": "data"
  },
  {
    "question": "Mrs. Montoya told students how many rounds to expect in the spelling bee based on previous years. According to the table, what was the rate of change between 2014 and 2015?",
    "choices": null,
    "answer": "4",
    "unit": "rounds per year",
    "table_title": "Rounds in the spelling bee",
    "table": "Year | Rounds\n2013 | 13\n2014 | 16\n2015 | 20\n2016 | 17\n2017 | 20",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{20 rounds - 16 rounds}{2015 - 2014}\n = \\frac{20 rounds - 16 rounds}{1 year}\n = \\frac{4 rounds}{1 year}\n = 4 rounds per year\nThe rate of change between 2014 and 2015 was 4 rounds per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "33648",
    "path": "data"
  },
  {
    "question": "Each town has 5 grocery stores. How many grocery stores are in 5 towns?",
    "choices": null,
    "answer": "25",
    "unit": null,
    "table_title": null,
    "table": "Number of towns | Number of grocery stores\n1 | 5\n2 | 10\n3 | 15\n4 | 20\n5 | ?",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 25 grocery stores in 5 towns.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "29224",
    "path": "data"
  },
  {
    "question": "Erin, an employee at McMillan's Convenience Store, looked at the sales of each of its soda products. On Saturday, how much more did the convenience store make from Nature's Nectar sales than from Refresh Mineral Water sales?",
    "choices": null,
    "answer": "4",
    "unit": "$",
    "table_title": "Convenience store beverage sales",
    "table": "Beverage | Saturday | Sunday\nKrazy Kola | $3 | $18\nKickin' Coffee | $16 | $4\nSweet Sips | $11 | $20\nRefresh Mineral Water | $8 | $5\nNature's Nectar | $12 | $2",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Saturday column. Find the numbers in this column for Nature's Nectar and Refresh Mineral Water.\n\nNature's Nectar: $12.00\nRefresh Mineral Water: $8.00\n\nNow subtract:\n\n$12.00 \u2212 $8.00 = $4.00\n\nOn Saturday, the convenience store made $4 more from Nature's Nectar sales than from Refresh Mineral Water sales.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "32991",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $1,525, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$985 | 18,000 | 3,000\n$1,165 | 15,600 | 5,500\n$1,345 | 13,200 | 8,000\n$1,525 | 10,800 | 10,500\n$1,705 | 8,400 | 13,000",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $1,525, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "35817",
    "path": "data"
  },
  {
    "question": "Each shelf has 5 jackets. How many jackets are on 3 shelves?",
    "choices": null,
    "answer": "15",
    "unit": "jackets",
    "table_title": null,
    "table": "Number of shelves | Number of jackets\n1 | 5\n2 | 10\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 15 jackets on 3 shelves.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "17697",
    "path": "data"
  },
  {
    "question": "How much more does a measuring tape cost than a wrench?",
    "choices": null,
    "answer": "4.30",
    "unit": "$",
    "table_title": null,
    "table": "shovel | $8.73\nmop | $5.82\nmeasuring tape | $9.79\nlawn sprinkler | $8.20\nhammer | $9.69\nwrench | $5.49",
    "row_num": 6,
    "column_num": 2,
    "solution": "Subtract the price of a wrench from the price of a measuring tape.\n\n$9.79 - $5.49 = $4.30\n\nA measuring tape costs $4.30 more than a wrench.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "4183",
    "path": "data"
  },
  {
    "question": "A bakery recorded how many cupcakes it sold in the past 5 days. What is the mean of the numbers?",
    "choices": null,
    "answer": "33",
    "unit": null,
    "table_title": "Cupcakes sold",
    "table": "Day | Number of cupcakes\nMonday | 33\nTuesday | 41\nWednesday | 34\nThursday | 19\nFriday | 38",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n33, 41, 34, 19, 38\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n33 + 41 + 34 + 19 + 38 = 165\n\nNow divide the sum by the number of numbers:\n\n165 \u00f7 5 = 33\n\nThe mean is 33.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "1292",
    "path": "data"
  },
  {
    "question": "A county agency recorded the money donated to several charitable causes over time. In May, how much more money was raised for education than for parks?",
    "choices": null,
    "answer": "5",
    "unit": "$",
    "table_title": "Donations received",
    "table": "Cause | May | June\nHunger | $7 | $8\nParks | $7 | $14\nEducation | $12 | $2",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the May column. Find the numbers in this column for education and parks.\n\neducation: $12.00\nparks: $7.00\n\nNow subtract:\n\n$12.00 \u2212 $7.00 = $5.00\n\nIn May, $5 more was raised for education.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "10266",
    "path": "data"
  },
  {
    "question": "Craig buys 0.7 pounds of purple erasers . What is the total cost?",
    "choices": null,
    "answer": "1.40",
    "unit": "$",
    "table_title": null,
    "table": "purple erasers | $2/pound\norange erasers | $4/pound\nblack erasers | $3/pound\nwhite erasers | $5/pound\ngreen erasers | $4/pound\nyellow erasers | $2/pound\nblue erasers | $2/pound",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the cost of the purple erasers. Multiply the price per pound by the number of pounds.\n$2 \u00d7 0.7 = $1.40\nThe total cost is $1.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "17271",
    "path": "data"
  },
  {
    "question": "Nathan buys 1 kilogram of gummy bears. What is the total cost?",
    "choices": null,
    "answer": "1.66",
    "unit": "$",
    "table_title": null,
    "table": "licorice | $1.74/kg\nchocolates | $1.05/kg\ngummy bears | $1.66/kg\nlemon sours | $0.92/kg\nyogurt-covered peanuts | $1.05/kg\nchocolate-covered raisins | $1.33/kg",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the gummy bears. Multiply the price per kilogram by the number of kilograms.\n\n$1.66 \u00d7 1 = $1.66\n\nThe total cost is $1.66.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "15800",
    "path": "data"
  },
  {
    "question": "Each hamburger place has 2 chefs. How many chefs are in 6 hamburger places?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": null,
    "table": "Number of hamburger places | Number of chefs\n1 | 2\n2 | 4\n3 | 6\n4 | 8\n5 | 10\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 12 chefs in 6 hamburger places.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "25473",
    "path": "data"
  },
  {
    "question": "After a spelling bee, some students compared how many words they spelled correctly. Who spelled the most words correctly?",
    "choices": [
      "Gordon",
      "Zoe",
      "Marshall",
      "Leah"
    ],
    "answer": "Zoe",
    "unit": null,
    "table_title": "Spelling bee results",
    "table": "Name | Number of words spelled correctly\nGordon | 72\nZoe | 79\nMarshall | 75\nLeah | 71",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 79.\n\nNow find the corresponding name. Zoe corresponds to 79.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "2527",
    "path": "data"
  },
  {
    "question": "How much money does Kylie need to buy a symphony ticket and a play ticket?",
    "choices": null,
    "answer": "85",
    "unit": "$",
    "table_title": null,
    "table": "play ticket | $25\nbaseball ticket | $43\nballet ticket | $14\nsymphony ticket | $60\nhockey ticket | $16\nairplane show ticket | $10",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a symphony ticket and the price of a play ticket:\n\n$60 + $25 = $85\n\nKylie needs $85.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "5037",
    "path": "data"
  },
  {
    "question": "An athlete counted how many autographs he signed each day. On which day did the athlete sign the fewest autographs?",
    "choices": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday"
    ],
    "answer": "Tuesday",
    "unit": null,
    "table_title": "Autographs signed",
    "table": "Day | Number of autographs\nMonday | 175\nTuesday | 117\nWednesday | 151\nThursday | 157",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 117.\n\nNow find the corresponding day. Tuesday corresponds to 117.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "6682",
    "path": "data"
  },
  {
    "question": "Abdul buys 0.2 pounds of green beads. How much does he spend?",
    "choices": null,
    "answer": "1.20",
    "unit": "$",
    "table_title": null,
    "table": "blue beads | $7 per pound\ngreen beads | $6 per pound\nblack beads | $7 per pound\nred beads | $6 per pound",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the green beads. Multiply the price per pound by the number of pounds.\n$6 \u00d7 0.2 = $1.20\nHe spends $1.20.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "1143",
    "path": "data"
  },
  {
    "question": "Mr. Bradley, the marine biology teacher, asked his students how many times they went to the beach last summer. How many students went to the beach fewer than 2 times?",
    "choices": null,
    "answer": "24",
    "unit": null,
    "table_title": "Trips to the beach last summer",
    "table": "Number of trips | Frequency\n0 | 18\n1 | 6\n2 | 2\n3 | 1",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the rows for 0 and 1 time. Add the frequencies for these rows.\n\nAdd:\n\n18 + 6 = 24\n\n24 students went to the beach fewer than 2 times.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "15910",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the volleyball game begin?",
    "choices": [
      "10:35 A.M.",
      "2:05 P.M.",
      "2:10 P.M.",
      "1:25 P.M."
    ],
    "answer": "1:25 P.M.",
    "unit": null,
    "table_title": "Camp schedule",
    "table": "Activity | Begin | End\nmusic class | 9:00 A.M. | 10:25 A.M.\narts and crafts | 10:35 A.M. | 11:05 A.M.\nsoftball game | 11:15 A.M. | 12:40 P.M.\ntalent show | 12:45 P.M. | 1:15 P.M.\nvolleyball game | 1:25 P.M. | 2:05 P.M.\nwater balloon toss | 2:10 P.M. | 2:45 P.M.\nrowing class | 2:50 P.M. | 3:35 P.M.",
    "row_num": 8,
    "column_num": 3,
    "solution": "Find the volleyball game on the schedule. Find the beginning time for the volleyball game.\n\nvolleyball game: 1:25 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "31774",
    "path": "data"
  },
  {
    "question": "How much money does Brenna need to buy a figure skating ticket and a comedy show ticket?",
    "choices": null,
    "answer": "90",
    "unit": "$",
    "table_title": null,
    "table": "comedy show ticket | $39\nopera ticket | $23\nbaseball ticket | $30\ndance performance ticket | $48\nfigure skating ticket | $51\nbasketball ticket | $53",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a figure skating ticket and the price of a comedy show ticket:\n\n$51 + $39 = $90\n\nBrenna needs $90.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "28414",
    "path": "data"
  },
  {
    "question": "Miss Kirk ran a sit-up competition among her P.E. students and monitored how many sit-ups each students could do. What is the largest number of sit-ups done?",
    "choices": null,
    "answer": "90",
    "unit": "sit-ups",
    "table_title": "Sit-up competition (number of sit-ups)",
    "table": "Stem | Leaf \n1 | 2\n2 | 1, 3\n3 | 1, 9\n4 | 3\n5 | 5, 5, 5, 6\n6 | 8\n7 | 7\n8 | 3, 5\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe largest number of sit-ups done has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe largest number of sit-ups done is 90 sit-ups.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "32987",
    "path": "data"
  },
  {
    "question": "How much more does a bat signed by a famous baseball player cost than a photograph signed by a famous race car driver?",
    "choices": null,
    "answer": "858",
    "unit": "$",
    "table_title": null,
    "table": "photograph signed by a famous race car driver | $2,074.00\nbat signed by a famous baseball player | $2,932.00\njersey signed by a famous basketball player | $8,707.00\nshirt signed by a famous soccer player | $1,751.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a photograph signed by a famous race car driver from the price of a bat signed by a famous baseball player.\n\n$2,932.00 - $2,074.00 = $858.00\n\nA bat signed by a famous baseball player costs $858.00 more than a photograph signed by a famous race car driver.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "31548",
    "path": "data"
  },
  {
    "question": "What is the total cost for 1/5 of a pound of dried berries?",
    "choices": null,
    "answer": "1.20",
    "unit": "$",
    "table_title": null,
    "table": "nuts | $7 per lb\ntrail mix | $3 per lb\ncookie bites | $6 per lb\ngummy bears | $4 per lb\ngranola bars | $6 per lb\ndried berries | $6 per lb",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the dried berries. Multiply the price per pound by the number of pounds.\n$6 \u00d7 \\frac{1}{5} = $6 \u00d7 0.2 = $1.20\nThe total cost is $1.20.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "22167",
    "path": "data"
  },
  {
    "question": "Brenna graphed the temperature at noon for 7 days. What is the range of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Temperature at noon",
    "table": "Day | Temperature (\u00c2\u00b0C)\nFriday | 10\nSaturday | 7\nSunday | 6\nMonday | 9\nTuesday | 5\nWednesday | 10\nThursday | 8",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 7, 6, 9, 5, 10, 8\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 5.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 5 = 5\n\nThe range is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "16694",
    "path": "data"
  },
  {
    "question": "After growing tired of squinting while driving, Dalton went shopping for a pair of sunglasses. He tried on glasses with different frames and lenses. What is the probability that a randomly selected pair of sunglasses has polarized lenses and cat eye frames? Simplify any fractions.",
    "choices": null,
    "answer": "3/11",
    "unit": null,
    "table_title": null,
    "table": " | Cat eye frames | Browline frames\nPolarized lenses | 3 | 4\nRegular lenses | 2 | 2",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the pair of sunglasses has polarized lenses\" and B be the event \"the pair of sunglasses has cat eye frames\".\nTo find the probability that a pair of sunglasses has polarized lenses and cat eye frames, first identify the sample space and the event.\nThe outcomes in the sample space are the different pairs of sunglasses. Each pair of sunglasses is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the pair of sunglasses has polarized lenses and cat eye frames\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the pair of sunglasses has polarized lenses and cat eye frames\", so look at the table to see how many pairs of sunglasses have polarized lenses and cat eye frames.\nThe number of pairs of sunglasses that have polarized lenses and cat eye frames is 3.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of pairs of sunglasses.\n3 + 2 + 4 + 2 = 11\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{3}{11}\nThe probability that a pair of sunglasses has polarized lenses and cat eye frames is \\frac{3}{11}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "21594",
    "path": "data"
  },
  {
    "question": "How much money does Pete need to buy a couch and a coffee table?",
    "choices": null,
    "answer": "1,032",
    "unit": "$",
    "table_title": null,
    "table": "set of bunk beds | $459\nchest of drawers | $109\ncouch | $862\ncoffee table | $170",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a couch and the price of a coffee table:\n\n$862 + $170 = $1,032\n\nPete needs $1,032.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "10668",
    "path": "data"
  },
  {
    "question": "How much money does Dirk need to buy a motorcycle and a jet ski?",
    "choices": null,
    "answer": "6,830",
    "unit": "$",
    "table_title": null,
    "table": "snowmobile | $2,388.00\nmotorcycle | $3,296.00\ntow truck | $6,907.00\nhovercraft | $6,122.00\njet ski | $3,534.00\nkayak | $1,924.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a motorcycle and the price of a jet ski:\n\n$3,296.00 + $3,534.00 = $6,830.00\n\nDirk needs $6,830.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "2201",
    "path": "data"
  },
  {
    "question": "Each tin has 5 pastries. How many pastries are in 6 tins?",
    "choices": null,
    "answer": "30",
    "unit": null,
    "table_title": null,
    "table": "Number of tins | Number of pastries\n1 | 5\n2 | 10\n3 | 15\n4 | 20\n5 | 25\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 30 pastries in 6 tins.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "9561",
    "path": "data"
  },
  {
    "question": "Each street has 2 houses. How many houses are on 4 streets?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": null,
    "table": "Number of streets | Number of houses\n1 | 2\n2 | 4\n3 | 6\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 8 houses on 4 streets.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "21301",
    "path": "data"
  },
  {
    "question": "Each necklace has 5 pearls. How many pearls are on 6 necklaces?",
    "choices": null,
    "answer": "30",
    "unit": null,
    "table_title": null,
    "table": "Number of necklaces | Number of pearls\n1 | 5\n2 | 10\n3 | 15\n4 | 20\n5 | 25\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 30 pearls on 6 necklaces.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "3810",
    "path": "data"
  },
  {
    "question": "Amy bought 3.8 pounds of dill dip. How much did she spend?",
    "choices": null,
    "answer": "7.60",
    "unit": "$",
    "table_title": null,
    "table": "hummus | $4 per lb\nonion dip | $4 per lb\nbean dip | $4 per lb\ndill dip | $2 per lb\nguacamole | $4 per lb",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the dill dip. Multiply the price per pound by the number of pounds.\n$2 \u00d7 3.8 = $7.60\nShe spent $7.60.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "1868",
    "path": "data"
  },
  {
    "question": "Dr. Ramsey, a pediatrician, weighed all the children who recently visited his office. What is the weight of the lightest child?",
    "choices": null,
    "answer": "11",
    "unit": "pounds",
    "table_title": "Children's weights (lbs)",
    "table": "Stem | Leaf \n1 | 1, 5\n2 | 0, 8, 9\n3 | 0, 0, 4, 9\n4 | 4, 7, 9\n5 | 1, 2, 3, 6, 9\n6 | 1, 5, 6",
    "row_num": 7,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 1.\n\nNow find the lowest leaf in the first row. The lowest leaf is 1.\n\nThe weight of the lightest child has a stem of 1 and a leaf of 1. Write the stem first, then the leaf: 11.\n\nThe weight of the lightest child is 11 pounds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "33008",
    "path": "data"
  },
  {
    "question": "Brett has $263.00. Does he have enough to buy a cockatoo and a bearded dragon?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "rabbit | $102.00\niguana | $201.00\nchinchilla | $108.00\npot-bellied pig | $321.00\ncockatoo | $119.00\nbearded dragon | $143.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a cockatoo and the price of a bearded dragon:\n\n$119.00 + $143.00 = $262.00\n\n$262.00 is less than $263.00. Brett does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "9862",
    "path": "data"
  },
  {
    "question": "Each branch has 2 oranges. How many oranges are on 4 branches?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": null,
    "table": "Number of branches | Number of oranges\n1 | 2\n2 | 4\n3 | 6\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 8 oranges on 4 branches.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "26284",
    "path": "data"
  },
  {
    "question": "Jaden's coach wrote down how many kilometers he had run over the past 5 days. What is the mean of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Kilometers run",
    "table": "Day | Kilometers\nWednesday | 5\nThursday | 10\nFriday | 3\nSaturday | 8\nSunday | 4",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 10, 3, 8, 4\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n5 + 10 + 3 + 8 + 4 = 30\n\nNow divide the sum by the number of numbers:\n\n30 \u00f7 5 = 6\n\nThe mean is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "38184",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $1,110, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$950 | 19,800 | 2,800\n$990 | 15,100 | 6,500\n$1,030 | 10,400 | 10,200\n$1,070 | 5,700 | 13,900\n$1,110 | 1,000 | 17,600",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $1,110, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "2017",
    "path": "data"
  },
  {
    "question": "How much more does a sour apple candy cost than a gummy worm?",
    "choices": null,
    "answer": "0.01",
    "unit": "$",
    "table_title": null,
    "table": "gummy bear | $0.03\ngummy worm | $0.03\ncinnamon candy | $0.03\nlemon drop | $0.09\npiece of licorice | $0.05\nsour apple candy | $0.04",
    "row_num": 6,
    "column_num": 2,
    "solution": "Subtract the price of a gummy worm from the price of a sour apple candy.\n\n$0.04 - $0.03 = $0.01\n\nA sour apple candy costs $0.01 more than a gummy worm.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "22263",
    "path": "data"
  },
  {
    "question": "The employee at the department store counted the number of ties on each tie rack. How many racks have exactly 26 ties?",
    "choices": null,
    "answer": "0",
    "unit": "racks",
    "table_title": "Ties per rack",
    "table": "Stem | Leaf \n1 | 2, 2, 5, 6\n2 | \n3 | 5, 6\n4 | 3\n5 | 1, 2, 2, 4, 5\n6 | 0, 1, 9, 9",
    "row_num": 7,
    "column_num": 2,
    "solution": "For the number 26, the stem is 2, and the leaf is 6. Find the row where the stem is 2. In that row, count all the leaves equal to 6.\n\nYou counted 0 leaves. 0 racks have exactly26 ties.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "21475",
    "path": "data"
  },
  {
    "question": "Stefan looked over his calendar to see how many times he had soccer practice each month. What is the mean of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Soccer practice",
    "table": "Month | Number of practices\nJuly | 10\nAugust | 4\nSeptember | 4\nOctober | 9\nNovember | 7\nMarch | 4\nApril | 4",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 4, 4, 9, 7, 4, 4\n\nFirst, count how many numbers are in the group.\n\nThere are 7 numbers.\n\nNow add all the numbers together:\n\n10 + 4 + 4 + 9 + 7 + 4 + 4 = 42\n\nNow divide the sum by the number of numbers:\n\n42 \u00f7 7 = 6\n\nThe mean is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "28020",
    "path": "data"
  },
  {
    "question": "The board of commerce recorded how many employees work at each company. How many more employees work at Future Computers than at Thompson Corporation?",
    "choices": null,
    "answer": "391",
    "unit": "employees",
    "table_title": "Company sizes",
    "table": "Company | Number of employees\nMadison Corporation | 643\nFuture Computers | 823\nABC Electronics | 216\nThompson Corporation | 432",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nFuture Computers: 823\nThompson Corporation: 432\n\nNow subtract: 823 - 432 = 391.\n\n391 more employees work at Future Computers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "6178",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $1,420, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$620 | 20,100 | 1,200\n$820 | 15,400 | 5,600\n$1,020 | 10,700 | 10,000\n$1,220 | 6,000 | 14,400\n$1,420 | 1,300 | 18,800",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $1,420, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "29583",
    "path": "data"
  },
  {
    "question": "A transportation analyst compared various bridges' tolls. How much is the toll for a car on the Golden Gate bridge?",
    "choices": null,
    "answer": "6",
    "unit": "$",
    "table_title": "Bridge tolls",
    "table": "Bridge | Truck | Car\nFort Madison | $4 | $1\nOakland Bay | $6 | $4\nGolden Gate | $7 | $6",
    "row_num": 4,
    "column_num": 3,
    "solution": "First, find the row for Golden Gate. Then find the number in the Car column.\n\nThis number is $6.00. On the Golden Gate bridge, the toll for a car is $6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "13633",
    "path": "data"
  },
  {
    "question": "At a swim meet, Nancy noted the size of various swim teams. How many teams have exactly 10 swimmers?",
    "choices": null,
    "answer": "2",
    "unit": "teams",
    "table_title": "Swimming team sizes (number of swimmers)",
    "table": "Stem | Leaf \n1 | 0, 0\n2 | \n3 | \n4 | \n5 | 4\n6 | 2, 9\n7 | 5",
    "row_num": 8,
    "column_num": 2,
    "solution": "For the number 10, the stem is 1, and the leaf is 0. Find the row where the stem is 1. In that row, count all the leaves equal to 0.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 teams have exactly10 swimmers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "35482",
    "path": "data"
  },
  {
    "question": "Zach has $148.00. Does he have enough to buy a CD signed by a famous band and a ball signed by a famous football player?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "photograph signed by a famous movie star | $72.00\nphotograph signed by a famous television star | $26.00\nbook signed by a famous author | $30.00\nball signed by a famous football player | $54.00\nCD signed by a famous band | $91.00\nbat signed by a famous baseball player | $68.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a CD signed by a famous band and the price of a ball signed by a famous football player:\n\n$91.00 + $54.00 = $145.00\n\n$145.00 is less than $148.00. Zach does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "6455",
    "path": "data"
  },
  {
    "question": "Kendrick went to the store and bought 3.5 kilograms of sliced ham. How much did he spend?",
    "choices": null,
    "answer": "10.50",
    "unit": "$",
    "table_title": null,
    "table": "pepperoni | $3/kg\nsmoked bacon | $3/kg\nsliced ham | $3/kg\nCanadian bacon | $3/kg\nsalami | $3/kg\nprosciutto | $2/kg",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the sliced ham. Multiply the price per kilogram by the number of kilograms.\n$3 \u00d7 3.5 = $10.50\nHe spent $10.50.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "24319",
    "path": "data"
  },
  {
    "question": "An athlete counted how many autographs he signed each day. On which day did the athlete sign the fewest autographs?",
    "choices": [
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday"
    ],
    "answer": "Wednesday",
    "unit": null,
    "table_title": "Autographs signed",
    "table": "Day | Number of autographs\nSunday | 134\nMonday | 143\nTuesday | 132\nWednesday | 114",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 114.\n\nNow find the corresponding day. Wednesday corresponds to 114.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "33016",
    "path": "data"
  },
  {
    "question": "Each room has 5 tables. How many tables are in 6 rooms?",
    "choices": null,
    "answer": "30",
    "unit": "tables",
    "table_title": null,
    "table": "Number of rooms | Number of tables\n1 | 5\n2 | 10\n3 | 15\n4 | 20\n5 | 25\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 30 tables in 6 rooms.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "35986",
    "path": "data"
  },
  {
    "question": "How much money does Jeanette need to buy 8 rakes?",
    "choices": null,
    "answer": "192.80",
    "unit": "$",
    "table_title": null,
    "table": "lawn mower | $58.75\nhammer | $22.67\nrake | $24.10\nwheelbarrow | $60.39",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of 8 rakes by multiplying 8 times the price of a rake.\n\n$24.10 \u00d7 8 = $192.80\n\nJeanette needs $192.80.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "17179",
    "path": "data"
  },
  {
    "question": "Julie has $0.50. Does she have enough to buy an orange ribbon and a small yellow button?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "small yellow button | $0.20\nbig blue button | $0.14\nsilver bow | $0.46\nspool of thread | $0.94\norange ribbon | $0.29",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of an orange ribbon and the price of a small yellow button:\n\n$0.29 + $0.20 = $0.49\n\n$0.49 is less than $0.50. Julie does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "23714",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the Tigers versus Red Hawks game begin?",
    "choices": [
      "10:35 A.M.",
      "10:10 A.M.",
      "12:00 P.M.",
      "11:15 A.M."
    ],
    "answer": "10:35 A.M.",
    "unit": null,
    "table_title": "Baseball tournament schedule",
    "table": "Game | Begin | End\nWolves versus Jaguars | 9:20 A.M. | 10:50 A.M.\nSharks versus Cougars | 10:10 A.M. | 11:20 A.M.\nTigers versus Red Hawks | 10:35 A.M. | 12:00 P.M.\nLions versus Eagles | 11:15 A.M. | 1:00 P.M.\nCardinals versus Cobras | 12:00 P.M. | 1:45 P.M.\nRattlesnakes versus Bears | 1:25 P.M. | 2:30 P.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find the Tigers versus Red Hawks game on the schedule. Find the beginning time for the Tigers versus Red Hawks game.\n\nTigers versus Red Hawks: 10:35 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "30061",
    "path": "data"
  },
  {
    "question": "Salem Elementary School polled its students about their favorite vegetables in order to decide which ones to plant in the new school garden. Which vegetable is most popular?",
    "choices": [
      "cauliflower",
      "celery",
      "onions"
    ],
    "answer": "onions",
    "unit": null,
    "table_title": "Favorite vegetables",
    "table": "Vegetable | Lower elementary students | Upper elementary students\nCelery | 2 | 8\nCauliflower | 6 | 7\nOnions | 2 | 15",
    "row_num": 4,
    "column_num": 3,
    "solution": "Add the numbers in each row.\n\ncelery: 2 + 8 = 10\ncauliflower: 6 + 7 = 13\nonions: 2 + 15 = 17\n\nThe greatest sum is 17, which is the total for the Onions row. The most popular vegetable is onions.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "26362",
    "path": "data"
  },
  {
    "question": "The parks department compared how many soccer fields there are at each park. What is the mean of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Soccer fields",
    "table": "Park | Number of soccer fields\nLighthouse Park | 1\nMadison Park | 1\nElmhurst Park | 3\nCanyon Park | 4\nCrane Park | 6\nMoon Park | 3\nMiddle Park | 3\nJuniper Park | 3",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n1, 1, 3, 4, 6, 3, 3, 3\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n1 + 1 + 3 + 4 + 6 + 3 + 3 + 3 = 24\n\nNow divide the sum by the number of numbers:\n\n24 \u00f7 8 = 3\n\nThe mean is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "17004",
    "path": "data"
  },
  {
    "question": "Fans of the Riverside baseball team compared the number of games won by their team each year. According to the table, what was the rate of change between 2008 and 2009?",
    "choices": null,
    "answer": "-1",
    "unit": "games per year",
    "table_title": "Games won by the Riverside baseball team",
    "table": "Year | Games won\n2008 | 41\n2009 | 40\n2010 | 32\n2011 | 37\n2012 | 25",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{40 games - 41 games}{2009 - 2008}\n = \\frac{40 games - 41 games}{1 year}\n = \\frac{-1 games}{1 year}\n = -1 games per year\nThe rate of change between 2008 and 2009 was - 1 games per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "29411",
    "path": "data"
  },
  {
    "question": "The architecture student counted the number of bricks in each building in his neighborhood. How many buildings have exactly 32 bricks?",
    "choices": null,
    "answer": "4",
    "unit": "buildings",
    "table_title": "Bricks per building",
    "table": "Stem | Leaf \n3 | 2, 2, 2, 2\n4 | \n5 | 1\n6 | 0\n7 | \n8 | 9\n9 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "For the number 32, the stem is 3, and the leaf is 2. Find the row where the stem is 3. In that row, count all the leaves equal to 2.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plot above. 4 buildings have exactly 32 bricks.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "20490",
    "path": "data"
  },
  {
    "question": "Miss Olson ran a sit-up competition among her P.E. students and monitored how many sit-ups each students could do. How many people did at least 50 sit-ups but fewer than 70 sit-ups?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Sit-up competition (number of sit-ups)",
    "table": "Stem | Leaf \n1 | 0, 6, 7, 8\n2 | 5, 7\n3 | 0, 2, 3, 7, 8, 8\n4 | 0, 9\n5 | \n6 | 1, 2, 4, 6, 9",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 5 and 6.\n\nYou counted 5 leaves, which are blue in the stem-and-leaf plot above. 5 people did at least 50 sit-ups but fewer than 70 sit-ups.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "37454",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Molly just missed the 1.15 P.M. ferry at Rocky Port. How long does she have to wait until the next ferry?",
    "choices": [
      "15 minutes",
      "30 minutes",
      "45 minutes",
      "1 hour"
    ],
    "answer": "15 minutes",
    "unit": null,
    "table_title": "Ferry schedule",
    "table": "Windy Sands | 7:00 A.M. | 7:15 A.M. | 7:30 A.M. | 7:45 A.M. | 8:00 A.M.\nCrest View | 8:45 A.M. | 9:00 A.M. | 9:15 A.M. | 9:30 A.M. | 9:45 A.M.\nStarfish City | 10:15 A.M. | 10:30 A.M. | 10:45 A.M. | 11:00 A.M. | 11:15 A.M.\nBeach Town | 11:45 A.M. | 12:00 P.M. | 12:15 P.M. | 12:30 P.M. | 12:45 P.M.\nRocky Port | 12:30 P.M. | 12:45 P.M. | 1:00 P.M. | 1:15 P.M. | 1:30 P.M.\nGrassy Beach | 1:45 P.M. | 2:00 P.M. | 2:15 P.M. | 2:30 P.M. | 2:45 P.M.\nGreen Harbor | 3:30 P.M. | 3:45 P.M. | 4:00 P.M. | 4:15 P.M. | 4:30 P.M.\nSandy Shores | 5:15 P.M. | 5:30 P.M. | 5:45 P.M. | 6:00 P.M. | 6:15 P.M.",
    "row_num": 8,
    "column_num": 6,
    "solution": "Find 1:15 P. M. in the row for Rocky Port.\n\nLook for the next ferry in that row.\n\nThe next ferry is at 1:30 P. M.\n\nFind the elapsed time. The elapsed time is 15 minutes.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 4,
    "split": "dev",
    "pid": "2263",
    "path": "data"
  },
  {
    "question": "What is the total cost for 1+1/2 kilograms of oval beads?",
    "choices": null,
    "answer": "3",
    "unit": "$",
    "table_title": null,
    "table": "spherical beads | $2/kilogram\noval beads | $2/kilogram\nrectangular beads | $2/kilogram\nflower-shaped beads | $3/kilogram",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the oval beads. Multiply the price per kilogram by the number of kilograms.\n$2 \u00d7 1\\frac{1}{2} = $2 \u00d7 1.5 = $3\nThe total cost is $3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "38305",
    "path": "data"
  },
  {
    "question": "Fans of the Vindale baseball team compared the number of games won by their team each year. According to the table, what was the rate of change between 2014 and 2015?",
    "choices": null,
    "answer": "-7",
    "unit": "games per year",
    "table_title": "Games won by the Vindale baseball team",
    "table": "Year | Games won\n2012 | 44\n2013 | 38\n2014 | 48\n2015 | 41\n2016 | 45",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{41 games - 48 games}{2015 - 2014}\n = \\frac{41 games - 48 games}{1 year}\n = \\frac{-7 games}{1 year}\n = -7 games per year\nThe rate of change between 2014 and 2015 was - 7 games per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "14526",
    "path": "data"
  },
  {
    "question": "Mrs. Shepherd told students how many rounds to expect in the spelling bee based on previous years. According to the table, what was the rate of change between 2018 and 2019?",
    "choices": null,
    "answer": "1",
    "unit": "rounds per year",
    "table_title": "Rounds in the spelling bee",
    "table": "Year | Rounds\n2017 | 15\n2018 | 13\n2019 | 14\n2020 | 8\n2021 | 13",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{14 rounds - 13 rounds}{2019 - 2018}\n = \\frac{14 rounds - 13 rounds}{1 year}\n = \\frac{1 round}{1 year}\n = 1 round per year\nThe rate of change between 2018 and 2019 was 1 round per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "30140",
    "path": "data"
  },
  {
    "question": "While writing a paper on making decisions in groups, Donald researched the size of a number of committees. How many committees have at least 30 members?",
    "choices": null,
    "answer": "7",
    "unit": "committees",
    "table_title": "Committee sizes (number of members)",
    "table": "Stem | Leaf \n2 | 0, 2, 3, 9\n3 | 5, 6, 8\n4 | 8\n5 | 1, 6, 7",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 3, 4, and 5.\n\nYou counted 7 leaves, which are blue in the stem-and-leaf plot above. 7 committees have at least 30 members.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "4519",
    "path": "data"
  },
  {
    "question": "Fans of the Springtown baseball team compared the number of games won by their team each year. According to the table, what was the rate of change between 2014 and 2015?",
    "choices": null,
    "answer": "9",
    "unit": "games per year",
    "table_title": "Games won by the Springtown baseball team",
    "table": "Year | Games won\n2013 | 8\n2014 | 8\n2015 | 17\n2016 | 7\n2017 | 16",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{17 games - 8 games}{2015 - 2014}\n = \\frac{17 games - 8 games}{1 year}\n = \\frac{9 games}{1 year}\n = 9 games per year\nThe rate of change between 2014 and 2015 was 9 games per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "162",
    "path": "data"
  },
  {
    "question": "A real estate agent looked into how many houses were sold in different cities. Where were the fewest houses sold?",
    "choices": [
      "Pennytown",
      "Fremont",
      "Liberty City",
      "Briggs Corner"
    ],
    "answer": "Briggs Corner",
    "unit": null,
    "table_title": "House sales",
    "table": "City | Number of houses sold\nPennytown | 151\nFremont | 135\nLiberty City | 153\nBriggs Corner | 111",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 111.\n\nNow find the corresponding city. Briggs Corner corresponds to 111.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "19843",
    "path": "data"
  },
  {
    "question": "Isaiah has $183.50. Does he have enough to buy a rocking chair and a nightstand?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "rocking chair | $90.29\nfootstool | $48.31\nchest of drawers | $69.47\nnightstand | $94.43",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a rocking chair and the price of a nightstand:\n\n$90.29 + $94.43 = $184.72\n\n$184.72 is more than $183.50. Isaiah does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 4,
    "split": "dev",
    "pid": "26428",
    "path": "data"
  },
  {
    "question": "A pizza delivery driver paid attention to how many pizzas he delivered over the past 5 days. What is the range of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Pizzas delivered",
    "table": "Day | Number of pizzas\nFriday | 5\nSaturday | 9\nSunday | 6\nMonday | 10\nTuesday | 8",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 9, 6, 10, 8\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 5.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 5 = 5\n\nThe range is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "1527",
    "path": "data"
  },
  {
    "question": "At a hot air balloon festival, Monica made note of how many passengers were in each balloon and the color of each balloon. What is the probability that a randomly selected hot air balloon contains 1 passenger and is blue? Simplify any fractions.",
    "choices": null,
    "answer": "4/13",
    "unit": null,
    "table_title": null,
    "table": " | Blue | Yellow\n1 passenger | 4 | 3\n2 passengers | 4 | 2",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the hot air balloon contains 1 passenger\" and B be the event \"the hot air balloon is blue\".\nTo find the probability that a hot air balloon contains 1 passenger and is blue, first identify the sample space and the event.\nThe outcomes in the sample space are the different hot air balloons. Each hot air balloon is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the hot air balloon contains 1 passenger and is blue\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the hot air balloon contains 1 passenger and is blue\", so look at the table to see how many hot air balloons contain 1 passenger and are blue.\nThe number of hot air balloons that contain 1 passenger and are blue is 4.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of hot air balloons.\n4 + 4 + 3 + 2 = 13\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{4}{13}\nThe probability that a hot air balloon contains 1 passenger and is blue is \\frac{4}{13}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "9568",
    "path": "data"
  },
  {
    "question": "A philanthropic organization compared the amounts of money that its members donated to certain causes. How much did Irma donate to job training?",
    "choices": null,
    "answer": "7",
    "unit": "$",
    "table_title": "Donations",
    "table": "Person | Job training | Clean water\nWyatt | $4 | $10\nRon | $20 | $17\nIrma | $7 | $18\nScott | $16 | $8\nBrendan | $15 | $18",
    "row_num": 6,
    "column_num": 3,
    "solution": "First, find the row for Irma. Then find the number in the Job training column.\n\nThis number is $7.00. Irma donated $7 to job training.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "27416",
    "path": "data"
  },
  {
    "question": "The manager of a party supply store researched how many balloons it sold in the past 4 days. On which day did the store sell the fewest balloons?",
    "choices": [
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "answer": "Saturday",
    "unit": null,
    "table_title": "Balloons sold",
    "table": "Day | Number of balloons\nThursday | 22\nFriday | 29\nSaturday | 21\nSunday | 27",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 21.\n\nNow find the corresponding day. Saturday corresponds to 21.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "32488",
    "path": "data"
  },
  {
    "question": "Brian, who rents properties for a living, measures all the offices in a building he is renting. How many offices are less than 50 square meters?",
    "choices": null,
    "answer": "15",
    "unit": "offices",
    "table_title": "Office sizes (square meters)",
    "table": "Stem | Leaf \n1 | 0, 6\n2 | 0, 4, 6\n3 | 5, 5, 7, 9\n4 | 3, 3, 5, 6, 7, 7\n5 | 0, 2, 4\n6 | 4\n7 | 0, 3, 7, 8",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, and 4.\n\nYou counted 15 leaves, which are blue in the stem-and-leaf plot above. 15 offices are less than 50 square meters.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "29582",
    "path": "data"
  },
  {
    "question": "Patrick kept track of how many kilometers he walked during the past 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Kilometers walked",
    "table": "Day | Kilometers\nWednesday | 8\nThursday | 3\nFriday | 2\nSaturday | 3\nSunday | 4",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n8, 3, 2, 3, 4\n\nFirst, arrange the numbers from least to greatest:\n\n2, 3, 3, 4, 8\n\nNow find the number in the middle.\n\n2, 3, 3, 4, 8\n\nThe number in the middle is 3.\n\nThe median is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "19155",
    "path": "data"
  },
  {
    "question": "How much money does Jackson need to buy 5 souvenir cups?",
    "choices": null,
    "answer": "2.50",
    "unit": "$",
    "table_title": null,
    "table": "souvenir cup | $0.50\nwhale keychain | $0.55\nsmall stuffed otter | $0.96\npin with a picture of the beach | $0.45\nshell necklace | $0.47",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of 5 souvenir cups by multiplying 5 times the price of a souvenir cup.\n\n$0.50 \u00d7 5 = $2.50\n\nJackson needs $2.50.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "31267",
    "path": "data"
  },
  {
    "question": "A farmer recalled how many watermelons were harvested in the past 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "60",
    "unit": null,
    "table_title": "Watermelons harvested",
    "table": "Day | Number of watermelons\nWednesday | 60\nThursday | 64\nFriday | 52\nSaturday | 71\nSunday | 60",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n60, 64, 52, 71, 60\n\nFirst, arrange the numbers from least to greatest:\n\n52, 60, 60, 64, 71\n\nNow find the number in the middle.\n\n52, 60, 60, 64, 71\n\nThe number in the middle is 60.\n\nThe median is 60.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "761",
    "path": "data"
  },
  {
    "question": "An agricultural agency is researching how much cheese people have been eating in different parts of the world. Which country consumed the least cheese per capita in 2006?",
    "choices": [
      "Argentina",
      "Canada",
      "Germany",
      "Australia"
    ],
    "answer": "Australia",
    "unit": null,
    "table_title": "Cheese consumption per capita (kg)",
    "table": "Country | 1996 | 2006\nGermany | 12 | 20\nArgentina | 11 | 11\nCanada | 10 | 11\nAustralia | 10 | 10\nAustria | 10 | 17",
    "row_num": 6,
    "column_num": 3,
    "solution": "Look at the numbers in the 2006 column. Find the least number in this column.\n\nThe least number is 10, which is in the Australia row. Australia consumed the least cheese per capita in 2006.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "37119",
    "path": "data"
  },
  {
    "question": "How much money does Akira need to buy 2 leaf blowers?",
    "choices": null,
    "answer": "142",
    "unit": "$",
    "table_title": null,
    "table": "wooden bench | $63.00\nfountain | $91.00\nrosebush | $29.00\nleaf blower | $71.00\niron bench | $94.00\nlawn mower | $89.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of 2 leaf blowers by multiplying 2 times the price of a leaf blower.\n\n$71.00 \u00d7 2 = $142.00\n\nAkira needs $142.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "6353",
    "path": "data"
  },
  {
    "question": "Carson, an employee at Mosley's Convenience Store, looked at the sales of each of its soda products. On Thursday, how much more did the convenience store make from Pearl's Soda sales than from Brenner's Juices sales?",
    "choices": null,
    "answer": "6",
    "unit": "$",
    "table_title": "Convenience store beverage sales",
    "table": "Beverage | Thursday | Friday\nPearl's Soda | $20 | $14\nBrenner's Juices | $14 | $8\nOlde Tyme Cola | $13 | $11\nRefresh Mineral Water | $2 | $18",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the Thursday column. Find the numbers in this column for Pearl's Soda and Brenner's Juices.\n\nPearl's Soda: $20.00\nBrenner's Juices: $14.00\n\nNow subtract:\n\n$20.00 \u2212 $14.00 = $6.00\n\nOn Thursday, the convenience store made $6 more from Pearl's Soda sales than from Brenner's Juices sales.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "21727",
    "path": "data"
  },
  {
    "question": "For a psychology assignment, Pam kept a sleep log for 5 days. What is the mean of the numbers?",
    "choices": null,
    "answer": "11",
    "unit": null,
    "table_title": "Hours slept",
    "table": "Day | Hours\nSaturday | 10\nSunday | 11\nMonday | 12\nTuesday | 11\nWednesday | 11",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 11, 12, 11, 11\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n10 + 11 + 12 + 11 + 11 = 55\n\nNow divide the sum by the number of numbers:\n\n55 \u00f7 5 = 11\n\nThe mean is 11.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "18713",
    "path": "data"
  },
  {
    "question": "For an economics project, Ruben determined the cost of ferry rides for bicycles and cars. Which charges less for a car, the Fauntleroy-Vashon ferry or the Mukilteu-Clinton ferry?",
    "choices": [
      "Mukilteu-Clinton",
      "Fauntleroy-Vashon"
    ],
    "answer": "Mukilteu-Clinton",
    "unit": null,
    "table_title": "Ferry fares",
    "table": "Ferry | Bicycle | Car\nSeattle-Bremerton | $8 | $12\nMukilteu-Clinton | $5 | $7\nFauntleroy-Vashon | $5 | $15",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the Car column. Compare the numbers in this column for Fauntleroy-Vashon and Mukilteu-Clinton.\n\n$7.00 is less than $15.00. The Mukilteu-Clinton ferry charges less for a car.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "24810",
    "path": "data"
  },
  {
    "question": "Some car owners compared how many miles they drove in the past year. How many more miles did Jessica drive than Leslie?",
    "choices": null,
    "answer": "1,006",
    "unit": "miles",
    "table_title": "Miles driven",
    "table": "Name | Miles\nLeslie | 7,589\nBridgette | 4,987\nGina | 2,174\nEmmett | 6,127\nJessica | 8,595",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nJessica: 8,595\nLeslie: 7,589\n\nNow subtract: 8,595 - 7,589 = 1,006.\n\nJessica drove 1,006 more miles.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "12498",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "x | y\n14 | 14\n19 | 10\n14 | 16",
    "row_num": 4,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nThe x-value 14 is paired with multiple y-values, so the relation is not a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "28064",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which stop does the ferry depart from at 6.55 A.M.?",
    "choices": [
      "Pebble Town",
      "Crest View",
      "Cliff View",
      "Sandy Shores"
    ],
    "answer": "Cliff View",
    "unit": null,
    "table_title": "Ferry schedule",
    "table": "Location | Arrive | Depart\nStarfish City | 5:35 A.M. | 5:50 A.M.\nCliff View | 6:50 A.M. | 6:55 A.M.\nSeagull Port | 8:30 A.M. | 8:40 A.M.\nPebble Town | 9:10 A.M. | 9:30 A.M.\nWindy Sands | 10:05 A.M. | 10:35 A.M.\nGreen Harbor | 11:10 A.M. | 11:25 A.M.\nSandy Shores | 12:50 P.M. | 12:55 P.M.\nBeach Town | 2:25 P.M. | 2:35 P.M.\nCrest View | 3:15 P.M. | 3:35 P.M.\nGrassy Beach | 5:15 P.M. | 5:35 P.M.",
    "row_num": 11,
    "column_num": 3,
    "solution": "Find 6:55 A. M. on the schedule. The ferry departs from Cliff View at 6:55 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "27863",
    "path": "data"
  },
  {
    "question": "Shelley recalled how many minutes she had spent at theater rehearsal in the past 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "52",
    "unit": null,
    "table_title": "Minutes spent rehearsing",
    "table": "Day | Minutes\nMonday | 52\nTuesday | 56\nWednesday | 46\nThursday | 53\nFriday | 50",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n52, 56, 46, 53, 50\n\nFirst, arrange the numbers from least to greatest:\n\n46, 50, 52, 53, 56\n\nNow find the number in the middle.\n\n46, 50, 52, 53, 56\n\nThe number in the middle is 52.\n\nThe median is 52.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "24564",
    "path": "data"
  },
  {
    "question": "Gabby, a candy store employee, placed peppermint candies into jars of various sizes. What is the smallest number of peppermint candies?",
    "choices": null,
    "answer": "19",
    "unit": "peppermint candies",
    "table_title": "Peppermint candies per jar",
    "table": "Stem | Leaf \n1 | 9\n2 | \n3 | 6\n4 | \n5 | 4, 6\n6 | \n7 | \n8 | 8, 9\n9 | 0, 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 1.\n\nNow find the lowest leaf in the first row. The lowest leaf is 9.\n\nThe smallest number of peppermint candies has a stem of 1 and a leaf of 9. Write the stem first, then the leaf: 19.\n\nThe smallest number of peppermint candies is 19 peppermint candies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "147",
    "path": "data"
  },
  {
    "question": "Some students compared how many blocks they live from school. What is the range of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Blocks from school",
    "table": "Name | Number of blocks\nPaula | 8\nJulia | 8\nLauren | 6\nDarius | 8\nWhitney | 3",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n8, 8, 6, 8, 3\n\nFirst, find the greatest number. The greatest number is 8.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n8 \u2212 3 = 5\n\nThe range is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "35367",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Maureen just missed the 9.30 A.M. boat at Rocky Cliffs. How long does she have to wait until the next boat?",
    "choices": [
      "15 minutes",
      "1 hour",
      "45 minutes",
      "30 minutes"
    ],
    "answer": "30 minutes",
    "unit": null,
    "table_title": "Tour boat schedule",
    "table": "Fisherman's Cove | 6:15 A.M. | 8:00 A.M. | 8:30 A.M.\nRocky Cliffs | 7:45 A.M. | 9:30 A.M. | 10:00 A.M.\nWhale Watch Harbor | 9:30 A.M. | 11:15 A.M. | 11:45 A.M.\nPalm Tree Island | 11:15 A.M. | 1:00 P.M. | 1:30 P.M.\nOcean City | 1:00 P.M. | 2:45 P.M. | 3:15 P.M.\nSurfing Beach | 2:30 P.M. | 4:15 P.M. | 4:45 P.M.",
    "row_num": 6,
    "column_num": 4,
    "solution": "Find 9:30 A. M. in the row for Rocky Cliffs.\n\nLook for the next boat in that row.\n\nThe next boat is at 10:00 A. M.\n\nFind the elapsed time. The elapsed time is 30 minutes.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 4,
    "split": "dev",
    "pid": "36137",
    "path": "data"
  },
  {
    "question": "Some friends met in New York City for vacation and compared how far they had traveled. How many more miles did Louis travel than Evelyn?",
    "choices": null,
    "answer": "631",
    "unit": "miles",
    "table_title": "Distance traveled",
    "table": "Name | Miles\nEvelyn | 127\nBraden | 858\nLouis | 758\nRick | 330",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nLouis: 758\nEvelyn: 127\n\nNow subtract: 758 - 127 = 631.\n\nLouis traveled 631 more miles.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "30452",
    "path": "data"
  },
  {
    "question": "Each laundry hamper has 5 polo shirts. How many polo shirts are in 4 laundry hampers?",
    "choices": null,
    "answer": "20",
    "unit": null,
    "table_title": null,
    "table": "Number of laundry hampers | Number of polo shirts\n1 | 5\n2 | 10\n3 | 15\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 20 polo shirts in 4 laundry hampers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "30987",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Braden just missed the 1.45 P.M. bus at the science museum. What time is the next bus?",
    "choices": [
      "3:45 P.M.",
      "1:30 P.M.",
      "2:00 P.M.",
      "3:15 P.M."
    ],
    "answer": "2:00 P.M.",
    "unit": null,
    "table_title": "Tour bus schedule",
    "table": "shopping district | 10:15 A.M. | 10:30 A.M. | 10:45 A.M.\nart museum | 11:15 A.M. | 11:30 A.M. | 11:45 A.M.\nold building | 11:30 A.M. | 11:45 A.M. | 12:00 P.M.\ngovernor's mansion | 12:30 P.M. | 12:45 P.M. | 1:00 P.M.\nscience museum | 1:30 P.M. | 1:45 P.M. | 2:00 P.M.\nuniversity campus | 2:30 P.M. | 2:45 P.M. | 3:00 P.M.\nskyscraper | 3:15 P.M. | 3:30 P.M. | 3:45 P.M.\nfamous bridge | 4:15 P.M. | 4:30 P.M. | 4:45 P.M.\ncity hall | 4:45 P.M. | 5:00 P.M. | 5:15 P.M.",
    "row_num": 9,
    "column_num": 4,
    "solution": "Find 1:45 P. M. in the row for the science museum.\n\nLook for the next bus in that row.\n\nThe next bus is at 2:00 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "35098",
    "path": "data"
  },
  {
    "question": "A pumpkin patch monitored the number of pumpkins sold each day. What is the median of the numbers?",
    "choices": null,
    "answer": "39",
    "unit": null,
    "table_title": "Pumpkins sold",
    "table": "Day | Number of pumpkins\nSunday | 36\nMonday | 44\nTuesday | 34\nWednesday | 59\nThursday | 39",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n36, 44, 34, 59, 39\n\nFirst, arrange the numbers from least to greatest:\n\n34, 36, 39, 44, 59\n\nNow find the number in the middle.\n\n34, 36, 39, 44, 59\n\nThe number in the middle is 39.\n\nThe median is 39.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "19617",
    "path": "data"
  },
  {
    "question": "A survey asked office workers what they like to do when taking a break from work. What fraction of the respondents preferred checking personal e-mail? Simplify your answer.",
    "choices": null,
    "answer": "25/259",
    "unit": null,
    "table_title": "Preferred break activities",
    "table": "Activity | Number of respondents\nStretching | 610\nHaving a snack | 760\nChecking personal e-mail | 250\nTaking a walk | 970",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find how many respondents preferred checking personal e-mail.\n\n250\n\nFind how many people responded in total.\n\n610 + 760 + 250 + 970 = 2,590\n\nDivide 250 by2,590.\n\n\\frac{250}{2,590}\n\nReduce the fraction.\n\n\\frac{250}{2,590} \u2192 \\frac{25}{259}\n\n\\frac{25}{259} of respondents preferred checking personal e-mail.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "18703",
    "path": "data"
  },
  {
    "question": "Each horse pasture has 10 sprinklers. How many sprinklers are in 4 horse pastures?",
    "choices": null,
    "answer": "40",
    "unit": null,
    "table_title": null,
    "table": "Number of horse pastures | Number of sprinklers\n1 | 10\n2 | 20\n3 | 30\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 40 sprinklers in 4 horse pastures.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "15037",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n3 | 18\n4 | 16\n5 | 14",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{16 - 18}{4 - 3}\n = \\frac{-2}{1}\n = -2\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{14 - 18}{5 - 3}\n = \\frac{-4}{2}\n = -2\nThe two rates of change are the same.\n2.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "33165",
    "path": "data"
  },
  {
    "question": "Mrs. Lam, the science teacher, informed her students of their scores on Monday's test. What is the lowest score?",
    "choices": null,
    "answer": "6",
    "unit": "points",
    "table_title": "Science test scores",
    "table": "Stem | Leaf \n0 | 6\n1 | 7\n2 | 5\n3 | 8\n4 | 2, 8, 8\n5 | 3\n6 | 1, 3, 8\n7 | 3",
    "row_num": 9,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 0.\n\nNow find the lowest leaf in the first row. The lowest leaf is 6.\n\nThe lowest score has a stem of 0 and a leaf of 6. Write the stem first, then the leaf: 06.\n\nThe lowest score is 6 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "5590",
    "path": "data"
  },
  {
    "question": "Kensington will decide whether to extend its public pool's hours by looking at the number of times its residents visited the pool last month. How many people are there in all?",
    "choices": null,
    "answer": "68",
    "unit": null,
    "table_title": "Going swimming last month",
    "table": "Number of times | Frequency\n1 | 15\n2 | 2\n3 | 19\n4 | 18\n5 | 5\n6 | 9",
    "row_num": 7,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n15 + 2 + 19 + 18 + 5 + 9 = 68\n\nThere are 68 people in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "28817",
    "path": "data"
  },
  {
    "question": "A parent volunteer counted the number of boxes sold by each student participating in the cookie fundraiser. How many students sold more than 3 boxes of cookies?",
    "choices": null,
    "answer": "33",
    "unit": null,
    "table_title": "Selling cookies",
    "table": "Boxes sold | Frequency\n1 | 16\n2 | 14\n3 | 9\n4 | 12\n5 | 17\n6 | 4",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the rows for 4, 5, and 6 boxes of cookies. Add the frequencies for these rows.\n\nAdd:\n\n12 + 17 + 4 = 33\n\n33 students sold more than 3 boxes of cookies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "754",
    "path": "data"
  },
  {
    "question": "The town council reported on how many stop signs there are on each street. What is the mode of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Stop signs",
    "table": "Street | Number of stop signs\nMason Street | 6\nJackson Street | 3\nIrving Street | 6\nWalker Street | 3\nSpring Street | 3",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 3, 6, 3, 3\n\nFirst, arrange the numbers from least to greatest:\n\n3, 3, 3, 6, 6\n\nNow count how many times each number appears.\n\n3 appears 3 times.\n6 appears 2 times.\n\nThe number that appears most often is 3.\n\nThe mode is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "5471",
    "path": "data"
  },
  {
    "question": "A dentist was making note of her upcoming appointments with different aged patients and the reasons for their visits. What is the probability that a randomly selected appointment is with patients under 18 years old and is for a regular cleaning? Simplify any fractions.",
    "choices": null,
    "answer": "5/18",
    "unit": null,
    "table_title": null,
    "table": " | Regular cleaning | Broken tooth\nPatients under 18 years old | 5 | 4\nPatients 19-60 years old | 3 | 6",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the appointment is with patients under 18 years old\" and B be the event \"the appointment is for a regular cleaning\".\nTo find the probability that a appointment is with patients under 18 years old and is for a regular cleaning, first identify the sample space and the event.\nThe outcomes in the sample space are the different appointments. Each appointment is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the appointment is with patients under 18 years old and is for a regular cleaning\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the appointment is with patients under 18 years old and is for a regular cleaning\", so look at the table to see how many appointments are with patients under 18 years old and are for a regular cleaning.\nThe number of appointments that are with patients under 18 years old and are for a regular cleaning is 5.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of appointments.\n5 + 3 + 4 + 6 = 18\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{5}{18}\nThe probability that a appointment is with patients under 18 years old and is for a regular cleaning is \\frac{5}{18}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "31377",
    "path": "data"
  },
  {
    "question": "A car dealership tracked the number of cars sold each month. What is the mode of the numbers?",
    "choices": null,
    "answer": "18",
    "unit": null,
    "table_title": "Cars sold",
    "table": "Month | Number of cars\nApril | 24\nMay | 20\nJune | 18\nJuly | 18\nAugust | 18\nSeptember | 24\nOctober | 18\nNovember | 20",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n24, 20, 18, 18, 18, 24, 18, 20\n\nFirst, arrange the numbers from least to greatest:\n\n18, 18, 18, 18, 20, 20, 24, 24\n\nNow count how many times each number appears.\n\n18 appears 4 times.\n20 appears 2 times.\n24 appears 2 times.\n\nThe number that appears most often is 18.\n\nThe mode is 18.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "6225",
    "path": "data"
  },
  {
    "question": "This is Sandra's complete financial record for December. How much money did Sandra spend on December 29?",
    "choices": null,
    "answer": "7.80",
    "unit": "$",
    "table_title": null,
    "table": "Date | Description | Received | Expenses | Available Funds\n | Balance: end of November | | | $328.20\n12/5 | wrapping paper | | $4.95 | $323.25\n12/16 | watching Ms. Carson's cat | $15.00 | | $338.25\n12/29 | calendar | | $7.80 | $330.45",
    "row_num": 5,
    "column_num": 5,
    "solution": "Look at the 12/29 row. The expenses were $7.80. So, Sandra spent $7.80 on December 29.\n",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "32156",
    "path": "data"
  },
  {
    "question": "Kevin has $5. Does he have enough to buy a pair of black socks and a pair of white socks?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "pair of white socks | $2\nblue sweater | $7\npair of black socks | $2\nyellow T-shirt | $6",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a pair of black socks and the price of a pair of white socks:\n\n$2 + $2 = $4\n\n$4 is less than $5. Kevin does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "4524",
    "path": "data"
  },
  {
    "question": "Sasha jotted down how many baskets she made during basketball practice each day. On which day did Sasha make the most baskets?",
    "choices": [
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday"
    ],
    "answer": "Thursday",
    "unit": null,
    "table_title": "Baskets made",
    "table": "Day | Number of baskets\nWednesday | 84\nThursday | 87\nFriday | 85\nSaturday | 86",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 87.\n\nNow find the corresponding day. Thursday corresponds to 87.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "12801",
    "path": "data"
  },
  {
    "question": "How much more does a cup of coffee cost than a bag of pretzels?",
    "choices": null,
    "answer": "0.03",
    "unit": "$",
    "table_title": null,
    "table": "bag of peanuts | $0.80\nbottle of water | $0.78\ncup of orange juice | $0.88\nbagel | $0.90\nbag of pretzels | $0.93\ncup of coffee | $0.96",
    "row_num": 6,
    "column_num": 2,
    "solution": "Subtract the price of a bag of pretzels from the price of a cup of coffee.\n\n$0.96 - $0.93 = $0.03\n\nA cup of coffee costs $0.03 more than a bag of pretzels.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "37973",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which stop does the train depart from at 12.10 P.M.?",
    "choices": [
      "high school",
      "shopping mall",
      "park",
      "baseball stadium"
    ],
    "answer": "park",
    "unit": null,
    "table_title": "Light rail train schedule",
    "table": "Location | Time\nswimming pool | 10:15 A.M.\nelementary school | 10:40 A.M.\nbasketball stadium | 11:10 A.M.\nshopping mall | 11:40 A.M.\npark | 12:10 P.M.\ntown square | 12:25 P.M.\nhigh school | 12:50 P.M.\nbaseball stadium | 1:15 P.M.",
    "row_num": 9,
    "column_num": 2,
    "solution": "Find 12:10 P. M. on the schedule. The train departs from the park at 12:10 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "25621",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $780, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$780 | 16,500 | 3,500\n$980 | 14,200 | 3,900\n$1,180 | 11,900 | 4,300\n$1,380 | 9,600 | 4,700\n$1,580 | 7,300 | 5,100",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $780, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "8796",
    "path": "data"
  },
  {
    "question": "A stock broker followed the stock prices of a certain set of companies. On Wednesday, how much more did Thompson Corporation's stock cost than Jonas Incorporated's stock?",
    "choices": null,
    "answer": "4",
    "unit": "$",
    "table_title": "Stock prices",
    "table": "Company | Tuesday | Wednesday\nJonas Incorporated | $15 | $15\nWhite and Company | $4 | $19\nWatson and Partners | $20 | $1\nComputer Data Company | $5 | $19\nThompson Corporation | $12 | $19",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Wednesday column. Find the numbers in this column for Thompson Corporation and Jonas Incorporated.\n\nThompson Corporation: $19.00\nJonas Incorporated: $15.00\n\nNow subtract:\n\n$19.00 \u2212 $15.00 = $4.00\n\nOn Wednesday Thompson Corporation's stock cost $4 more than Jonas Incorporated's stock.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "12762",
    "path": "data"
  },
  {
    "question": "Kensington will decide whether to extend its public pool's hours by looking at the number of times its residents visited the pool last month. How many people went swimming more than 2 times?",
    "choices": null,
    "answer": "34",
    "unit": null,
    "table_title": "Going swimming last month",
    "table": "Number of times | Frequency\n1 | 13\n2 | 12\n3 | 15\n4 | 19",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the rows for 3 and 4 times. Add the frequencies for these rows.\n\nAdd:\n\n15 + 19 = 34\n\n34 people went swimming more than 2 times.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "16924",
    "path": "data"
  },
  {
    "question": "The Spanish club made a table showing the ages of its members. What is the range of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Club members' ages",
    "table": "Name | Age (years)\nAaliyah | 10\nOmar | 9\nGordon | 7\nCora | 6\nDominic | 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 9, 7, 6, 7\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 6.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 6 = 4\n\nThe range is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "3924",
    "path": "data"
  },
  {
    "question": "Some teachers compared how many years they have been teaching. Who has been teaching the longest?",
    "choices": [
      "Mr. Perez",
      "Ms. Chan",
      "Mr. Boone",
      "Mr. Nakamura"
    ],
    "answer": "Mr. Nakamura",
    "unit": null,
    "table_title": "Years of teaching",
    "table": "Teacher | Number of years\nMr. Perez | 17\nMs. Chan | 11\nMr. Boone | 18\nMr. Nakamura | 19",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 19.\n\nNow find the corresponding teacher. Mr. Nakamura corresponds to 19.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "20350",
    "path": "data"
  },
  {
    "question": "How much money does Seth need to buy 3 Pinto horses?",
    "choices": null,
    "answer": "5,025",
    "unit": "$",
    "table_title": null,
    "table": "Hanoverian horse | $5,038\nPinto horse | $1,675\nThoroughbred horse | $7,304\nPalomino horse | $4,837\nClydesdale horse | $1,294",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of 3 Pinto horses by multiplying 3 times the price of a Pinto horse.\n\n$1,675 \u00d7 3 = $5,025\n\nSeth needs $5,025.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "6915",
    "path": "data"
  },
  {
    "question": "Emmett has $7.76. How much money will Emmett have left if he buys a package of purple streamers and a gift bag?",
    "choices": null,
    "answer": "2.46",
    "unit": "$",
    "table_title": null,
    "table": "birthday balloon | $1.26\ngift bag | $3.59\ngreeting card | $1.88\npackage of purple streamers | $1.71",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of a package of purple streamers and a gift bag.\n\n$1.71 + $3.59 = $5.30\n\nNow subtract the total cost from the starting amount.\n\n$7.76 - $5.30 = $2.46\n\nEmmett will have $2.46 left.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "30394",
    "path": "data"
  },
  {
    "question": "Curious about people's recycling behaviors, Kinsley put on some gloves and sifted through some recycling and trash bins. She kept count of the plastic type of each bottle and which bottles are properly dispensed. What is the probability that a randomly selected bottle is made of plastic #2 and is correctly placed? Simplify any fractions.",
    "choices": null,
    "answer": "3/10",
    "unit": null,
    "table_title": null,
    "table": " | Correctly placed | Incorrectly placed\nPlastic #2 | 6 | 5\nPlastic #4 | 6 | 3",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the bottle is made of plastic #2\" and B be the event \"the bottle is correctly placed\".\nTo find the probability that a bottle is made of plastic #2 and is correctly placed, first identify the sample space and the event.\nThe outcomes in the sample space are the different bottles. Each bottle is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the bottle is made of plastic #2 and is correctly placed\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the bottle is made of plastic #2 and is correctly placed\", so look at the table to see how many bottles are made of plastic #2 and are correctly placed.\nThe number of bottles that are made of plastic #2 and are correctly placed is 6.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of bottles.\n6 + 6 + 5 + 3 = 20\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{6}{20}\n = \\frac{3}{10}\nThe probability that a bottle is made of plastic #2 and is correctly placed is \\frac{3}{10}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "34448",
    "path": "data"
  },
  {
    "question": "A bakery recorded how many cupcakes it sold in the past 4 days. On which day did the bakery sell the fewest cupcakes?",
    "choices": [
      "Saturday",
      "Sunday",
      "Monday",
      "Tuesday"
    ],
    "answer": "Saturday",
    "unit": null,
    "table_title": "Cupcakes sold",
    "table": "Day | Number of cupcakes\nSaturday | 31\nSunday | 35\nMonday | 32\nTuesday | 37",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 31.\n\nNow find the corresponding day. Saturday corresponds to 31.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "29414",
    "path": "data"
  },
  {
    "question": "What is the total cost for 4 pounds of finishing nails?",
    "choices": null,
    "answer": "38.52",
    "unit": "$",
    "table_title": null,
    "table": "boat nails | $9.02 per pound\nfinishing nails | $9.63 per pound\nroofing nails | $9.82 per pound\nbox nails | $9.05 per pound\ncooler nails | $9.55 per pound",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the finishing nails. Multiply the price per pound by the number of pounds.\n\n$9.63 \u00d7 4 = $38.52\n\nThe total cost is $38.52.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "17160",
    "path": "data"
  },
  {
    "question": "The parks department compared how many basketball hoops there are at each park. What is the range of the numbers?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": "Basketball hoops",
    "table": "Park | Number of basketball hoops\nHeron Park | 12\nPinehurst Park | 15\nRiverfront Park | 12\nKelly Park | 14\nMooreland Park | 3",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n12, 15, 12, 14, 3\n\nFirst, find the greatest number. The greatest number is 15.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n15 \u2212 3 = 12\n\nThe range is 12.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "12414",
    "path": "data"
  },
  {
    "question": "The movie critic liked to count the number of actors in each movie she saw. How many movies had at least 21 actors but fewer than 75 actors?",
    "choices": null,
    "answer": "12",
    "unit": "movies",
    "table_title": "Actors per movie",
    "table": "Stem | Leaf \n1 | 5, 7, 7\n2 | 0, 7, 9\n3 | 0, 3\n4 | \n5 | 2, 4\n6 | 2, 3, 5, 6, 8\n7 | 4, 6\n8 | 2, 4, 8, 9, 9",
    "row_num": 9,
    "column_num": 2,
    "solution": "Find the row with stem 2. Count all the leaves greater than or equal to 1.\n\nCount all the leaves in the rows with stems 3, 4, 5, and 6.\n\nIn the row with stem 7, count all the leaves less than 5.\n\nYou counted 12 leaves, which are blue in the stem-and-leaf plots above. 12 movies had at least 21 actors but fewer than 75 actors.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "10606",
    "path": "data"
  },
  {
    "question": "How much money does Jack need to buy 3 rolls of electrical tape?",
    "choices": null,
    "answer": "0.81",
    "unit": "$",
    "table_title": null,
    "table": "red thumbtack | $0.14\nroll of electrical tape | $0.27\nbrass clip | $0.19\nminiature padlock | $0.31\nspool of gold wire | $0.70",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of 3 rolls of electrical tape by multiplying 3 times the price of a roll of electrical tape.\n\n$0.27 \u00d7 3 = $0.81\n\nJack needs $0.81.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "32592",
    "path": "data"
  },
  {
    "question": "A county agency recorded the money donated to several charitable causes over time. How much more money was raised for parks in May than in June?",
    "choices": null,
    "answer": "10",
    "unit": "$",
    "table_title": "Donations received",
    "table": "Cause | May | June\nEducation | $19 | $19\nMedical research | $10 | $20\nParks | $12 | $2\nAnimals | $6 | $19\nHunger | $7 | $13",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Parks row. Find the numbers in this row for May and June.\n\nMay: $12.00\nJune: $2.00\n\nNow subtract:\n\n$12.00 \u2212 $2.00 = $10.00\n\n$10 more was raised for parks in May than in June.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "38275",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n3 | 4\n4 | 12\n5 | 20",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{12 - 4}{4 - 3}\n = \\frac{8}{1}\n = 8\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{20 - 12}{5 - 4}\n = \\frac{8}{1}\n = 8\nThe two rates of change are the same.\nIf you checked the rate of change between rows 1 and 3, you would find that it is also 8.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "18188",
    "path": "data"
  },
  {
    "question": "A pair of Union High School hockey fans counted the number of games won by the school each year. According to the table, what was the rate of change between 2009 and 2010?",
    "choices": null,
    "answer": "-8",
    "unit": "games per year",
    "table_title": "Hockey games won by Union High",
    "table": "Year | Games won\n2008 | 15\n2009 | 15\n2010 | 7\n2011 | 9\n2012 | 6",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{7 games - 15 games}{2010 - 2009}\n = \\frac{7 games - 15 games}{1 year}\n = \\frac{-8 games}{1 year}\n = -8 games per year\nThe rate of change between 2009 and 2010 was - 8 games per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "24751",
    "path": "data"
  },
  {
    "question": "Each shed has 5 hammers. How many hammers are in 4 sheds?",
    "choices": null,
    "answer": "20",
    "unit": null,
    "table_title": null,
    "table": "Number of sheds | Number of hammers\n1 | 5\n2 | 10\n3 | 15\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 20 hammers in 4 sheds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "9816",
    "path": "data"
  },
  {
    "question": "A doctor's records revealed how many patients he saw each month. In which month did the doctor see the fewest patients?",
    "choices": [
      "October",
      "November",
      "December",
      "January"
    ],
    "answer": "October",
    "unit": null,
    "table_title": "Patients seen",
    "table": "Month | Number of patients\nOctober | 737\nNovember | 779\nDecember | 739\nJanuary | 793",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 737.\n\nNow find the corresponding month. October corresponds to 737.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "32336",
    "path": "data"
  },
  {
    "question": "Harold graphed the temperature at noon for 6 days. What is the mode of the numbers?",
    "choices": null,
    "answer": "11",
    "unit": null,
    "table_title": "Temperature at noon",
    "table": "Day | Temperature (\u00c2\u00b0C)\nMonday | 17\nTuesday | 11\nWednesday | 9\nThursday | 11\nFriday | 11\nSaturday | 17",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n17, 11, 9, 11, 11, 17\n\nFirst, arrange the numbers from least to greatest:\n\n9, 11, 11, 11, 17, 17\n\nNow count how many times each number appears.\n\n9 appears 1 time.\n11 appears 3 times.\n17 appears 2 times.\n\nThe number that appears most often is 11.\n\nThe mode is 11.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "34137",
    "path": "data"
  },
  {
    "question": "In a study on public parking, the director of transportation counted the number of cars in each of the city's parking lots. How many parking lots had exactly 30 cars?",
    "choices": null,
    "answer": "2",
    "unit": "parking lots",
    "table_title": "Cars per parking lot",
    "table": "Stem | Leaf \n3 | 0, 0, 2\n4 | \n5 | 3, 5\n6 | 9\n7 | 7\n8 | 7\n9 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "For the number 30, the stem is 3, and the leaf is 0. Find the row where the stem is 3. In that row, count all the leaves equal to 0.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 parking lots had exactly 30 cars.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "3455",
    "path": "data"
  },
  {
    "question": "Pete and his brother are at a store shopping for a beanbag chair for their school's library. The store sells beanbag chairs with different fabrics and types of filling. What is the probability that a randomly selected beanbag chair is filled with beads and is made from velvet? Simplify any fractions.",
    "choices": null,
    "answer": "5/18",
    "unit": null,
    "table_title": null,
    "table": " | Velvet | Suede\nFoam | 3 | 6\nBeads | 5 | 4",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the beanbag chair is filled with beads\" and B be the event \"the beanbag chair is made from velvet\".\nTo find the probability that a beanbag chair is filled with beads and is made from velvet, first identify the sample space and the event.\nThe outcomes in the sample space are the different beanbag chairs. Each beanbag chair is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the beanbag chair is filled with beads and is made from velvet\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the beanbag chair is filled with beads and is made from velvet\", so look at the table to see how many beanbag chairs are filled with beads and are made from velvet.\nThe number of beanbag chairs that are filled with beads and are made from velvet is 5.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of beanbag chairs.\n3 + 5 + 6 + 4 = 18\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{5}{18}\nThe probability that a beanbag chair is filled with beads and is made from velvet is \\frac{5}{18}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "1269",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $685, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$285 | 18,200 | 5,800\n$385 | 14,700 | 6,400\n$485 | 11,200 | 7,000\n$585 | 7,700 | 7,600\n$685 | 4,200 | 8,200",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $685, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "9055",
    "path": "data"
  },
  {
    "question": "If Alexa buys 4+1/2 pounds of yogurt-covered peanuts, how much will she spend?",
    "choices": null,
    "answer": "9",
    "unit": "$",
    "table_title": null,
    "table": "chocolates | $2 per lb\ngummy bears | $3 per lb\nyogurt-covered peanuts | $2 per lb\nlicorice | $1 per lb\nlemon sours | $4 per lb",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the yogurt-covered peanuts. Multiply the price per pound by the number of pounds.\n$2 \u00d7 4\\frac{1}{2} = $2 \u00d7 4.5 = $9\nShe will spend $9.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "17422",
    "path": "data"
  },
  {
    "question": "Bella paid attention to how many flowers she planted in the garden during the past 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Flowers plants",
    "table": "Day | Number of flowers\nFriday | 0\nSaturday | 1\nSunday | 6\nMonday | 8\nTuesday | 2",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n0, 1, 6, 8, 2\n\nFirst, arrange the numbers from least to greatest:\n\n0, 1, 2, 6, 8\n\nNow find the number in the middle.\n\n0, 1, 2, 6, 8\n\nThe number in the middle is 2.\n\nThe median is 2.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "20110",
    "path": "data"
  },
  {
    "question": "An adventure tour company found out how many whales people saw on its most popular whale tour. How many people saw fewer than 4 whales?",
    "choices": null,
    "answer": "47",
    "unit": null,
    "table_title": "Whale watching",
    "table": "Whales spotted | Frequency\n0 | 15\n1 | 16\n2 | 11\n3 | 5\n4 | 2\n5 | 1",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the rows for 0, 1, 2, and 3 whales. Add the frequencies for these rows.\n\nAdd:\n\n15 + 16 + 11 + 5 = 47\n\n47 people saw fewer than 4 whales.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "18751",
    "path": "data"
  },
  {
    "question": "Lamar graphed the temperature at noon for 6 days. What is the range of the numbers?",
    "choices": null,
    "answer": "16",
    "unit": null,
    "table_title": "Temperature at noon",
    "table": "Day | Temperature (\u00c2\u00b0C)\nThursday | 12\nFriday | 6\nSaturday | 22\nSunday | 20\nMonday | 18\nTuesday | 22",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n12, 6, 22, 20, 18, 22\n\nFirst, find the greatest number. The greatest number is 22.\n\nNext, find the least number. The least number is 6.\n\nSubtract the least number from the greatest number:\n\n22 \u2212 6 = 16\n\nThe range is 16.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "3200",
    "path": "data"
  },
  {
    "question": "Mrs. Jacobson, the science teacher, informed her students of their scores on Monday's test. How many students scored at least 49 points but fewer than 58 points?",
    "choices": null,
    "answer": "3",
    "unit": "students",
    "table_title": "Science test scores",
    "table": "Stem | Leaf \n4 | 5, 6\n5 | 1, 2, 6\n6 | 7\n7 | 3, 4\n8 | 0, 4, 8, 9\n9 | 0",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row with stem 4. Count all the leaves greater than or equal to 9.\n\nIn the row with stem 5, count all the leaves less than 8.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plots above. 3 students scored at least 49 points but fewer than 58 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "29112",
    "path": "data"
  },
  {
    "question": "A researcher asked people how many letters they had written in the past year and recorded the results. How many people wrote exactly 4 letters?",
    "choices": null,
    "answer": "1",
    "unit": null,
    "table_title": "Writing letters",
    "table": "Letters written | Frequency\n0 | 7\n1 | 16\n2 | 19\n3 | 14\n4 | 1",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row for 4 letters and read the frequency. The frequency is 1.\n\n1 person wrote exactly 4 letters.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "27376",
    "path": "data"
  },
  {
    "question": "How much would it cost to buy 4 pounds of coarse gravel and 2 pounds of white sand?",
    "choices": null,
    "answer": "24.22",
    "unit": "$",
    "table_title": null,
    "table": "black sand | $3.50 per lb\nwhite sand | $2.11 per lb\nrocks | $2.00 per lb\nfine gravel | $4.74 per lb\ncoarse gravel | $5.00 per lb\npebbles | $2.26 per lb",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the coarse gravel. Multiply:\n\n$5 \u00d7 4 = $20\n\nFind the cost of the white sand. Multiply:\n\n$2.11 \u00d7 2 = $4.22\n\nNow find the total cost by adding:\n\n$20 + $4.22 = $24.22\n\nIt would cost $24.22.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "30954",
    "path": "data"
  },
  {
    "question": "Vijay just downloaded the new game Gem Excavator on his phone. In the first level, Vijay gains points for each green gem he finds. However, he loses points for each red gem he finds. The table shows how the gems affect Vijay's points. Which color gem affects Vijay's points less?",
    "choices": [
      "green",
      "red"
    ],
    "answer": "green",
    "unit": null,
    "table_title": null,
    "table": "Gem color | Change in points\nGreen | 25\nRed | -40",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find the gem that affects Vijay's points less, use absolute value. Absolute value tells you how much Vijay's points change for each color gem.\nGreen: |25| = 25\nRed: |-40| = 40\nVijay gains 25 points for each green gem he finds, and he loses 40 points for each red gem he finds. So, the green gems affect Vijay's points less.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "32917",
    "path": "data"
  },
  {
    "question": "The city recorded how many fire hydrants there are on each street. What is the mean of the numbers?",
    "choices": null,
    "answer": "13",
    "unit": null,
    "table_title": "Fire hydrants",
    "table": "Street | Number of hydrants\nMaple Street | 17\nElm Street | 1\nOak Street | 18\nRose Street | 18\nCedar Street | 8\nAspen Street | 15\nLemon Street | 14",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n17, 1, 18, 18, 8, 15, 14\n\nFirst, count how many numbers are in the group.\n\nThere are 7 numbers.\n\nNow add all the numbers together:\n\n17 + 1 + 18 + 18 + 8 + 15 + 14 = 91\n\nNow divide the sum by the number of numbers:\n\n91 \u00f7 7 = 13\n\nThe mean is 13.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "17161",
    "path": "data"
  },
  {
    "question": "A theme park developer recorded the number of people who visited the local water park last summer. How many people went to the water park fewer than 3 times?",
    "choices": null,
    "answer": "20",
    "unit": null,
    "table_title": "Going to the water park last summer",
    "table": "Number of trips | Frequency\n1 | 17\n2 | 3\n3 | 7\n4 | 19\n5 | 0",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the rows for 1 and 2 times. Add the frequencies for these rows.\n\nAdd:\n\n17 + 3 = 20\n\n20 people went to the water park fewer than 3 times.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "9690",
    "path": "data"
  },
  {
    "question": "Kendra has $666.00. Does she have enough to buy a bat signed by a famous baseball player and a skate signed by a famous figure skater?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "photograph signed by a famous singer | $711.00\nCD signed by a famous band | $735.00\nphotograph signed by a famous movie star | $584.00\nskate signed by a famous figure skater | $428.00\nbat signed by a famous baseball player | $233.00\nphotograph signed by a famous race car driver | $920.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a bat signed by a famous baseball player and the price of a skate signed by a famous figure skater:\n\n$233.00 + $428.00 = $661.00\n\n$661.00 is less than $666.00. Kendra does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 7,
    "split": "dev",
    "pid": "21776",
    "path": "data"
  },
  {
    "question": "The students in Mr. Kent's class recorded the number of siblings that each has. How many students have fewer than 3 siblings?",
    "choices": null,
    "answer": "39",
    "unit": null,
    "table_title": "Siblings",
    "table": "Number of siblings | Frequency\n0 | 19\n1 | 5\n2 | 15\n3 | 9\n4 | 20\n5 | 0",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the rows for 0, 1, and 2 siblings. Add the frequencies for these rows.\n\nAdd:\n\n19 + 5 + 15 = 39\n\n39 students have fewer than 3 siblings.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "20678",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "x | y\n15 | 13\n15 | 16\n9 | 6",
    "row_num": 4,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nThe x-value 15 is paired with multiple y-values, so the relation is not a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "10536",
    "path": "data"
  },
  {
    "question": "Lee wrote down how many spelling words he practiced each day. What is the mean of the numbers?",
    "choices": null,
    "answer": "9",
    "unit": null,
    "table_title": "Spelling words practiced",
    "table": "Day | Number of spelling words\nSunday | 9\nMonday | 7\nTuesday | 10\nWednesday | 10\nThursday | 8\nFriday | 10",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 7, 10, 10, 8, 10\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n9 + 7 + 10 + 10 + 8 + 10 = 54\n\nNow divide the sum by the number of numbers:\n\n54 \u00f7 6 = 9\n\nThe mean is 9.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "19127",
    "path": "data"
  },
  {
    "question": "In hopes of raising more funds for arts education, some parents in the Kensington School District publicized the current per-student arts education budget. According to the table, what was the rate of change between 2014 and 2015?",
    "choices": null,
    "answer": "5",
    "unit": "$, per year",
    "table_title": "Kensington arts education budget",
    "table": "Year | Per-student budget\n2012 | $20\n2013 | $18\n2014 | $16\n2015 | $21\n2016 | $19",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{$21 - $16}{2015 - 2014}\n = \\frac{$21 - $16}{1 year}\n = \\frac{$5}{1 year}\n = $5 per year\nThe rate of change between 2014 and 2015 was $5 per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "16690",
    "path": "data"
  },
  {
    "question": "The owner of a bed and breakfast inn recalled how many guests the inn had hosted each day. What is the mean of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Inn guests",
    "table": "Day | Number of guests\nThursday | 10\nFriday | 7\nSaturday | 5\nSunday | 3\nMonday | 5",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 7, 5, 3, 5\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n10 + 7 + 5 + 3 + 5 = 30\n\nNow divide the sum by the number of numbers:\n\n30 \u00f7 5 = 6\n\nThe mean is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "26710",
    "path": "data"
  },
  {
    "question": "An economist tracked the amount of per-capita aid sent from the U.S. to various countries during the 1900s. In 1985, which country received more aid per capita, Afghanistan or Algeria?",
    "choices": [
      "Algeria",
      "Afghanistan"
    ],
    "answer": "Algeria",
    "unit": null,
    "table_title": "Aid received per capita from the U.S.",
    "table": "Country | 1985 | 1995\nAlgeria | $8 | $11\nAfghanistan | $1 | $10\nLibya | $1 | $1\nPakistan | $8 | $7",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the 1985 column. Compare the numbers in this column for Afghanistan and Algeria.\n\n$8.00 is more than $1.00. In 1985, Algeria received more aid per capita.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "38343",
    "path": "data"
  },
  {
    "question": "Some farmers compared how many tractors they own. What is the mode of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Tractors",
    "table": "Farmer | Number of tractors\nFarmer Rob | 4\nFarmer John | 2\nFarmer Judy | 2\nFarmer Megan | 7\nFarmer Joe | 7\nFarmer Jane | 14\nFarmer Alex | 7\nFarmer Walt | 14",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n4, 2, 2, 7, 7, 14, 7, 14\n\nFirst, arrange the numbers from least to greatest:\n\n2, 2, 4, 7, 7, 7, 14, 14\n\nNow count how many times each number appears.\n\n2 appears 2 times.\n4 appears 1 time.\n7 appears 3 times.\n14 appears 2 times.\n\nThe number that appears most often is 7.\n\nThe mode is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "1773",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "nonlinear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n10 | 15\n11 | 9\n12 | 2",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{9 - 15}{11 - 10}\n = \\frac{-6}{1}\n = -6\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{2 - 15}{12 - 10}\n = \\frac{-13}{2}\n = -6\\frac{1}{2}\nThe rate of change is not the same for each pair of points. So, the function does not have a constant rate of change.\nThe function is nonlinear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "33",
    "path": "data"
  },
  {
    "question": "Bernard recalled how many goals he had made in soccer practice each day. What is the range of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Goals made",
    "table": "Day | Number of goals\nTuesday | 3\nWednesday | 1\nThursday | 7\nFriday | 4\nSaturday | 1\nSunday | 4\nMonday | 3",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n3, 1, 7, 4, 1, 4, 3\n\nFirst, find the greatest number. The greatest number is 7.\n\nNext, find the least number. The least number is 1.\n\nSubtract the least number from the greatest number:\n\n7 \u2212 1 = 6\n\nThe range is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "27646",
    "path": "data"
  },
  {
    "question": "A dietitian noted the number of apples eaten by his clients last week. How many clients ate more than 1 apple last week?",
    "choices": null,
    "answer": "16",
    "unit": null,
    "table_title": "Eating apples last week",
    "table": "Apples eaten | Frequency\n0 | 1\n1 | 14\n2 | 12\n3 | 4",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the rows for 2 and 3 apples last week. Add the frequencies for these rows.\n\nAdd:\n\n12 + 4 = 16\n\n16 clients ate more than 1 apple last week.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "7963",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $1,355, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$995 | 17,200 | 1,000\n$1,115 | 15,000 | 4,800\n$1,235 | 12,800 | 8,600\n$1,355 | 10,600 | 12,400\n$1,475 | 8,400 | 16,200",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $1,355, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "12186",
    "path": "data"
  },
  {
    "question": "Maria counted the pages in each book on her English class's required reading list. What is the largest number of pages?",
    "choices": null,
    "answer": "90",
    "unit": "pages",
    "table_title": "Pages per book",
    "table": "Stem | Leaf \n5 | 3, 3\n6 | 8, 9\n7 | 2, 4\n8 | 7, 7\n9 | 0, 0, 0",
    "row_num": 6,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe largest number of pages has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe largest number of pages is 90 pages.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "3710",
    "path": "data"
  },
  {
    "question": "Percy's class recorded how many states each student has visited. What is the range of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "States visited",
    "table": "Name | Number of states\nPercy | 10\nKenneth | 6\nEthan | 7\nTina | 7\nHassan | 6\nColleen | 7\nLarry | 3",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 6, 7, 7, 6, 7, 3\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 3 = 7\n\nThe range is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "24406",
    "path": "data"
  },
  {
    "question": "A reporter looked through her notebook to remember how many people she had interviewed in the past 5 days. What is the range of the numbers?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "People interviewed",
    "table": "Day | Number of people\nSunday | 28\nMonday | 27\nTuesday | 27\nWednesday | 28\nThursday | 26",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n28, 27, 27, 28, 26\n\nFirst, find the greatest number. The greatest number is 28.\n\nNext, find the least number. The least number is 26.\n\nSubtract the least number from the greatest number:\n\n28 \u2212 26 = 2\n\nThe range is 2.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "32515",
    "path": "data"
  },
  {
    "question": "Some friends played a trivia game and recorded their scores. What is the range of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Trivia game scores",
    "table": "Name | Score\nLara | 4\nBrendan | 3\nCara | 3\nShannon | 1\nKelsey | 4\nHector | 3",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n4, 3, 3, 1, 4, 3\n\nFirst, find the greatest number. The greatest number is 4.\n\nNext, find the least number. The least number is 1.\n\nSubtract the least number from the greatest number:\n\n4 \u2212 1 = 3\n\nThe range is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "19338",
    "path": "data"
  },
  {
    "question": "A museum curator counted the number of paintings in each exhibit at the art museum. How many exhibits have at least 52 paintings but fewer than 69 paintings?",
    "choices": null,
    "answer": "4",
    "unit": "exhibits",
    "table_title": "Paintings per exhibit",
    "table": "Stem | Leaf \n3 | 4\n4 | 6\n5 | 3\n6 | 0, 1, 5\n7 | 5, 5\n8 | 1, 2, 4, 5, 6, 8",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row with stem 5. Count all the leaves greater than or equal to 2.\n\nIn the row with stem 6, count all the leaves less than 9.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plots above. 4 exhibits have at least 52 paintings but fewer than 69 paintings.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "11959",
    "path": "data"
  },
  {
    "question": "Look at Keenan's pay stub. Keenan lives in a state without state income tax. How much payroll tax did Keenan pay in total?",
    "choices": null,
    "answer": "163.43",
    "unit": "$",
    "table_title": null,
    "table": "Employee | Pay period |\nKeenan McIntyre | May 20-26 |\nTotal earnings | | $820.00\nFederal income tax | $100.70 |\nOther taxes | $62.73 |\nTotal taxes | | ?\nPay after taxes | | ?",
    "row_num": 7,
    "column_num": 3,
    "solution": "To find the total payroll tax, add the federal income tax and the other taxes.\nThe federal income tax is $100.70. The other taxes are $62.73. Add.\n$100.70 + $62.73 = $163.43\nKeenan paid a total of $163.43 in payroll tax.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "8068",
    "path": "data"
  },
  {
    "question": "A pizza chef recalled how many pizzas she had made during the past 4 days. On which day did the chef make the fewest pizzas?",
    "choices": [
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday"
    ],
    "answer": "Tuesday",
    "unit": null,
    "table_title": "Pizzas made",
    "table": "Day | Number of pizzas\nSunday | 96\nMonday | 94\nTuesday | 91\nWednesday | 97",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 91.\n\nNow find the corresponding day. Tuesday corresponds to 91.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "31008",
    "path": "data"
  },
  {
    "question": "While doing a project for P. E. class, Debbie researched the number of athletes competing in an international sporting event. How many countries have at least 40 athletes?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Athletes per country",
    "table": "Stem | Leaf \n4 | 3, 3, 6\n5 | 0, 3\n6 | \n7 | 7, 8",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 4, 5, 6, and 7.\n\nYou counted 7 leaves, which are blue in the stem-and-leaf plot above. 7 countries have at least 40 athletes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "9381",
    "path": "data"
  },
  {
    "question": "Lindsey counted the number of articles in several different magazines. How many magazines had at least 14 articles?",
    "choices": null,
    "answer": "9",
    "unit": "magazines",
    "table_title": "Articles per magazine",
    "table": "Stem | Leaf \n1 | 0, 2, 8, 8\n2 | 1, 1, 5, 6\n3 | 1, 7\n4 | 2",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the row with stem 1. Count all the leaves greater than or equal to 4.\n\nCount all the leaves in the rows with stems 2, 3, and 4.\n\nYou counted 9 leaves, which are blue in the stem-and-leaf plots above. 9 magazines had at least 14 articles.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "6643",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. At which stop does the train arrive at 5.25 A.M.?",
    "choices": [
      "Magician Village",
      "Floral Gardens",
      "Happy Cow Farm",
      "Gecko Paradise"
    ],
    "answer": "Floral Gardens",
    "unit": null,
    "table_title": "Train schedule",
    "table": "Location | Arrive | Depart\nMagician Village | 4:15 A.M. | 4:45 A.M.\nFloral Gardens | 5:25 A.M. | 5:55 A.M.\nChickenville | 6:40 A.M. | 7:05 A.M.\nGecko Paradise | 8:05 A.M. | 8:15 A.M.\nHappy Cow Farm | 8:50 A.M. | 9:00 A.M.\nPleasant River Campground | 10:00 A.M. | 10:10 A.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find 5:25 A. M. on the schedule. The train arrives at Floral Gardens at 5:25 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "32818",
    "path": "data"
  },
  {
    "question": "Sandeep, a journalism student, counted the number of pages in several major magazines. What is the largest number of pages?",
    "choices": null,
    "answer": "90",
    "unit": "pages",
    "table_title": "Pages per magazine",
    "table": "Stem | Leaf \n1 | 2, 3\n2 | 1\n3 | 2, 3, 7, 9\n4 | 6\n5 | 3, 9\n6 | 5, 6, 8\n7 | 1, 9\n8 | \n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe largest number of pages has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe largest number of pages is 90 pages.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "13956",
    "path": "data"
  },
  {
    "question": "The manager of a party supply store researched how many balloons it sold in the past 4 days. On which day did the store sell the most balloons?",
    "choices": [
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday"
    ],
    "answer": "Friday",
    "unit": null,
    "table_title": "Balloons sold",
    "table": "Day | Number of balloons\nWednesday | 145\nThursday | 151\nFriday | 154\nSaturday | 111",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 154.\n\nNow find the corresponding day. Friday corresponds to 154.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "2351",
    "path": "data"
  },
  {
    "question": "The city recorded how many fire hydrants there are on each street. What is the mean of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Fire hydrants",
    "table": "Street | Number of hydrants\nPine Street | 2\nOak Street | 4\nAspen Street | 1\nFir Street | 4\nCedar Street | 4",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 4, 1, 4, 4\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n2 + 4 + 1 + 4 + 4 = 15\n\nNow divide the sum by the number of numbers:\n\n15 \u00f7 5 = 3\n\nThe mean is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "26640",
    "path": "data"
  },
  {
    "question": "For a math assignment, Russell researched the scores of the people competing on his favorite quiz show. How many people scored at least 75 points but fewer than 93 points?",
    "choices": null,
    "answer": "4",
    "unit": "people",
    "table_title": "Quiz show scores",
    "table": "Stem | Leaf \n1 | 1\n2 | \n3 | \n4 | 5, 6\n5 | 4\n6 | \n7 | 3, 8, 9\n8 | 3\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Find the row with stem 7. Count all the leaves greater than or equal to 5.\n\nCount all the leaves in the row with stem 8.\n\nIn the row with stem 9, count all the leaves less than 3.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plots above. 4 people scored at least 75 points but fewer than 93 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "5265",
    "path": "data"
  },
  {
    "question": "The city library monitored the number of books checked out each day. What is the mean of the numbers?",
    "choices": null,
    "answer": "55",
    "unit": null,
    "table_title": "Books checked out",
    "table": "Day | Number of books\nMonday | 46\nTuesday | 55\nWednesday | 58\nThursday | 53\nFriday | 57\nSaturday | 61",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n46, 55, 58, 53, 57, 61\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n46 + 55 + 58 + 53 + 57 + 61 = 330\n\nNow divide the sum by the number of numbers:\n\n330 \u00f7 6 = 55\n\nThe mean is 55.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "7244",
    "path": "data"
  },
  {
    "question": "A beauty salon in Stafford has three beauticians and keeps track of how often clients request each one specifically. What fraction of requests were for Felipe? Simplify your answer.",
    "choices": null,
    "answer": "93/206",
    "unit": null,
    "table_title": "Beautician requests",
    "table": "Beautician | Requests\nHansen | 200\nFelipe | 930\nBritney | 930",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find how many clients requested Felipe.\n\n930\n\nFind how many requests were made in total.\n\n200 + 930 + 930 = 2,060\n\nDivide 930 by2,060.\n\n\\frac{930}{2,060}\n\nReduce the fraction.\n\n\\frac{930}{2,060} \u2192 \\frac{93}{206}\n\n\\frac{93}{206} of clients requested Felipe.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "26946",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the engine demonstration end?",
    "choices": [
      "6:05 P.M.",
      "11:35 A.M.",
      "1:20 P.M.",
      "4:00 P.M."
    ],
    "answer": "1:20 P.M.",
    "unit": null,
    "table_title": "Science museum schedule",
    "table": "Event | Begin | End\nmedicine lecture | 10:15 A.M. | 11:35 A.M.\nengine demonstration | 11:05 A.M. | 1:20 P.M.\ngravity lecture | 12:55 P.M. | 2:20 P.M.\ndinosaur show | 1:55 P.M. | 2:35 P.M.\nreptile show | 2:00 P.M. | 4:00 P.M.\ntrain lecture | 3:45 P.M. | 4:55 P.M.\nnutrition lecture | 4:40 P.M. | 6:05 P.M.",
    "row_num": 8,
    "column_num": 3,
    "solution": "Find the engine demonstration on the schedule. Find the end time for the engine demonstration.\n\nengine demonstration: 1:20 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "2008",
    "path": "data"
  },
  {
    "question": "Maddie is shopping for a new bicycle. She is most interested in color and type of tires. What is the probability that a randomly selected bike has road bike tires and is red? Simplify any fractions.",
    "choices": null,
    "answer": "1/10",
    "unit": null,
    "table_title": null,
    "table": " | Red | Green\nRoad bike tires | 1 | 2\nMountain bike tires | 3 | 4",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the bike has road bike tires\" and B be the event \"the bike is red\".\nTo find the probability that a bike has road bike tires and is red, first identify the sample space and the event.\nThe outcomes in the sample space are the different bikes. Each bike is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the bike has road bike tires and is red\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the bike has road bike tires and is red\", so look at the table to see how many bikes have road bike tires and are a red.\nThe number of bikes that have road bike tires and are a red is 1.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of bikes.\n1 + 3 + 2 + 4 = 10\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{1}{10}\nThe probability that a bike has road bike tires and is red is \\frac{1}{10}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "14902",
    "path": "data"
  },
  {
    "question": "In a study on public parking, the director of transportation counted the number of cars in each of the city's parking lots. How many parking lots had at least 60 cars but fewer than 65 cars?",
    "choices": null,
    "answer": "4",
    "unit": "parking lots",
    "table_title": "Cars per parking lot",
    "table": "Stem | Leaf \n4 | 3, 5, 7, 9, 9\n5 | 7, 7, 8, 9\n6 | 0, 2, 2, 4, 7\n7 | 2, 4",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the row with stem 6. Count all the leaves greater than or equal to 0 and less than 5.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plot above. 4 parking lots had at least 60 cars but fewer than 65 cars.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "30972",
    "path": "data"
  },
  {
    "question": "As part of a statistics project, a math class weighed all the children who were willing to participate. How many children weighed at least 22 pounds?",
    "choices": null,
    "answer": "19",
    "unit": "children",
    "table_title": "Children's weights (lbs)",
    "table": "Stem | Leaf \n1 | 4, 4, 5, 6, 7\n2 | 6, 6, 8, 9\n3 | 2, 4, 5, 9\n4 | 0, 6, 9\n5 | 1, 3, 7, 7, 8\n6 | 0, 1, 7",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row with stem 2. Count all the leaves greater than or equal to 2.\n\nCount all the leaves in the rows with stems 3, 4, 5, and 6.\n\nYou counted 19 leaves, which are blue in the stem-and-leaf plots above. 19 children weighed at least 22 pounds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "35070",
    "path": "data"
  },
  {
    "question": "Diego went to the store and bought 2/5 of a kilogram of duck. How much did he spend?",
    "choices": null,
    "answer": "1.60",
    "unit": "$",
    "table_title": null,
    "table": "ham | $2/kg\nduck | $4/kg\npork | $3/kg\nchicken | $3/kg\nbeef | $4/kg",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the duck. Multiply the price per kilogram by the number of kilograms.\n$4 \u00d7 \\frac{2}{5} = $4 \u00d7 0.4 = $1.60\nHe spent $1.60.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "5572",
    "path": "data"
  },
  {
    "question": "The players on a quiz show received the following scores. Who had the lowest score?",
    "choices": [
      "Vicky",
      "Jonah",
      "Lexi",
      "Farid"
    ],
    "answer": "Jonah",
    "unit": null,
    "table_title": "Quiz show scores",
    "table": "Name | Score\nVicky | 661\nJonah | 612\nLexi | 621\nFarid | 628",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 612.\n\nNow find the corresponding name. Jonah corresponds to 612.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "2962",
    "path": "data"
  },
  {
    "question": "How much more does a mop cost than a measuring tape?",
    "choices": null,
    "answer": "1.15",
    "unit": "$",
    "table_title": null,
    "table": "broom | $11.51\nmop | $15.74\nmeasuring tape | $14.59\ncan of paint | $12.04",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a measuring tape from the price of a mop.\n\n$15.74 - $14.59 = $1.15\n\nA mop costs $1.15 more than a measuring tape.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "29297",
    "path": "data"
  },
  {
    "question": "After a scavenger hunt, a team counted the number of pine cones found by each of its members. How many people are there in all?",
    "choices": null,
    "answer": "36",
    "unit": null,
    "table_title": "Finding pine cones",
    "table": "Pine cones found | Frequency\n1 | 9\n2 | 5\n3 | 8\n4 | 7\n5 | 1\n6 | 6",
    "row_num": 7,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n9 + 5 + 8 + 7 + 1 + 6 = 36\n\nThere are 36 people in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "16414",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $730, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$630 | 20,200 | 10,200\n$680 | 15,600 | 13,000\n$730 | 11,000 | 15,800\n$780 | 6,400 | 18,600\n$830 | 1,800 | 21,400",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $730, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "23843",
    "path": "data"
  },
  {
    "question": "An actor was informed how many fan letters he received each day. On which day were the most fan letters received?",
    "choices": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday"
    ],
    "answer": "Monday",
    "unit": null,
    "table_title": "Fan letters received",
    "table": "Day | Number of fan letters\nMonday | 887\nTuesday | 857\nWednesday | 858\nThursday | 875",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 887.\n\nNow find the corresponding day. Monday corresponds to 887.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "33406",
    "path": "data"
  },
  {
    "question": "How much money does Gabrielle need to buy a piece of gum, a lemon drop, and a cinnamon candy?",
    "choices": null,
    "answer": "0.13",
    "unit": "$",
    "table_title": null,
    "table": "cinnamon candy | $0.05\ngummy bear | $0.03\npeppermint candy | $0.01\ngum drop | $0.07\nlemon drop | $0.07\npiece of gum | $0.01",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of a piece of gum, a lemon drop, and a cinnamon candy.\n\n$0.01 + $0.07 + $0.05 = $0.13\n\nGabrielle needs $0.13.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "24478",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Nora just missed the 10.15 A.M. ferry at Beach Town. What time is the next ferry?",
    "choices": [
      "12:15 P.M.",
      "12:45 P.M.",
      "8:00 A.M.",
      "11:00 A.M."
    ],
    "answer": "11:00 A.M.",
    "unit": null,
    "table_title": "Ferry schedule",
    "table": "Foggy Port | 6:00 A.M. | 7:15 A.M. | 8:00 A.M.\nRocky Port | 7:45 A.M. | 9:00 A.M. | 9:45 A.M.\nBeach Town | 9:00 A.M. | 10:15 A.M. | 11:00 A.M.\nStarfish City | 10:45 A.M. | 12:00 P.M. | 12:45 P.M.\nGrassy Beach | 12:15 P.M. | 1:30 P.M. | 2:15 P.M.\nWindy Sands | 2:00 P.M. | 3:15 P.M. | 4:00 P.M.\nCliff View | 3:15 P.M. | 4:30 P.M. | 5:15 P.M.\nPebble Town | 5:00 P.M. | 6:15 P.M. | 7:00 P.M.",
    "row_num": 8,
    "column_num": 4,
    "solution": "Find 10:15 A. M. in the row for Beach Town.\n\nLook for the next ferry in that row.\n\nThe next ferry is at 11:00 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "32474",
    "path": "data"
  },
  {
    "question": "Each gym locker has 10 volleyballs. How many volleyballs are in 6 gym lockers?",
    "choices": null,
    "answer": "60",
    "unit": null,
    "table_title": null,
    "table": "Number of gym lockers | Number of volleyballs\n1 | 10\n2 | 20\n3 | 30\n4 | 40\n5 | 50\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 60 volleyballs in 6 gym lockers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "5422",
    "path": "data"
  },
  {
    "question": "How much would it cost to buy 2+9/10 kilograms of pine nuts?",
    "choices": null,
    "answer": "14.50",
    "unit": "$",
    "table_title": null,
    "table": "peanuts | $4 per kilogram\nBrazil nuts | $4 per kilogram\npistachios | $5 per kilogram\npine nuts | $5 per kilogram\nchestnuts | $3 per kilogram\nmacadamia nuts | $4 per kilogram",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the pine nuts. Multiply the price per kilogram by the number of kilograms.\n$5 \u00d7 2\\frac{9}{10} = $5 \u00d7 2.9 = $14.50\nIt would cost $14.50.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "12474",
    "path": "data"
  },
  {
    "question": "A baker wrote down how many pies she made in the past 4 days. On which day did the baker make the fewest pies?",
    "choices": [
      "Friday",
      "Saturday",
      "Sunday",
      "Monday"
    ],
    "answer": "Monday",
    "unit": null,
    "table_title": "Pies baked",
    "table": "Day | Number of pies\nFriday | 24\nSaturday | 28\nSunday | 23\nMonday | 22",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 22.\n\nNow find the corresponding day. Monday corresponds to 22.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "2983",
    "path": "data"
  },
  {
    "question": "Cameron buys 2.7 pounds of dark brown sugar. How much does he spend?",
    "choices": null,
    "answer": "16.20",
    "unit": "$",
    "table_title": null,
    "table": "agave syrup | $6/pound\ngranulated sugar | $6/pound\nmaple syrup | $7/pound\npowdered sugar | $4/pound\nlight brown sugar | $5/pound\ndark brown sugar | $6/pound",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the dark brown sugar. Multiply the price per pound by the number of pounds.\n$6 \u00d7 2.7 = $16.20\nHe spends $16.20.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "38364",
    "path": "data"
  },
  {
    "question": "How much money does Ian need to buy a ticket for an Alaskan cruise and a ticket for an Australian cruise?",
    "choices": null,
    "answer": "767",
    "unit": "$",
    "table_title": null,
    "table": "ticket for a Mediterranean cruise | $484\nticket for an Alaskan cruise | $125\nticket for a Hawaiian cruise | $169\nticket for an Australian cruise | $642",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a ticket for an Alaskan cruise and the price of a ticket for an Australian cruise:\n\n$125 + $642 = $767\n\nIan needs $767.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "810",
    "path": "data"
  },
  {
    "question": "At Lakeside Consulting, the head of human resources examined how the number of employees with health care benefits varied in response to policy changes. According to the table, what was the rate of change between 2015 and 2016?",
    "choices": null,
    "answer": "-12",
    "unit": "employees per year",
    "table_title": "Employees with health care benefits",
    "table": "Year | Employees\n2013 | 22\n2014 | 33\n2015 | 32\n2016 | 20\n2017 | 17",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{20 employees - 32 employees}{2016 - 2015}\n = \\frac{20 employees - 32 employees}{1 year}\n = \\frac{-12 employees}{1 year}\n = -12 employees per year\nThe rate of change between 2015 and 2016 was - 12 employees per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "4896",
    "path": "data"
  },
  {
    "question": "Sixth graders at Richmond Middle School are taught in classes of various sizes. How many more boys than girls are in Mrs. South's class?",
    "choices": null,
    "answer": "2",
    "unit": "boys",
    "table_title": "Sixth grade classes",
    "table": "Teacher | Boys | Girls\nMr. Center | 16 | 11\nMiss West | 9 | 17\nMs. North | 11 | 5\nMrs. South | 14 | 12\nMr. East | 10 | 6",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Mrs. South row. Find the numbers in this row for boys and girls.\n\nboys: 14\ngirls: 12\n\nNow subtract:\n\n14 \u2212 12 = 2\n\n2 more boys than girls are in Mrs. South's class.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "14154",
    "path": "data"
  },
  {
    "question": "Nicholas, an aspiring meteorologist, spent the past few weekends studying the clouds. He took detailed notes on the types of clouds observed and the time of day they were observed. What is the probability that a randomly selected cloud was observed in the afternoon and was marked as stratocumulus? Simplify any fractions.",
    "choices": null,
    "answer": "1/4",
    "unit": null,
    "table_title": null,
    "table": " | Stratocumulus | Stratus\nMorning | 1 | 6\nAfternoon | 4 | 5",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the cloud was observed in the afternoon\" and B be the event \"the cloud was marked as stratocumulus\".\nTo find the probability that a cloud was observed in the afternoon and was marked as stratocumulus, first identify the sample space and the event.\nThe outcomes in the sample space are the different clouds. Each cloud is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the cloud was observed in the afternoon and was marked as stratocumulus\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the cloud was observed in the afternoon and was marked as stratocumulus\", so look at the table to see how many clouds were observed during the afternoon and were marked as stratocumulus.\nThe number of clouds that were observed during the afternoon and were marked as stratocumulus is 4.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of clouds.\n1 + 4 + 6 + 5 = 16\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{4}{16}\n = \\frac{1}{4}\nThe probability that a cloud was observed in the afternoon and was marked as stratocumulus is \\frac{1}{4}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "5560",
    "path": "data"
  },
  {
    "question": "A race car driver kept track of how many laps he drove in the past 5 days. What is the range of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Laps driven",
    "table": "Day | Number of laps\nThursday | 7\nFriday | 6\nSaturday | 9\nSunday | 9\nMonday | 5",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 6, 9, 9, 5\n\nFirst, find the greatest number. The greatest number is 9.\n\nNext, find the least number. The least number is 5.\n\nSubtract the least number from the greatest number:\n\n9 \u2212 5 = 4\n\nThe range is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "16372",
    "path": "data"
  },
  {
    "question": "An actor was informed how many fan letters he received each day. What is the mean of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Fan letters received",
    "table": "Day | Number of fan letters\nThursday | 5\nFriday | 5\nSaturday | 8\nMonday | 3\nTuesday | 4",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 5, 8, 3, 4\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n5 + 5 + 8 + 3 + 4 = 25\n\nNow divide the sum by the number of numbers:\n\n25 \u00f7 5 = 5\n\nThe mean is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "37389",
    "path": "data"
  },
  {
    "question": "A researcher recorded the number of cows on each farm in the county. How many farms have fewer than 69 cows?",
    "choices": null,
    "answer": "8",
    "unit": "farms",
    "table_title": "Cows per farm",
    "table": "Stem | Leaf \n5 | 0, 1, 2, 3, 4, 8\n6 | 3, 3, 9\n7 | 0, 1, 1, 5\n8 | 0, 2, 4, 4, 7\n9 | 0",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count all the leaves in the row with stem 5.\n\nIn the row with stem 6, count all the leaves less than 9.\n\nYou counted 8 leaves, which are blue in the stem-and-leaf plots above. 8 farms have fewer than 69 cows.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "8096",
    "path": "data"
  },
  {
    "question": "Mr. Osborne, a track coach, recorded the sizes of all the nearby track teams. What is the size of the largest team?",
    "choices": null,
    "answer": "90",
    "unit": "members",
    "table_title": "Track team sizes (number of members)",
    "table": "Stem | Leaf \n1 | 0, 0, 1, 1, 9\n2 | 2, 2, 8\n3 | 3, 7\n4 | 0, 7, 8\n5 | 4\n6 | 0\n7 | 1, 2, 4, 8\n8 | 0\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe size of the largest team has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe size of the largest team is 90 members.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "17455",
    "path": "data"
  },
  {
    "question": "Avery has $49.50. Does she have enough to buy an atlas and a photo album?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "atlas | $17.90\nencyclopedia | $25.23\nmap of Africa | $14.93\nairplane calendar | $14.42\nphoto album | $30.82\nbook of poems | $24.16",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of an atlas and the price of a photo album:\n\n$17.90 + $30.82 = $48.72\n\n$48.72 is less than $49.50. Avery does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 7,
    "split": "dev",
    "pid": "5331",
    "path": "data"
  },
  {
    "question": "Ann counted the number of peanuts in each bag of trail mix. What is the largest number of peanuts?",
    "choices": null,
    "answer": "58",
    "unit": "peanuts",
    "table_title": "Peanuts per bag of trail mix",
    "table": "Stem | Leaf \n1 | 0, 2, 4, 5, 7, 9, 9\n2 | 0, 2\n3 | 5, 9\n4 | 0, 2, 4\n5 | 0, 3, 4, 6, 8",
    "row_num": 6,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 5.\n\nNow find the highest leaf in the last row. The highest leaf is 8.\n\nThe largest number of peanuts has a stem of 5 and a leaf of 8. Write the stem first, then the leaf: 58.\n\nThe largest number of peanuts is 58 peanuts.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "16028",
    "path": "data"
  },
  {
    "question": "A taxi cab driver tracked how many miles he drove each month. How many miles did the taxi cab driver drive in total in April and May?",
    "choices": null,
    "answer": "15,123",
    "unit": "miles",
    "table_title": "Miles driven",
    "table": "Month | Miles\nApril | 8,428\nMay | 6,695\nJune | 3,260",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nApril: 8,428\nMay: 6,695\n\nNow add: 8,428 + 6,695 = 15,123.\n\nThe taxi cab driver drove 15,123 miles in April and May.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "14008",
    "path": "data"
  },
  {
    "question": "Each apartment has 2 lamps. How many lamps are in 4 apartments?",
    "choices": null,
    "answer": "8",
    "unit": "lamps",
    "table_title": null,
    "table": "Number of apartments | Number of lamps\n1 | 2\n2 | 4\n3 | 6\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 8 lamps in 4 apartments.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "2150",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $855, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$735 | 22,700 | 2,600\n$795 | 21,500 | 4,900\n$855 | 20,300 | 7,200\n$915 | 19,100 | 9,500\n$975 | 17,900 | 11,800",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $855, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "34801",
    "path": "data"
  },
  {
    "question": "An environmental agency examined how many trees were planted by different organizations. What is the mean of the numbers?",
    "choices": null,
    "answer": "98",
    "unit": null,
    "table_title": "Trees planted",
    "table": "Organization | Number of trees planted\nMission Reforestation | 99\nTrees for All | 100\nPlant It | 98\nDreaming Green | 96\nHeal the Earth | 96\nLet it Grow | 99\nNew Planet | 97\nAcorns to Oaks | 99",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n99, 100, 98, 96, 96, 99, 97, 99\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n99 + 100 + 98 + 96 + 96 + 99 + 97 + 99 = 784\n\nNow divide the sum by the number of numbers:\n\n784 \u00f7 8 = 98\n\nThe mean is 98.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "3706",
    "path": "data"
  },
  {
    "question": "As part of a statistics project, a math class weighed all the children who were willing to participate. How many children weighed at least 40 pounds but less than 60 pounds?",
    "choices": null,
    "answer": "8",
    "unit": "children",
    "table_title": "Children's weights (lbs)",
    "table": "Stem | Leaf \n2 | 5, 5\n3 | 2, 5, 8, 9\n4 | 0, 1, 3, 4, 6, 9\n5 | 1, 6\n6 | 1, 8",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 4 and 5.\n\nYou counted 8 leaves, which are blue in the stem-and-leaf plot above. 8 children weighed at least 40 pounds but less than 60 pounds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "18126",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $655, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$655 | 20,000 | 17,800\n$785 | 15,600 | 18,800\n$915 | 11,200 | 19,800\n$1,045 | 6,800 | 20,800\n$1,175 | 2,400 | 21,800",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $655, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "10913",
    "path": "data"
  },
  {
    "question": "This is Kira's complete financial record for April. How much money did Kira spend on a bag of jellybeans?",
    "choices": null,
    "answer": "4.15",
    "unit": "$",
    "table_title": null,
    "table": "Date | Description | Received | Expenses | Available Funds\n | Balance: end of March | | | $461.80\n4/7 | bag of jellybeans | | $4.15 | $457.65\n4/14 | helping Mr. Sandoval | $20.00 | | $477.65\n4/23 | umbrella | | $12.65 | $465.00",
    "row_num": 5,
    "column_num": 5,
    "solution": "Look at the bag of jellybeans row. The expenses were $4.15. So, Kira spent $4.15 on a bag of jellybeans.\n",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "18863",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "nonlinear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n15 | 6\n16 | 9\n17 | 17",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{9 - 6}{16 - 15}\n = \\frac{3}{1}\n = 3\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{17 - 6}{17 - 15}\n = \\frac{11}{2}\n = 5\\frac{1}{2}\nThe rate of change is not the same for each pair of points. So, the function does not have a constant rate of change.\nThe function is nonlinear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "29376",
    "path": "data"
  },
  {
    "question": "Carson paid attention to how many flowers he planted in the garden during the past 7 days. What is the range of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Flowers plants",
    "table": "Day | Number of flowers\nFriday | 4\nSaturday | 6\nSunday | 2\nMonday | 4\nTuesday | 2\nWednesday | 7\nThursday | 3",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n4, 6, 2, 4, 2, 7, 3\n\nFirst, find the greatest number. The greatest number is 7.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n7 \u2212 2 = 5\n\nThe range is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "13185",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n12 | 6\n13 | 12\n14 | 18",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{12 - 6}{13 - 12}\n = \\frac{6}{1}\n = 6\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{18 - 12}{14 - 13}\n = \\frac{6}{1}\n = 6\nThe two rates of change are the same.\nIf you checked the rate of change between rows 1 and 3, you would find that it is also 6.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "21199",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Johnny just missed the 10.30 A.M. train at Millersburg. How long does he have to wait until the next train?",
    "choices": [
      "1 hour",
      "15 minutes",
      "30 minutes",
      "45 minutes"
    ],
    "answer": "30 minutes",
    "unit": null,
    "table_title": "Train schedule",
    "table": "Salem | 7:00 A.M. | 7:15 A.M. | 8:15 A.M. | 8:30 A.M. | 9:00 A.M.\nMillersburg | 9:00 A.M. | 9:15 A.M. | 10:15 A.M. | 10:30 A.M. | 11:00 A.M.\nOak Grove | 9:45 A.M. | 10:00 A.M. | 11:00 A.M. | 11:15 A.M. | 11:45 A.M.\nHillsboro | 11:15 A.M. | 11:30 A.M. | 12:30 P.M. | 12:45 P.M. | 1:15 P.M.\nManchester | 1:00 P.M. | 1:15 P.M. | 2:15 P.M. | 2:30 P.M. | 3:00 P.M.",
    "row_num": 5,
    "column_num": 6,
    "solution": "Find 10:30 A. M. in the row for Millersburg.\n\nLook for the next train in that row.\n\nThe next train is at 11:00 A. M.\n\nFind the elapsed time. The elapsed time is 30 minutes.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 4,
    "split": "dev",
    "pid": "32737",
    "path": "data"
  },
  {
    "question": "Zach has $10.77. Does he have enough to buy a map of the United States and a map of the world?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "map of the United States | $3.64\nmath book | $7.00\nmap of the world | $7.28\nphoto album | $6.40\ndictionary | $6.33\nmystery novel | $3.26",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a map of the United States and the price of a map of the world:\n\n$3.64 + $7.28 = $10.92\n\n$10.92 is more than $10.77. Zach does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "23180",
    "path": "data"
  },
  {
    "question": "How much money does Rosa need to buy an oil painting and a silver coat rack?",
    "choices": null,
    "answer": "141",
    "unit": "$",
    "table_title": null,
    "table": "lamp | $73.00\ncrystal sculpture | $95.00\noil painting | $64.00\nsilver coat rack | $77.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of an oil painting and the price of a silver coat rack:\n\n$64.00 + $77.00 = $141.00\n\nRosa needs $141.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "17739",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $775, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$655 | 20,200 | 5,700\n$715 | 15,400 | 9,200\n$775 | 10,600 | 12,700\n$835 | 5,800 | 16,200\n$895 | 1,000 | 19,700",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $775, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "490",
    "path": "data"
  },
  {
    "question": "A video store clerk looked up the number of movies checked out each day. On which day were the most movies checked out?",
    "choices": [
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday"
    ],
    "answer": "Wednesday",
    "unit": null,
    "table_title": "Movies checked out",
    "table": "Day | Number of movies\nSunday | 319\nMonday | 339\nTuesday | 313\nWednesday | 391",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 391.\n\nNow find the corresponding day. Wednesday corresponds to 391.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "22401",
    "path": "data"
  },
  {
    "question": "David has $1,350.00. Does he have enough to buy a piccolo and a saxophone?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "keyboard | $402.00\nsaxophone | $988.00\nclarinet | $910.00\npiccolo | $435.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a piccolo and the price of a saxophone:\n\n$435.00 + $988.00 = $1,423.00\n\n$1,423.00 is more than $1,350.00. David does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 7,
    "split": "dev",
    "pid": "33542",
    "path": "data"
  },
  {
    "question": "A museum curator counted the number of paintings in each exhibit at the art museum. How many exhibits have fewer than 60 paintings?",
    "choices": null,
    "answer": "4",
    "unit": "exhibits",
    "table_title": "Paintings per exhibit",
    "table": "Stem | Leaf \n2 | 5\n3 | 8\n4 | 8\n5 | 0\n6 | 5, 9\n7 | \n8 | 0\n9 | 0",
    "row_num": 9,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 2, 3, 4, and 5.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plot above. 4 exhibits have fewer than 60 paintings.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "26395",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $1,055, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$665 | 18,000 | 7,000\n$795 | 16,500 | 9,200\n$925 | 15,000 | 11,400\n$1,055 | 13,500 | 13,600\n$1,185 | 12,000 | 15,800",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $1,055, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "3060",
    "path": "data"
  },
  {
    "question": "Becky has $30.50. Does she have enough to buy a book about music and a book about basketball?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "book about reptiles | $23.18\nbook about birds | $14.44\nbook about fish | $20.15\nbook about basketball | $19.90\nbook about music | $11.26\nbook about art | $20.78",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a book about music and the price of a book about basketball:\n\n$11.26 + $19.90 = $31.16\n\n$31.16 is more than $30.50. Becky does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "30028",
    "path": "data"
  },
  {
    "question": "A hardware store monitored how many hammers it sold in the past 7 days. What is the median of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Hammers sold",
    "table": "Day | Number of hammers\nMonday | 2\nTuesday | 8\nWednesday | 10\nThursday | 2\nFriday | 4\nSaturday | 4\nSunday | 4",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 8, 10, 2, 4, 4, 4\n\nFirst, arrange the numbers from least to greatest:\n\n2, 2, 4, 4, 4, 8, 10\n\nNow find the number in the middle.\n\n2, 2, 4, 4, 4, 8, 10\n\nThe number in the middle is 4.\n\nThe median is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "36401",
    "path": "data"
  },
  {
    "question": "Amanda and her brother are at a store shopping for a beanbag chair for their school's library. The store sells beanbag chairs with different fabrics and types of filling. What is the probability that a randomly selected beanbag chair is filled with beads and is made from suede? Simplify any fractions.",
    "choices": null,
    "answer": "5/19",
    "unit": null,
    "table_title": null,
    "table": " | Velvet | Suede\nFoam | 6 | 6\nBeads | 2 | 5",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the beanbag chair is filled with beads\" and B be the event \"the beanbag chair is made from suede\".\nTo find the probability that a beanbag chair is filled with beads and is made from suede, first identify the sample space and the event.\nThe outcomes in the sample space are the different beanbag chairs. Each beanbag chair is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the beanbag chair is filled with beads and is made from suede\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the beanbag chair is filled with beads and is made from suede\", so look at the table to see how many beanbag chairs are filled with beads and are made from suede.\nThe number of beanbag chairs that are filled with beads and are made from suede is 5.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of beanbag chairs.\n6 + 2 + 6 + 5 = 19\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{5}{19}\nThe probability that a beanbag chair is filled with beads and is made from suede is \\frac{5}{19}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "29150",
    "path": "data"
  },
  {
    "question": "Craig has $1.40. Does he have enough to buy a purple clam shell and a spiral snail shell?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "whole sand dollar | $0.68\nbeautiful yellow shell | $0.46\nspiral snail shell | $0.73\npurple clam shell | $0.75",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a purple clam shell and the price of a spiral snail shell:\n\n$0.75 + $0.73 = $1.48\n\n$1.48 is more than $1.40. Craig does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 7,
    "split": "dev",
    "pid": "31399",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the track meet end?",
    "choices": [
      "8:10 P.M.",
      "5:50 P.M.",
      "3:40 P.M.",
      "8:35 P.M."
    ],
    "answer": "8:35 P.M.",
    "unit": null,
    "table_title": "University sports schedule",
    "table": "Event | Begin | End\nwomen's tennis match | 12:55 P.M. | 3:40 P.M.\nmen's tennis match | 3:20 P.M. | 5:50 P.M.\nsoftball game | 4:55 P.M. | 8:10 P.M.\ntrack meet | 7:10 P.M. | 8:35 P.M.\nbaseball game | 9:05 P.M. | 10:15 P.M.",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the track meet on the schedule. Find the end time for the track meet.\n\ntrack meet: 8:35 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "34741",
    "path": "data"
  },
  {
    "question": "How much would it cost to buy 1/10 of a pound of pimento olives?",
    "choices": null,
    "answer": "0.70",
    "unit": "$",
    "table_title": null,
    "table": "pimento olives | $7/pound\nSpanish olives | $7/pound\ngreen olives | $7/pound\nKalamata olives | $7/pound\nblack olives | $4/pound\nGreek olives | $3/pound",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the pimento olives. Multiply the price per pound by the number of pounds.\n$7 \u00d7 \\frac{1}{10} = $7 \u00d7 0.1 = $0.70\nIt would cost $0.70.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "26483",
    "path": "data"
  },
  {
    "question": "A newspaper researched how many grocery stores there are in each town. What is the mode of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Grocery stores in each town",
    "table": "Town | Number of stores\nRichmond | 6\nAshland | 8\nSpringfield | 6\nColumbia | 6\nMarion | 8\nRiverside | 4\nSalem | 4\nGreenwood | 6",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 8, 6, 6, 8, 4, 4, 6\n\nFirst, arrange the numbers from least to greatest:\n\n4, 4, 6, 6, 6, 6, 8, 8\n\nNow count how many times each number appears.\n\n4 appears 2 times.\n6 appears 4 times.\n8 appears 2 times.\n\nThe number that appears most often is 6.\n\nThe mode is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "27427",
    "path": "data"
  },
  {
    "question": "Bryce jotted down how many baskets he made during basketball practice each day. What is the median of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Baskets made",
    "table": "Day | Number of baskets\nFriday | 9\nSaturday | 7\nSunday | 6\nMonday | 5\nTuesday | 2",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 7, 6, 5, 2\n\nFirst, arrange the numbers from least to greatest:\n\n2, 5, 6, 7, 9\n\nNow find the number in the middle.\n\n2, 5, 6, 7, 9\n\nThe number in the middle is 6.\n\nThe median is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "18050",
    "path": "data"
  },
  {
    "question": "Liz has $31. Does she have enough to buy a lawn sprinkler and a watering can?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "wrench | $11\ngarden hose | $17\nlawn sprinkler | $19\nwatering can | $10\nhammer | $12",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a lawn sprinkler and the price of a watering can:\n\n$19 + $10 = $29\n\n$29 is less than $31. Liz does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "29838",
    "path": "data"
  },
  {
    "question": "The town council reported on how many stop signs there are on each street. What is the median of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Stop signs",
    "table": "Street | Number of stop signs\nMarshall Street | 2\nMason Street | 2\nIrving Street | 6\nSmith Street | 5\nPeabody Street | 7\nJackson Street | 8\nWatson Street | 4",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 2, 6, 5, 7, 8, 4\n\nFirst, arrange the numbers from least to greatest:\n\n2, 2, 4, 5, 6, 7, 8\n\nNow find the number in the middle.\n\n2, 2, 4, 5, 6, 7, 8\n\nThe number in the middle is 5.\n\nThe median is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "8441",
    "path": "data"
  },
  {
    "question": "Each year, the campers at Mia's summer camp try to set that summer's record for finishing the obstacle course as quickly as possible. According to the table, what was the rate of change between 2018 and 2019?",
    "choices": null,
    "answer": "-3",
    "unit": "minutes per year",
    "table_title": "Record obstacle course completion times",
    "table": "Year | Record time (minutes)\n2015 | 27\n2016 | 28\n2017 | 29\n2018 | 27\n2019 | 24",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{24 minutes - 27 minutes}{2019 - 2018}\n = \\frac{24 minutes - 27 minutes}{1 year}\n = \\frac{-3 minutes}{1 year}\n = -3 minutes per year\nThe rate of change between 2018 and 2019 was - 3 minutes per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "34900",
    "path": "data"
  },
  {
    "question": "Each desk has 10 notepads. How many notepads are on 4 desks?",
    "choices": null,
    "answer": "40",
    "unit": null,
    "table_title": null,
    "table": "Number of desks | Number of notepads\n1 | 10\n2 | 20\n3 | 30\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 40 notepads on 4 desks.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "36710",
    "path": "data"
  },
  {
    "question": "A dog show enthusiast recorded the weight of the winning dog at recent dog shows. According to the table, what was the rate of change between 2020 and 2021?",
    "choices": null,
    "answer": "22",
    "unit": "kilograms per year",
    "table_title": "Weight of winning dog at a dog show",
    "table": "Year | Weight (kg)\n2017 | 40\n2018 | 31\n2019 | 5\n2020 | 16\n2021 | 38",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{38 kilograms - 16 kilograms}{2021 - 2020}\n = \\frac{38 kilograms - 16 kilograms}{1 year}\n = \\frac{22 kilograms}{1 year}\n = 22 kilograms per year\nThe rate of change between 2020 and 2021 was 22 kilograms per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "17684",
    "path": "data"
  },
  {
    "question": "Marco buys 1.8 pounds of peanuts. How much does he spend?",
    "choices": null,
    "answer": "14.40",
    "unit": "$",
    "table_title": null,
    "table": "Brazil nuts | $5 per pound\npistachios | $11 per pound\npeanuts | $8 per pound\npine nuts | $8 per pound\nmacadamia nuts | $6 per pound",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the peanuts. Multiply the price per pound by the number of pounds.\n$8 \u00d7 1.8 = $14.40\nHe spends $14.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "24694",
    "path": "data"
  },
  {
    "question": "How much more does a book about basketball cost than a book about fish?",
    "choices": null,
    "answer": "10.33",
    "unit": "$",
    "table_title": null,
    "table": "book about fish | $12.76\nbook about baseball | $22.07\nbook about dinosaurs | $20.45\nbook about basketball | $23.09",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a book about fish from the price of a book about basketball.\n\n$23.09 - $12.76 = $10.33\n\nA book about basketball costs $10.33 more than a book about fish.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "12424",
    "path": "data"
  },
  {
    "question": "Some players on a co-ed basketball team compared the total number of points they scored over the course of a year. What fraction of the points were scored by Miguel? Simplify your answer.",
    "choices": null,
    "answer": "10/39",
    "unit": null,
    "table_title": "Points scored in basketball",
    "table": "Player | Points scored\nMiguel | 100\nSadie | 180\nOther | 110",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find how many points Miguel scored.\n\n100\n\nFind how many points the players scored in total.\n\n100 + 180 + 110 = 390\n\nDivide 100 by 390.\n\n\\frac{100}{390}\n\nReduce the fraction.\n\n\\frac{100}{390} \u2192 \\frac{10}{39}\n\n\\frac{10}{39} of points Miguel scored.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "15698",
    "path": "data"
  },
  {
    "question": "Nora went to the store. She bought 4.4 pounds of guacamole. How much did she spend?",
    "choices": null,
    "answer": "8.80",
    "unit": "$",
    "table_title": null,
    "table": "hummus | $4 per pound\ndill dip | $2 per pound\nguacamole | $2 per pound\nonion dip | $2 per pound",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the guacamole. Multiply the price per pound by the number of pounds.\n$2 \u00d7 4.4 = $8.80\nShe spent $8.80.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "22084",
    "path": "data"
  },
  {
    "question": "Some students compared how many blocks they live from school. Who lives the closest to school?",
    "choices": [
      "Garrett",
      "Jason",
      "Quincy",
      "Matt"
    ],
    "answer": "Jason",
    "unit": null,
    "table_title": "Blocks from school",
    "table": "Name | Number of blocks\nGarrett | 19\nJason | 14\nQuincy | 15\nMatt | 16",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 14.\n\nNow find the corresponding name. Jason corresponds to 14.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "33680",
    "path": "data"
  },
  {
    "question": "Jayla has $16,679. Does she have enough to buy a high-tech desktop and a business laptop?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "high-tech desktop | $6,604\nwide-screen desktop | $1,487\nbusiness laptop | $9,455\nwide-screen laptop | $6,530",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a high-tech desktop and the price of a business laptop:\n\n$6,604 + $9,455 = $16,059\n\n$16,059 is less than $16,679. Jayla does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "3457",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the figure skating event end?",
    "choices": [
      "10:30 P.M.",
      "2:05 P.M.",
      "6:55 P.M.",
      "5:15 P.M."
    ],
    "answer": "5:15 P.M.",
    "unit": null,
    "table_title": "Winter Olympics schedule",
    "table": "Event | Begin | End\nspeed skating | 9:00 A.M. | 2:05 P.M.\nfigure skating | 1:25 P.M. | 5:15 P.M.\nbobsled | 4:55 P.M. | 6:55 P.M.\nice hockey | 6:20 P.M. | 9:55 P.M.\nluge | 9:25 P.M. | 10:30 P.M.",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the figure skating event on the schedule. Find the end time for the figure skating event.\n\nfigure skating: 5:15 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "17252",
    "path": "data"
  },
  {
    "question": "For a science fair project, Bella tracked the temperature each day. How many temperature readings were exactly 14\u00b0C?",
    "choices": null,
    "answer": "1",
    "unit": "temperature readings",
    "table_title": "Daily temperatures (\u00b0C)",
    "table": "Stem | Leaf \n1 | 0, 4, 6, 8, 8, 8, 8\n2 | 2, 2, 2, 2, 3, 3, 8, 8, 8, 8\n3 | 0, 0, 3, 4, 5\n4 | 0, 1, 2",
    "row_num": 5,
    "column_num": 2,
    "solution": "For the number 14, the stem is 1, and the leaf is 4. Find the row where the stem is 1. In that row, count all the leaves equal to 4.\n\nYou counted 1 leaf, which is blue in the stem-and-leaf plot above. 1 temperature reading was exactly14\u00b0C.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "30475",
    "path": "data"
  },
  {
    "question": "A baker wrote down how many pies she made in the past 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Pies baked",
    "table": "Day | Number of pies\nTuesday | 2\nWednesday | 2\nThursday | 2\nFriday | 2\nSaturday | 4",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 2, 2, 2, 4\n\nFirst, arrange the numbers from least to greatest:\n\n2, 2, 2, 2, 4\n\nNow find the number in the middle.\n\n2, 2, 2, 2, 4\n\nThe number in the middle is 2.\n\nThe median is 2.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "3351",
    "path": "data"
  },
  {
    "question": "How much more does a designer watch cost than a designer coat?",
    "choices": null,
    "answer": "1,750",
    "unit": "$",
    "table_title": null,
    "table": "designer watch | $8,141\npair of designer shoes | $9,866\ndesigner handbag | $4,703\ndesigner coat | $6,391",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a designer coat from the price of a designer watch.\n\n$8,141 - $6,391 = $1,750\n\nA designer watch costs $1,750 more than a designer coat.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "12892",
    "path": "data"
  },
  {
    "question": "A city planner counted the number of floors per building in the downtown area. How many buildings have at least 15 floors?",
    "choices": null,
    "answer": "10",
    "unit": "buildings",
    "table_title": "Floors per building",
    "table": "Stem | Leaf \n1 | 4, 5\n2 | 6, 6\n3 | 3, 3\n4 | \n5 | 0, 2, 8\n6 | 5\n7 | 8",
    "row_num": 8,
    "column_num": 2,
    "solution": "Find the row with stem 1. Count all the leaves greater than or equal to 5.\n\nCount all the leaves in the rows with stems 2, 3, 4, 5, 6, and 7.\n\nYou counted 10 leaves, which are blue in the stem-and-leaf plots above. 10 buildings have at least 15 floors.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "1735",
    "path": "data"
  },
  {
    "question": "A machine dispensed red gumdrops into bags of various sizes. How many bags had less than 50 red gumdrops?",
    "choices": null,
    "answer": "10",
    "unit": "bags",
    "table_title": "Red gumdrops per bag",
    "table": "Stem | Leaf \n3 | 4, 5, 6, 9, 9\n4 | 0, 1, 5, 6, 7\n5 | 1, 1, 3, 3, 5, 6, 7\n6 | 0, 0, 1, 2, 4, 9",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 3 and 4.\n\nYou counted 10 leaves, which are blue in the stem-and-leaf plot above. 10 bags had less than 50 red gumdrops.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "18097",
    "path": "data"
  },
  {
    "question": "If Cooper buys 5 pounds of Gala apples, 3 pounds of Macintosh apples, and 2 pounds of Pink Lady apples, how much will he spend?",
    "choices": null,
    "answer": "11.81",
    "unit": "$",
    "table_title": null,
    "table": "Gala apples | $1.14/pound\nMacintosh apples | $1.23/pound\nPink Lady apples | $1.21/pound\nWashington apples | $1.36/pound\nFuji apples | $1.18/pound",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the Gala apples. Multiply:\n\n$1.14 \u00d7 5 = $5.70\n\nFind the cost of the Macintosh apples. Multiply:\n\n$1.23 \u00d7 3 = $3.69\n\nFind the cost of the Pink Lady apples. Multiply:\n\n$1.21 \u00d7 2 = $2.42\n\nNow find the total cost by adding:\n\n$5.70 + $3.69 + $2.42 = $11.81\n\nHe will spend $11.81.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "11992",
    "path": "data"
  },
  {
    "question": "How much money does Jackie need to buy an orange T-shirt and a red sweater?",
    "choices": null,
    "answer": "14",
    "unit": "$",
    "table_title": null,
    "table": "black skirt | $9\nred sweater | $7\nstriped shirt | $2\norange T-shirt | $7\npair of white socks | $1",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of an orange T-shirt and the price of a red sweater:\n\n$7 + $7 = $14\n\nJackie needs $14.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "29614",
    "path": "data"
  },
  {
    "question": "The owner of a bed and breakfast inn recalled how many guests the inn had hosted each day. What is the mode of the numbers?",
    "choices": null,
    "answer": "25",
    "unit": null,
    "table_title": "Inn guests",
    "table": "Day | Number of guests\nWednesday | 25\nThursday | 13\nFriday | 13\nSaturday | 25\nSunday | 25",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n25, 13, 13, 25, 25\n\nFirst, arrange the numbers from least to greatest:\n\n13, 13, 25, 25, 25\n\nNow count how many times each number appears.\n\n13 appears 2 times.\n25 appears 3 times.\n\nThe number that appears most often is 25.\n\nThe mode is 25.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "37268",
    "path": "data"
  },
  {
    "question": "An employee at the craft store counted the number of red buttons in each bag of mixed buttons. How many bags had at least 0 red buttons but fewer than 30 red buttons?",
    "choices": null,
    "answer": "11",
    "unit": "bags",
    "table_title": "Red buttons per bag",
    "table": "Stem | Leaf \n0 | 1, 5, 5\n1 | 1, 8, 9\n2 | 0, 1, 2, 4, 7\n3 | 0, 3, 3, 3, 4, 6, 6, 8, 9, 9",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 0, 1, and 2.\n\nYou counted 11 leaves, which are blue in the stem-and-leaf plot above. 11 bags had at least 0 red buttons but fewer than 30 red buttons.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "12990",
    "path": "data"
  },
  {
    "question": "Each truck has 5 shovels. How many shovels are in 4 trucks?",
    "choices": null,
    "answer": "20",
    "unit": null,
    "table_title": null,
    "table": "Number of trucks | Number of shovels\n1 | 5\n2 | 10\n3 | 15\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 20 shovels in 4 trucks.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "31628",
    "path": "data"
  },
  {
    "question": "How much money does Andrew need to buy a strawberry cheesecake, a cherry pie, and an almond tart?",
    "choices": null,
    "answer": "25.08",
    "unit": "$",
    "table_title": null,
    "table": "banana cream pie | $9.44\nalmond tart | $9.85\ncherry pie | $5.67\nstrawberry cheesecake | $9.56\nchocolate cheesecake | $9.90",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of a strawberry cheesecake, a cherry pie, and an almond tart.\n\n$9.56 + $5.67 + $9.85 = $25.08\n\nAndrew needs $25.08.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "33049",
    "path": "data"
  },
  {
    "question": "The parks department compared how many soccer fields there are at each park. What is the range of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Soccer fields",
    "table": "Park | Number of soccer fields\nCanyon Park | 9\nLighthouse Park | 10\nMadison Park | 7\nMiddle Park | 2\nWindy Hill Park | 3\nCrane Park | 8\nJuniper Park | 3\nMoon Park | 5",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 10, 7, 2, 3, 8, 3, 5\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 2 = 8\n\nThe range is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "20558",
    "path": "data"
  },
  {
    "question": "How much more does a whale-watching adventure package cost than a ski trip package?",
    "choices": null,
    "answer": "326",
    "unit": "$",
    "table_title": null,
    "table": "deep-sea fishing package | $898\nwhale-watching adventure package | $626\ncamping adventure package | $654\nmountain-biking adventure package | $519\nski trip package | $300",
    "row_num": 5,
    "column_num": 2,
    "solution": "Subtract the price of a ski trip package from the price of a whale-watching adventure package.\n\n$626 - $300 = $326\n\nA whale-watching adventure package costs $326 more than a ski trip package.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "26016",
    "path": "data"
  },
  {
    "question": "Some pizza restaurants compared their pizza sales. Which restaurant sold the most pizza slices?",
    "choices": [
      "Deep Dish by Dan",
      "Mario's Pizzeria",
      "Pizza Italia",
      "Antonio's Pizzeria"
    ],
    "answer": "Antonio's Pizzeria",
    "unit": null,
    "table_title": "Pizza slices sold",
    "table": "Restaurant | Number of slices sold\nDeep Dish by Dan | 752\nMario's Pizzeria | 771\nPizza Italia | 758\nAntonio's Pizzeria | 781",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 781.\n\nNow find the corresponding restaurant. Antonio's Pizzeria corresponds to 781.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "9088",
    "path": "data"
  },
  {
    "question": "The school district compared how many math teachers each high school has. What is the mode of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Math teachers",
    "table": "High school | Number of math teachers\nHillview High | 6\nCentral High | 3\nGreen High | 3\nLincoln High | 3\nNorthside High | 6",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 3, 3, 3, 6\n\nFirst, arrange the numbers from least to greatest:\n\n3, 3, 3, 6, 6\n\nNow count how many times each number appears.\n\n3 appears 3 times.\n6 appears 2 times.\n\nThe number that appears most often is 3.\n\nThe mode is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "4422",
    "path": "data"
  },
  {
    "question": "A stock broker followed the stock prices of a certain set of companies. How much did Computer Data Company's stock cost on Monday?",
    "choices": null,
    "answer": "2",
    "unit": "$",
    "table_title": "Stock prices",
    "table": "Company | Monday | Tuesday\nWhite and Company | $8 | $14\nJonas Incorporated | $15 | $11\nThompson Corporation | $5 | $11\nHouston Sporting Goods | $16 | $2\nComputer Data Company | $2 | $18",
    "row_num": 6,
    "column_num": 3,
    "solution": "First, find the row for Computer Data Company. Then find the number in the Monday column.\n\nThis number is $2.00. Computer Data Company's stock cost $2 on Monday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "18997",
    "path": "data"
  },
  {
    "question": "Worried about going over his storage limit, Santiago monitored the number of undeleted voicemail messages stored on his phone each day. According to the table, what was the rate of change between Thursday and Friday?",
    "choices": null,
    "answer": "-6",
    "unit": "voicemail messages per day",
    "table_title": "Voicemail messages on Santiago's phone",
    "table": "Day | Voicemail messages\nTuesday | 12\nWednesday | 16\nThursday | 19\nFriday | 13\nSaturday | 13",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{13 voicemail messages - 19 voicemail messages}{1 day}\n = \\frac{-6 voicemail messages}{1 day}\n = -6 voicemail messages per day\nThe rate of change between Thursday and Friday was - 6 voicemail messages per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "35719",
    "path": "data"
  },
  {
    "question": "Each laundry hamper has 2 pairs of jeans. How many pairs of jeans are in 4 laundry hampers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": null,
    "table": "Number of laundry hampers | Number of pairs of jeans\n1 | 2\n2 | 4\n3 | 6\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 8 pairs of jeans in 4 laundry hampers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "5604",
    "path": "data"
  },
  {
    "question": "The parks department compared how many basketball hoops there are at each park. What is the range of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Basketball hoops",
    "table": "Park | Number of basketball hoops\nMooreland Park | 5\nOtter Park | 4\nWestfield Park | 3\nPinehurst Park | 4\nLinden Park | 5\nRiverfront Park | 8\nCrestview Park | 6",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 4, 3, 4, 5, 8, 6\n\nFirst, find the greatest number. The greatest number is 8.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n8 \u2212 3 = 5\n\nThe range is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "16757",
    "path": "data"
  },
  {
    "question": "Several families compared how many vegetables they ate in a year. How many more vegetables did the Cartwright family eat than the Yamazaki family?",
    "choices": null,
    "answer": "228",
    "unit": "vegetables",
    "table_title": "Vegetables eaten in a year",
    "table": "Family | Number of vegetables eaten\nMcCullough family | 710\nCartwright family | 746\nGrisham family | 779\nYamazaki family | 518\nWensing family | 823",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nCartwright family: 746\nYamazaki family: 518\n\nNow subtract: 746 - 518 = 228.\n\nThe Cartwright family ate 228 more vegetables than the Yamazaki family.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "1530",
    "path": "data"
  },
  {
    "question": "At a swim meet, Alvin noted the size of various swim teams. How many teams have exactly 59 swimmers?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Swimming team sizes (number of swimmers)",
    "table": "Stem | Leaf \n1 | 8\n2 | \n3 | 0\n4 | \n5 | 8, 9, 9\n6 | 9\n7 | 4\n8 | 8",
    "row_num": 9,
    "column_num": 2,
    "solution": "For the number 59, the stem is 5, and the leaf is 9. Find the row where the stem is 5. In that row, count all the leaves equal to 9.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 teams have exactly 59 swimmers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "17821",
    "path": "data"
  },
  {
    "question": "Erin has $2.31. How much money will Erin have left if she buys a bag of potato chips and a glass of lemonade?",
    "choices": null,
    "answer": "0.50",
    "unit": "$",
    "table_title": null,
    "table": "pickle | $0.70\nglass of lemonade | $0.86\nbottle of water | $0.82\nbag of potato chips | $0.95\nmuffin | $0.56",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of a bag of potato chips and a glass of lemonade.\n\n$0.95 + $0.86 = $1.81\n\nNow subtract the total cost from the starting amount.\n\n$2.31 - $1.81 = $0.50\n\nErin will have $0.50 left.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "31200",
    "path": "data"
  },
  {
    "question": "In science class, Regan is learning about places with extreme temperatures. She learns that the highest temperature ever recorded was in Death Valley, California. She also learns that the lowest temperature ever recorded was in Vostok Station, Antarctica. The record-setting temperatures of the two locations are shown in the table. Which location's temperature was further from zero?",
    "choices": [
      "Death Valley",
      "Vostok Station"
    ],
    "answer": "Death Valley",
    "unit": null,
    "table_title": null,
    "table": "Location | Temperature (\u00b0F)\nDeath Valley | 134\nVostok Station | -128",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive number means the temperature was above zero. A negative number means the temperature was below zero.\nTo find which temperature was further from zero, use absolute value. Absolute value tells you how far a temperature is from zero.\nDeath Valley: |134| = 134\nVostok Station: |-128| = 128\nThe temperature of Death Valley was further from zero. It was 134 degrees above zero.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "4211",
    "path": "data"
  },
  {
    "question": "An athlete counted how many autographs he signed each day. On which day did the athlete sign the fewest autographs?",
    "choices": [
      "Saturday",
      "Sunday",
      "Monday",
      "Tuesday"
    ],
    "answer": "Sunday",
    "unit": null,
    "table_title": "Autographs signed",
    "table": "Day | Number of autographs\nSaturday | 998\nSunday | 934\nMonday | 943\nTuesday | 941",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 934.\n\nNow find the corresponding day. Sunday corresponds to 934.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "7474",
    "path": "data"
  },
  {
    "question": "The local high school found out how many members each club had. Which club has the fewest members?",
    "choices": [
      "Spanish club",
      "photography club",
      "math club",
      "film club"
    ],
    "answer": "math club",
    "unit": null,
    "table_title": "Club membership",
    "table": "Club | Number of members\nSpanish club | 149\nphotography club | 141\nmath club | 119\nfilm club | 194",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 119.\n\nNow find the corresponding club. Math club corresponds to 119.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "6796",
    "path": "data"
  },
  {
    "question": "If Carla buys 4+3/4 pounds of macadamia nut butter, how much will she spend?",
    "choices": null,
    "answer": "19",
    "unit": "$",
    "table_title": null,
    "table": "macadamia nut butter | $4 per lb\nwalnut butter | $6 per lb\nalmond butter | $4 per lb\npeanut butter | $6 per lb",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the macadamia nut butter. Multiply the price per pound by the number of pounds.\n$4 \u00d7 4\\frac{3}{4} = $4 \u00d7 4.75 = $19\nShe will spend $19.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "24573",
    "path": "data"
  },
  {
    "question": "Liam has $1.00. Does he have enough to buy a deer postcard and a tulip stamp?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "mountain postcard | $0.68\nbutterfly stamp | $0.14\npiece of bubble wrap | $0.57\nrobot stamp | $0.40\ntulip stamp | $0.50\ndeer postcard | $0.37",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a deer postcard and the price of a tulip stamp:\n\n$0.37 + $0.50 = $0.87\n\n$0.87 is less than $1.00. Liam does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "1793",
    "path": "data"
  },
  {
    "question": "At a candy factory, butterscotch candies were packaged into bags of different sizes. How many bags had fewer than 40 butterscotch candies?",
    "choices": null,
    "answer": "3",
    "unit": "bags",
    "table_title": "Butterscotch candies per bag",
    "table": "Stem | Leaf \n1 | 3\n2 | 1\n3 | 1\n4 | \n5 | 5\n6 | 7\n7 | 1, 4\n8 | \n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, and 3.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plot above. 3 bags had fewer than 40 butterscotch candies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "6769",
    "path": "data"
  },
  {
    "question": "Steve has $1.58. Does he have enough to buy a football helmet key chain and a globe key chain?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "football helmet key chain | $0.61\npuppy key chain | $0.51\ncartoon character key chain | $0.56\nglobe key chain | $0.90",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a football helmet key chain and the price of a globe key chain:\n\n$0.61 + $0.90 = $1.51\n\n$1.51 is less than $1.58. Steve does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 7,
    "split": "dev",
    "pid": "11824",
    "path": "data"
  },
  {
    "question": "To determine whether people make fewer trips to the movies when the economy is bad, a reporter asked people how many movies they saw last month. How many people went to the movies more than 2 times?",
    "choices": null,
    "answer": "22",
    "unit": null,
    "table_title": "Trips to the movies last month",
    "table": "Number of trips | Frequency\n0 | 12\n1 | 7\n2 | 3\n3 | 6\n4 | 16",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the rows for 3 and 4 times. Add the frequencies for these rows.\n\nAdd:\n\n6 + 16 = 22\n\n22 people went to the movies more than 2 times.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "26400",
    "path": "data"
  },
  {
    "question": "A florist looked at how many flowers she sold in the past 5 months. How many flowers in total did the florist sell in November and January?",
    "choices": null,
    "answer": "7,373",
    "unit": "flowers",
    "table_title": "Flowers sold",
    "table": "Month | Number of flowers\nNovember | 5,364\nDecember | 2,975\nJanuary | 2,009\nFebruary | 1,744\nMarch | 1,261",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nNovember: 5,364\nJanuary: 2,009\n\nNow add: 5,364 + 2,009 = 7,373.\n\nThe florist sold 7,373 flowers in November and January.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "4046",
    "path": "data"
  },
  {
    "question": "An administrator at the Department of Motor Vehicles (DMV) tracked the average wait time from month to month. According to the table, what was the rate of change between April and May?",
    "choices": null,
    "answer": "8",
    "unit": "minutes per month",
    "table_title": "Average waiting time at the DMV",
    "table": "Month | Waiting time (minutes)\nJanuary | 16\nFebruary | 9\nMarch | 18\nApril | 9\nMay | 17",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{17 minutes - 9 minutes}{1 month}\n = \\frac{8 minutes}{1 month}\n = 8 minutes per month\nThe rate of change between April and May was 8 minutes per month.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "29277",
    "path": "data"
  },
  {
    "question": "For a fundraiser, the children in the art club made greeting cards and kept track of how many they produced. How many children made fewer than 4 greeting cards?",
    "choices": null,
    "answer": "27",
    "unit": null,
    "table_title": "Making greeting cards",
    "table": "Greeting cards made | Frequency\n0 | 11\n1 | 3\n2 | 5\n3 | 8\n4 | 7\n5 | 19",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the rows for 0, 1, 2, and 3 greeting cards. Add the frequencies for these rows.\n\nAdd:\n\n11 + 3 + 5 + 8 = 27\n\n27 children made fewer than 4 greeting cards.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "26921",
    "path": "data"
  },
  {
    "question": "Josh has $0.07. Does he have enough to buy an orange envelope and a bright blue note card?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "purple envelope | $0.09\nsheet of green paper | $0.07\nbright blue note card | $0.06\nsheet of blue and yellow paper | $0.01\norange envelope | $0.03",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of an orange envelope and the price of a bright blue note card:\n\n$0.03 + $0.06 = $0.09\n\n$0.09 is more than $0.07. Josh does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "8168",
    "path": "data"
  },
  {
    "question": "How much money does Shane need to buy a scorpion and a chameleon?",
    "choices": null,
    "answer": "101.52",
    "unit": "$",
    "table_title": null,
    "table": "pot-bellied pig | $21.07\nscorpion | $45.58\nfinch | $39.59\ntarantula | $36.83\nchameleon | $55.94",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a scorpion and the price of a chameleon:\n\n$45.58 + $55.94 = $101.52\n\nShane needs $101.52.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "14153",
    "path": "data"
  },
  {
    "question": "How much money does Braden need to buy a photograph signed by a famous race car driver, a book signed by a famous author, and a ball signed by a famous football player?",
    "choices": null,
    "answer": "197",
    "unit": "$",
    "table_title": null,
    "table": "ball signed by a famous football player | $59\nphotograph signed by a famous race car driver | $99\nbook signed by a famous author | $39\nprogram signed by a famous dancer | $50\nphotograph signed by a famous television star | $37\njersey signed by a famous hockey player | $65",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of a photograph signed by a famous race car driver, a book signed by a famous author, and a ball signed by a famous football player.\n\n$99 + $39 + $59 = $197\n\nBraden needs $197.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "1276",
    "path": "data"
  },
  {
    "question": "Dalton was a spectator at his town's air guitar competition. Contestants were allowed to play either the acoustic or electric air guitar, but not both. Dalton recorded which type of guitar each contestant played. He also counted the number of contestants wearing different kinds of pants, as there were some interesting stylistic choices. What is the probability that a randomly selected contestant played an acoustic guitar and was dressed in leather? Simplify any fractions.",
    "choices": null,
    "answer": "3/17",
    "unit": null,
    "table_title": null,
    "table": " | Leather | Velvet\nAcoustic guitar | 3 | 3\nElectric guitar | 6 | 5",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the contestant played an acoustic guitar\" and B be the event \"the contestant was dressed in leather\".\nTo find the probability that a contestant played an acoustic guitar and was dressed in leather, first identify the sample space and the event.\nThe outcomes in the sample space are the different contestants. Each contestant is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the contestant played an acoustic guitar and was dressed in leather\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the contestant played an acoustic guitar and was dressed in leather\", so look at the table to see how many contestants played an acoustic guitar and were dressed in leather.\nThe number of contestants who played an acoustic guitar and were dressed in leather is 3.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of contestants.\n3 + 6 + 3 + 5 = 17\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{3}{17}\nThe probability that a contestant played an acoustic guitar and was dressed in leather is \\frac{3}{17}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "27676",
    "path": "data"
  },
  {
    "question": "Franco paid attention to how many comic strips he read in the past 7 days. What is the range of the numbers?",
    "choices": null,
    "answer": "11",
    "unit": null,
    "table_title": "Comic strips read",
    "table": "Day | Number of comic strips\nSaturday | 16\nSunday | 11\nMonday | 13\nTuesday | 10\nWednesday | 12\nThursday | 19\nFriday | 8",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n16, 11, 13, 10, 12, 19, 8\n\nFirst, find the greatest number. The greatest number is 19.\n\nNext, find the least number. The least number is 8.\n\nSubtract the least number from the greatest number:\n\n19 \u2212 8 = 11\n\nThe range is 11.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "14385",
    "path": "data"
  },
  {
    "question": "Tom kept a driving log to see how many miles he drove each day. What is the range of the numbers?",
    "choices": null,
    "answer": "26",
    "unit": null,
    "table_title": "Miles driven",
    "table": "Day | Number of miles\nWednesday | 68\nThursday | 54\nFriday | 70\nSaturday | 73\nSunday | 71\nMonday | 80",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n68, 54, 70, 73, 71, 80\n\nFirst, find the greatest number. The greatest number is 80.\n\nNext, find the least number. The least number is 54.\n\nSubtract the least number from the greatest number:\n\n80 \u2212 54 = 26\n\nThe range is 26.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "1123",
    "path": "data"
  },
  {
    "question": "A philanthropic organization compared the amounts of money that its members donated to certain causes. How much more money did Rose donate to hunger prevention than Denise?",
    "choices": null,
    "answer": "2",
    "unit": "$",
    "table_title": "Donations",
    "table": "Person | Hunger prevention | Animal rights\nRose | $6 | $8\nRafi | $2 | $12\nDenise | $4 | $7",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the Hunger prevention column. Find the numbers in this column for Rose and Denise.\n\nRose: $6.00\nDenise: $4.00\n\nNow subtract:\n\n$6.00 \u2212 $4.00 = $2.00\n\nRose donated $2 more to hunger prevention than Denise.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "30040",
    "path": "data"
  },
  {
    "question": "This is Alice's complete financial record for June. How much money did Alice spend on a flashlight?",
    "choices": null,
    "answer": "9.85",
    "unit": "$",
    "table_title": null,
    "table": "Date | Description | Received | Expenses | Available Funds\n | Balance: end of May | | | $304.75\n6/10 | flashlight | | $9.85 | $294.90\n6/10 | bug spray | | $6.10 | $288.80\n6/25 | camp counselor | $55.00 | | $343.80",
    "row_num": 5,
    "column_num": 5,
    "solution": "Look at the flashlight row. The expenses were $9.85. So, Alice spent $9.85 on a flashlight.\n",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "18278",
    "path": "data"
  },
  {
    "question": "An administrator at the Department of Motor Vehicles (DMV) tracked the average wait time from month to month. According to the table, what was the rate of change between May and June?",
    "choices": null,
    "answer": "5",
    "unit": "minutes per month",
    "table_title": "Average waiting time at the DMV",
    "table": "Month | Waiting time (minutes)\nFebruary | 36\nMarch | 46\nApril | 38\nMay | 37\nJune | 42",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{42 minutes - 37 minutes}{1 month}\n = \\frac{5 minutes}{1 month}\n = 5 minutes per month\nThe rate of change between May and June was 5 minutes per month.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "31466",
    "path": "data"
  },
  {
    "question": "In science class, Mona is learning about places with extreme temperatures. She learns that the highest temperature ever recorded was in Death Valley, California. She also learns that the lowest temperature ever recorded was in Vostok Station, Antarctica. The record-setting temperatures of the two locations are shown in the table. Which location's temperature was further from zero?",
    "choices": [
      "Death Valley",
      "Vostok Station"
    ],
    "answer": "Death Valley",
    "unit": null,
    "table_title": null,
    "table": "Location | Temperature (\u00b0F)\nDeath Valley | 134\nVostok Station | -128",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive number means the temperature was above zero. A negative number means the temperature was below zero.\nTo find which temperature was further from zero, use absolute value. Absolute value tells you how far a temperature is from zero.\nDeath Valley: |134| = 134\nVostok Station: |-128| = 128\nThe temperature of Death Valley was further from zero. It was 134 degrees above zero.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "23782",
    "path": "data"
  },
  {
    "question": "Max has two dogs, Sprinkles and Champ. He is concerned because Sprinkles keeps eating Champ's food. Max asks their vet how much each dog's weight has changed since their last visit. Which dog's weight has changed the most?",
    "choices": [
      "Sprinkles",
      "Champ"
    ],
    "answer": "Champ",
    "unit": null,
    "table_title": null,
    "table": "Dog | Weight change (oz.)\nSprinkles | 5\nChamp | -6",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find which dog's weight changed the most, use absolute value. Absolute value tells you how much each dog's weight has changed.\nSprinkles: |5| = 5\nChamp: |-6| = 6\nChamp's weight has changed the most. He has lost 6 ounces.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "29888",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "nonlinear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n17 | 0\n18 | 4\n19 | 6",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{4 - 0}{18 - 17}\n = \\frac{4}{1}\n = 4\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{6 - 4}{19 - 18}\n = \\frac{2}{1}\n = 2\nThe rate of change is not the same for each pair of points. So, the function does not have a constant rate of change.\nThe function is nonlinear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "11352",
    "path": "data"
  },
  {
    "question": "This is Duncan's complete financial record for July. On July 5, how much money did Duncan make?",
    "choices": null,
    "answer": "15",
    "unit": "$",
    "table_title": null,
    "table": "Date | Description | Received | Expenses | Available Funds\n | Balance: end of June | | | $450.70\n7/5 | cleaning the Stewarts' pool | $15.00 | | $465.70\n7/17 | bottle of water | | $1.50 | $464.20\n7/29 | swim trunks | | $16.80 | $447.40",
    "row_num": 5,
    "column_num": 5,
    "solution": "Look at the 7/5 row. The amount received was $15.00. So, Duncan made $15.00 on July 5.\n",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "32679",
    "path": "data"
  },
  {
    "question": "A high school basketball coach counted the number of points his team scored each game. How many games had exactly 93 points?",
    "choices": null,
    "answer": "0",
    "unit": "games",
    "table_title": "Points per game",
    "table": "Stem | Leaf \n2 | 0, 0, 1, 7, 7\n3 | 1, 8\n4 | 0, 0, 2, 2, 3, 5, 6\n5 | 0, 5, 9\n6 | 8\n7 | 4, 5, 6\n8 | \n9 | 0",
    "row_num": 9,
    "column_num": 2,
    "solution": "For the number 93, the stem is 9, and the leaf is 3. Find the row where the stem is 9. In that row, count all the leaves equal to 3.\n\nYou counted 0 leaves. 0 games had exactly 93 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "26286",
    "path": "data"
  },
  {
    "question": "Each coat rack has 5 jackets. How many jackets are on 3 coat racks?",
    "choices": null,
    "answer": "15",
    "unit": null,
    "table_title": null,
    "table": "Number of coat racks | Number of jackets\n1 | 5\n2 | 10\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 15 jackets on 3 coat racks.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "25655",
    "path": "data"
  },
  {
    "question": "Zeke went on a vacation to an amusement park and counted how many rides he went on each day. What is the mode of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Amusement park rides",
    "table": "Day | Number of rides\nMonday | 8\nTuesday | 9\nWednesday | 8\nThursday | 9\nFriday | 7\nSaturday | 7\nSunday | 7",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n8, 9, 8, 9, 7, 7, 7\n\nFirst, arrange the numbers from least to greatest:\n\n7, 7, 7, 8, 8, 9, 9\n\nNow count how many times each number appears.\n\n7 appears 3 times.\n8 appears 2 times.\n9 appears 2 times.\n\nThe number that appears most often is 7.\n\nThe mode is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "13600",
    "path": "data"
  },
  {
    "question": "A city recorded how many people rode the subway each day. On which day did the most people ride the subway?",
    "choices": [
      "Friday",
      "Saturday",
      "Sunday",
      "Monday"
    ],
    "answer": "Monday",
    "unit": null,
    "table_title": "Subway riders",
    "table": "Day | Number of riders\nFriday | 449\nSaturday | 463\nSunday | 436\nMonday | 464",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 464.\n\nNow find the corresponding day. Monday corresponds to 464.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "11234",
    "path": "data"
  },
  {
    "question": "How much money does Charlie need to buy 4 airplane calendars?",
    "choices": null,
    "answer": "48",
    "unit": "$",
    "table_title": null,
    "table": "airplane calendar | $12\nbook of poems | $14\ndog calendar | $15\natlas | $28\nmath book | $10\nphoto album | $10",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of 4 airplane calendars by multiplying 4 times the price of an airplane calendar.\n\n$12 \u00d7 4 = $48\n\nCharlie needs $48.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "21077",
    "path": "data"
  },
  {
    "question": "How much money does Trent need to buy a small yellow button and a pack of white tissue paper?",
    "choices": null,
    "answer": "0.98",
    "unit": "$",
    "table_title": null,
    "table": "pack of white tissue paper | $0.83\nsmall yellow button | $0.15\nfake yellow daisy | $0.35\nsilver bow | $0.15\nspool of silver wire | $0.51\nsheet of star stickers | $0.88",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a small yellow button and the price of a pack of white tissue paper:\n\n$0.15 + $0.83 = $0.98\n\nTrent needs $0.98.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "15577",
    "path": "data"
  },
  {
    "question": "A pretzel stand owner kept track of the number of pretzels sold during the past 4 days. On which day did the stand sell the most pretzels?",
    "choices": [
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday"
    ],
    "answer": "Tuesday",
    "unit": null,
    "table_title": "Pretzels sold",
    "table": "Day | Number of pretzels\nSunday | 347\nMonday | 338\nTuesday | 374\nWednesday | 373",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 374.\n\nNow find the corresponding day. Tuesday corresponds to 374.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "35650",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "x | y\n14 | 5\n13 | 17\n13 | 18",
    "row_num": 4,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nThe x-value 13 is paired with multiple y-values, so the relation is not a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "10170",
    "path": "data"
  },
  {
    "question": "How much money does Riley need to buy 5 boxes of markers?",
    "choices": null,
    "answer": "19",
    "unit": "$",
    "table_title": null,
    "table": "rubber stamp | $1.77\nbox of envelopes | $1.74\nbox of markers | $3.80\nbottle of glue | $2.48\nroll of tape | $1.03",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of 5 boxes of markers by multiplying 5 times the price of a box of markers.\n\n$3.80 \u00d7 5 = $19.00\n\nRiley needs $19.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "37191",
    "path": "data"
  },
  {
    "question": "Mrs. Dawson told students how many rounds to expect in the spelling bee based on previous years. According to the table, what was the rate of change between 2014 and 2015?",
    "choices": null,
    "answer": "0",
    "unit": "rounds per year",
    "table_title": "Rounds in the spelling bee",
    "table": "Year | Rounds\n2014 | 15\n2015 | 15\n2016 | 10\n2017 | 12\n2018 | 12",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{15 rounds - 15 rounds}{2015 - 2014}\n = \\frac{15 rounds - 15 rounds}{1 year}\n = \\frac{0 rounds}{1 year}\n = 0 rounds per year\nThe rate of change between 2014 and 2015 was 0 rounds per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "14420",
    "path": "data"
  },
  {
    "question": "Shelby has $306. Does she have enough to buy a rabbit and a finch?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "chameleon | $264\nfinch | $192\nrabbit | $118\ncockatoo | $221\nbearded dragon | $392",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a rabbit and the price of a finch:\n\n$118 + $192 = $310\n\n$310 is more than $306. Shelby does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "36693",
    "path": "data"
  },
  {
    "question": "Joe went on a vacation to an amusement park and counted how many rides he went on each day. On which day did Joe go on the most rides?",
    "choices": [
      "Friday",
      "Saturday",
      "Sunday",
      "Monday"
    ],
    "answer": "Sunday",
    "unit": null,
    "table_title": "Amusement park rides",
    "table": "Day | Number of rides\nFriday | 31\nSaturday | 32\nSunday | 37\nMonday | 36",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 37.\n\nNow find the corresponding day. Sunday corresponds to 37.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "17346",
    "path": "data"
  },
  {
    "question": "The parks department compared how many soccer fields there are at each park. What is the range of the numbers?",
    "choices": null,
    "answer": "9",
    "unit": null,
    "table_title": "Soccer fields",
    "table": "Park | Number of soccer fields\nLighthouse Park | 8\nCanyon Park | 4\nElmhurst Park | 3\nJuniper Park | 2\nMadison Park | 1\nMiddle Park | 5\nWindy Hill Park | 10\nCrane Park | 6",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n8, 4, 3, 2, 1, 5, 10, 6\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 1.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 1 = 9\n\nThe range is 9.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "35427",
    "path": "data"
  },
  {
    "question": "Myra, an employee at Walter's Convenience Store, looked at the sales of each of its soda products. Which beverage had higher sales on Friday, Krazy Kola or Nature's Nectar?",
    "choices": [
      "Krazy Kola",
      "Nature's Nectar"
    ],
    "answer": "Nature's Nectar",
    "unit": null,
    "table_title": "Convenience store beverage sales",
    "table": "Beverage | Thursday | Friday\nBrenner's Juices | $9 | $14\nNature's Nectar | $5 | $12\nFizzy Fun | $16 | $8\nKrazy Kola | $11 | $2",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the Friday column. Compare the numbers in this column for Krazy Kola and Nature's Nectar.\n\n$12.00 is more than $2.00. Nature's Nectar had higher sales on Friday.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "37384",
    "path": "data"
  },
  {
    "question": "Sasha's classmates revealed how many science articles they read. What is the range of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Science articles read",
    "table": "Name | Number of science articles\nSasha | 6\nNolan | 3\nEmma | 10\nJohn | 9\nFelipe | 9\nPam | 2\nAngie | 9\nBryce | 5",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 3, 10, 9, 9, 2, 9, 5\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 2 = 8\n\nThe range is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "26166",
    "path": "data"
  },
  {
    "question": "Manuel counted the number of silver beads on each bracelet at Sparrowtown Jewelry, the store where he works. What is the smallest number of silver beads?",
    "choices": null,
    "answer": "20",
    "unit": "silver beads",
    "table_title": "Silver beads per bracelet",
    "table": "Stem | Leaf \n2 | 0, 2, 4, 7\n3 | 1, 3\n4 | 3\n5 | 3, 4, 7, 9\n6 | 0, 1, 2, 2, 6, 7, 7, 8\n7 | 0, 3, 4, 6, 7, 9",
    "row_num": 7,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 2.\n\nNow find the lowest leaf in the first row. The lowest leaf is 0.\n\nThe smallest number of silver beads has a stem of 2 and a leaf of 0. Write the stem first, then the leaf: 20.\n\nThe smallest number of silver beads is 20 silver beads.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "8696",
    "path": "data"
  },
  {
    "question": "Derek and his brother are at a store shopping for a beanbag chair for their school's library. The store sells beanbag chairs with different fabrics and types of filling. What is the probability that a randomly selected beanbag chair is filled with beads and is made from velvet? Simplify any fractions.",
    "choices": null,
    "answer": "1/4",
    "unit": null,
    "table_title": null,
    "table": " | Velvet | Suede\nFoam | 6 | 2\nBeads | 5 | 7",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the beanbag chair is filled with beads\" and B be the event \"the beanbag chair is made from velvet\".\nTo find the probability that a beanbag chair is filled with beads and is made from velvet, first identify the sample space and the event.\nThe outcomes in the sample space are the different beanbag chairs. Each beanbag chair is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the beanbag chair is filled with beads and is made from velvet\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the beanbag chair is filled with beads and is made from velvet\", so look at the table to see how many beanbag chairs are filled with beads and are made from velvet.\nThe number of beanbag chairs that are filled with beads and are made from velvet is 5.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of beanbag chairs.\n6 + 5 + 2 + 7 = 20\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{5}{20}\n = \\frac{1}{4}\nThe probability that a beanbag chair is filled with beads and is made from velvet is \\frac{1}{4}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "28887",
    "path": "data"
  },
  {
    "question": "Look at Veronica's pay stub. Veronica lives in a state that has state income tax. How much did Veronica make after taxes?",
    "choices": null,
    "answer": "2,825.35",
    "unit": "$",
    "table_title": null,
    "table": "Employee | Pay period |\nVeronica O'Neil | May |\nTotal earnings | | $3,900.00\nFederal income tax | $504.30 |\nState income tax | $272.00 |\nOther taxes | $298.35 |\nTotal taxes | | ?\nPay after taxes | | ?",
    "row_num": 8,
    "column_num": 3,
    "solution": "Find how much Veronica made after taxes. Find the total payroll tax, then subtract it from the total earnings.\nTo find the total payroll tax, add the federal income tax, state income tax, and other taxes.\nThe total earnings are $3,900.00. The total payroll tax is $1,074.65. Subtract to find the difference.\n$3,900.00 - $1,074.65 = $2,825.35\nVeronica made $2,825.35 after taxes.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "10131",
    "path": "data"
  },
  {
    "question": "In science class, Brenna is learning about places with extreme temperatures. She learns that the highest temperature ever recorded was in Death Valley, California. She also learns that the lowest temperature ever recorded was in Vostok Station, Antarctica. The record-setting temperatures of the two locations are shown in the table. Which location's temperature was further from zero?",
    "choices": [
      "Death Valley",
      "Vostok Station"
    ],
    "answer": "Death Valley",
    "unit": null,
    "table_title": null,
    "table": "Location | Temperature (\u00b0F)\nDeath Valley | 134\nVostok Station | -128",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive number means the temperature was above zero. A negative number means the temperature was below zero.\nTo find which temperature was further from zero, use absolute value. Absolute value tells you how far a temperature is from zero.\nDeath Valley: |134| = 134\nVostok Station: |-128| = 128\nThe temperature of Death Valley was further from zero. It was 134 degrees above zero.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "9306",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $310, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$50 | 15,800 | 20,100\n$180 | 12,700 | 20,600\n$310 | 9,600 | 21,100\n$440 | 6,500 | 21,600\n$570 | 3,400 | 22,100",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $310, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "11300",
    "path": "data"
  },
  {
    "question": "A coffee shop monitored the number of cups of coffee sold each day. What is the range of the numbers?",
    "choices": null,
    "answer": "17",
    "unit": null,
    "table_title": "Cups of coffee sold",
    "table": "Day | Number of cups\nFriday | 14\nSaturday | 31\nSunday | 25\nMonday | 30\nTuesday | 27",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n14, 31, 25, 30, 27\n\nFirst, find the greatest number. The greatest number is 31.\n\nNext, find the least number. The least number is 14.\n\nSubtract the least number from the greatest number:\n\n31 \u2212 14 = 17\n\nThe range is 17.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "22057",
    "path": "data"
  },
  {
    "question": "How much money does Regan need to buy 6 saxophones?",
    "choices": null,
    "answer": "4,866",
    "unit": "$",
    "table_title": null,
    "table": "keyboard | $597.00\ncello | $956.00\nsaxophone | $811.00\ntrombone | $625.00\noboe | $845.00\nclarinet | $557.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of 6 saxophones by multiplying 6 times the price of a saxophone.\n\n$811.00 \u00d7 6 = $4,866.00\n\nRegan needs $4,866.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "34763",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $155, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$155 | 17,100 | 14,600\n$255 | 15,400 | 15,700\n$355 | 13,700 | 16,800\n$455 | 12,000 | 17,900\n$555 | 10,300 | 19,000",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $155, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "19635",
    "path": "data"
  },
  {
    "question": "An actor was informed how many fan letters he received each day. What is the median of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Fan letters received",
    "table": "Day | Number of fan letters\nWednesday | 5\nThursday | 9\nFriday | 7\nSaturday | 10\nMonday | 5",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 9, 7, 10, 5\n\nFirst, arrange the numbers from least to greatest:\n\n5, 5, 7, 9, 10\n\nNow find the number in the middle.\n\n5, 5, 7, 9, 10\n\nThe number in the middle is 7.\n\nThe median is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "15296",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n10 | 4\n11 | 6\n12 | 8",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{6 - 4}{11 - 10}\n = \\frac{2}{1}\n = 2\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{8 - 4}{12 - 10}\n = \\frac{4}{2}\n = 2\nThe two rates of change are the same.\nIf you checked the rate of change between rows 2 and 3, you would find that it is also 2.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "5628",
    "path": "data"
  },
  {
    "question": "For a math project, students in Mrs. Chandler's class recorded the number of pets that each student has. How many students in the class have exactly 4 pets?",
    "choices": null,
    "answer": "16",
    "unit": null,
    "table_title": "Pets",
    "table": "Number of pets | Frequency\n0 | 8\n1 | 10\n2 | 0\n3 | 11\n4 | 16\n5 | 3\n6 | 15",
    "row_num": 8,
    "column_num": 2,
    "solution": "Find the row for 4 pets and read the frequency. The frequency is 16.\n\n16 students have exactly 4 pets.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "11964",
    "path": "data"
  },
  {
    "question": "Every summer, Turner goes on a week-long canoe trip with his childhood camp friends. After the trip, he usually purchases some oars from the destination city. His collection of oars is organized by year and type of wood. What is the probability that a randomly selected oar was made from spruce wood and was purchased in 2010? Simplify any fractions.",
    "choices": null,
    "answer": "4/15",
    "unit": null,
    "table_title": null,
    "table": " | 2010 | 2011\nSpruce wood | 4 | 4\nAsh wood | 3 | 4",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the oar was made from spruce wood\" and B be the event \"the oar was purchased in 2010\".\nTo find the probability that a oar was made from spruce wood and was purchased in 2010, first identify the sample space and the event.\nThe outcomes in the sample space are the different oars. Each oar is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the oar was made from spruce wood and was purchased in 2010\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the oar was made from spruce wood and was purchased in 2010\", so look at the table to see how many oars were made from spruce wood and were purchased in 2010.\nThe number of oars that were made from spruce wood and were purchased in 2010 is 4.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of oars.\n4 + 3 + 4 + 4 = 15\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{4}{15}\nThe probability that a oar was made from spruce wood and was purchased in 2010 is \\frac{4}{15}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "31005",
    "path": "data"
  },
  {
    "question": "Some farmers compared how many tractors they own. What is the median of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Tractors",
    "table": "Farmer | Number of tractors\nFarmer John | 8\nFarmer Judy | 7\nFarmer Walt | 6\nFarmer Susie | 1\nFarmer Megan | 5\nFarmer Rick | 4\nFarmer Jane | 1",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n8, 7, 6, 1, 5, 4, 1\n\nFirst, arrange the numbers from least to greatest:\n\n1, 1, 4, 5, 6, 7, 8\n\nNow find the number in the middle.\n\n1, 1, 4, 5, 6, 7, 8\n\nThe number in the middle is 5.\n\nThe median is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "25871",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n14 | 1\n15 | 10\n16 | 19",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{10 - 1}{15 - 14}\n = \\frac{9}{1}\n = 9\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{19 - 10}{16 - 15}\n = \\frac{9}{1}\n = 9\nThe two rates of change are the same.\nIf you checked the rate of change between rows 1 and 3, you would find that it is also 9.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "27717",
    "path": "data"
  },
  {
    "question": "A pet store owner had his staff count the number of fish in each tank. How many tanks have at least 27 fish but fewer than 42 fish?",
    "choices": null,
    "answer": "5",
    "unit": "tanks",
    "table_title": "Fish per tank",
    "table": "Stem | Leaf \n0 | 1, 2, 2\n1 | 2\n2 | 1, 4\n3 | 2, 3, 9\n4 | 0, 1, 6, 7, 8",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row with stem 2. Count all the leaves greater than or equal to 7.\n\nCount all the leaves in the row with stem 3.\n\nIn the row with stem 4, count all the leaves less than 2.\n\nYou counted 5 leaves, which are blue in the stem-and-leaf plots above. 5 tanks have at least 27 fish but fewer than 42 fish.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "7500",
    "path": "data"
  },
  {
    "question": "Dustin's coach wrote down how many kilometers he had run over the past 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Kilometers run",
    "table": "Day | Kilometers\nWednesday | 0\nThursday | 0\nFriday | 7\nSaturday | 4\nSunday | 2",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n0, 0, 7, 4, 2\n\nFirst, arrange the numbers from least to greatest:\n\n0, 0, 2, 4, 7\n\nNow find the number in the middle.\n\n0, 0, 2, 4, 7\n\nThe number in the middle is 2.\n\nThe median is 2.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "18111",
    "path": "data"
  },
  {
    "question": "A race car driver kept track of how many laps he drove in the past 4 days. On which day did the driver do the most laps?",
    "choices": [
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday"
    ],
    "answer": "Wednesday",
    "unit": null,
    "table_title": "Laps driven",
    "table": "Day | Number of laps\nTuesday | 52\nWednesday | 57\nThursday | 53\nFriday | 51",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 57.\n\nNow find the corresponding day. Wednesday corresponds to 57.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "35861",
    "path": "data"
  },
  {
    "question": "How much money does Nicole need to buy a can of pears and a can of soup?",
    "choices": null,
    "answer": "1.40",
    "unit": "$",
    "table_title": null,
    "table": "can of pears | $0.81\njar of applesauce | $0.75\ncan of soup | $0.59\njar of olives | $0.79\ncan of green beans | $0.71",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a can of pears and the price of a can of soup:\n\n$0.81 + $0.59 = $1.40\n\nNicole needs $1.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 3,
    "split": "dev",
    "pid": "34576",
    "path": "data"
  },
  {
    "question": "Patty wrote down how many pages she read over the past 4 days. On which day did Patty read the fewest pages?",
    "choices": [
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday"
    ],
    "answer": "Wednesday",
    "unit": null,
    "table_title": "Pages read",
    "table": "Day | Number of pages\nSunday | 243\nMonday | 239\nTuesday | 242\nWednesday | 223",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 223.\n\nNow find the corresponding day. Wednesday corresponds to 223.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "22857",
    "path": "data"
  },
  {
    "question": "A city planner counted the number of floors per building in the downtown area. How many buildings have fewer than 54 floors?",
    "choices": null,
    "answer": "6",
    "unit": "buildings",
    "table_title": "Floors per building",
    "table": "Stem | Leaf \n1 | 0\n2 | 0, 2, 5\n3 | 0, 5\n4 | \n5 | 9\n6 | 5",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, and 4.\n\nIn the row with stem 5, count all the leaves less than 4.\n\nYou counted 6 leaves, which are blue in the stem-and-leaf plots above. 6 buildings have fewer than 54 floors.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "33002",
    "path": "data"
  },
  {
    "question": "Fans of the Silvergrove baseball team compared the number of games won by their team each year. According to the table, what was the rate of change between 2016 and 2017?",
    "choices": null,
    "answer": "26",
    "unit": "games per year",
    "table_title": "Games won by the Silvergrove baseball team",
    "table": "Year | Games won\n2014 | 26\n2015 | 5\n2016 | 17\n2017 | 43\n2018 | 42",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{43 games - 17 games}{2017 - 2016}\n = \\frac{43 games - 17 games}{1 year}\n = \\frac{26 games}{1 year}\n = 26 games per year\nThe rate of change between 2016 and 2017 was 26 games per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "23481",
    "path": "data"
  },
  {
    "question": "Some friends discussed the sizes of their coin collections. Who has the fewest coins?",
    "choices": [
      "Ben",
      "Luther",
      "Dalton",
      "Troy"
    ],
    "answer": "Troy",
    "unit": null,
    "table_title": "Coin collections",
    "table": "Name | Number of coins\nBen | 395\nLuther | 353\nDalton | 359\nTroy | 339",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 339.\n\nNow find the corresponding name. Troy corresponds to 339.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "14566",
    "path": "data"
  },
  {
    "question": "Some students at Silvergrove Middle School signed up to help out with the school play. Are there more students on the sound committee or the costume committee?",
    "choices": [
      "sound",
      "costume"
    ],
    "answer": "costume",
    "unit": null,
    "table_title": "School play committees",
    "table": "Committee | Girls | Boys\nCasting | 15 | 16\nSound | 5 | 12\nCostume | 20 | 13",
    "row_num": 4,
    "column_num": 3,
    "solution": "Add the numbers in the Sound row. Then, add the numbers in the Costume row.\n\nsound: 5 + 12 = 17\ncostume: 20 + 13 = 33\n\n33 is more than 17. More students are on the costume committee.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "31900",
    "path": "data"
  },
  {
    "question": "How much money does Walter need to buy a map of Africa and a dog calendar?",
    "choices": null,
    "answer": "25",
    "unit": "$",
    "table_title": null,
    "table": "cookbook | $17\nmap of Africa | $12\nmath book | $12\ndog calendar | $13",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a map of Africa and the price of a dog calendar:\n\n$12 + $13 = $25\n\nWalter needs $25.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "5523",
    "path": "data"
  },
  {
    "question": "How much more does a king snake cost than an iguana?",
    "choices": null,
    "answer": "175",
    "unit": "$",
    "table_title": null,
    "table": "king snake | $289\niguana | $114\nhedgehog | $195\nfinch | $157",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of an iguana from the price of a king snake.\n\n$289 - $114 = $175\n\nA king snake costs $175 more than an iguana.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "24135",
    "path": "data"
  },
  {
    "question": "A volunteer for the local running club counted the number of participants at each race. How many races had at least 51 participants but fewer than 92 participants?",
    "choices": null,
    "answer": "10",
    "unit": "races",
    "table_title": "Participants per race",
    "table": "Stem | Leaf \n5 | 0, 2, 3, 4, 6\n6 | 3, 7\n7 | 0, 3\n8 | 5\n9 | 0",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row with stem 5. Count all the leaves greater than or equal to 1.\n\nCount all the leaves in the rows with stems 6, 7, and 8.\n\nIn the row with stem 9, count all the leaves less than 2.\n\nYou counted 10 leaves, which are blue in the stem-and-leaf plots above. 10 races had at least 51 participants but fewer than 92 participants.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "2920",
    "path": "data"
  },
  {
    "question": "Amelia counted the number of pieces of pepperoni on each pizza she made. How many pizzas had exactly 18 pieces of pepperoni?",
    "choices": null,
    "answer": "3",
    "unit": "pizzas",
    "table_title": "Pieces of pepperoni per pizza",
    "table": "Stem | Leaf \n1 | 0, 0, 1, 5, 6, 7, 8, 8, 8, 9\n2 | 6, 7, 9\n3 | 0, 0, 3, 6, 6\n4 | 1, 2, 4, 6",
    "row_num": 5,
    "column_num": 2,
    "solution": "For the number 18, the stem is 1, and the leaf is 8. Find the row where the stem is 1. In that row, count all the leaves equal to 8.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plot above. 3 pizzas had exactly18 pieces of pepperoni.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "25740",
    "path": "data"
  },
  {
    "question": "How much more does a large plate cost than a rolling pin?",
    "choices": null,
    "answer": "5",
    "unit": "$",
    "table_title": null,
    "table": "mixing bowl | $9\nrolling pin | $4\nglass measuring cup | $5\nlarge plate | $9",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a rolling pin from the price of a large plate.\n\n$9 - $4 = $5\n\nA large plate costs $5 more than a rolling pin.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "10871",
    "path": "data"
  },
  {
    "question": "Leah wrote down how many spelling words she practiced each day. What is the range of the numbers?",
    "choices": null,
    "answer": "28",
    "unit": null,
    "table_title": "Spelling words practiced",
    "table": "Day | Number of spelling words\nWednesday | 79\nThursday | 86\nFriday | 87\nSaturday | 59\nSunday | 67\nMonday | 87",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n79, 86, 87, 59, 67, 87\n\nFirst, find the greatest number. The greatest number is 87.\n\nNext, find the least number. The least number is 59.\n\nSubtract the least number from the greatest number:\n\n87 \u2212 59 = 28\n\nThe range is 28.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "19156",
    "path": "data"
  },
  {
    "question": "A cookie factory monitored the number of broken cookies per pack yesterday. How many packs had at least 50 broken cookies but less than 69 broken cookies?",
    "choices": null,
    "answer": "4",
    "unit": "packs",
    "table_title": "Broken cookies per pack",
    "table": "Stem | Leaf \n2 | 2, 4, 6\n3 | 1, 2, 4, 4, 5, 5, 7\n4 | 1, 6\n5 | 4, 6\n6 | 5, 7\n7 | 0, 1, 6, 6, 7",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count all the leaves in the row with stem 5.\n\nIn the row with stem 6, count all the leaves less than 9.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plots above. 4 packs had at least 50 broken cookies but less than 69 broken cookies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "37381",
    "path": "data"
  },
  {
    "question": "How much more does a book about sharks cost than a book about ballet?",
    "choices": null,
    "answer": "0.96",
    "unit": "$",
    "table_title": null,
    "table": "book about sharks | $17.31\nbook about basketball | $18.22\nbook about soccer | $12.47\nbook about helicopters | $15.69\nbook about Australia | $17.39\nbook about ballet | $16.35",
    "row_num": 6,
    "column_num": 2,
    "solution": "Subtract the price of a book about ballet from the price of a book about sharks.\n\n$17.31 - $16.35 = $0.96\n\nA book about sharks costs $0.96 more than a book about ballet.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "2046",
    "path": "data"
  },
  {
    "question": "A food critic counted the number of menu items at each restaurant in town. What is the largest number of menu items?",
    "choices": null,
    "answer": "90",
    "unit": "menu items",
    "table_title": "Menu items per restaurant",
    "table": "Stem | Leaf \n4 | 0, 3, 6\n5 | 2, 6\n6 | 3, 3, 5, 9\n7 | 9\n8 | 0, 7, 7, 8, 9\n9 | 0",
    "row_num": 7,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe largest number of menu items has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe largest number of menu items is 90 menu items.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "15494",
    "path": "data"
  },
  {
    "question": "A philanthropic organization compared the amounts of money that its members donated to certain causes. Who donated the most money to hunger prevention?",
    "choices": [
      "Hazel",
      "Edmond",
      "Danielle",
      "Travis"
    ],
    "answer": "Edmond",
    "unit": null,
    "table_title": "Donations",
    "table": "Person | Arts education | Hunger prevention\nEdmond | $13 | $16\nHazel | $3 | $9\nDanielle | $18 | $15\nTravis | $14 | $10",
    "row_num": 5,
    "column_num": 3,
    "solution": "Look at the numbers in the Hunger prevention column. Find the greatest number in this column.\n\nThe greatest number is $16.00, which is in the Edmond row. Edmond donated the most to hunger prevention.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "4786",
    "path": "data"
  },
  {
    "question": "Ms. Bradford reported her students' scores on the most recent quiz. How many students scored exactly 17 points?",
    "choices": null,
    "answer": "1",
    "unit": "students",
    "table_title": "Quiz scores",
    "table": "Stem | Leaf \n1 | 6, 7, 8\n2 | 1, 4, 6, 7\n3 | \n4 | 1, 2, 5, 7, 7, 9\n5 | 1, 8, 9",
    "row_num": 6,
    "column_num": 2,
    "solution": "For the number 17, the stem is 1, and the leaf is 7. Find the row where the stem is 1. In that row, count all the leaves equal to 7.\n\nYou counted 1 leaf, which is blue in the stem-and-leaf plot above. 1 student scored exactly17 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "3434",
    "path": "data"
  },
  {
    "question": "A law firm in Silvergrove kept track of how many hours were billed by each partner last year. What fraction of the hours were billed by Wendy? Simplify your answer.",
    "choices": null,
    "answer": "19/65",
    "unit": null,
    "table_title": "Law firm hours billed",
    "table": "Partner | Hours billed\nWendy | 570\nMarcy | 860\nDylan | 520",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find how many hours were billed by Wendy.\n\n570\n\nFind how many hours were billed in total.\n\n570 + 860 + 520 = 1,950\n\nDivide 570 by1,950.\n\n\\frac{570}{1,950}\n\nReduce the fraction.\n\n\\frac{570}{1,950} \u2192 \\frac{19}{65}\n\n\\frac{19}{65} of hours were billed by Wendy.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "25564",
    "path": "data"
  },
  {
    "question": "An employee at the craft store counted the number of red buttons in each bag of mixed buttons. How many bags had at least 40 red buttons?",
    "choices": null,
    "answer": "17",
    "unit": null,
    "table_title": "Red buttons per bag",
    "table": "Stem | Leaf \n1 | 3, 3, 6\n2 | 0, 1, 9\n3 | 2, 8\n4 | 9\n5 | 4, 6\n6 | 0, 3, 4, 4, 4, 5, 5, 6, 8\n7 | 0, 3, 6, 7, 8",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 4, 5, 6, and 7.\n\nYou counted 17 leaves, which are blue in the stem-and-leaf plot above. 17 bags had at least 40 red buttons.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "21789",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which movie ends at 2.15 P.M.?",
    "choices": [
      "Car Chases and Motorcycle Races",
      "The Crystal Ball of Fortune",
      "The Fairy Tale Princess",
      "Return to Tumbleweed City"
    ],
    "answer": "The Crystal Ball of Fortune",
    "unit": null,
    "table_title": "Movie schedule",
    "table": "Movie | Begin | End\nTime Traveler II | 8:25 A.M. | 9:30 A.M.\nReturn to Tumbleweed City | 8:45 A.M. | 11:35 A.M.\nCar Chases and Motorcycle Races | 10:35 A.M. | 1:05 P.M.\nThe Crystal Ball of Fortune | 12:10 P.M. | 2:15 P.M.\nThe Fairy Tale Princess | 1:15 P.M. | 4:00 P.M.\nWitches and Wizards on Broomsticks | 3:10 P.M. | 4:20 P.M.\nAliens from Outer Space | 3:20 P.M. | 5:55 P.M.",
    "row_num": 8,
    "column_num": 3,
    "solution": "Find 2:15 P. M. on the schedule. The Crystal Ball of Fortune ends at 2:15 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "11796",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the wrestling meet end?",
    "choices": [
      "8:40 P.M.",
      "2:30 P.M.",
      "3:50 P.M.",
      "5:15 P.M."
    ],
    "answer": "2:30 P.M.",
    "unit": null,
    "table_title": "University sports schedule",
    "table": "Event | Begin | End\nmen's volleyball game | 11:25 A.M. | 1:10 P.M.\nwrestling meet | 12:15 P.M. | 2:30 P.M.\nrugby match | 2:45 P.M. | 3:50 P.M.\nwomen's basketball game | 3:15 P.M. | 5:15 P.M.\nmen's basketball game | 4:50 P.M. | 6:35 P.M.\nswim meet | 5:45 P.M. | 8:40 P.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find the wrestling meet on the schedule. Find the end time for the wrestling meet.\n\nwrestling meet: 2:30 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "22832",
    "path": "data"
  },
  {
    "question": "Each town has 2 libraries. How many libraries are in 3 towns?",
    "choices": null,
    "answer": "6",
    "unit": "libraries",
    "table_title": null,
    "table": "Number of towns | Number of libraries\n1 | 2\n2 | 4\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 6 libraries in 3 towns.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "5142",
    "path": "data"
  },
  {
    "question": "A survey asked office workers what they like to do when taking a break from work. What fraction of the respondents preferred surfing the internet? Simplify your answer.",
    "choices": null,
    "answer": "73/312",
    "unit": null,
    "table_title": "Preferred break activities",
    "table": "Activity | Number of respondents\nMaking phone calls | 650\nChatting with coworkers | 560\nChecking personal e-mail | 370\nSending text messages | 180\nSurfing the internet | 730\nHaving a snack | 630",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find how many respondents preferred surfing the internet.\n\n730\n\nFind how many people responded in total.\n\n650 + 560 + 370 + 180 + 730 + 630 = 3,120\n\nDivide 730 by 3,120.\n\n\\frac{730}{3,120}\n\nReduce the fraction.\n\n\\frac{730}{3,120} \u2192 \\frac{73}{312}\n\n\\frac{73}{312} of respondents preferred surfing the internet.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "33842",
    "path": "data"
  },
  {
    "question": "Hanson went to the store and bought 2 kilograms of cucumbers. How much did he spend?",
    "choices": null,
    "answer": "1.92",
    "unit": "$",
    "table_title": null,
    "table": "potatoes | $0.75 per kilogram\nzucchini | $0.60 per kilogram\nbeets | $0.29 per kilogram\ncucumbers | $0.96 per kilogram\ncarrots | $0.62 per kilogram",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the cucumbers. Multiply the price per kilogram by the number of kilograms.\n\n$0.96 \u00d7 2 = $1.92\n\nHe spent $1.92.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "27615",
    "path": "data"
  },
  {
    "question": "In science class, Maria is learning about places with extreme temperatures. She learns that the highest temperature ever recorded was in Death Valley, California. She also learns that the lowest temperature ever recorded was in Vostok Station, Antarctica. The record-setting temperatures of the two locations are shown in the table. Which location's temperature was further from zero?",
    "choices": [
      "Death Valley",
      "Vostok Station"
    ],
    "answer": "Death Valley",
    "unit": null,
    "table_title": null,
    "table": "Location | Temperature (\u00b0F)\nDeath Valley | 134\nVostok Station | -128",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive number means the temperature was above zero. A negative number means the temperature was below zero.\nTo find which temperature was further from zero, use absolute value. Absolute value tells you how far a temperature is from zero.\nDeath Valley: |134| = 134\nVostok Station: |-128| = 128\nThe temperature of Death Valley was further from zero. It was 134 degrees above zero.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "35345",
    "path": "data"
  },
  {
    "question": "Each basket has 5 marigolds. How many marigolds are in 4 baskets?",
    "choices": null,
    "answer": "20",
    "unit": "marigolds",
    "table_title": null,
    "table": "Number of baskets | Number of marigolds\n1 | 5\n2 | 10\n3 | 15\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 20 marigolds in 4 baskets.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "9921",
    "path": "data"
  },
  {
    "question": "Preston counted the number of problems on each of his tests. How many tests had at least 80 problems?",
    "choices": null,
    "answer": "5",
    "unit": "tests",
    "table_title": "Problems per test",
    "table": "Stem | Leaf \n4 | 0, 3, 6, 7\n5 | 4, 4\n6 | 0, 6\n7 | 1, 2, 2, 4, 5, 9\n8 | 2, 3, 6\n9 | 0, 0",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 8 and 9.\n\nYou counted 5 leaves, which are blue in the stem-and-leaf plot above. 5 tests had at least 80 problems.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "10988",
    "path": "data"
  },
  {
    "question": "Aaron buys 3 kilograms of orange beads. How much does he spend?",
    "choices": null,
    "answer": "7.71",
    "unit": "$",
    "table_title": null,
    "table": "black beads | $2.18/kilogram\nyellow beads | $3.45/kilogram\nblue beads | $3.00/kilogram\nred beads | $3.38/kilogram\norange beads | $2.57/kilogram\ngreen beads | $2.52/kilogram\npurple beads | $3.22/kilogram",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the cost of the orange beads. Multiply the price per kilogram by the number of kilograms.\n\n$2.57 \u00d7 3 = $7.71\n\nHe spends $7.71.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "17253",
    "path": "data"
  },
  {
    "question": "The train conductor made sure to count the number of passengers on each train. How many trains had at least 20 passengers but fewer than 80 passengers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Passengers per train",
    "table": "Stem | Leaf \n2 | 0, 0, 0\n3 | \n4 | 7\n5 | \n6 | 1\n7 | 5\n8 | 7",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 2, 3, 4, 5, 6, and 7.\n\nYou counted 6 leaves, which are blue in the stem-and-leaf plot above. 6 trains had at least 20 passengers but fewer than 80 passengers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "948",
    "path": "data"
  },
  {
    "question": "A farmer recalled how many watermelons were harvested in the past 4 days. On which day were the most watermelons harvested?",
    "choices": [
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday"
    ],
    "answer": "Sunday",
    "unit": null,
    "table_title": "Watermelons harvested",
    "table": "Day | Number of watermelons\nSunday | 583\nMonday | 535\nTuesday | 538\nWednesday | 558",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 583.\n\nNow find the corresponding day. Sunday corresponds to 583.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "30757",
    "path": "data"
  },
  {
    "question": "A pretzel stand owner kept track of the number of pretzels sold during the past 4 days. On which day did the stand sell the most pretzels?",
    "choices": [
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday"
    ],
    "answer": "Sunday",
    "unit": null,
    "table_title": "Pretzels sold",
    "table": "Day | Number of pretzels\nSunday | 79\nMonday | 72\nTuesday | 71\nWednesday | 74",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 79.\n\nNow find the corresponding day. Sunday corresponds to 79.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "1665",
    "path": "data"
  },
  {
    "question": "To get credit for meeting her school's community service requirement, Kate kept a volunteering log. What is the range of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Hours spent volunteering",
    "table": "Day | Hours\nTuesday | 2\nWednesday | 4\nThursday | 5\nFriday | 2\nSaturday | 5\nSunday | 3",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 4, 5, 2, 5, 3\n\nFirst, find the greatest number. The greatest number is 5.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n5 \u2212 2 = 3\n\nThe range is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "37678",
    "path": "data"
  },
  {
    "question": "An archer recalled how many times he hit the bull's-eye in the past 7 days. What is the median of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Bull's-eyes",
    "table": "Day | Number of bull's-eyes\nFriday | 6\nSaturday | 1\nSunday | 10\nMonday | 9\nTuesday | 5\nWednesday | 6\nThursday | 8",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 1, 10, 9, 5, 6, 8\n\nFirst, arrange the numbers from least to greatest:\n\n1, 5, 6, 6, 8, 9, 10\n\nNow find the number in the middle.\n\n1, 5, 6, 6, 8, 9, 10\n\nThe number in the middle is 6.\n\nThe median is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "654",
    "path": "data"
  },
  {
    "question": "The teachers at a middle school counted how many computers they had in their classrooms. What is the mean of the numbers?",
    "choices": null,
    "answer": "15",
    "unit": null,
    "table_title": "Computers in classrooms",
    "table": "Teacher | Number of computers\nMrs. Rossi | 14\nMrs. Jansen | 15\nMiss Murphy | 14\nMr. Schmidt | 15\nMr. Lim | 16\nMs. Cohen | 15\nMr. Morales | 16\nMrs. Tan | 15",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n14, 15, 14, 15, 16, 15, 16, 15\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n14 + 15 + 14 + 15 + 16 + 15 + 16 + 15 = 120\n\nNow divide the sum by the number of numbers:\n\n120 \u00f7 8 = 15\n\nThe mean is 15.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "32128",
    "path": "data"
  },
  {
    "question": "Zane tracked the maximum daily wind speed for 4 days. Which day had the highest wind speed?",
    "choices": [
      "Friday",
      "Saturday",
      "Sunday",
      "Monday"
    ],
    "answer": "Friday",
    "unit": null,
    "table_title": "Daily wind speed",
    "table": "Day | Wind speed (miles per hour)\nFriday | 29\nSaturday | 25\nSunday | 21\nMonday | 28",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 29.\n\nNow find the corresponding day. Friday corresponds to 29.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "33967",
    "path": "data"
  },
  {
    "question": "Scott wants to buy 1.6 pounds of banana chips. How much will he spend?",
    "choices": null,
    "answer": "8",
    "unit": "$",
    "table_title": null,
    "table": "dried apple | $6/lb\ndried pear | $3/lb\nraisins | $4/lb\nbanana chips | $5/lb\ndried pineapple | $6/lb",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the banana chips. Multiply the price per pound by the number of pounds.\n$5 \u00d7 1.6 = $8\nHe will spend $8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "7023",
    "path": "data"
  },
  {
    "question": "What is the total cost for 0.4 pounds of red bell peppers?",
    "choices": null,
    "answer": "0.40",
    "unit": "$",
    "table_title": null,
    "table": "red bell peppers | $1/lb\npurple bell peppers | $1/lb\nchili peppers | $1/lb\ngreen bell peppers | $2/lb\nAnaheim peppers | $3/lb\nhabanero peppers | $2/lb",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the red bell peppers. Multiply the price per pound by the number of pounds.\n$1 \u00d7 0.4 = $0.40\nThe total cost is $0.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "21668",
    "path": "data"
  },
  {
    "question": "The gym teacher wrote down how many tennis balls his students hit in half an hour. What is the mean of the numbers?",
    "choices": null,
    "answer": "65",
    "unit": null,
    "table_title": "Hitting tennis balls",
    "table": "Name | Number of tennis balls\nBella | 62\nShelby | 63\nLee | 57\nZack | 72\nGarrett | 72\nWinston | 62\nKeenan | 58\nJack | 74",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n62, 63, 57, 72, 72, 62, 58, 74\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n62 + 63 + 57 + 72 + 72 + 62 + 58 + 74 = 520\n\nNow divide the sum by the number of numbers:\n\n520 \u00f7 8 = 65\n\nThe mean is 65.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "1007",
    "path": "data"
  },
  {
    "question": "A school district compared how many students attend each elementary school. Which school has the fewest students?",
    "choices": [
      "Eastside Elementary",
      "Douglas Elementary",
      "West Elementary",
      "North River Elementary"
    ],
    "answer": "Douglas Elementary",
    "unit": null,
    "table_title": "Elementary school attendance",
    "table": "School | Number of students\nEastside Elementary | 987\nDouglas Elementary | 978\nWest Elementary | 979\nNorth River Elementary | 998",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 978.\n\nNow find the corresponding school. Douglas Elementary corresponds to 978.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "31531",
    "path": "data"
  },
  {
    "question": "Isabella joined a book club to spend more quality time with her cousin. At the first meeting, club members recorded how many hours a week they typically read and whether they preferred e-readers or paperback books. What is the probability that a randomly selected club member prefers paperback books and reads about 1 hour per week? Simplify any fractions.",
    "choices": null,
    "answer": "3/20",
    "unit": null,
    "table_title": null,
    "table": " | About 1 hour per week | About 3 hours per week\nE-readers | 2 | 7\nPaperback books | 3 | 8",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the club member prefers paperback books\" and B be the event \"the club member reads about 1 hour per week\".\nTo find the probability that a club member prefers paperback books and reads about 1 hour per week, first identify the sample space and the event.\nThe outcomes in the sample space are the different club members. Each club member is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the club member prefers paperback books and reads about 1 hour per week\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the club member prefers paperback books and reads about 1 hour per week\", so look at the table to see how many club members prefer paperback books and read about 1 hour per week.\nThe number of club members who prefer paperback books and read about 1 hour per week is 3.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of club members.\n2 + 3 + 7 + 8 = 20\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{3}{20}\nThe probability that a club member prefers paperback books and reads about 1 hour per week is \\frac{3}{20}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "14953",
    "path": "data"
  },
  {
    "question": "For an assignment, Preston looked at which countries got the most Nobel Prizes in various decades. In the 1980s, how many more Nobel Prize winners did Germany have than Japan?",
    "choices": null,
    "answer": "9",
    "unit": "Nobel Prize winners",
    "table_title": "Nobel Prize winners",
    "table": "Country | 1980s | 1990s\nJapan | 2 | 1\nGermany | 11 | 7\nFrance | 5 | 3\nRussia | 1 | 1",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the 1980 s column. Find the numbers in this column for Germany and Japan.\n\nGermany: 11\nJapan: 2\n\nNow subtract:\n\n11 \u2212 2 = 9\n\nGermany had 9 more Nobel Prize winners in the 1980 s than Japan.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "21765",
    "path": "data"
  },
  {
    "question": "A county agency recorded the money donated to several charitable causes over time. How much more money was raised for medical research in April than in May?",
    "choices": null,
    "answer": "3",
    "unit": "$",
    "table_title": "Donations received",
    "table": "Cause | April | May\nParks | $2 | $5\nEducation | $18 | $20\nHunger | $2 | $4\nMedical research | $5 | $2",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the Medical research row. Find the numbers in this row for April and May.\n\nApril: $5.00\nMay: $2.00\n\nNow subtract:\n\n$5.00 \u2212 $2.00 = $3.00\n\n$3 more was raised for medical research in April than in May.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "25694",
    "path": "data"
  },
  {
    "question": "Kamal has $38.00. Does he have enough to buy a ladder and a shovel?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "measuring tape | $14.00\nladder | $21.00\nshovel | $18.00\nlawn mower | $65.00\ngarden hose | $13.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a ladder and the price of a shovel:\n\n$21.00 + $18.00 = $39.00\n\n$39.00 is more than $38.00. Kamal does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "26968",
    "path": "data"
  },
  {
    "question": "What is the total cost for 1.1 kilograms of marinara sauce?",
    "choices": null,
    "answer": "2.20",
    "unit": "$",
    "table_title": null,
    "table": "pesto sauce | $2/kilogram\ntomato sauce | $2/kilogram\nchicken sauce | $3/kilogram\nalfredo sauce | $2/kilogram\nmarinara sauce | $2/kilogram",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the marinara sauce. Multiply the price per kilogram by the number of kilograms.\n$2 \u00d7 1.1 = $2.20\nThe total cost is $2.20.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "9875",
    "path": "data"
  },
  {
    "question": "If Marvin buys 4+1/10 pounds of sand, how much will he spend?",
    "choices": null,
    "answer": "8.20",
    "unit": "$",
    "table_title": null,
    "table": "sawdust | $5/lb\ndirt | $3/lb\nmulch | $2/lb\nsand | $2/lb\nbark | $2/lb",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the sand. Multiply the price per pound by the number of pounds.\n$2 \u00d7 4\\frac{1}{10} = $2 \u00d7 4.1 = $8.20\nHe will spend $8.20.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "245",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Jaylen just missed the 1.15 P.M. train at Belmont. What time is the next train?",
    "choices": [
      "3:30 A.M.",
      "10:00 P.M.",
      "9:45 P.M.",
      "6:30 P.M."
    ],
    "answer": "6:30 P.M.",
    "unit": null,
    "table_title": "Train schedule",
    "table": "Ashland | 3:45 A.M. | 12:00 P.M. | 5:15 P.M. | 8:45 P.M. | 10:30 P.M.\nBelmont | 5:00 A.M. | 1:15 P.M. | 6:30 P.M. | 10:00 P.M. | 11:45 P.M.\nSpringtown | 6:45 A.M. | 3:00 P.M. | 8:15 P.M. | 11:45 P.M. | 1:30 A.M.\nOxford | 8:15 A.M. | 4:30 P.M. | 9:45 P.M. | 1:15 A.M. | 3:00 A.M.\nCedarburg | 9:30 A.M. | 5:45 P.M. | 11:00 P.M. | 2:30 A.M. | 4:15 A.M.\nOak Grove | 10:15 A.M. | 6:30 P.M. | 11:45 P.M. | 3:15 A.M. | 5:00 A.M.\nBrookfield | 11:30 A.M. | 7:45 P.M. | 1:00 A.M. | 4:30 A.M. | 6:15 A.M.\nOakdale | 1:00 P.M. | 9:15 P.M. | 2:30 A.M. | 6:00 A.M. | 7:45 A.M.\nRichmond | 2:00 P.M. | 10:15 P.M. | 3:30 A.M. | 7:00 A.M. | 8:45 A.M.",
    "row_num": 9,
    "column_num": 6,
    "solution": "Find 1:15 P. M. in the row for Belmont.\n\nLook for the next train in that row.\n\nThe next train is at 6:30 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "11649",
    "path": "data"
  },
  {
    "question": "Reagan went to the store and bought 2.5 pounds of rib. How much did she spend?",
    "choices": null,
    "answer": "17.50",
    "unit": "$",
    "table_title": null,
    "table": "chuck | $5/lb\nflank | $10/lb\nloin | $10/lb\nbrisket | $7/lb\nround | $5/lb\nshank | $10/lb\nrib | $7/lb",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the cost of the rib. Multiply the price per pound by the number of pounds.\n$7 \u00d7 2.5 = $17.50\nShe spent $17.50.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "9163",
    "path": "data"
  },
  {
    "question": "A pizza chef recalled how many pizzas he had made during the past 7 days. What is the mean of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Pizzas made",
    "table": "Day | Number of pizzas\nTuesday | 5\nWednesday | 8\nThursday | 7\nFriday | 9\nSaturday | 10\nSunday | 10\nMonday | 7",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 8, 7, 9, 10, 10, 7\n\nFirst, count how many numbers are in the group.\n\nThere are 7 numbers.\n\nNow add all the numbers together:\n\n5 + 8 + 7 + 9 + 10 + 10 + 7 = 56\n\nNow divide the sum by the number of numbers:\n\n56 \u00f7 7 = 8\n\nThe mean is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "8875",
    "path": "data"
  },
  {
    "question": "A farm equipment company kept a record of the number of tractors made each month. What is the range of the numbers?",
    "choices": null,
    "answer": "17",
    "unit": null,
    "table_title": "Tractors made",
    "table": "Month | Number of tractors\nNovember | 28\nDecember | 15\nJanuary | 11\nFebruary | 12\nMarch | 26\nApril | 12",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n28, 15, 11, 12, 26, 12\n\nFirst, find the greatest number. The greatest number is 28.\n\nNext, find the least number. The least number is 11.\n\nSubtract the least number from the greatest number:\n\n28 \u2212 11 = 17\n\nThe range is 17.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "18754",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. How long does it take to get from the landmark sculpture to the famous bridge?",
    "choices": [
      "45 minutes",
      "1 hour and 15 minutes",
      "1 hour",
      "30 minutes"
    ],
    "answer": "1 hour and 15 minutes",
    "unit": null,
    "table_title": "Tour bus schedule",
    "table": "city hall | 9:30 A.M. | 9:45 A.M. | 10:45 A.M.\nart museum | 10:00 A.M. | 10:15 A.M. | 11:15 A.M.\nshopping district | 10:15 A.M. | 10:30 A.M. | 11:30 A.M.\nthe riverfront | 11:15 A.M. | 11:30 A.M. | 12:30 P.M.\nlandmark sculpture | 11:45 A.M. | 12:00 P.M. | 1:00 P.M.\ndowntown | 12:00 P.M. | 12:15 P.M. | 1:15 P.M.\nfamous bridge | 1:00 P.M. | 1:15 P.M. | 2:15 P.M.",
    "row_num": 7,
    "column_num": 4,
    "solution": "Read the times in the first column for the landmark sculpture and the famous bridge.\n\nFind the elapsed time between 11:45 A. M. and 1:00 P. M. The elapsed time is 1 hour and 15 minutes.\n\nNo matter which column of times you look at, the elapsed time is always 1 hour and 15 minutes.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 4,
    "split": "dev",
    "pid": "15816",
    "path": "data"
  },
  {
    "question": "Each shelf has 5 hammers. How many hammers are on 3 shelves?",
    "choices": null,
    "answer": "15",
    "unit": "hammers",
    "table_title": null,
    "table": "Number of shelves | Number of hammers\n1 | 5\n2 | 10\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 15 hammers on 3 shelves.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "18559",
    "path": "data"
  },
  {
    "question": "A real estate agent looked into how many houses were sold in different cities. What is the range of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "House sales",
    "table": "City | Number of houses sold\nBriggs Corner | 46\nPleasant Town | 50\nCenter City | 50\nFremont | 51\nNew Hamburg | 47",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n46, 50, 50, 51, 47\n\nFirst, find the greatest number. The greatest number is 51.\n\nNext, find the least number. The least number is 46.\n\nSubtract the least number from the greatest number:\n\n51 \u2212 46 = 5\n\nThe range is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "36228",
    "path": "data"
  },
  {
    "question": "Mrs. Olson told students how many rounds to expect in the spelling bee based on previous years. According to the table, what was the rate of change between 2017 and 2018?",
    "choices": null,
    "answer": "-4",
    "unit": "rounds per year",
    "table_title": "Rounds in the spelling bee",
    "table": "Year | Rounds\n2015 | 12\n2016 | 15\n2017 | 14\n2018 | 10\n2019 | 16",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{10 rounds - 14 rounds}{2018 - 2017}\n = \\frac{10 rounds - 14 rounds}{1 year}\n = \\frac{-4 rounds}{1 year}\n = -4 rounds per year\nThe rate of change between 2017 and 2018 was - 4 rounds per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "3421",
    "path": "data"
  },
  {
    "question": "How much money does Allie need to buy a dry erase marker and a package of note cards?",
    "choices": null,
    "answer": "1.58",
    "unit": "$",
    "table_title": null,
    "table": "bottle of glue | $0.82\ndry erase marker | $0.95\npackage of note cards | $0.63\nrubber stamp | $0.65",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a dry erase marker and the price of a package of note cards:\n\n$0.95 + $0.63 = $1.58\n\nAllie needs $1.58.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "8285",
    "path": "data"
  },
  {
    "question": "What is the total cost for 1.7 pounds of soy sauce?",
    "choices": null,
    "answer": "8.50",
    "unit": "$",
    "table_title": null,
    "table": "hot sauce | $5/lb\nketchup | $5/lb\nDijon mustard | $2/lb\nsoy sauce | $5/lb",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the soy sauce. Multiply the price per pound by the number of pounds.\n$5 \u00d7 1.7 = $8.50\nThe total cost is $8.50.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "2720",
    "path": "data"
  },
  {
    "question": "Some pizza restaurants compared their pizza sales. Which restaurant sold the fewest pizza slices?",
    "choices": [
      "Deep Dish by Dan",
      "Taste of New York",
      "Pizza Italia",
      "Antonio's Pizzeria"
    ],
    "answer": "Pizza Italia",
    "unit": null,
    "table_title": "Pizza slices sold",
    "table": "Restaurant | Number of slices sold\nDeep Dish by Dan | 57\nTaste of New York | 59\nPizza Italia | 51\nAntonio's Pizzeria | 56",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 51.\n\nNow find the corresponding restaurant. Pizza Italia corresponds to 51.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "31920",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $420, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$420 | 18,500 | 10,500\n$620 | 17,500 | 13,200\n$820 | 16,500 | 15,900\n$1,020 | 15,500 | 18,600\n$1,220 | 14,500 | 21,300",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $420, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "17681",
    "path": "data"
  },
  {
    "question": "The parks department compared how many soccer fields there are at each park. What is the range of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Soccer fields",
    "table": "Park | Number of soccer fields\nCanyon Park | 7\nWindy Hill Park | 3\nElmhurst Park | 2\nLighthouse Park | 8\nMadison Park | 4",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 3, 2, 8, 4\n\nFirst, find the greatest number. The greatest number is 8.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n8 \u2212 2 = 6\n\nThe range is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "8184",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $785, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$445 | 18,200 | 2,800\n$615 | 14,000 | 6,400\n$785 | 9,800 | 10,000\n$955 | 5,600 | 13,600\n$1,125 | 1,400 | 17,200",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $785, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "32576",
    "path": "data"
  },
  {
    "question": "A school administrator who was concerned about grade inflation looked over the number of straight-A students from year to year. According to the table, what was the rate of change between 2007 and 2008?",
    "choices": null,
    "answer": "9",
    "unit": "students per year",
    "table_title": "Straight-A students",
    "table": "Year | Students\n2006 | 22\n2007 | 22\n2008 | 31\n2009 | 26\n2010 | 27",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{31 students - 22 students}{2008 - 2007}\n = \\frac{31 students - 22 students}{1 year}\n = \\frac{9 students}{1 year}\n = 9 students per year\nThe rate of change between 2007 and 2008 was 9 students per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "23565",
    "path": "data"
  },
  {
    "question": "Some friends played a trivia game and recorded their scores. What is the mode of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Trivia game scores",
    "table": "Name | Score\nEvelyn | 2\nPreston | 4\nDylan | 7\nLacey | 4\nKate | 7\nWanda | 4\nTerrence | 4\nShelby | 7",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 4, 7, 4, 7, 4, 4, 7\n\nFirst, arrange the numbers from least to greatest:\n\n2, 4, 4, 4, 4, 7, 7, 7\n\nNow count how many times each number appears.\n\n2 appears 1 time.\n4 appears 4 times.\n7 appears 3 times.\n\nThe number that appears most often is 4.\n\nThe mode is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "33775",
    "path": "data"
  },
  {
    "question": "Employees at Kenneth's Movies tracked the number of movies that customers rented last month. How many customers rented a movie more than 4 times?",
    "choices": null,
    "answer": "1",
    "unit": null,
    "table_title": "Renting movies last month",
    "table": "Number of times | Frequency\n0 | 3\n1 | 19\n2 | 13\n3 | 14\n4 | 9\n5 | 1",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row for 5 times and read the frequency. The frequency is 1.\n\n1 customer rented a movie more than 4 times.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "32615",
    "path": "data"
  },
  {
    "question": "Some farmers compared how many tractors they own. What is the mean of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Tractors",
    "table": "Farmer | Number of tractors\nFarmer Tom | 7\nFarmer Jane | 10\nFarmer Walt | 9\nFarmer Joe | 7\nFarmer Megan | 10\nFarmer Rob | 5\nFarmer Alex | 1\nFarmer Andy | 7",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 10, 9, 7, 10, 5, 1, 7\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n7 + 10 + 9 + 7 + 10 + 5 + 1 + 7 = 56\n\nNow divide the sum by the number of numbers:\n\n56 \u00f7 8 = 7\n\nThe mean is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "26939",
    "path": "data"
  },
  {
    "question": "Derek's Candies has been studying how much chocolate people have been eating in different countries. Which country consumed the least chocolate per capita in 2002?",
    "choices": [
      "Australia",
      "Belgium",
      "Sweden",
      "Denmark"
    ],
    "answer": "Australia",
    "unit": null,
    "table_title": "Chocolate consumption per capita (kg)",
    "table": "Country | 2002 | 2005\nDenmark | 9 | 8\nAustralia | 4 | 5\nSweden | 8 | 7\nBelgium | 8 | 11",
    "row_num": 5,
    "column_num": 3,
    "solution": "Look at the numbers in the 2002 column. Find the least number in this column.\n\nThe least number is 4, which is in the Australia row. Australia consumed the least chocolate per capita in 2002.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "30146",
    "path": "data"
  },
  {
    "question": "A sandwich shop in Newport polled its customers regarding their favorite sandwiches. What fraction of customers preferred egg salad sandwiches? Simplify your answer.",
    "choices": null,
    "answer": "47/88",
    "unit": null,
    "table_title": "Sandwich preference",
    "table": "Sandwich | Number of customers\nCheese | 300\nEgg salad | 940\nOther | 520",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find how many customers preferred egg salad sandwiches.\n\n940\n\nFind how many customers participated in the poll in total.\n\n300 + 940 + 520 = 1,760\n\nDivide 940 by1,760.\n\n\\frac{940}{1,760}\n\nReduce the fraction.\n\n\\frac{940}{1,760} \u2192 \\frac{47}{88}\n\n\\frac{47}{88} of customers preferred egg salad sandwiches.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "6906",
    "path": "data"
  },
  {
    "question": "Zoe went to the store. She bought 4 pounds of cranberry applesauce, 1 pound of unsweetened applesauce, and 5 pounds of blueberry applesauce. How much did she spend?",
    "choices": null,
    "answer": "40",
    "unit": "$",
    "table_title": null,
    "table": "blueberry applesauce | $6 per lb\ncranberry applesauce | $2 per lb\nplain applesauce | $5 per lb\nunsweetened applesauce | $2 per lb\nraspberry applesauce | $5 per lb\nstrawberry applesauce | $3 per lb",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the cranberry applesauce. Multiply:\n\n$2 \u00d7 4 = $8\n\nFind the cost of the unsweetened applesauce. Multiply:\n\n$2 \u00d7 1 = $2\n\nFind the cost of the blueberry applesauce. Multiply:\n\n$6 \u00d7 5 = $30\n\nNow find the total cost by adding:\n\n$8 + $2 + $30 = $40\n\nShe spent $40.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "34206",
    "path": "data"
  },
  {
    "question": "How much money does Abdul need to buy 8 shovels and a garden hose?",
    "choices": null,
    "answer": "133",
    "unit": "$",
    "table_title": null,
    "table": "wrench | $12\nhammer | $25\nlawn sprinkler | $12\nrake | $24\nshovel | $14\ngarden hose | $21",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of 8 shovels.\n\n$14 \u00d7 8 = $112\n\nNow find the total cost.\n\n$112 + $21 = $133\n\nAbdul needs $133.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "17663",
    "path": "data"
  },
  {
    "question": "A volunteer for the local running club counted the number of participants at each race. What is the smallest number of participants?",
    "choices": null,
    "answer": "8",
    "unit": "participants",
    "table_title": "Participants per race",
    "table": "Stem | Leaf \n0 | 8\n1 | 9\n2 | \n3 | 0, 8\n4 | \n5 | 2\n6 | \n7 | 6\n8 | 3, 8\n9 | 0",
    "row_num": 11,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 0.\n\nNow find the lowest leaf in the first row. The lowest leaf is 8.\n\nThe smallest number of participants has a stem of 0 and a leaf of 8. Write the stem first, then the leaf: 08.\n\nThe smallest number of participants is 8 participants.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "5334",
    "path": "data"
  },
  {
    "question": "Look at this table. Is this relation a function?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "x | y\n0 | 20\n16 | 6\n8 | 2",
    "row_num": 4,
    "column_num": 2,
    "solution": "Look at the x-values in the table.\n\nEach of the x-values is paired with only one y-value, so the relation is a function.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "10408",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. At which stop does the train arrive at 11.10 A.M.?",
    "choices": [
      "Wilson Road",
      "Taylor Boulevard",
      "Elm Street",
      "Center Boulevard"
    ],
    "answer": "Taylor Boulevard",
    "unit": null,
    "table_title": "Subway train schedule",
    "table": "Location | Time\nJefferson Road | 8:55 A.M.\nWilson Road | 9:15 A.M.\nAdams Boulevard | 9:40 A.M.\nOak Boulevard | 10:20 A.M.\nTaylor Boulevard | 11:10 A.M.\nElm Street | 11:20 A.M.\nCollege Avenue | 11:50 A.M.\nBroadway Avenue | 12:30 P.M.\nLee Street | 1:15 P.M.\nCenter Boulevard | 1:30 P.M.",
    "row_num": 11,
    "column_num": 2,
    "solution": "Find 11:10 A. M. on the schedule. The train arrives at Taylor Boulevard at 11:10 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "24941",
    "path": "data"
  },
  {
    "question": "Jaylen has $2.67. Does he have enough to buy a bottle of vegetable oil and a bottle of chocolate syrup?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "jar of tomato sauce | $1.84\nbottle of soy sauce | $1.51\nbottle of vegetable oil | $1.39\nbottle of olive oil | $4.62\nbottle of chocolate syrup | $1.16",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a bottle of vegetable oil and the price of a bottle of chocolate syrup:\n\n$1.39 + $1.16 = $2.55\n\n$2.55 is less than $2.67. Jaylen does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 7,
    "split": "dev",
    "pid": "19348",
    "path": "data"
  },
  {
    "question": "Wayne looked at the dates of the digital photos on his computer to find out how many he had taken in the past 5 days. What is the range of the numbers?",
    "choices": null,
    "answer": "1",
    "unit": null,
    "table_title": "Photographs taken",
    "table": "Day | Number of photographs\nFriday | 2\nSaturday | 3\nSunday | 2\nMonday | 2\nTuesday | 3",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 3, 2, 2, 3\n\nFirst, find the greatest number. The greatest number is 3.\n\nNext, find the least number. The least number is 2.\n\nSubtract the least number from the greatest number:\n\n3 \u2212 2 = 1\n\nThe range is 1.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "10557",
    "path": "data"
  },
  {
    "question": "Herman has $1.37. How much money will Herman have left if he buys a pin with a picture of the beach and a tiny bottle of sand?",
    "choices": null,
    "answer": "0.25",
    "unit": "$",
    "table_title": null,
    "table": "beach postcard | $0.51\npicture of a shark | $0.61\ntiny bottle of sand | $0.52\nshell necklace | $0.92\npin with a picture of the beach | $0.60",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of a pin with a picture of the beach and a tiny bottle of sand.\n\n$0.60 + $0.52 = $1.12\n\nNow subtract the total cost from the starting amount.\n\n$1.37 - $1.12 = $0.25\n\nHerman will have $0.25 left.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 4,
    "split": "dev",
    "pid": "20750",
    "path": "data"
  },
  {
    "question": "A city recorded how many people rode the subway each day. How many people in total rode the subway on Tuesday and Wednesday?",
    "choices": null,
    "answer": "8,974",
    "unit": "people",
    "table_title": "Subway riders",
    "table": "Day | Number of riders\nTuesday | 7,822\nWednesday | 1,152\nThursday | 1,022",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nTuesday: 7,822\nWednesday: 1,152\n\nNow add: 7,822 + 1,152 = 8,974.\n\n8,974 people rode the subway on Tuesday and Wednesday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "34048",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. At which stop does the ferry arrive at 1.05 P.M.?",
    "choices": [
      "Rocky Port",
      "Bay Harbor",
      "Starfish City",
      "Foggy Port"
    ],
    "answer": "Rocky Port",
    "unit": null,
    "table_title": "Ferry schedule",
    "table": "Location | Arrive | Depart\nBay Harbor | 7:00 A.M. | 7:30 A.M.\nFoggy Port | 8:20 A.M. | 8:50 A.M.\nStarfish City | 10:20 A.M. | 10:30 A.M.\nSeagull Port | 10:50 A.M. | 11:20 A.M.\nPebble Town | 11:45 A.M. | 12:05 P.M.\nRocky Port | 1:05 P.M. | 1:35 P.M.\nGreen Harbor | 3:00 P.M. | 3:30 P.M.\nGrassy Beach | 5:10 P.M. | 5:30 P.M.",
    "row_num": 9,
    "column_num": 3,
    "solution": "Find 1:05 P. M. on the schedule. The ferry arrives at Rocky Port at 1:05 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "390",
    "path": "data"
  },
  {
    "question": "Some students visited nearby zoos to record the number of bears kept there. How many bears are there at the Midwest Zoo?",
    "choices": null,
    "answer": "24",
    "unit": "bears",
    "table_title": "Bears in zoos",
    "table": "Zoo | Panda bears | Polar bears\nPacific Zoo | 13 | 8\nMidwest Zoo | 14 | 10\nEastern Zoo | 13 | 4",
    "row_num": 4,
    "column_num": 3,
    "solution": "Find the row for Midwest Zoo. Add the numbers in the Midwest Zoo row.\n\nAdd:\n\n14 + 10 = 24\n\nThe Midwest Zoo has 24 bears.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "16975",
    "path": "data"
  },
  {
    "question": "How much money does Manny need to buy a brown cat's eye bead and a green emerald bead?",
    "choices": null,
    "answer": "0.77",
    "unit": "$",
    "table_title": null,
    "table": "long red bead | $0.43\nbrown cat's eye bead | $0.24\norange and yellow striped bead | $0.40\nshiny metal bead | $0.26\ngreen emerald bead | $0.53",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a brown cat's eye bead and the price of a green emerald bead:\n\n$0.24 + $0.53 = $0.77\n\nManny needs $0.77.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 3,
    "split": "dev",
    "pid": "34592",
    "path": "data"
  },
  {
    "question": "Tiana's class recorded how many cans of food each student collected for their canned food drive. What is the median of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Cans of food collected",
    "table": "Name | Number of cans of food\nTiana | 9\nElizabeth | 4\nDarnel | 8\nColton | 7\nSasha | 8",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 4, 8, 7, 8\n\nFirst, arrange the numbers from least to greatest:\n\n4, 7, 8, 8, 9\n\nNow find the number in the middle.\n\n4, 7, 8, 8, 9\n\nThe number in the middle is 8.\n\nThe median is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "21261",
    "path": "data"
  },
  {
    "question": "Elizabeth bought 2 kilograms of spirali pasta. How much did she spend?",
    "choices": null,
    "answer": "5.40",
    "unit": "$",
    "table_title": null,
    "table": "rigatoni pasta | $3.10/kilogram\nspirali pasta | $2.70/kilogram\nrotini pasta | $1.54/kilogram\npenne pasta | $1.96/kilogram\nfarfalle pasta | $3.05/kilogram\nfusilli pasta | $1.39/kilogram",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the spirali pasta. Multiply the price per kilogram by the number of kilograms.\n\n$2.70 \u00d7 2 = $5.40\n\nShe spent $5.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "8332",
    "path": "data"
  },
  {
    "question": "Dr. Richmond, a zoo director, researched ticket prices at other zoos around the country. At the Denver Zoo, how much more does an adult ticket cost than a child ticket?",
    "choices": null,
    "answer": "5",
    "unit": "$",
    "table_title": "Zoo ticket prices",
    "table": "Zoo | Adult | Child\nMinnesota | $16 | $10\nDenver | $12 | $7\nLos Angeles | $13 | $8\nBoise | $6 | $3",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the Denver row. Find the numbers in this row for adult and child.\n\nadult: $12.00\nchild: $7.00\n\nNow subtract:\n\n$12.00 \u2212 $7.00 = $5.00\n\nAt the Denver Zoo, an adult ticket cost $5 more than a child ticket.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "18141",
    "path": "data"
  },
  {
    "question": "An author kept a log of how many pages he wrote in the past 6 days. What is the mean of the numbers?",
    "choices": null,
    "answer": "25",
    "unit": null,
    "table_title": "Pages written",
    "table": "Day | Number of pages\nSunday | 26\nMonday | 25\nTuesday | 24\nWednesday | 28\nThursday | 21\nFriday | 26",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n26, 25, 24, 28, 21, 26\n\nFirst, count how many numbers are in the group.\n\nThere are 6 numbers.\n\nNow add all the numbers together:\n\n26 + 25 + 24 + 28 + 21 + 26 = 150\n\nNow divide the sum by the number of numbers:\n\n150 \u00f7 6 = 25\n\nThe mean is 25.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "16881",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which event begins at 11.35 A.M.?",
    "choices": [
      "swimming competition",
      "obstacle course",
      "softball game",
      "pie-eating contest"
    ],
    "answer": "pie-eating contest",
    "unit": null,
    "table_title": "School picnic schedule",
    "table": "Event | Begin | End\nsoftball game | 11:00 A.M. | 11:40 A.M.\npie-eating contest | 11:35 A.M. | 12:25 P.M.\nsoccer game | 12:45 P.M. | 1:35 P.M.\nswimming competition | 1:40 P.M. | 2:05 P.M.\ndance competition | 2:15 P.M. | 3:05 P.M.\nobstacle course | 2:45 P.M. | 3:10 P.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find 11:35 A. M. on the schedule. The pie-eating contest begins at 11:35 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "15971",
    "path": "data"
  },
  {
    "question": "A science teacher presented a balloon to his class, and posed the question, \"If I keep this balloon in the freezer overnight, what will occur?\" He followed up with, \"How certain are you of your answer?\" The teacher recorded his students' responses. What is the probability that a randomly selected student was uncertain and believes the balloon will stay the same? Simplify any fractions.",
    "choices": null,
    "answer": "1/5",
    "unit": null,
    "table_title": null,
    "table": " | Shrink | Stay the same\nCertain | 2 | 4\nUncertain | 2 | 2",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the student was uncertain\" and B be the event \"the student believes the balloon will stay the same\".\nTo find the probability that a student was uncertain and believes the balloon will stay the same, first identify the sample space and the event.\nThe outcomes in the sample space are the different students. Each student is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the student was uncertain and believes the balloon will stay the same\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the student was uncertain and believes the balloon will stay the same\", so look at the table to see how many students were uncertain and believe the balloon will stay the same.\nThe number of students who were uncertain and believe the balloon will stay the same is 2.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of students.\n2 + 2 + 4 + 2 = 10\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{2}{10}\n = \\frac{1}{5}\nThe probability that a student was uncertain and believes the balloon will stay the same is \\frac{1}{5}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "12306",
    "path": "data"
  },
  {
    "question": "The soccer coach is preparing for the upcoming season by seeing how many goals his team members scored last season. How many team members scored at least 1 goal last season?",
    "choices": null,
    "answer": "42",
    "unit": null,
    "table_title": "Soccer goals last season",
    "table": "Goals scored | Frequency\n0 | 19\n1 | 16\n2 | 15\n3 | 11",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the rows for 1, 2, and 3 goals last season. Add the frequencies for these rows.\n\nAdd:\n\n16 + 15 + 11 = 42\n\n42 team members scored at least 1 goal last season.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "31235",
    "path": "data"
  },
  {
    "question": "Each football field has 2 sprinklers. How many sprinklers are on 4 football fields?",
    "choices": null,
    "answer": "8",
    "unit": "sprinklers",
    "table_title": null,
    "table": "Number of football fields | Number of sprinklers\n1 | 2\n2 | 4\n3 | 6\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 8 sprinklers on 4 football fields.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "29622",
    "path": "data"
  },
  {
    "question": "How much money does Britney need to buy 9 golf carts?",
    "choices": null,
    "answer": "41,562",
    "unit": "$",
    "table_title": null,
    "table": "kayak | $1,372.00\nconvertible | $6,917.00\nboxcar | $6,988.00\ngolf cart | $4,618.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of 9 golf carts by multiplying 9 times the price of a golf cart.\n\n$4,618.00 \u00d7 9 = $41,562.00\n\nBritney needs $41,562.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "21771",
    "path": "data"
  },
  {
    "question": "The houses in Amanda's town get their water from a local reservoir. Amanda and a group of engineers monitor the water level for safety and health reasons. The change in water level over two months is shown in the table. During which month did the water level change more?",
    "choices": [
      "April",
      "May"
    ],
    "answer": "April",
    "unit": null,
    "table_title": null,
    "table": "Month | Change in water level (in.)\nApril | -6\nMay | 4",
    "row_num": 3,
    "column_num": 2,
    "solution": "A positive change means the water level went up. A negative change means the water level went down.\nTo find the month the water level changed more, use absolute value. Absolute value tells you how much the water level changed each month.\nApril: |-6| = 6\nMay: |4| = 4\nThe water level went down 6 inches in April, and it only went up 4 inches in May. The water level changed more in April.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "27106",
    "path": "data"
  },
  {
    "question": "An agricultural agency is researching how much cheese people have been eating in different parts of the world. Which country consumed the least cheese per capita in 1996?",
    "choices": [
      "Austria",
      "Great Britain",
      "Germany",
      "Argentina"
    ],
    "answer": "Great Britain",
    "unit": null,
    "table_title": "Cheese consumption per capita (kg)",
    "table": "Country | 1996 | 2006\nAustria | 10 | 17\nCanada | 10 | 11\nArgentina | 11 | 11\nGreat Britain | 9 | 10\nGermany | 12 | 20",
    "row_num": 6,
    "column_num": 3,
    "solution": "Look at the numbers in the 1996 column. Find the least number in this column.\n\nThe least number is 9, which is in the Great Britain row. Great Britain consumed the least cheese per capita in 1996.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "18675",
    "path": "data"
  },
  {
    "question": "In trying to calculate how much money could be saved by packing lunch, Johnny recorded the amount he spent on lunch each day. According to the table, what was the rate of change between Tuesday and Wednesday?",
    "choices": null,
    "answer": "0",
    "unit": "$, per day",
    "table_title": "Amount Johnny spent on lunch",
    "table": "Day | Amount spent\nSunday | $1\nMonday | $10\nTuesday | $2\nWednesday | $2\nThursday | $4",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{$2 - $2}{1 day}\n = \\frac{$0}{1 day}\n = $0 perday\nThe rate of change between Tuesday and Wednesday was $0 perday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "4200",
    "path": "data"
  },
  {
    "question": "Each field has 2 sheep. How many sheep are in 6 fields?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": null,
    "table": "Number of fields | Number of sheep\n1 | 2\n2 | 4\n3 | 6\n4 | 8\n5 | 10\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 12 sheep in 6 fields.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "34747",
    "path": "data"
  },
  {
    "question": "Several students participated in a race. Which runner took the longest?",
    "choices": [
      "Ruth",
      "Heather",
      "Mitch",
      "Norma"
    ],
    "answer": "Heather",
    "unit": null,
    "table_title": "Race results",
    "table": "Runner | Time (minutes)\nRuth | 20\nHeather | 29\nMitch | 23\nNorma | 22",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 29.\n\nNow find the corresponding runner. Heather corresponds to 29.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "6695",
    "path": "data"
  },
  {
    "question": "How much money does Kylie need to buy a red thumbtack and a gold tack?",
    "choices": null,
    "answer": "0.12",
    "unit": "$",
    "table_title": null,
    "table": "elastic band | $0.08\nred thumbtack | $0.03\nsmall metal hook | $0.04\ngold tack | $0.09\nbrass clip | $0.02",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a red thumbtack and the price of a gold tack:\n\n$0.03 + $0.09 = $0.12\n\nKylie needs $0.12.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 3,
    "split": "dev",
    "pid": "31081",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does Weightlifting class begin?",
    "choices": [
      "8:55 A.M.",
      "1:10 P.M.",
      "10:05 A.M.",
      "3:50 P.M."
    ],
    "answer": "8:55 A.M.",
    "unit": null,
    "table_title": "Gym teacher's schedule",
    "table": "Class | Begin | End\nWeightlifting | 8:55 A.M. | 10:05 A.M.\nSwimming | 10:20 A.M. | 11:10 A.M.\nBallet | 11:20 A.M. | 1:00 P.M.\nAerobics | 1:10 P.M. | 1:45 P.M.\nSocial Dance | 1:50 P.M. | 2:35 P.M.\nFloor Hockey | 2:40 P.M. | 3:50 P.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find Weightlifting class on the schedule. Find the beginning time for Weightlifting class.\n\nWeightlifting: 8:55 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "21821",
    "path": "data"
  },
  {
    "question": "The employee at the department store counted the number of ties on each tie rack. How many racks have exactly 67 ties?",
    "choices": null,
    "answer": "4",
    "unit": "racks",
    "table_title": "Ties per rack",
    "table": "Stem | Leaf \n3 | 2, 5, 6\n4 | 2, 9, 9\n5 | 0, 1, 3, 3, 4, 5, 7, 8, 9\n6 | 6, 7, 7, 7, 7, 9\n7 | 2, 5, 9",
    "row_num": 6,
    "column_num": 2,
    "solution": "For the number 67, the stem is 6, and the leaf is 7. Find the row where the stem is 6. In that row, count all the leaves equal to 7.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plot above. 4 racks have exactly 67 ties.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "25736",
    "path": "data"
  },
  {
    "question": "The county released data about how many schools there are in each town. What is the range of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Schools in each town",
    "table": "Town | Number of schools\nChesterton | 3\nRichmond | 8\nAshland | 5\nMarion | 4\nSpringfield | 8\nColumbia | 8\nSalem | 5\nRiverside | 5",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n3, 8, 5, 4, 8, 8, 5, 5\n\nFirst, find the greatest number. The greatest number is 8.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n8 \u2212 3 = 5\n\nThe range is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "18174",
    "path": "data"
  },
  {
    "question": "Victor just downloaded the new game Gem Excavator on his phone. In the first level, Victor gains points for each green gem he finds. However, he loses points for each red gem he finds. The table shows how the gems affect Victor's points. Which color gem affects Victor's points less?",
    "choices": [
      "green",
      "red"
    ],
    "answer": "green",
    "unit": null,
    "table_title": null,
    "table": "Gem color | Change in points\nGreen | 25\nRed | -40",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find the gem that affects Victor's points less, use absolute value. Absolute value tells you how much Victor's points change for each color gem.\nGreen: |25| = 25\nRed: |-40| = 40\nVictor gains 25 points for each green gem he finds, and he loses 40 points for each red gem he finds. So, the green gems affect Victor's points less.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "25590",
    "path": "data"
  },
  {
    "question": "Vicky purchased 2/5 of a kilogram of dried apple. What was the total cost?",
    "choices": null,
    "answer": "1.20",
    "unit": "$",
    "table_title": null,
    "table": "dried pear | $1/kilogram\ndried apple | $3/kilogram\nraisins | $3/kilogram\nbanana chips | $1/kilogram\ndried pineapple | $3/kilogram",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the dried apple. Multiply the price per kilogram by the number of kilograms.\n$3 \u00d7 \\frac{2}{5} = $3 \u00d7 0.4 = $1.20\nThe total cost was $1.20.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "31062",
    "path": "data"
  },
  {
    "question": "Jon jotted down how many minutes he spent practicing golf in the past 4 days. On which day did Jon practice the most?",
    "choices": [
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday"
    ],
    "answer": "Thursday",
    "unit": null,
    "table_title": "Minutes spent practicing",
    "table": "Day | Minutes\nTuesday | 61\nWednesday | 63\nThursday | 68\nFriday | 64",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 68.\n\nNow find the corresponding day. Thursday corresponds to 68.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "29601",
    "path": "data"
  },
  {
    "question": "The advertising agency counted the number of billboards in each city in the state. How many cities have at least 10 billboards but fewer than 60 billboards?",
    "choices": null,
    "answer": "7",
    "unit": "cities",
    "table_title": "Billboards per city",
    "table": "Stem | Leaf \n1 | 1, 8\n2 | 9\n3 | \n4 | 0, 8, 9\n5 | 3\n6 | 1, 7",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, 4, and 5.\n\nYou counted 7 leaves, which are blue in the stem-and-leaf plot above. 7 cities have at least 10 billboards but fewer than 60 billboards.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "35661",
    "path": "data"
  },
  {
    "question": "How much money does Shelley need to buy 4 gumballs?",
    "choices": null,
    "answer": "0.52",
    "unit": "$",
    "table_title": null,
    "table": "gum drop | $0.12\ngumball | $0.13\ngummy worm | $0.17\npiece of mint chocolate | $0.15\ngrape lollipop | $0.18\nlemon drop | $0.19",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the total cost of 4 gumballs by multiplying 4 times the price of a gumball.\n\n$0.13 \u00d7 4 = $0.52\n\nShelley needs $0.52.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "30672",
    "path": "data"
  },
  {
    "question": "Every year Belleville has a citywide relay and reports the winning times. According to the table, what was the rate of change between 2017 and 2018?",
    "choices": null,
    "answer": "14",
    "unit": "minutes per year",
    "table_title": "Winning relay times",
    "table": "Year | Winning time (minutes)\n2016 | 39\n2017 | 31\n2018 | 45\n2019 | 45\n2020 | 27",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{45 minutes - 31 minutes}{2018 - 2017}\n = \\frac{45 minutes - 31 minutes}{1 year}\n = \\frac{14 minutes}{1 year}\n = 14 minutes per year\nThe rate of change between 2017 and 2018 was 14 minutes per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "13088",
    "path": "data"
  },
  {
    "question": "Some scooter companies compared how many scooters they sold. In all, how many scooters did Zippy Scooters and Just Scooters sell?",
    "choices": null,
    "answer": "6,010",
    "unit": "scooters",
    "table_title": "Scooters sold",
    "table": "Company | Number of scooters sold\nGo-Go Scooters | 3,290\nZippy Scooters | 4,921\nJust Scooters | 1,089\nScooters Galore | 3,750\nLet's Jet Scooters | 3,551",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nZippy Scooters: 4,921\nJust Scooters: 1,089\n\nNow add: 4,921 + 1,089 = 6,010.\n\nIn all, Zippy Scooters and Just Scooters sold 6,010 scooters.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "35857",
    "path": "data"
  },
  {
    "question": "A pottery factory kept track of the number of broken plates per shipment last week. What is the smallest number of broken plates?",
    "choices": null,
    "answer": "41",
    "unit": "broken plates",
    "table_title": "Broken plates per shipment",
    "table": "Stem | Leaf \n4 | 1\n5 | \n6 | 3, 8, 9, 9\n7 | 2, 2\n8 | \n9 | 0",
    "row_num": 7,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 4.\n\nNow find the lowest leaf in the first row. The lowest leaf is 1.\n\nThe smallest number of broken plates has a stem of 4 and a leaf of 1. Write the stem first, then the leaf: 41.\n\nThe smallest number of broken plates is 41 broken plates.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "33991",
    "path": "data"
  },
  {
    "question": "Jayce wants to buy 2 pounds of straw mushrooms. How much will he spend?",
    "choices": null,
    "answer": "20.56",
    "unit": "$",
    "table_title": null,
    "table": "oyster mushrooms | $17.07 per lb\nportobello mushrooms | $9.34 per lb\nchanterelle mushrooms | $29.43 per lb\nstraw mushrooms | $10.28 per lb\nporcini mushrooms | $21.80 per lb\nenoki mushrooms | $17.91 per lb",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the straw mushrooms. Multiply the price per pound by the number of pounds.\n\n$10.28 \u00d7 2 = $20.56\n\nHe will spend $20.56.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "29461",
    "path": "data"
  },
  {
    "question": "Each shelf has 5 scarves. How many scarves are on 4 shelves?",
    "choices": null,
    "answer": "20",
    "unit": "scarves",
    "table_title": null,
    "table": "Number of shelves | Number of scarves\n1 | 5\n2 | 10\n3 | 15\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 20 scarves on 4 shelves.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "19878",
    "path": "data"
  },
  {
    "question": "Billy wrote down how many pages he read over the past 4 days. How many pages in total did Billy read on Monday and Wednesday?",
    "choices": null,
    "answer": "221",
    "unit": "pages",
    "table_title": "Pages read",
    "table": "Day | Number of pages\nSunday | 116\nMonday | 113\nTuesday | 156\nWednesday | 108",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nMonday: 113\nWednesday: 108\n\nNow add: 113 + 108 = 221.\n\nBilly read 221 pages on Monday and Wednesday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "37603",
    "path": "data"
  },
  {
    "question": "Each van has 10 open seats. How many open seats are in 3 vans?",
    "choices": null,
    "answer": "30",
    "unit": null,
    "table_title": null,
    "table": "Number of vans | Number of open seats\n1 | 10\n2 | 20\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 30 open seats in 3 vans.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "32625",
    "path": "data"
  },
  {
    "question": "The bird-watching club recorded how many birds its members saw each month. In which month did the club see the fewest birds?",
    "choices": [
      "December",
      "January",
      "February",
      "March"
    ],
    "answer": "December",
    "unit": null,
    "table_title": "Number of birds seen",
    "table": "Month | Number of birds\nDecember | 632\nJanuary | 656\nFebruary | 668\nMarch | 653",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 632.\n\nNow find the corresponding month. December corresponds to 632.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "17619",
    "path": "data"
  },
  {
    "question": "Mrs. Jordan told students how many rounds to expect in the spelling bee based on previous years. According to the table, what was the rate of change between 2008 and 2009?",
    "choices": null,
    "answer": "-4",
    "unit": "rounds per year",
    "table_title": "Rounds in the spelling bee",
    "table": "Year | Rounds\n2008 | 10\n2009 | 6\n2010 | 14\n2011 | 8\n2012 | 5",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{6 rounds - 10 rounds}{2009 - 2008}\n = \\frac{6 rounds - 10 rounds}{1 year}\n = \\frac{-4 rounds}{1 year}\n = -4 rounds per year\nThe rate of change between 2008 and 2009 was - 4 rounds per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "3480",
    "path": "data"
  },
  {
    "question": "An economist tracked the amount of per-capita aid sent from the U.S. to various countries during the 1900s. In 1995, how much more aid per capita did Algeria receive than Pakistan?",
    "choices": null,
    "answer": "4",
    "unit": "$",
    "table_title": "Aid received per capita from the U.S.",
    "table": "Country | 1985 | 1995\nPakistan | $8 | $7\nLibya | $1 | $1\nAlgeria | $8 | $11\nAfghanistan | $1 | $10",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the 1995 column. Find the numbers in this column for Algeria and Pakistan.\n\nAlgeria: $11.00\nPakistan: $7.00\n\nNow subtract:\n\n$11.00 \u2212 $7.00 = $4.00\n\nIn 1995, Algeria received $4 more aid per capita than Pakistan received.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "33933",
    "path": "data"
  },
  {
    "question": "The bird watcher counted the number of birds in each flock that passed overhead. How many flocks had at least 35 birds but fewer than 78 birds?",
    "choices": null,
    "answer": "13",
    "unit": null,
    "table_title": "Birds per flock",
    "table": "Stem | Leaf \n1 | 3, 6, 8\n2 | \n3 | 3, 4, 7, 9\n4 | 3, 5\n5 | 1, 2, 4, 4, 5\n6 | 1, 2, 4\n7 | 2",
    "row_num": 8,
    "column_num": 2,
    "solution": "Find the row with stem 3. Count all the leaves greater than or equal to 5.\n\nCount all the leaves in the rows with stems 4, 5, and 6.\n\nIn the row with stem 7, count all the leaves less than 8.\n\nYou counted 13 leaves, which are blue in the stem-and-leaf plots above. 13 flocks had at least 35 birds but fewer than 78 birds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "22531",
    "path": "data"
  },
  {
    "question": "Each shelf has 10 books. How many books are on 5 shelves?",
    "choices": null,
    "answer": "50",
    "unit": "books",
    "table_title": null,
    "table": "Number of shelves | Number of books\n1 | 10\n2 | 20\n3 | 30\n4 | 40\n5 | ?",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 50 books on 5 shelves.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "22554",
    "path": "data"
  },
  {
    "question": "Betty kept a log of how many pages she read each month. In which month did Betty read the fewest pages?",
    "choices": [
      "July",
      "August",
      "September",
      "October"
    ],
    "answer": "October",
    "unit": null,
    "table_title": "Pages read",
    "table": "Month | Number of pages\nJuly | 64\nAugust | 63\nSeptember | 69\nOctober | 62",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 62.\n\nNow find the corresponding month. October corresponds to 62.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "35982",
    "path": "data"
  },
  {
    "question": "How much money does Paul need to buy a lawn chair and a rosebush?",
    "choices": null,
    "answer": "29",
    "unit": "$",
    "table_title": null,
    "table": "red clay pot | $11\nrosebush | $13\nlawn chair | $16\nlawn mower | $60",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a lawn chair and the price of a rosebush:\n\n$16 + $13 = $29\n\nPaul needs $29.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "25653",
    "path": "data"
  },
  {
    "question": "Vivian's class paid attention to how many bottles each student collected for their recycling project. What is the mean of the numbers?",
    "choices": null,
    "answer": "18",
    "unit": null,
    "table_title": "Bottles collected",
    "table": "Name | Number of bottles\nVivian | 13\nConnor | 19\nLola | 21\nNolan | 20\nDiane | 22\nAntonio | 16\nGina | 13\nKimi | 20",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n13, 19, 21, 20, 22, 16, 13, 20\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n13 + 19 + 21 + 20 + 22 + 16 + 13 + 20 = 144\n\nNow divide the sum by the number of numbers:\n\n144 \u00f7 8 = 18\n\nThe mean is 18.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "1116",
    "path": "data"
  },
  {
    "question": "How much would it cost to buy 3/4 of a kilogram of topaz?",
    "choices": null,
    "answer": "6",
    "unit": "$",
    "table_title": null,
    "table": "fool's gold | $6 per kg\ngranite | $5 per kg\ntiger's eye | $7 per kg\namethyst | $7 per kg\ntopaz | $8 per kg",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the topaz. Multiply the price per kilogram by the number of kilograms.\n$8 \u00d7 \\frac{3}{4} = $8 \u00d7 0.75 = $6\nIt would cost $6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "11614",
    "path": "data"
  },
  {
    "question": "Lara kept track of how many boxes of cookies she sold over the past 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Boxes of cookies sold",
    "table": "Day | Number of boxes\nFriday | 6\nSaturday | 5\nSunday | 8\nMonday | 5\nTuesday | 6",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 5, 8, 5, 6\n\nFirst, arrange the numbers from least to greatest:\n\n5, 5, 6, 6, 8\n\nNow find the number in the middle.\n\n5, 5, 6, 6, 8\n\nThe number in the middle is 6.\n\nThe median is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "38153",
    "path": "data"
  },
  {
    "question": "How much money does Rudy need to buy 6 guitars?",
    "choices": null,
    "answer": "34,398",
    "unit": "$",
    "table_title": null,
    "table": "piano | $1,041\ntrombone | $1,303\nguitar | $5,733\ncornet | $1,450",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of 6 guitars by multiplying 6 times the price of a guitar.\n\n$5,733 \u00d7 6 = $34,398\n\nRudy needs $34,398.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "37606",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $1,345, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$835 | 20,000 | 4,700\n$1,005 | 15,700 | 8,500\n$1,175 | 11,400 | 12,300\n$1,345 | 7,100 | 16,100\n$1,515 | 2,800 | 19,900",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $1,345, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "8445",
    "path": "data"
  },
  {
    "question": "The architecture student counted the number of bricks in each building in her neighborhood. What is the smallest number of bricks?",
    "choices": null,
    "answer": "20",
    "unit": "bricks",
    "table_title": "Bricks per building",
    "table": "Stem | Leaf \n2 | 0, 0, 3, 5, 6, 8\n3 | 2, 3, 4, 7, 8\n4 | 2, 3, 3, 4, 8\n5 | 1, 3, 7",
    "row_num": 5,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 2.\n\nNow find the lowest leaf in the first row. The lowest leaf is 0.\n\nThe smallest number of bricks has a stem of 2 and a leaf of 0. Write the stem first, then the leaf: 20.\n\nThe smallest number of bricks is 20 bricks.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "14390",
    "path": "data"
  },
  {
    "question": "An administrator at the Department of Motor Vehicles (DMV) tracked the average wait time from month to month. According to the table, what was the rate of change between May and June?",
    "choices": null,
    "answer": "-27",
    "unit": "minutes per month",
    "table_title": "Average waiting time at the DMV",
    "table": "Month | Waiting time (minutes)\nMay | 50\nJune | 23\nJuly | 45\nAugust | 26\nSeptember | 21",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{23 minutes - 50 minutes}{1 month}\n = \\frac{-27 minutes}{1 month}\n = -27 minutes per month\nThe rate of change between May and June was - 27 minutes per month.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "36785",
    "path": "data"
  },
  {
    "question": "Nina buys 4/5 of a kilogram of puffed rice bars. What is the total cost?",
    "choices": null,
    "answer": "2.40",
    "unit": "$",
    "table_title": null,
    "table": "lemon bars | $2/kg\npuffed rice bars | $3/kg\ncoffee cake | $3/kg\npopcorn balls | $2/kg\nblueberry bars | $2/kg",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the puffed rice bars. Multiply the price per kilogram by the number of kilograms.\n$3 \u00d7 \\frac{4}{5} = $3 \u00d7 0.8 = $2.40\nThe total cost is $2.40.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "23578",
    "path": "data"
  },
  {
    "question": "Joseph attended his town's annual Worm Charming Competition. Contestants are assigned to a square foot of land, where they have 30 minutes to \"charm\" worms to the surface of the dirt using a single technique. Joseph observed contestants' charming techniques, and kept track of how many worms surfaced. What is the probability that a randomly selected contestant charmed 5-10 worms and tried raking the ground? Simplify any fractions.",
    "choices": null,
    "answer": "1/6",
    "unit": null,
    "table_title": null,
    "table": " | Tapping the ground | Raking the ground\n5-10 worms | 5 | 2\n11-20 worms | 2 | 3",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the contestant charmed 5-10 worms\" and B be the event \"the contestant tried raking the ground\".\nTo find the probability that a contestant charmed 5-10 worms and tried raking the ground, first identify the sample space and the event.\nThe outcomes in the sample space are the different contestants. Each contestant is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the contestant charmed 5-10 worms and tried raking the ground\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the contestant charmed 5-10 worms and tried raking the ground\", so look at the table to see how many contestants charmed 5-10 worms and tried raking the ground.\nThe number of contestants who charmed 5-10 worms and tried raking the ground is 2.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of contestants.\n5 + 2 + 2 + 3 = 12\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{2}{12}\n = \\frac{1}{6}\nThe probability that a contestant charmed 5-10 worms and tried raking the ground is \\frac{1}{6}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "6694",
    "path": "data"
  },
  {
    "question": "A cookie factory monitored the number of broken cookies per pack yesterday. How many packs had at least 30 broken cookies but less than 40 broken cookies?",
    "choices": null,
    "answer": "2",
    "unit": "packs",
    "table_title": "Broken cookies per pack",
    "table": "Stem | Leaf \n2 | 7\n3 | 7, 8\n4 | 2\n5 | 1, 4, 6\n6 | \n7 | 2, 4, 4, 7",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count all the leaves in the row with stem 3.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 packs had at least 30 broken cookies but less than 40 broken cookies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "10542",
    "path": "data"
  },
  {
    "question": "Dr. Buchanan, a zoo director, researched ticket prices at other zoos around the country. At the Denver Zoo, how much more does a senior ticket cost than a child ticket?",
    "choices": null,
    "answer": "2",
    "unit": "$",
    "table_title": "Zoo ticket prices",
    "table": "Zoo | Child | Senior\nCleveland | $7 | $10\nCentral Florida | $7 | $9\nSan Francisco | $9 | $12\nLos Angeles | $8 | $10\nDenver | $7 | $9",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Denver row. Find the numbers in this row for senior and child.\n\nsenior: $9.00\nchild: $7.00\n\nNow subtract:\n\n$9.00 \u2212 $7.00 = $2.00\n\nAt the Denver Zoo, a senior ticket cost $2 more than a child ticket.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "37681",
    "path": "data"
  },
  {
    "question": "A survey asked office workers what they like to do when taking a break from work. What fraction of the respondents preferred sending text messages? Simplify your answer.",
    "choices": null,
    "answer": "18/277",
    "unit": null,
    "table_title": "Preferred break activities",
    "table": "Activity | Number of respondents\nSending text messages | 180\nChecking personal e-mail | 680\nMaking phone calls | 980\nStretching | 130\nHaving a snack | 650\nChatting with coworkers | 150",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find how many respondents preferred sending text messages.\n\n180\n\nFind how many people responded in total.\n\n180 + 680 + 980 + 130 + 650 + 150 = 2,770\n\nDivide 180 by2,770.\n\n\\frac{180}{2,770}\n\nReduce the fraction.\n\n\\frac{180}{2,770} \u2192 \\frac{18}{277}\n\n\\frac{18}{277} of respondents preferred sending text messages.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "24743",
    "path": "data"
  },
  {
    "question": "Some friends went bowling and kept track of their scores. Who had the highest score?",
    "choices": [
      "Sadie",
      "Elise",
      "Diane",
      "Harry"
    ],
    "answer": "Harry",
    "unit": null,
    "table_title": "Bowling scores",
    "table": "Name | Score\nSadie | 119\nElise | 151\nDiane | 159\nHarry | 195",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 195.\n\nNow find the corresponding name. Harry corresponds to 195.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "19928",
    "path": "data"
  },
  {
    "question": "Some friends compared the sizes of their sticker collections. What is the mode of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Sticker collections",
    "table": "Name | Number of stickers\nBernie | 7\nTrent | 7\nLily | 5\nRoxanne | 5\nNatalie | 5",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 7, 5, 5, 5\n\nFirst, arrange the numbers from least to greatest:\n\n5, 5, 5, 7, 7\n\nNow count how many times each number appears.\n\n5 appears 3 times.\n7 appears 2 times.\n\nThe number that appears most often is 5.\n\nThe mode is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "1150",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which stop does the train depart from at 11.15 A.M.?",
    "choices": [
      "art gallery district",
      "waterfront",
      "city park",
      "university"
    ],
    "answer": "city park",
    "unit": null,
    "table_title": "Subway train schedule",
    "table": "Location | Time\ncivic center | 9:10 A.M.\nuniversity | 9:20 A.M.\nfootball stadium | 10:10 A.M.\nwaterfront | 10:35 A.M.\ncity park | 11:15 A.M.\nbaseball stadium | 11:55 A.M.\nart gallery district | 12:30 P.M.\nrestaurant district | 1:20 P.M.",
    "row_num": 9,
    "column_num": 2,
    "solution": "Find 11:15 A. M. on the schedule. The train departs from the city park at 11:15 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "16512",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which stop does the train depart from at 12.50 P.M.?",
    "choices": [
      "soccer field",
      "zoo",
      "art museum",
      "hospital"
    ],
    "answer": "art museum",
    "unit": null,
    "table_title": "Light rail train schedule",
    "table": "Location | Time\nbaseball stadium | 11:00 A.M.\nzoo | 11:25 A.M.\nhospital | 11:45 A.M.\nsoccer field | 12:15 P.M.\nshopping mall | 12:20 P.M.\nart museum | 12:50 P.M.\nscience museum | 1:15 P.M.",
    "row_num": 8,
    "column_num": 2,
    "solution": "Find 12:50 P. M. on the schedule. The train departs from the art museum at 12:50 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "8031",
    "path": "data"
  },
  {
    "question": "The employee at the department store counted the number of ties on each tie rack. How many racks have fewer than 30 ties?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Ties per rack",
    "table": "Stem | Leaf \n1 | 0, 0, 3, 7\n2 | 0\n3 | 3\n4 | 3, 6, 8\n5 | 1, 2, 3, 7\n6 | 8",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1 and 2.\n\nYou counted 5 leaves, which are blue in the stem-and-leaf plot above. 5 racks have fewer than 30 ties.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "28920",
    "path": "data"
  },
  {
    "question": "How much money does Brad need to buy a train ticket to Seattle and a train ticket to Los Angeles?",
    "choices": null,
    "answer": "605",
    "unit": "$",
    "table_title": null,
    "table": "train ticket to Los Angeles | $130\ntrain ticket to Miami | $145\ntrain ticket to Baltimore | $935\ntrain ticket to Seattle | $475",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a train ticket to Seattle and the price of a train ticket to Los Angeles:\n\n$475 + $130 = $605\n\nBrad needs $605.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "17505",
    "path": "data"
  },
  {
    "question": "Each box has 2 jelly donuts. How many jelly donuts are in 5 boxes?",
    "choices": null,
    "answer": "10",
    "unit": "jelly donuts",
    "table_title": null,
    "table": "Number of boxes | Number of jelly donuts\n1 | 2\n2 | 4\n3 | 6\n4 | 8\n5 | ?",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 10 jelly donuts in 5 boxes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "34819",
    "path": "data"
  },
  {
    "question": "A girl compared the ages of her cousins. What is the range of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Ages of cousins",
    "table": "Name | Age (years)\nTara | 6\nHayley | 6\nDarnel | 7\nEddie | 3\nLillian | 7\nPam | 5\nColin | 7\nJustin | 5",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 6, 7, 3, 7, 5, 7, 5\n\nFirst, find the greatest number. The greatest number is 7.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n7 \u2212 3 = 4\n\nThe range is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "32100",
    "path": "data"
  },
  {
    "question": "Mrs. Fowler, the science teacher, informed her students of their scores on Monday's test. How many students scored exactly 90 points?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Science test scores",
    "table": "Stem | Leaf \n1 | 9\n2 | 2\n3 | \n4 | \n5 | 3, 7\n6 | 8, 8\n7 | 1\n8 | \n9 | 0, 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "For the number 90, the stem is 9, and the leaf is 0. Find the row where the stem is 9. In that row, count all the leaves equal to 0.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 students scored exactly 90 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "5712",
    "path": "data"
  },
  {
    "question": "While hanging Christmas lights for neighbors, Josiah counted the number of broken lights on each string. How many strings had at least 43 broken lights but less than 57 broken lights?",
    "choices": null,
    "answer": "6",
    "unit": "strings",
    "table_title": "Broken lights per string",
    "table": "Stem | Leaf \n3 | 2, 4, 6, 7, 8, 9, 9\n4 | 0, 2, 4, 4, 9\n5 | 2, 5, 6, 8, 8, 9\n6 | 3, 4, 6, 7",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the row with stem 4. Count all the leaves greater than or equal to 3.\n\nIn the row with stem 5, count all the leaves less than 7.\n\nYou counted 6 leaves, which are blue in the stem-and-leaf plots above. 6 strings had at least 43 broken lights but less than 57 broken lights.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "23083",
    "path": "data"
  },
  {
    "question": "At Brookfield Consulting, the head of human resources examined how the number of employees with health care benefits varied in response to policy changes. According to the table, what was the rate of change between 2019 and 2020?",
    "choices": null,
    "answer": "-2",
    "unit": "employees per year",
    "table_title": "Employees with health care benefits",
    "table": "Year | Employees\n2017 | 5\n2018 | 18\n2019 | 18\n2020 | 16\n2021 | 15",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{16 employees - 18 employees}{2020 - 2019}\n = \\frac{16 employees - 18 employees}{1 year}\n = \\frac{-2 employees}{1 year}\n = -2 employees per year\nThe rate of change between 2019 and 2020 was - 2 employees per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "14350",
    "path": "data"
  },
  {
    "question": "For an economics project, Abby determined the cost of ferry rides for bicycles and cars. Which charges more for a bicycle, the Ocracoke ferry or the Fauntleroy-Vashon ferry?",
    "choices": [
      "Fauntleroy-Vashon",
      "Ocracoke"
    ],
    "answer": "Fauntleroy-Vashon",
    "unit": null,
    "table_title": "Ferry fares",
    "table": "Ferry | Bicycle | Car\nSouthport-Fort Fisher | $2 | $5\nMukilteu-Clinton | $5 | $7\nOcracoke | $3 | $15\nSeattle-Bremerton | $8 | $12\nFauntleroy-Vashon | $5 | $15",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Bicycle column. Compare the numbers in this column for Ocracoke and Fauntleroy-Vashon.\n\n$5.00 is more than $3.00. The Fauntleroy-Vashon ferry charges more for a bicycle.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "3574",
    "path": "data"
  },
  {
    "question": "Miranda graphed the amount of snow that fell in the last 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Daily snowfall",
    "table": "Day | Snowfall (inches)\nTuesday | 2\nWednesday | 6\nThursday | 2\nFriday | 8\nSaturday | 3",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n2, 6, 2, 8, 3\n\nFirst, arrange the numbers from least to greatest:\n\n2, 2, 3, 6, 8\n\nNow find the number in the middle.\n\n2, 2, 3, 6, 8\n\nThe number in the middle is 3.\n\nThe median is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "33607",
    "path": "data"
  },
  {
    "question": "David just downloaded the new game Gem Excavator on his phone. In the first level, David gains points for each green gem he finds. However, he loses points for each red gem he finds. The table shows how the gems affect David's points. Which color gem affects David's points less?",
    "choices": [
      "green",
      "red"
    ],
    "answer": "green",
    "unit": null,
    "table_title": null,
    "table": "Gem color | Change in points\nGreen | 25\nRed | -40",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find the gem that affects David's points less, use absolute value. Absolute value tells you how much David's points change for each color gem.\nGreen: |25| = 25\nRed: |-40| = 40\nDavid gains 25 points for each green gem he finds, and he loses 40 points for each red gem he finds. So, the green gems affect David's points less.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "30629",
    "path": "data"
  },
  {
    "question": "A city planner counted the number of floors per building in the downtown area. How many buildings have fewer than 70 floors?",
    "choices": null,
    "answer": "17",
    "unit": "buildings",
    "table_title": "Floors per building",
    "table": "Stem | Leaf \n0 | 2, 7, 7\n1 | 2, 4, 5, 9\n2 | \n3 | 1, 2, 6, 7, 7\n4 | \n5 | 2, 4, 9\n6 | 0, 6\n7 | 2, 3, 4",
    "row_num": 9,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 0, 1, 2, 3, 4, 5, and 6.\n\nYou counted 17 leaves, which are blue in the stem-and-leaf plot above. 17 buildings have fewer than 70 floors.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "17485",
    "path": "data"
  },
  {
    "question": "A toy store employee counted the number of toys in each bin in the sale section. What is the largest number of toys?",
    "choices": null,
    "answer": "90",
    "unit": "toys",
    "table_title": "Toys per bin",
    "table": "Stem | Leaf \n1 | 4, 7\n2 | 2, 4, 7\n3 | 6, 8\n4 | \n5 | 2, 3, 3, 8\n6 | 3, 5, 5\n7 | 4\n8 | 1, 3\n9 | 0, 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe largest number of toys has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe largest number of toys is 90 toys.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "2817",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $405, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$405 | 21,000 | 3,700\n$505 | 20,400 | 7,000\n$605 | 19,800 | 10,300\n$705 | 19,200 | 13,600\n$805 | 18,600 | 16,900",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $405, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "336",
    "path": "data"
  },
  {
    "question": "A researcher working for a cereal company surveyed people about their cereal consumption habits. How many people ate cereal exactly twice last week?",
    "choices": null,
    "answer": "0",
    "unit": null,
    "table_title": "Eating cereal last week",
    "table": "Times eaten | Frequency\n0 | 17\n1 | 18\n2 | 0\n3 | 9\n4 | 20",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row for 2 times and read the frequency. The frequency is 0.\n\n0 people ate cereal exactly twice last week.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "26822",
    "path": "data"
  },
  {
    "question": "For Earth Day, Lakewood High's environmental club tracked the number of seeds planted by its members. How many members planted fewer than 2 seeds?",
    "choices": null,
    "answer": "24",
    "unit": null,
    "table_title": "Planting seeds in the garden",
    "table": "Seeds planted | Frequency\n0 | 4\n1 | 20\n2 | 15\n3 | 10",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the rows for 0 and 1 seed. Add the frequencies for these rows.\n\nAdd:\n\n4 + 20 = 24\n\n24 members planted fewer than 2 seeds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "719",
    "path": "data"
  },
  {
    "question": "How much more does a tennis ticket cost than a baseball ticket?",
    "choices": null,
    "answer": "16",
    "unit": "$",
    "table_title": null,
    "table": "football ticket | $79\ngolf ticket | $64\nbaseball ticket | $45\ntennis ticket | $61\nbasketball ticket | $54\nhockey ticket | $48",
    "row_num": 6,
    "column_num": 2,
    "solution": "Subtract the price of a baseball ticket from the price of a tennis ticket.\n\n$61 - $45 = $16\n\nA tennis ticket costs $16 more than a baseball ticket.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "36476",
    "path": "data"
  },
  {
    "question": "An economics student recorded the amount of per-capita aid that the U.S. gave to various countries during the 1900s. In 2000, which country received less aid per capita, Algeria or Libya?",
    "choices": [
      "Libya",
      "Algeria"
    ],
    "answer": "Libya",
    "unit": null,
    "table_title": "Aid received per capita from the U.S.",
    "table": "Country | 1990 | 2000\nPakistan | $10 | $5\nAlgeria | $10 | $5\nAfghanistan | $7 | $5\nLibya | $5 | $3",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the 2000 column. Compare the numbers in this column for Algeria and Libya.\n\n$3.00 is less than $5.00. In 2000, Libya received less aid per capita.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "17472",
    "path": "data"
  },
  {
    "question": "A toy store employee counted the number of toys in each bin in the sale section. What is the largest number of toys?",
    "choices": null,
    "answer": "62",
    "unit": "toys",
    "table_title": "Toys per bin",
    "table": "Stem | Leaf \n2 | 5, 6, 8\n3 | 0, 2, 4, 6\n4 | 4\n5 | 0, 1, 3, 4\n6 | 2",
    "row_num": 6,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 6.\n\nNow find the highest leaf in the last row. The highest leaf is 2.\n\nThe largest number of toys has a stem of 6 and a leaf of 2. Write the stem first, then the leaf: 62.\n\nThe largest number of toys is 62 toys.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "8063",
    "path": "data"
  },
  {
    "question": "The members of the track team compared how many miles they ran last week. What is the range of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Running miles",
    "table": "Name | Miles\nJoseph | 10\nLinda | 6\nWarren | 3\nMaya | 8\nKamal | 10",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 6, 3, 8, 10\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 3 = 7\n\nThe range is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "20836",
    "path": "data"
  },
  {
    "question": "Professor Hutchinson informed her students of their scores on the midterm exam. How many students scored at least 40 points but fewer than 60 points?",
    "choices": null,
    "answer": "6",
    "unit": "students",
    "table_title": "Midterm exam scores",
    "table": "Stem | Leaf \n4 | 1, 5, 6, 6, 6\n5 | 3\n6 | 0, 1, 1, 6, 9\n7 | 0, 1, 2, 2, 6\n8 | 5, 6, 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 4 and 5.\n\nYou counted 6 leaves, which are blue in the stem-and-leaf plot above. 6 students scored at least 40 points but fewer than 60 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "19263",
    "path": "data"
  },
  {
    "question": "Amy has $1.50. Does she have enough to buy a ruler and a silver glitter pen?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "ruler | $0.37\npencil sharpener | $0.88\npencil | $0.26\nsilver glitter pen | $0.88\neraser | $0.90",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a ruler and the price of a silver glitter pen:\n\n$0.37 + $0.88 = $1.25\n\n$1.25 is less than $1.50. Amy does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "5706",
    "path": "data"
  },
  {
    "question": "Abby wants to buy 5 kilograms of chicken. How much will she spend?",
    "choices": null,
    "answer": "20",
    "unit": "$",
    "table_title": null,
    "table": "duck | $2 per kg\nham | $2 per kg\nturkey | $3 per kg\nchicken | $4 per kg\npork | $2 per kg\nbeef | $2 per kg",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the chicken. Multiply the price per kilogram by the number of kilograms.\n\n$4 \u00d7 5 = $20\n\nShe will spend $20.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "11312",
    "path": "data"
  },
  {
    "question": "Mr. Palmer, a track coach, recorded the sizes of all the nearby track teams. How many teams have at least 25 members but fewer than 42 members?",
    "choices": null,
    "answer": "4",
    "unit": "teams",
    "table_title": "Track team sizes (number of members)",
    "table": "Stem | Leaf \n2 | 6, 8\n3 | 7, 8\n4 | 5\n5 | 3, 5, 8",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the row with stem 2. Count all the leaves greater than or equal to 5.\n\nCount all the leaves in the row with stem 3.\n\nIn the row with stem 4, count all the leaves less than 2.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plots above. 4 teams have at least 25 members but fewer than 42 members.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "12080",
    "path": "data"
  },
  {
    "question": "How much more does a sheet of blue and yellow paper cost than a white note card?",
    "choices": null,
    "answer": "0.29",
    "unit": "$",
    "table_title": null,
    "table": "piece of red and purple stationery | $0.50\nsheet of blue and yellow paper | $0.40\nsheet of green paper | $0.11\npiece of pink paper | $0.56\nwhite note card | $0.11",
    "row_num": 5,
    "column_num": 2,
    "solution": "Subtract the price of a white note card from the price of a sheet of blue and yellow paper.\n\n$0.40 - $0.11 = $0.29\n\nA sheet of blue and yellow paper costs $0.29 more than a white note card.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "35359",
    "path": "data"
  },
  {
    "question": "How much money does Darrell need to buy a lawn chair and a beach umbrella?",
    "choices": null,
    "answer": "31",
    "unit": "$",
    "table_title": null,
    "table": "lawn chair | $11\nrosebush | $31\npicnic table | $65\nbeach umbrella | $20",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a lawn chair and the price of a beach umbrella:\n\n$11 + $20 = $31\n\nDarrell needs $31.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "15437",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $915, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$915 | 20,800 | 12,900\n$1,075 | 16,900 | 15,200\n$1,235 | 13,000 | 17,500\n$1,395 | 9,100 | 19,800\n$1,555 | 5,200 | 22,100",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $915, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "17725",
    "path": "data"
  },
  {
    "question": "Chandler bought 1 pound of pomelos. How much did he spend?",
    "choices": null,
    "answer": "1",
    "unit": "$",
    "table_title": null,
    "table": "Persian oranges | $1 per lb\nblood oranges | $2 per lb\npomelos | $1 per lb\nnavel oranges | $2 per lb",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the pomelos. Multiply the price per pound by the number of pounds.\n\n$1 \u00d7 1 = $1\n\nHe spent $1.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "36583",
    "path": "data"
  },
  {
    "question": "Each shelf has 5 shirts. How many shirts are on 6 shelves?",
    "choices": null,
    "answer": "30",
    "unit": "shirts",
    "table_title": null,
    "table": "Number of shelves | Number of shirts\n1 | 5\n2 | 10\n3 | 15\n4 | 20\n5 | 25\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 30 shirts on 6 shelves.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "16344",
    "path": "data"
  },
  {
    "question": "Riley buys 4 kilograms of French rolls and 5 kilograms of spelt rolls. How much does she spend?",
    "choices": null,
    "answer": "49",
    "unit": "$",
    "table_title": null,
    "table": "spelt rolls | $5/kilogram\nhamburger buns | $8/kilogram\nEnglish muffins | $6/kilogram\nwheat rolls | $4/kilogram\nrye rolls | $8/kilogram\ntortillas | $5/kilogram\nFrench rolls | $6/kilogram",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the cost of the French rolls. Multiply:\n\n$6 \u00d7 4 = $24\n\nFind the cost of the spelt rolls. Multiply:\n\n$5 \u00d7 5 = $25\n\nNow find the total cost by adding:\n\n$24 + $25 = $49\n\nShe spends $49.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "16899",
    "path": "data"
  },
  {
    "question": "Tristan has two dogs, Sprinkles and Champ. He is concerned because Sprinkles keeps eating Champ's food. Tristan asks their vet how much each dog's weight has changed since their last visit. Which dog's weight has changed the most?",
    "choices": [
      "Sprinkles",
      "Champ"
    ],
    "answer": "Champ",
    "unit": null,
    "table_title": null,
    "table": "Dog | Weight change (oz.)\nSprinkles | 5\nChamp | -6",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find which dog's weight changed the most, use absolute value. Absolute value tells you how much each dog's weight has changed.\nSprinkles: |5| = 5\nChamp: |-6| = 6\nChamp's weight has changed the most. He has lost 6 ounces.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "3140",
    "path": "data"
  },
  {
    "question": "While looking through an almanac at the library, Jonathan noticed some data showing the population density of various states. In 2000, which of the states shown had the fewest people per square mile?",
    "choices": [
      "Nevada",
      "Montana",
      "New Mexico"
    ],
    "answer": "Montana",
    "unit": null,
    "table_title": "Population per square mile",
    "table": "State | 1990 | 2000\nNew Mexico | 12 | 15\nMontana | 5 | 6\nNevada | 10 | 18",
    "row_num": 4,
    "column_num": 3,
    "solution": "Look at the numbers in the 2000 column. Find the least number in this column.\n\nThe least number is 6, which is in the Montana row. In 2000, Montana had the fewest people per square mile.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "17110",
    "path": "data"
  },
  {
    "question": "How much money does Jerry need to buy a picture of a shark and a sand castle magnet?",
    "choices": null,
    "answer": "1.43",
    "unit": "$",
    "table_title": null,
    "table": "souvenir spoon | $0.91\npink flamingo pen | $0.98\nsand castle magnet | $0.60\npicture of a shark | $0.83",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a picture of a shark and the price of a sand castle magnet:\n\n$0.83 + $0.60 = $1.43\n\nJerry needs $1.43.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 3,
    "split": "dev",
    "pid": "16971",
    "path": "data"
  },
  {
    "question": "Carter went to the store and bought 5 pounds of Bosc pears and 2 pounds of Osband pears. How much did he spend?",
    "choices": null,
    "answer": "31",
    "unit": "$",
    "table_title": null,
    "table": "Bosc pears | $5/lb\nOsband pears | $3/lb\nred Anjou pears | $1/lb\nConcorde pears | $4/lb\ngreen Anjou pears | $2/lb\nBartlett pears | $3/lb",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the Bosc pears. Multiply:\n\n$5 \u00d7 5 = $25\n\nFind the cost of the Osband pears. Multiply:\n\n$3 \u00d7 2 = $6\n\nNow find the total cost by adding:\n\n$25 + $6 = $31\n\nHe spent $31.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "5783",
    "path": "data"
  },
  {
    "question": "A stock broker followed the stock prices of a certain set of companies. Which company's stock cost more on Tuesday, White and Company or Thompson Corporation?",
    "choices": [
      "White and Company",
      "Thompson Corporation"
    ],
    "answer": "White and Company",
    "unit": null,
    "table_title": "Stock prices",
    "table": "Company | Monday | Tuesday\nJonas Incorporated | $10 | $3\nHouston Sporting Goods | $19 | $11\nComputer Data Company | $6 | $18\nThompson Corporation | $2 | $1\nWhite and Company | $9 | $17",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Tuesday column. Compare the numbers in this column for White and Company and Thompson Corporation.\n\n$17.00 is more than $1.00. On Tuesday, White and Company's stock cost more.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "26953",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which event ends at 2.55 P.M.?",
    "choices": [
      "cycling event",
      "rowing event",
      "volleyball event",
      "archery event"
    ],
    "answer": "cycling event",
    "unit": null,
    "table_title": "Summer Olympics schedule",
    "table": "Event | Begin | End\ndiving | 10:10 A.M. | 11:50 A.M.\ncycling | 11:00 A.M. | 2:55 P.M.\nrowing | 1:15 P.M. | 7:30 P.M.\narchery | 5:50 P.M. | 8:05 P.M.\nvolleyball | 7:35 P.M. | 9:30 P.M.",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find 2:55 P. M. on the schedule. The cycling event ends at 2:55 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 3,
    "split": "dev",
    "pid": "30813",
    "path": "data"
  },
  {
    "question": "The members of the track team compared how many miles they ran last week. What is the mean of the numbers?",
    "choices": null,
    "answer": "6",
    "unit": null,
    "table_title": "Running miles",
    "table": "Name | Miles\nEdmond | 6\nBrad | 1\nGwen | 2\nHarper | 10\nLouis | 7\nFlorence | 6\nZack | 10",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n6, 1, 2, 10, 7, 6, 10\n\nFirst, count how many numbers are in the group.\n\nThere are 7 numbers.\n\nNow add all the numbers together:\n\n6 + 1 + 2 + 10 + 7 + 6 + 10 = 42\n\nNow divide the sum by the number of numbers:\n\n42 \u00f7 7 = 6\n\nThe mean is 6.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "28249",
    "path": "data"
  },
  {
    "question": "Each closet has 10 raincoats. How many raincoats are in 3 closets?",
    "choices": null,
    "answer": "30",
    "unit": null,
    "table_title": null,
    "table": "Number of closets | Number of raincoats\n1 | 10\n2 | 20\n3 | ?",
    "row_num": 4,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 30 raincoats in 3 closets.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "26336",
    "path": "data"
  },
  {
    "question": "Each train car has 5 passengers. How many passengers are in 4 train cars?",
    "choices": null,
    "answer": "20",
    "unit": null,
    "table_title": null,
    "table": "Number of train cars | Number of passengers\n1 | 5\n2 | 10\n3 | 15\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 20 passengers in 4 train cars.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "28504",
    "path": "data"
  },
  {
    "question": "Fans of the Springdale baseball team compared the number of games won by their team each year. According to the table, what was the rate of change between 2009 and 2010?",
    "choices": null,
    "answer": "12",
    "unit": "games per year",
    "table_title": "Games won by the Springdale baseball team",
    "table": "Year | Games won\n2008 | 21\n2009 | 24\n2010 | 36\n2011 | 22\n2012 | 27",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{36 games - 24 games}{2010 - 2009}\n = \\frac{36 games - 24 games}{1 year}\n = \\frac{12 games}{1 year}\n = 12 games per year\nThe rate of change between 2009 and 2010 was 12 games per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "8192",
    "path": "data"
  },
  {
    "question": "Destiny has $12,685.00. Does she have enough to buy a popcorn cart and a funnel cake stand?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "popcorn cart | $6,011.00\npeanut cart | $6,524.00\nfunnel cake stand | $7,139.00\nshaved ice cart | $6,844.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a popcorn cart and the price of a funnel cake stand:\n\n$6,011.00 + $7,139.00 = $13,150.00\n\n$13,150.00 is more than $12,685.00. Destiny does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 7,
    "split": "dev",
    "pid": "22254",
    "path": "data"
  },
  {
    "question": "An architecture student measured the heights of all the buildings downtown. What is the height of the shortest building?",
    "choices": null,
    "answer": "22",
    "unit": "meters tall",
    "table_title": "Building heights (meters)",
    "table": "Stem | Leaf \n2 | 2, 4, 5, 8\n3 | 1, 2, 2\n4 | 0, 2, 6, 6\n5 | 5\n6 | 5, 7\n7 | 1, 3, 8\n8 | 1, 1, 3, 5",
    "row_num": 8,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 2.\n\nNow find the lowest leaf in the first row. The lowest leaf is 2.\n\nThe height of the shortest building has a stem of 2 and a leaf of 2. Write the stem first, then the leaf: 22.\n\nThe height of the shortest building is 22 meters tall.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "20716",
    "path": "data"
  },
  {
    "question": "The employee at the department store counted the number of ties on each tie rack. How many racks have exactly 23 ties?",
    "choices": null,
    "answer": "2",
    "unit": "racks",
    "table_title": "Ties per rack",
    "table": "Stem | Leaf \n1 | 3, 4, 8\n2 | 0, 2, 2, 3, 3, 7, 8, 8\n3 | 1, 2, 4\n4 | 1, 2, 2\n5 | 2, 4, 5, 6, 9, 9",
    "row_num": 6,
    "column_num": 2,
    "solution": "For the number 23, the stem is 2, and the leaf is 3. Find the row where the stem is 2. In that row, count all the leaves equal to 3.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 racks have exactly23 ties.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "10329",
    "path": "data"
  },
  {
    "question": "A florist looked at how many flowers she sold in the past 3 months. How many more flowers did the florist sell in December than in October?",
    "choices": null,
    "answer": "6,039",
    "unit": "flowers",
    "table_title": "Flowers sold",
    "table": "Month | Number of flowers\nOctober | 1,913\nNovember | 4,640\nDecember | 7,952",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nDecember: 7,952\nOctober: 1,913\n\nNow subtract: 7,952 - 1,913 = 6,039.\n\nThe florist sold 6,039 more flowers in December.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "5194",
    "path": "data"
  },
  {
    "question": "The parks department compared how many basketball hoops there are at each park. Which park has the most basketball hoops?",
    "choices": [
      "Crestview Park",
      "Westfield Park",
      "Pinehurst Park",
      "Otter Park"
    ],
    "answer": "Otter Park",
    "unit": null,
    "table_title": "Basketball hoops",
    "table": "Park | Number of basketball hoops\nCrestview Park | 15\nWestfield Park | 13\nPinehurst Park | 11\nOtter Park | 18",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 18.\n\nNow find the corresponding park. Otter Park corresponds to 18.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "6728",
    "path": "data"
  },
  {
    "question": "Professor Malone compiled the scores from the last quiz. How many students are there in all?",
    "choices": null,
    "answer": "55",
    "unit": null,
    "table_title": "Scores on the last quiz",
    "table": "Score | Frequency\n5 | 6\n6 | 1\n7 | 16\n8 | 18\n9 | 3\n10 | 11",
    "row_num": 7,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n6 + 1 + 16 + 18 + 3 + 11 = 55\n\nThere are 55 students in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "20665",
    "path": "data"
  },
  {
    "question": "Some teachers compared how many students are in their classes. Which teacher has the most students?",
    "choices": [
      "Mrs. Truman",
      "Miss Urban",
      "Mrs. Woodworth",
      "Ms. Hershfeld"
    ],
    "answer": "Ms. Hershfeld",
    "unit": null,
    "table_title": "Class size",
    "table": "Teacher | Number of students\nMrs. Truman | 23\nMiss Urban | 26\nMrs. Woodworth | 27\nMs. Hershfeld | 28",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 28.\n\nNow find the corresponding teacher. Ms. Hershfeld corresponds to 28.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "32022",
    "path": "data"
  },
  {
    "question": "Some students compared how many blocks they live from school. What is the mean of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Blocks from school",
    "table": "Name | Number of blocks\nTodd | 9\nStacy | 5\nEdward | 2\nKeenan | 3\nPete | 6",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 5, 2, 3, 6\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n9 + 5 + 2 + 3 + 6 = 25\n\nNow divide the sum by the number of numbers:\n\n25 \u00f7 5 = 5\n\nThe mean is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "34624",
    "path": "data"
  },
  {
    "question": "A real estate agent drove around the neighborhood and counted the number of houses on each block. How many blocks have at least 27 houses but fewer than 33 houses?",
    "choices": null,
    "answer": "2",
    "unit": "blocks",
    "table_title": "Houses per block",
    "table": "Stem | Leaf \n0 | 6, 8, 9\n1 | 0, 0, 9\n2 | 0, 2, 6, 9\n3 | 0, 3, 5, 5, 7, 7, 8, 9",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the row with stem 2. Count all the leaves greater than or equal to 7.\n\nIn the row with stem 3, count all the leaves less than 3.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plots above. 2 blocks have at least 27 houses but fewer than 33 houses.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "36397",
    "path": "data"
  },
  {
    "question": "Edward's classmates recorded how many books they read last year. Who read the most books?",
    "choices": [
      "Edward",
      "Brendan",
      "Peter",
      "Tina"
    ],
    "answer": "Edward",
    "unit": null,
    "table_title": "Books read",
    "table": "Name | Number of books\nEdward | 27\nBrendan | 26\nPeter | 23\nTina | 25",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 27.\n\nNow find the corresponding name. Edward corresponds to 27.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "21275",
    "path": "data"
  },
  {
    "question": "Reagan found out the sizes of all the clubs at her school. How many clubs have at least 31 members but fewer than 54 members?",
    "choices": null,
    "answer": "4",
    "unit": "clubs",
    "table_title": "Club sizes (number of members)",
    "table": "Stem | Leaf \n1 | 1, 7\n2 | 3, 7, 9\n3 | 6\n4 | 0, 1, 8\n5 | 8\n6 | 1, 5, 6\n7 | \n8 | 2\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "Find the row with stem 3. Count all the leaves greater than or equal to 1.\n\nCount all the leaves in the row with stem 4.\n\nIn the row with stem 5, count all the leaves less than 4.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plots above. 4 clubs have at least 31 members but fewer than 54 members.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "26161",
    "path": "data"
  },
  {
    "question": "The manager of a party supply store researched how many balloons it sold in the past 7 days. What is the median of the numbers?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": "Balloons sold",
    "table": "Day | Number of balloons\nTuesday | 9\nWednesday | 4\nThursday | 8\nFriday | 4\nSaturday | 8\nSunday | 10\nMonday | 2",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 4, 8, 4, 8, 10, 2\n\nFirst, arrange the numbers from least to greatest:\n\n2, 4, 4, 8, 8, 9, 10\n\nNow find the number in the middle.\n\n2, 4, 4, 8, 8, 9, 10\n\nThe number in the middle is 8.\n\nThe median is 8.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "438",
    "path": "data"
  },
  {
    "question": "Winston looked at his calendar to see how many hours he had worked in the past 5 days. What is the mean of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Hours worked",
    "table": "Day | Hours\nThursday | 7\nFriday | 10\nSaturday | 2\nSunday | 9\nMonday | 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 10, 2, 9, 7\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n7 + 10 + 2 + 9 + 7 = 35\n\nNow divide the sum by the number of numbers:\n\n35 \u00f7 5 = 7\n\nThe mean is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "7294",
    "path": "data"
  },
  {
    "question": "Each vase has 2 tulips. How many tulips are in 4 vases?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": null,
    "table": "Number of vases | Number of tulips\n1 | 2\n2 | 4\n3 | 6\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 8 tulips in 4 vases.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "5748",
    "path": "data"
  },
  {
    "question": "How much money does Sharon need to buy a white bead with black spots and an orange glass bead?",
    "choices": null,
    "answer": "0.15",
    "unit": "$",
    "table_title": null,
    "table": "blue glass bead | $0.02\norange glass bead | $0.09\nwhite bead with black spots | $0.06\nshiny metal bead | $0.08",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a white bead with black spots and the price of an orange glass bead:\n\n$0.06 + $0.09 = $0.15\n\nSharon needs $0.15.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 3,
    "split": "dev",
    "pid": "37882",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does Tennis class begin?",
    "choices": [
      "10:55 A.M.",
      "3:45 P.M.",
      "12:05 P.M.",
      "4:10 P.M."
    ],
    "answer": "10:55 A.M.",
    "unit": null,
    "table_title": "Class schedule",
    "table": "Subject | Begin | End\nEuropean History | 9:15 A.M. | 10:40 A.M.\nTennis | 10:55 A.M. | 12:05 P.M.\nAncient Civilizations | 12:45 P.M. | 1:30 P.M.\nAdvanced Algebra | 1:55 P.M. | 2:30 P.M.\nFrench Literature | 3:00 P.M. | 3:45 P.M.\nRussian | 4:10 P.M. | 5:30 P.M.",
    "row_num": 7,
    "column_num": 3,
    "solution": "Find Tennis class on the schedule. Find the beginning time for Tennis class.\n\nTennis: 10:55 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "12766",
    "path": "data"
  },
  {
    "question": "Wendy has $101.00. Does she have enough to buy a hedgehog and a bearded dragon?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "hedgehog | $67.00\ntree frog | $19.00\nscorpion | $41.00\nbearded dragon | $31.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a hedgehog and the price of a bearded dragon:\n\n$67.00 + $31.00 = $98.00\n\n$98.00 is less than $101.00. Wendy does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "17181",
    "path": "data"
  },
  {
    "question": "The players on a quiz show received the following scores. What is the mode of the numbers?",
    "choices": null,
    "answer": "75",
    "unit": null,
    "table_title": "Quiz show scores",
    "table": "Name | Score\nDeb | 78\nHanson | 77\nVivian | 75\nEdward | 75\nMartina | 66\nJuan | 66\nBen | 78\nSandeep | 75",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n78, 77, 75, 75, 66, 66, 78, 75\n\nFirst, arrange the numbers from least to greatest:\n\n66, 66, 75, 75, 75, 77, 78, 78\n\nNow count how many times each number appears.\n\n66 appears 2 times.\n75 appears 3 times.\n77 appears 1 time.\n78 appears 2 times.\n\nThe number that appears most often is 75.\n\nThe mode is 75.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "6442",
    "path": "data"
  },
  {
    "question": "Carson graphed the amount of snow that fell in the last 5 days. What is the median of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Daily snowfall",
    "table": "Day | Snowfall (inches)\nSaturday | 5\nSunday | 4\nMonday | 5\nTuesday | 4\nWednesday | 1",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n5, 4, 5, 4, 1\n\nFirst, arrange the numbers from least to greatest:\n\n1, 4, 4, 5, 5\n\nNow find the number in the middle.\n\n1, 4, 4, 5, 5\n\nThe number in the middle is 4.\n\nThe median is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "25947",
    "path": "data"
  },
  {
    "question": "Some friends played golf and compared their scores. What is the mode of the numbers?",
    "choices": null,
    "answer": "78",
    "unit": null,
    "table_title": "Golf scores",
    "table": "Name | Score\nHeather | 78\nAdele | 74\nGina | 74\nRonald | 70\nLuna | 78\nPablo | 78\nJaylen | 73\nDarius | 73",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n78, 74, 74, 70, 78, 78, 73, 73\n\nFirst, arrange the numbers from least to greatest:\n\n70, 73, 73, 74, 74, 78, 78, 78\n\nNow count how many times each number appears.\n\n70 appears 1 time.\n73 appears 2 times.\n74 appears 2 times.\n78 appears 3 times.\n\nThe number that appears most often is 78.\n\nThe mode is 78.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "18158",
    "path": "data"
  },
  {
    "question": "A cookie factory monitored the number of broken cookies per pack yesterday. What is the smallest number of broken cookies?",
    "choices": null,
    "answer": "39",
    "unit": "broken cookies",
    "table_title": "Broken cookies per pack",
    "table": "Stem | Leaf \n3 | 9\n4 | 1\n5 | \n6 | 9\n7 | 5\n8 | 6, 6\n9 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "Look at the first row of the stem-and-leaf plot. The first row has the lowest stem. The stem for the first row is 3.\n\nNow find the lowest leaf in the first row. The lowest leaf is 9.\n\nThe smallest number of broken cookies has a stem of 3 and a leaf of 9. Write the stem first, then the leaf: 39.\n\nThe smallest number of broken cookies is 39 broken cookies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "8713",
    "path": "data"
  },
  {
    "question": "How much more does a toy guitar cost than a jar of clay?",
    "choices": null,
    "answer": "6.71",
    "unit": "$",
    "table_title": null,
    "table": "toy truck | $1.97\nset of juggling balls | $3.46\njar of clay | $2.06\ntoy guitar | $8.77\njigsaw puzzle | $8.94",
    "row_num": 5,
    "column_num": 2,
    "solution": "Subtract the price of a jar of clay from the price of a toy guitar.\n\n$8.77 - $2.06 = $6.71\n\nA toy guitar costs $6.71 more than a jar of clay.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "20701",
    "path": "data"
  },
  {
    "question": "Cooper purchased 2 pounds of bolts, 1 pound of nails, and 5 pounds of nuts. What was the total cost?",
    "choices": null,
    "answer": "26",
    "unit": "$",
    "table_title": null,
    "table": "nails | $1 per pound\nnuts | $3 per pound\nscrews | $2 per pound\nstandard washers | $2 per pound\nbolts | $5 per pound\nrivets | $1 per pound\nsplit washers | $1 per pound",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the cost of the bolts. Multiply:\n\n$5 \u00d7 2 = $10\n\nFind the cost of the nails. Multiply:\n\n$1 \u00d7 1 = $1\n\nFind the cost of the nuts. Multiply:\n\n$3 \u00d7 5 = $15\n\nNow find the total cost by adding:\n\n$10 + $1 + $15 = $26\n\nThe total cost was $26.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "27978",
    "path": "data"
  },
  {
    "question": "Sam kept a written log of how many miles he biked during the past 5 days. What is the mean of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Miles biked",
    "table": "Day | Number of miles\nThursday | 8\nFriday | 7\nSaturday | 5\nSunday | 8\nMonday | 7",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n8, 7, 5, 8, 7\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n8 + 7 + 5 + 8 + 7 = 35\n\nNow divide the sum by the number of numbers:\n\n35 \u00f7 5 = 7\n\nThe mean is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "14031",
    "path": "data"
  },
  {
    "question": "How much money does Paula need to buy a book of poems and a cat calendar?",
    "choices": null,
    "answer": "35",
    "unit": "$",
    "table_title": null,
    "table": "map of Africa | $15.00\ncat calendar | $15.00\natlas | $19.00\nencyclopedia | $12.00\nscrapbook | $11.00\nbook of poems | $20.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a book of poems and the price of a cat calendar:\n\n$20.00 + $15.00 = $35.00\n\nPaula needs $35.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "36898",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $635, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$635 | 12,200 | 1,900\n$785 | 10,800 | 6,500\n$935 | 9,400 | 11,100\n$1,085 | 8,000 | 15,700\n$1,235 | 6,600 | 20,300",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $635, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "7816",
    "path": "data"
  },
  {
    "question": "An architecture student measured the heights of all the buildings downtown. How many buildings are exactly 30 meters tall?",
    "choices": null,
    "answer": "4",
    "unit": "buildings",
    "table_title": "Building heights (meters)",
    "table": "Stem | Leaf \n1 | 2, 4\n2 | 2, 4\n3 | 0, 0, 0, 0, 5, 9, 9\n4 | 4, 7\n5 | 4, 7\n6 | \n7 | 2, 6\n8 | 1, 3\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "For the number 30, the stem is 3, and the leaf is 0. Find the row where the stem is 3. In that row, count all the leaves equal to 0.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plot above. 4 buildings are exactly 30 meters tall.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "10867",
    "path": "data"
  },
  {
    "question": "A vendor who sold bread at farmers' markets counted the number of leftover loaves at the end of each day. According to the table, what was the rate of change between Tuesday and Wednesday?",
    "choices": null,
    "answer": "-7",
    "unit": "loaves per day",
    "table_title": "Loaves of leftover bread",
    "table": "Day | Leftover loaves\nSunday | 19\nMonday | 20\nTuesday | 32\nWednesday | 25\nThursday | 20",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{25 loaves - 32 loaves}{1 day}\n = \\frac{-7 loaves}{1 day}\n = -7 loaves per day\nThe rate of change between Tuesday and Wednesday was - 7 loaves per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "26188",
    "path": "data"
  },
  {
    "question": "Each gym locker has 2 T-shirts. How many T-shirts are in 6 gym lockers?",
    "choices": null,
    "answer": "12",
    "unit": "T-shirts",
    "table_title": null,
    "table": "Number of gym lockers | Number of T-shirts\n1 | 2\n2 | 4\n3 | 6\n4 | 8\n5 | 10\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 12 T-shirts in 6 gym lockers.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 1,
    "split": "dev",
    "pid": "5669",
    "path": "data"
  },
  {
    "question": "Brenna has $86. Does she have enough to buy a TV stand and a desk?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "set of bunk beds | $86\nTV stand | $26\ndesk | $66\nrocking chair | $87\nbookcase | $71\nchest of drawers | $71",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a TV stand and the price of a desk:\n\n$26 + $66 = $92\n\n$92 is more than $86. Brenna does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "22859",
    "path": "data"
  },
  {
    "question": "Maria, a fantasy football fan, carefully studied the number of touchdowns completed by her favorite players last season. How many players scored at least 2 touchdowns last season?",
    "choices": null,
    "answer": "32",
    "unit": null,
    "table_title": "Football touchdowns scored last season",
    "table": "Touchdowns scored | Frequency\n0 | 18\n1 | 11\n2 | 9\n3 | 7\n4 | 10\n5 | 6",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the rows for 2, 3, 4, and 5 touchdowns last season. Add the frequencies for these rows.\n\nAdd:\n\n9 + 7 + 10 + 6 = 32\n\n32 players scored at least 2 touchdowns last season.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "24034",
    "path": "data"
  },
  {
    "question": "A farmer examined each building on his farm to determine how many lights needed repair. How many lights are there in the barn?",
    "choices": null,
    "answer": "6",
    "unit": "lights",
    "table_title": "Lights on the farm",
    "table": "Building | Broken lights | Working lights\nMill | 4 | 2\nBarn | 1 | 5\nShed | 2 | 1\nHen house | 9 | 5",
    "row_num": 5,
    "column_num": 3,
    "solution": "Find the row for barn. Add the numbers in the Barn row.\n\nAdd:\n\n1 + 5 = 6\n\nThere are 6 lights in the barn.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "24095",
    "path": "data"
  },
  {
    "question": "Sophie purchased 4 pounds of pebbles and 5 pounds of black sand. What was the total cost?",
    "choices": null,
    "answer": "35",
    "unit": "$",
    "table_title": null,
    "table": "black sand | $3 per pound\nfine gravel | $2 per pound\npebbles | $5 per pound\nwhite sand | $3 per pound\nrocks | $5 per pound",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the pebbles. Multiply:\n\n$5 \u00d7 4 = $20\n\nFind the cost of the black sand. Multiply:\n\n$3 \u00d7 5 = $15\n\nNow find the total cost by adding:\n\n$20 + $15 = $35\n\nThe total cost was $35.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "14567",
    "path": "data"
  },
  {
    "question": "How much more does a set of forks cost than an apron?",
    "choices": null,
    "answer": "6",
    "unit": "$",
    "table_title": null,
    "table": "soup pot | $29\ncookbook | $18\nset of forks | $20\nteapot | $19\napron | $14\nglass bowl | $14",
    "row_num": 6,
    "column_num": 2,
    "solution": "Subtract the price of an apron from the price of a set of forks.\n\n$20 - $14 = $6\n\nA set of forks costs $6 more than an apron.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "10254",
    "path": "data"
  },
  {
    "question": "Preston's class paid attention to how many bottles each student collected for their recycling project. Together, how many bottles did Preston and Gordon collect?",
    "choices": null,
    "answer": "2,626",
    "unit": "bottles",
    "table_title": "Bottles collected",
    "table": "Name | Number of bottles\nHelen | 7,446\nPreston | 1,127\nEliana | 1,473\nGordon | 1,499\nMaya | 1,411",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nPreston: 1,127\nGordon: 1,499\n\nNow add: 1,127 + 1,499 = 2,626.\n\nPreston and Gordon collected 2,626 bottles.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "16267",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which game begins at 2.45 P.M.?",
    "choices": [
      "Lightning versus Ducks game",
      "Lions versus Eagles game",
      "Wolves versus Jaguars game",
      "Thunder versus Blue Jays game"
    ],
    "answer": "Lightning versus Ducks game",
    "unit": null,
    "table_title": "Baseball tournament schedule",
    "table": "Game | Begin | End\nWolves versus Jaguars | 9:20 A.M. | 11:15 A.M.\nSharks versus Cougars | 10:25 A.M. | 11:45 A.M.\nCardinals versus Cobras | 10:50 A.M. | 12:20 P.M.\nThunder versus Blue Jays | 11:40 A.M. | 1:30 P.M.\nFire versus Cyclones | 12:30 P.M. | 2:00 P.M.\nLions versus Eagles | 1:20 P.M. | 2:50 P.M.\nLightning versus Ducks | 2:45 P.M. | 4:30 P.M.\nVipers versus Crocodiles | 3:40 P.M. | 5:40 P.M.",
    "row_num": 9,
    "column_num": 3,
    "solution": "Find 2:45 P. M. on the schedule. The Lightning versus Ducks game begins at 2:45 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 3,
    "split": "dev",
    "pid": "33229",
    "path": "data"
  },
  {
    "question": "Jordan's class recorded how many states each student has visited. What is the median of the numbers?",
    "choices": null,
    "answer": "18",
    "unit": null,
    "table_title": "States visited",
    "table": "Name | Number of states\nJordan | 9\nZack | 19\nRodrigo | 17\nWilliam | 24\nEvan | 17\nAlice | 18\nGary | 26",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n9, 19, 17, 24, 17, 18, 26\n\nFirst, arrange the numbers from least to greatest:\n\n9, 17, 17, 18, 19, 24, 26\n\nNow find the number in the middle.\n\n9, 17, 17, 18, 19, 24, 26\n\nThe number in the middle is 18.\n\nThe median is 18.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "16014",
    "path": "data"
  },
  {
    "question": "Austen has two dogs, Sprinkles and Champ. He is concerned because Sprinkles keeps eating Champ's food. Austen asks their vet how much each dog's weight has changed since their last visit. Which dog's weight has changed the most?",
    "choices": [
      "Sprinkles",
      "Champ"
    ],
    "answer": "Champ",
    "unit": null,
    "table_title": null,
    "table": "Dog | Weight change (oz.)\nSprinkles | 5\nChamp | -6",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find which dog's weight changed the most, use absolute value. Absolute value tells you how much each dog's weight has changed.\nSprinkles: |5| = 5\nChamp: |-6| = 6\nChamp's weight has changed the most. He has lost 6 ounces.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 6,
    "split": "dev",
    "pid": "2055",
    "path": "data"
  },
  {
    "question": "How much money does Madelyn need to buy 4 tickets for a Mexican cruise and 4 tickets for an Atlantic cruise?",
    "choices": null,
    "answer": "3,980",
    "unit": "$",
    "table_title": null,
    "table": "ticket for an Atlantic cruise | $199.00\nticket for a Mexican cruise | $796.00\nticket for an Australian cruise | $351.00\nticket for a South American cruise | $232.00\nticket for an Alaskan cruise | $941.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of 4 tickets for a Mexican cruise.\n\n$796.00 \u00d7 4 = $3,184.00\n\nFind the cost of 4 tickets for an Atlantic cruise.\n\n$199.00 \u00d7 4 = $796.00\n\nNow find the total cost.\n\n$3,184.00 + $796.00 = $3,980.00\n\nMadelyn needs $3,980.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "9580",
    "path": "data"
  },
  {
    "question": "Carson's class paid attention to how many bottles each student collected for their recycling project. Who collected the fewest bottles?",
    "choices": [
      "Carson",
      "Dustin",
      "Tori",
      "Anita"
    ],
    "answer": "Carson",
    "unit": null,
    "table_title": "Bottles collected",
    "table": "Name | Number of bottles\nCarson | 91\nDustin | 92\nTori | 98\nAnita | 97",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 91.\n\nNow find the corresponding name. Carson corresponds to 91.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "6071",
    "path": "data"
  },
  {
    "question": "Each van has 2 people. How many people are in 4 vans?",
    "choices": null,
    "answer": "8",
    "unit": null,
    "table_title": null,
    "table": "Number of vans | Number of people\n1 | 2\n2 | 4\n3 | 6\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 8 people in 4 vans.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "10711",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which class begins at 10.40 A.M.?",
    "choices": [
      "Fourth Grade Choir",
      "Beginning Piano class",
      "Rhythm and Drums class",
      "Beginning Band"
    ],
    "answer": "Beginning Band",
    "unit": null,
    "table_title": "Music teacher's schedule",
    "table": "Class | Begin | End\nOrchestra | 8:35 A.M. | 9:50 A.M.\nWriting Music | 9:55 A.M. | 10:30 A.M.\nBeginning Band | 10:40 A.M. | 11:40 A.M.\nFourth Grade Choir | 11:55 A.M. | 12:25 P.M.\nBeginning Piano | 12:40 P.M. | 1:30 P.M.\nSixth Grade Choir | 1:35 P.M. | 2:50 P.M.\nRhythm and Drums | 2:55 P.M. | 4:20 P.M.",
    "row_num": 8,
    "column_num": 3,
    "solution": "Find 10:40 A. M. on the schedule. Beginning Band begins at 10:40 A. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "32226",
    "path": "data"
  },
  {
    "question": "An Italian restaurant monitored the number of times its regular customers ate pizza last month. How many customers are there in all?",
    "choices": null,
    "answer": "35",
    "unit": null,
    "table_title": "Eating pizza last month",
    "table": "Times eaten | Frequency\n0 | 11\n1 | 3\n2 | 14\n3 | 7",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n11 + 3 + 14 + 7 = 35\n\nThere are 35 customers in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "37911",
    "path": "data"
  },
  {
    "question": "How much money does Helen need to buy a crystal vase and a silver coat rack?",
    "choices": null,
    "answer": "128",
    "unit": "$",
    "table_title": null,
    "table": "rug | $51.00\ncrystal sculpture | $90.00\nchandelier | $70.00\noil painting | $85.00\ncrystal vase | $49.00\nsilver coat rack | $79.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a crystal vase and the price of a silver coat rack:\n\n$49.00 + $79.00 = $128.00\n\nHelen needs $128.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "35397",
    "path": "data"
  },
  {
    "question": "The staff of a game show tracked the performance of all the contestants during the past season. How many people scored fewer than 50 points?",
    "choices": null,
    "answer": "10",
    "unit": "people",
    "table_title": "Game show scores",
    "table": "Stem | Leaf \n3 | 2, 2, 7, 8, 8, 9\n4 | 2, 4, 8, 9\n5 | 1, 3, 7\n6 | 5, 6, 7\n7 | 7, 8\n8 | 1, 3, 3\n9 | 0",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 3 and 4.\n\nYou counted 10 leaves, which are blue in the stem-and-leaf plot above. 10 people scored fewer than 50 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "763",
    "path": "data"
  },
  {
    "question": "Some students compared how many pets they have. What is the mode of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Pets",
    "table": "Name | Number of pets\nKirk | 7\nJon | 3\nReid | 5\nPaula | 7\nStefan | 7\nWendy | 5\nTessa | 5\nMadelyn | 5",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 3, 5, 7, 7, 5, 5, 5\n\nFirst, arrange the numbers from least to greatest:\n\n3, 5, 5, 5, 5, 7, 7, 7\n\nNow count how many times each number appears.\n\n3 appears 1 time.\n5 appears 4 times.\n7 appears 3 times.\n\nThe number that appears most often is 5.\n\nThe mode is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "10540",
    "path": "data"
  },
  {
    "question": "A game show program recorded the scores of its contestants. How many contestants are there in all?",
    "choices": null,
    "answer": "27",
    "unit": null,
    "table_title": "Scores on a quiz show",
    "table": "Score | Frequency\n5 | 7\n6 | 1\n7 | 9\n8 | 2\n9 | 5\n10 | 3",
    "row_num": 7,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n7 + 1 + 9 + 2 + 5 + 3 = 27\n\nThere are 27 contestants in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "20513",
    "path": "data"
  },
  {
    "question": "Antonio counted the number of words per page in his new book. How many pages have exactly 69 words?",
    "choices": null,
    "answer": "2",
    "unit": "pages",
    "table_title": "Words per page",
    "table": "Stem | Leaf \n3 | 9\n4 | 2, 3, 5, 8\n5 | 3, 4, 8, 9\n6 | 1, 8, 9, 9",
    "row_num": 5,
    "column_num": 2,
    "solution": "For the number 69, the stem is 6, and the leaf is 9. Find the row where the stem is 6. In that row, count all the leaves equal to 9.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 pages have exactly 69 words.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "37983",
    "path": "data"
  },
  {
    "question": "Bryce wants to buy 2 pounds of bran flakes and 4 pounds of granola. How much will he spend?",
    "choices": null,
    "answer": "16",
    "unit": "$",
    "table_title": null,
    "table": "bran flakes | $2 per pound\nwheat flakes | $4 per pound\nmulti-grain cereal | $3 per pound\ngranola | $3 per pound\nrice crisps | $5 per pound",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the bran flakes. Multiply:\n\n$2 \u00d7 2 = $4\n\nFind the cost of the granola. Multiply:\n\n$3 \u00d7 4 = $12\n\nNow find the total cost by adding:\n\n$4 + $12 = $16\n\nHe will spend $16.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "12621",
    "path": "data"
  },
  {
    "question": "Each package has 5 apples. How many apples are in 6 packages?",
    "choices": null,
    "answer": "30",
    "unit": null,
    "table_title": null,
    "table": "Number of packages | Number of apples\n1 | 5\n2 | 10\n3 | 15\n4 | 20\n5 | 25\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by fives. Use the chart: there are 30 apples in 6 packages.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "16776",
    "path": "data"
  },
  {
    "question": "A county agency recorded the money donated to several charitable causes over time. In June, which cause raised the most money?",
    "choices": [
      "education",
      "medical research",
      "hunger"
    ],
    "answer": "education",
    "unit": null,
    "table_title": "Donations received",
    "table": "Cause | May | June\nEducation | $15 | $12\nHunger | $18 | $9\nMedical research | $16 | $8",
    "row_num": 4,
    "column_num": 3,
    "solution": "Look at the numbers in the June column. Find the greatest number in this column.\n\nThe greatest number is $12.00, which is in the Education row. In June, the most money was raised for education.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "26068",
    "path": "data"
  },
  {
    "question": "For a math assignment, Addison researched the scores of the people competing on her favorite quiz show. How many people scored fewer than 90 points?",
    "choices": null,
    "answer": "8",
    "unit": "people",
    "table_title": "Quiz show scores",
    "table": "Stem | Leaf \n4 | 0, 6\n5 | 0, 4\n6 | 5\n7 | 9\n8 | 1, 6",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 4, 5, 6, 7, and 8.\n\nYou counted 8 leaves, which are blue in the stem-and-leaf plot above. 8 people scored fewer than 90 points.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "15579",
    "path": "data"
  },
  {
    "question": "A cookie factory monitored the number of broken cookies per pack yesterday. How many packs had exactly 16 broken cookies?",
    "choices": null,
    "answer": "3",
    "unit": "packs",
    "table_title": "Broken cookies per pack",
    "table": "Stem | Leaf \n1 | 6, 6, 6\n2 | 0, 2, 2, 5, 9\n3 | 2, 2, 6, 7\n4 | 6\n5 | 3, 6, 9\n6 | 9\n7 | 1, 1, 5, 5, 9, 9\n8 | 0, 1",
    "row_num": 9,
    "column_num": 2,
    "solution": "For the number 16, the stem is 1, and the leaf is 6. Find the row where the stem is 1. In that row, count all the leaves equal to 6.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plot above. 3 packs had exactly16 broken cookies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "21067",
    "path": "data"
  },
  {
    "question": "Lamar wants to buy 4 pounds of rocks and 1 pound of coarse gravel. How much will he spend?",
    "choices": null,
    "answer": "10",
    "unit": "$",
    "table_title": null,
    "table": "white sand | $4 per lb\npebbles | $5 per lb\nrocks | $2 per lb\ncoarse gravel | $2 per lb\nfine gravel | $3 per lb",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the rocks. Multiply:\n\n$2 \u00d7 4 = $8\n\nFind the cost of the coarse gravel. Multiply:\n\n$2 \u00d7 1 = $2\n\nNow find the total cost by adding:\n\n$8 + $2 = $10\n\nHe will spend $10.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "11798",
    "path": "data"
  },
  {
    "question": "Some students compared how many clubs they belong to. What is the mode of the numbers?",
    "choices": null,
    "answer": "1",
    "unit": null,
    "table_title": "Clubs",
    "table": "Name | Number of clubs\nBobby | 4\nHector | 3\nGabrielle | 1\nJennifer | 1\nKiera | 1\nMarvin | 4\nAshley | 3",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n4, 3, 1, 1, 1, 4, 3\n\nFirst, arrange the numbers from least to greatest:\n\n1, 1, 1, 3, 3, 4, 4\n\nNow count how many times each number appears.\n\n1 appears 3 times.\n3 appears 2 times.\n4 appears 2 times.\n\nThe number that appears most often is 1.\n\nThe mode is 1.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "37641",
    "path": "data"
  },
  {
    "question": "A girl compared the ages of her cousins. Which cousin is the oldest?",
    "choices": [
      "Rose",
      "Dalton",
      "Kristen",
      "Tony"
    ],
    "answer": "Dalton",
    "unit": null,
    "table_title": "Ages of cousins",
    "table": "Name | Age (years)\nRose | 14\nDalton | 18\nKristen | 12\nTony | 11",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 18.\n\nNow find the corresponding name. Dalton corresponds to 18.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "21218",
    "path": "data"
  },
  {
    "question": "How much money does Wayne need to buy a shiny gold shell and an oyster shell?",
    "choices": null,
    "answer": "0.12",
    "unit": "$",
    "table_title": null,
    "table": "pink and white striped shell | $0.01\nshiny gold shell | $0.06\noyster shell | $0.06\nwhole sand dollar | $0.01\nbeautiful yellow shell | $0.04",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a shiny gold shell and the price of an oyster shell:\n\n$0.06 + $0.06 = $0.12\n\nWayne needs $0.12.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "12102",
    "path": "data"
  },
  {
    "question": "Charlotte has $212. How much money will Charlotte have left if she buys a leaf blower and a fountain?",
    "choices": null,
    "answer": "77",
    "unit": "$",
    "table_title": null,
    "table": "fountain | $68\nleaf blower | $67\nwooden bench | $76\nbeach umbrella | $45",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of a leaf blower and a fountain.\n\n$67 + $68 = $135\n\nNow subtract the total cost from the starting amount.\n\n$212 - $135 = $77\n\nCharlotte will have $77 left.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "14944",
    "path": "data"
  },
  {
    "question": "To better understand library usage patterns, a librarian figured out how many books were checked out by some patrons last year. How many patrons checked out at least 3 books?",
    "choices": null,
    "answer": "42",
    "unit": null,
    "table_title": "Checking out books from the library",
    "table": "Books checked out | Frequency\n1 | 4\n2 | 14\n3 | 7\n4 | 17\n5 | 6\n6 | 12",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the rows for 3, 4, 5, and 6 books. Add the frequencies for these rows.\n\nAdd:\n\n7 + 17 + 6 + 12 = 42\n\n42 patrons checked out at least 3 books.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "26170",
    "path": "data"
  },
  {
    "question": "Each dish has 2 cherries. How many cherries are in 6 dishes?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": null,
    "table": "Number of dishes | Number of cherries\n1 | 2\n2 | 4\n3 | 6\n4 | 8\n5 | 10\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 12 cherries in 6 dishes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "4752",
    "path": "data"
  },
  {
    "question": "Some teachers compared how many students are in their classes. What is the mean of the numbers?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": "Class size",
    "table": "Teacher | Number of students\nMr. Clay | 13\nMr. Watson | 15\nMiss Jones | 10\nMiss Urban | 12\nMrs. King | 10",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n13, 15, 10, 12, 10\n\nFirst, count how many numbers are in the group.\n\nThere are 5 numbers.\n\nNow add all the numbers together:\n\n13 + 15 + 10 + 12 + 10 = 60\n\nNow divide the sum by the number of numbers:\n\n60 \u00f7 5 = 12\n\nThe mean is 12.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "27894",
    "path": "data"
  },
  {
    "question": "Annie counted the number of pairs of shoes for sale at each of the shoe stores in the mall. How many stores have fewer than 80 pairs of shoes?",
    "choices": null,
    "answer": "6",
    "unit": "stores",
    "table_title": "Pairs of shoes per store",
    "table": "Stem | Leaf \n2 | 5, 5\n3 | \n4 | 6\n5 | 1, 6\n6 | \n7 | 0\n8 | 6",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 2, 3, 4, 5, 6, and 7.\n\nYou counted 6 leaves, which are blue in the stem-and-leaf plot above. 6 stores have fewer than 80 pairs of shoes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "22331",
    "path": "data"
  },
  {
    "question": "At Josie's birthday party, children and parents celebrated by participating in some activities. How many more children than parents are playing tag?",
    "choices": null,
    "answer": "5",
    "unit": "children",
    "table_title": "Birthday party",
    "table": "Activity | Parents | Children\nSinging | 14 | 20\nEating cake | 5 | 10\nJumping rope | 16 | 20\nSwimming | 16 | 19\nPlaying tag | 4 | 9",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Playing tag row. Find the numbers in this row for children and parents.\n\nchildren: 9\nparents: 4\n\nNow subtract:\n\n9 \u2212 4 = 5\n\n5 more children than parents are playing tag.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "17417",
    "path": "data"
  },
  {
    "question": "A bagel wholesaler examined the bagel sales of each of the retail stores that it served. Which shop sold fewer bagels, Tina's Bagels or New York Bagels?",
    "choices": [
      "Tina's Bagels",
      "New York Bagels"
    ],
    "answer": "Tina's Bagels",
    "unit": null,
    "table_title": "Bagel sales",
    "table": "Shop | Blueberry bagels | Onion bagels\nNew York Bagels | 9 | 18\nSuper Bagel | 13 | 12\nTina's Bagels | 3 | 1\nBagel Town Cafe | 8 | 8",
    "row_num": 5,
    "column_num": 3,
    "solution": "Add the numbers in the Tina's Bagels row. Then, add the numbers in the New York Bagels row.\n\nTina's Bagels: 3 + 1 = 4\nNew York Bagels: 9 + 18 = 27\n\n4 is less than 27. Tina's Bagels sold fewer bagels.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "21148",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Which group ends at 3.15 P.M.?",
    "choices": [
      "non-sporting group competition",
      "herding group competition",
      "hound group competition",
      "toy group competition"
    ],
    "answer": "herding group competition",
    "unit": null,
    "table_title": "Dog show schedule",
    "table": "Group | Begin | End\nnon-sporting group | 11:05 A.M. | 12:30 P.M.\nhound group | 12:35 P.M. | 2:15 P.M.\nherding group | 2:30 P.M. | 3:15 P.M.\nterrier group | 3:20 P.M. | 5:05 P.M.\ntoy group | 5:20 P.M. | 7:15 P.M.",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find 3:15 P. M. on the schedule. The herding group competition ends at 3:15 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 3,
    "split": "dev",
    "pid": "34504",
    "path": "data"
  },
  {
    "question": "Maddie is looking at the price of new cell phones online. Her favorite company, OrangeTech, has a special this weekend. Maddie can add an upgrade to a phone for an additional cost, or she can buy a used phone to get a discount. The change in price for each option is shown in the table. Which option results in a greater change in price?",
    "choices": [
      "adding an upgrade",
      "buying a used phone"
    ],
    "answer": "buying a used phone",
    "unit": null,
    "table_title": null,
    "table": "Option | Change in phone price\nAdd an upgrade | $60\nBuy a used phone | -$75",
    "row_num": 3,
    "column_num": 2,
    "solution": "To find the option that results in a greater change in price, use absolute value. Absolute value tells you how much the price changes.\nAdd an upgrade: |$60| = $60\nBuy a used phone: |-$75| = $75\nBuying a used phone results in a greater change in price. It reduces the price by $75.",
    "ques_type": "multi_choice",
    "ans_type": "other_text",
    "grade": 6,
    "split": "dev",
    "pid": "37225",
    "path": "data"
  },
  {
    "question": "Jessica has $0.19. Does she have enough to buy a piece of copper and a pumice stone?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "smooth piece of sea glass | $0.04\nyellow tiger's eye | $0.02\npiece of copper | $0.09\npumice stone | $0.09",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a piece of copper and the price of a pumice stone:\n\n$0.09 + $0.09 = $0.18\n\n$0.18 is less than $0.19. Jessica does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 4,
    "split": "dev",
    "pid": "4414",
    "path": "data"
  },
  {
    "question": "How much more does a leather chair cost than a kitchen table?",
    "choices": null,
    "answer": "529",
    "unit": "$",
    "table_title": null,
    "table": "hammock | $245\nleather chair | $733\ndesk | $236\nkitchen table | $204",
    "row_num": 4,
    "column_num": 2,
    "solution": "Subtract the price of a kitchen table from the price of a leather chair.\n\n$733 - $204 = $529\n\nA leather chair costs $529 more than a kitchen table.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "14292",
    "path": "data"
  },
  {
    "question": "For an economics project, Tony determined the cost of ferry rides for bicycles and cars. How much does it cost to take a bicycle on the Fauntleroy-Vashon ferry?",
    "choices": null,
    "answer": "5",
    "unit": "$",
    "table_title": "Ferry fares",
    "table": "Ferry | Car | Bicycle\nSeattle-Bremerton | $12 | $8\nOcracoke | $15 | $3\nFauntleroy-Vashon | $15 | $5\nMukilteu-Clinton | $7 | $5",
    "row_num": 5,
    "column_num": 3,
    "solution": "First, find the row for Fauntleroy-Vashon. Then find the number in the Bicycle column.\n\nThis number is $5.00. It costs $5 to take a bicycle on the Fauntleroy-Vashon ferry.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "24887",
    "path": "data"
  },
  {
    "question": "Each tray has 10 donuts. How many donuts are on 4 trays?",
    "choices": null,
    "answer": "40",
    "unit": null,
    "table_title": null,
    "table": "Number of trays | Number of donuts\n1 | 10\n2 | 20\n3 | 30\n4 | ?",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count by tens. Use the chart: there are 40 donuts on 4 trays.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "28647",
    "path": "data"
  },
  {
    "question": "How much money does Kari need to buy 4 topaz bracelets?",
    "choices": null,
    "answer": "33,336",
    "unit": "$",
    "table_title": null,
    "table": "pearl bracelet | $9,694\nsapphire pendant | $7,677\ndiamond bracelet | $8,970\ntopaz bracelet | $8,334",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of 4 topaz bracelets by multiplying 4 times the price of a topaz bracelet.\n\n$8,334 \u00d7 4 = $33,336\n\nKari needs $33,336.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "4816",
    "path": "data"
  },
  {
    "question": "Each bin has 2 yellow blocks. How many yellow blocks are in 5 bins?",
    "choices": null,
    "answer": "10",
    "unit": null,
    "table_title": null,
    "table": "Number of bins | Number of yellow blocks\n1 | 2\n2 | 4\n3 | 6\n4 | 8\n5 | ?",
    "row_num": 6,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 10 yellow blocks in 5 bins.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "26398",
    "path": "data"
  },
  {
    "question": "Some students compared how many clubs they belong to. What is the median of the numbers?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Clubs",
    "table": "Name | Number of clubs\nDamon | 1\nRodrigo | 2\nJake | 6\nLacey | 3\nAdele | 10",
    "row_num": 6,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n1, 2, 6, 3, 10\n\nFirst, arrange the numbers from least to greatest:\n\n1, 2, 3, 6, 10\n\nNow find the number in the middle.\n\n1, 2, 3, 6, 10\n\nThe number in the middle is 3.\n\nThe median is 3.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "21590",
    "path": "data"
  },
  {
    "question": "In a study on public parking, the director of transportation counted the number of cars in each of the city's parking lots. How many parking lots had at least 10 cars?",
    "choices": null,
    "answer": "10",
    "unit": null,
    "table_title": "Cars per parking lot",
    "table": "Stem | Leaf \n1 | 6, 7\n2 | 3\n3 | 0\n4 | \n5 | 0, 0\n6 | 1, 7\n7 | 3\n8 | 6",
    "row_num": 9,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 1, 2, 3, 4, 5, 6, 7, and 8.\n\nYou counted 10 leaves, which are blue in the stem-and-leaf plot above. 10 parking lots had at least 10 cars.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "31359",
    "path": "data"
  },
  {
    "question": "How much money does Colin need to buy a football ticket and a play ticket?",
    "choices": null,
    "answer": "142.18",
    "unit": "$",
    "table_title": null,
    "table": "opera ticket | $87.94\nfootball ticket | $94.23\nbasketball ticket | $57.35\nplay ticket | $47.95\ndance performance ticket | $22.78\nballet ticket | $47.26",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a football ticket and the price of a play ticket:\n\n$94.23 + $47.95 = $142.18\n\nColin needs $142.18.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "24205",
    "path": "data"
  },
  {
    "question": "Eli kept track of the number of characters in each book he read. How many books had at least 15 characters?",
    "choices": null,
    "answer": "9",
    "unit": "books",
    "table_title": "Characters per book",
    "table": "Stem | Leaf \n1 | 3\n2 | 1, 5\n3 | 1, 2, 3, 9\n4 | \n5 | 0, 1, 6",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row with stem 1. Count all the leaves greater than or equal to 5.\n\nCount all the leaves in the rows with stems 2, 3, 4, and 5.\n\nYou counted 9 leaves, which are blue in the stem-and-leaf plots above. 9 books had at least 15 characters.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "7978",
    "path": "data"
  },
  {
    "question": "Hector, an employee at Lloyd's Convenience Store, looked at the sales of each of its soda products. How much more did the convenience store make from Nature's Nectar sales on Thursday than on Friday?",
    "choices": null,
    "answer": "4",
    "unit": "$",
    "table_title": "Convenience store beverage sales",
    "table": "Beverage | Thursday | Friday\nKickin' Coffee | $6 | $18\nOlde Tyme Cola | $3 | $19\nRefresh Mineral Water | $7 | $18\nNature's Nectar | $9 | $5\nFizzy Fun | $4 | $14",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Nature's Nectar row. Find the numbers in this row for Thursday and Friday.\n\nThursday: $9.00\nFriday: $5.00\n\nNow subtract:\n\n$9.00 \u2212 $5.00 = $4.00\n\nThe convenience store made $4 more from Nature's Nectar sales on Thursday than on Friday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "35882",
    "path": "data"
  },
  {
    "question": "A health instructor surveyed all his students, and tallied the results. The first survey question asked, \"Do you adhere to a vegetarian diet or omnivorous diet?\" The second question asked, \"If you were to buy a pet today, which animal would it be?\" What is the probability that a randomly selected student adheres to a vegetarian diet and would buy a cat? Simplify any fractions.",
    "choices": null,
    "answer": "1/12",
    "unit": null,
    "table_title": null,
    "table": " | Dog | Cat\nA vegetarian diet | 4 | 1\nAn omnivorous diet | 4 | 3",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the student adheres to a vegetarian diet\" and B be the event \"the student would buy a cat\".\nTo find the probability that a student adheres to a vegetarian diet and would buy a cat, first identify the sample space and the event.\nThe outcomes in the sample space are the different students. Each student is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the student adheres to a vegetarian diet and would buy a cat\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the student adheres to a vegetarian diet and would buy a cat\", so look at the table to see how many students adhere to a vegetarian diet and would buy a cat.\nThe number of students who adhere to a vegetarian diet and would buy a cat is 1.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of students.\n4 + 4 + 1 + 3 = 12\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{1}{12}\nThe probability that a student adheres to a vegetarian diet and would buy a cat is \\frac{1}{12}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "533",
    "path": "data"
  },
  {
    "question": "A drawing class was assigned a final project where students had to choose one art medium and one subject. The teacher kept track of the types of projects submitted. What is the probability that a randomly selected student chose to draw a plant and used chalk? Simplify any fractions.",
    "choices": null,
    "answer": "6/19",
    "unit": null,
    "table_title": null,
    "table": " | Acrylic paint | Chalk\nA plant | 7 | 6\nAn insect | 2 | 4",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the student chose to draw a plant\" and B be the event \"the student used chalk\".\nTo find the probability that a student chose to draw a plant and used chalk, first identify the sample space and the event.\nThe outcomes in the sample space are the different students. Each student is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the student chose to draw a plant and used chalk\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the student chose to draw a plant and used chalk\", so look at the table to see how many students chose to draw a plant and used chalk.\nThe number of students who chose to draw a plant and used chalk is 6.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of students.\n7 + 2 + 6 + 4 = 19\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{6}{19}\nThe probability that a student chose to draw a plant and used chalk is \\frac{6}{19}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "36890",
    "path": "data"
  },
  {
    "question": "Christina has $65.00. Does she have enough to buy a soup pot and a serving platter?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "serving platter | $19.00\ncutting board | $11.00\nsoup pot | $42.00\nteapot | $39.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a soup pot and the price of a serving platter:\n\n$42.00 + $19.00 = $61.00\n\n$61.00 is less than $65.00. Christina does have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "10941",
    "path": "data"
  },
  {
    "question": "Megan went on a bird watching trip and jotted down the number of birds she saw each day. On which day did Megan see the most birds?",
    "choices": [
      "Saturday",
      "Sunday",
      "Monday",
      "Tuesday"
    ],
    "answer": "Tuesday",
    "unit": null,
    "table_title": "Number of birds",
    "table": "Day | Number of birds\nSaturday | 61\nSunday | 67\nMonday | 65\nTuesday | 69",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 69.\n\nNow find the corresponding day. Tuesday corresponds to 69.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "35832",
    "path": "data"
  },
  {
    "question": "At Newport Consulting, the head of human resources examined how the number of employees with health care benefits varied in response to policy changes. According to the table, what was the rate of change between 2011 and 2012?",
    "choices": null,
    "answer": "-5",
    "unit": "employees per year",
    "table_title": "Employees with health care benefits",
    "table": "Year | Employees\n2008 | 14\n2009 | 18\n2010 | 24\n2011 | 26\n2012 | 21",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{21 employees - 26 employees}{2012 - 2011}\n = \\frac{21 employees - 26 employees}{1 year}\n = \\frac{-5 employees}{1 year}\n = -5 employees per year\nThe rate of change between 2011 and 2012 was - 5 employees per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "28474",
    "path": "data"
  },
  {
    "question": "Aiden kept track of how long it took to finish his homework each day. According to the table, what was the rate of change between Monday and Tuesday?",
    "choices": null,
    "answer": "7",
    "unit": "minutes per day",
    "table_title": "Time Aiden spent on homework",
    "table": "Day | Minutes\nSunday | 41\nMonday | 40\nTuesday | 47\nWednesday | 31\nThursday | 27",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{47 minutes - 40 minutes}{1 day}\n = \\frac{7 minutes}{1 day}\n = 7 minutes per day\nThe rate of change between Monday and Tuesday was 7 minutes per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "23279",
    "path": "data"
  },
  {
    "question": "For a math project, students in Mrs. Mills's class recorded the number of pets that each student has. How many students in the class have exactly 1 pet?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": "Pets",
    "table": "Number of pets | Frequency\n0 | 16\n1 | 12\n2 | 3\n3 | 18\n4 | 14",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row for 1 pet and read the frequency. The frequency is 12.\n\n12 students have exactly1 pet.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "26421",
    "path": "data"
  },
  {
    "question": "A business magazine surveyed its readers about their commute times. How many commutes are at least 20 minutes?",
    "choices": null,
    "answer": "23",
    "unit": null,
    "table_title": "Commute time (minutes)",
    "table": "Stem | Leaf \n2 | 5, 8, 9\n3 | 5, 6, 8\n4 | 5, 6, 8, 8, 8, 9\n5 | 0, 0, 1\n6 | 1, 4, 5, 9\n7 | 2, 3, 9\n8 | 7",
    "row_num": 8,
    "column_num": 2,
    "solution": "Count all the leaves in the rows with stems 2, 3, 4, 5, 6, 7, and 8.\n\nYou counted 23 leaves, which are blue in the stem-and-leaf plot above. 23 commutes are at least 20 minutes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "8688",
    "path": "data"
  },
  {
    "question": "Gordon counted the number of problems on each of his tests. How many tests had at least 33 problems but fewer than 54 problems?",
    "choices": null,
    "answer": "7",
    "unit": "tests",
    "table_title": "Problems per test",
    "table": "Stem | Leaf \n3 | 9, 9\n4 | 2, 3, 3, 7\n5 | 0\n6 | 0, 5\n7 | 1, 4, 7\n8 | 8",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row with stem 3. Count all the leaves greater than or equal to 3.\n\nCount all the leaves in the row with stem 4.\n\nIn the row with stem 5, count all the leaves less than 4.\n\nYou counted 7 leaves, which are blue in the stem-and-leaf plots above. 7 tests had at least 33 problems but fewer than 54 problems.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "9159",
    "path": "data"
  },
  {
    "question": "The bird watcher counted the number of birds in each flock that passed overhead. How many flocks had at least 35 birds but fewer than 55 birds?",
    "choices": null,
    "answer": "4",
    "unit": "flocks",
    "table_title": "Birds per flock",
    "table": "Stem | Leaf \n1 | 1, 1, 6\n2 | 1\n3 | 4, 9\n4 | 1, 4, 9\n5 | 8, 8, 9",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row with stem 3. Count all the leaves greater than or equal to 5.\n\nCount all the leaves in the row with stem 4.\n\nIn the row with stem 5, count all the leaves less than 5.\n\nYou counted 4 leaves, which are blue in the stem-and-leaf plots above. 4 flocks had at least 35 birds but fewer than 55 birds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "10299",
    "path": "data"
  },
  {
    "question": "Jonathan has $8.00. Does he have enough to buy a fish bowl and a bag of cat treats?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "no",
    "unit": null,
    "table_title": null,
    "table": "dog bowl | $7.00\nbag of cat treats | $3.00\ndog leash | $5.00\nfish bowl | $6.00\nhamster wheel | $1.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a fish bowl and the price of a bag of cat treats:\n\n$6.00 + $3.00 = $9.00\n\n$9.00 is more than $8.00. Jonathan does not have enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "26507",
    "path": "data"
  },
  {
    "question": "The aquarium's records showed how many tickets were sold in the past 4 days. How many tickets did the aquarium sell in all on Sunday and Wednesday?",
    "choices": null,
    "answer": "881",
    "unit": "tickets",
    "table_title": "Tickets sold",
    "table": "Day | Number of tickets\nSunday | 626\nMonday | 256\nTuesday | 195\nWednesday | 255",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nSunday: 626\nWednesday: 255\n\nNow add: 626 + 255 = 881.\n\nThe aquarium sold 881 tickets in all on Sunday and Wednesday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "6087",
    "path": "data"
  },
  {
    "question": "As part of a statistics project, a math class weighed all the children who were willing to participate. How many children weighed at least 31 pounds but less than 40 pounds?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Children's weights (lbs)",
    "table": "Stem | Leaf \n1 | 6, 7\n2 | 1, 3, 8\n3 | 2, 3, 6\n4 | 8, 9\n5 | 0, 4, 5, 6, 7\n6 | 1, 3, 4, 5, 8",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row with stem 3. Count all the leaves greater than or equal to 1.\n\nYou counted 3 leaves, which are blue in the stem-and-leaf plot above. 3 children weighed at least 31 pounds but less than 40 pounds.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "23683",
    "path": "data"
  },
  {
    "question": "Kyle has $13. Does he have enough to buy a cookbook and a casserole dish?",
    "choices": [
      "yes",
      "no"
    ],
    "answer": "yes",
    "unit": null,
    "table_title": null,
    "table": "large plate | $6\nice cream scoop | $8\nmixing bowl | $9\nglass measuring cup | $5\ncasserole dish | $9\ncookbook | $4",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the price of a cookbook and the price of a casserole dish:\n\n$4 + $9 = $13\n\nSince Kyle has $13, he has just enough money.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 3,
    "split": "dev",
    "pid": "17888",
    "path": "data"
  },
  {
    "question": "The Richmond Middle School fundraising committee found out how many sweatshirts students already had, in order to decide whether to sell sweatshirts for a fundraiser. How many students have more than 3 sweatshirts?",
    "choices": null,
    "answer": "1",
    "unit": null,
    "table_title": "Sweatshirts",
    "table": "Number of sweatshirts | Frequency\n0 | 5\n1 | 0\n2 | 11\n3 | 17\n4 | 1",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the row for 4 sweatshirts and read the frequency. The frequency is 1.\n\n1 student has more than 3 sweatshirts.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "3564",
    "path": "data"
  },
  {
    "question": "Devon's class paid attention to how many bottles each student collected for their recycling project. What is the mean of the numbers?",
    "choices": null,
    "answer": "92",
    "unit": null,
    "table_title": "Bottles collected",
    "table": "Name | Number of bottles\nDevon | 92\nRoxanne | 96\nAubrey | 95\nBobby | 87\nVictor | 96\nKira | 91\nNathan | 87",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n92, 96, 95, 87, 96, 91, 87\n\nFirst, count how many numbers are in the group.\n\nThere are 7 numbers.\n\nNow add all the numbers together:\n\n92 + 96 + 95 + 87 + 96 + 91 + 87 = 644\n\nNow divide the sum by the number of numbers:\n\n644 \u00f7 7 = 92\n\nThe mean is 92.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "28373",
    "path": "data"
  },
  {
    "question": "Peter counted the number of pieces of pepperoni on each pizza he made. How many pizzas had at least 30 pieces of pepperoni but fewer than 40 pieces of pepperoni?",
    "choices": null,
    "answer": "2",
    "unit": "pizzas",
    "table_title": "Pieces of pepperoni per pizza",
    "table": "Stem | Leaf \n1 | 2, 3, 5, 5, 7, 7, 8, 9\n2 | 4, 6, 9\n3 | 8, 8\n4 | 4",
    "row_num": 5,
    "column_num": 2,
    "solution": "Count all the leaves in the row with stem 3.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 pizzas had at least 30 pieces of pepperoni but fewer than 40 pieces of pepperoni.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "27742",
    "path": "data"
  },
  {
    "question": "In hopes of raising more funds for arts education, some parents in the Hillsboro School District publicized the current per-student arts education budget. According to the table, what was the rate of change between 2009 and 2010?",
    "choices": null,
    "answer": "9",
    "unit": "$, per year",
    "table_title": "Hillsboro arts education budget",
    "table": "Year | Per-student budget\n2007 | $32\n2008 | $29\n2009 | $23\n2010 | $32\n2011 | $23",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{$32 - $23}{2010 - 2009}\n = \\frac{$32 - $23}{1 year}\n = \\frac{$9}{1 year}\n = $9 per year\nThe rate of change between 2009 and 2010 was $9 per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "16645",
    "path": "data"
  },
  {
    "question": "How much money does Sally need to buy a pencil and a box of envelopes?",
    "choices": null,
    "answer": "1.35",
    "unit": "$",
    "table_title": null,
    "table": "pencil sharpener | $0.74\nbox of envelopes | $0.95\npencil | $0.40\nruler | $0.52",
    "row_num": 4,
    "column_num": 2,
    "solution": "Add the price of a pencil and the price of a box of envelopes:\n\n$0.40 + $0.95 = $1.35\n\nSally needs $1.35.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "12719",
    "path": "data"
  },
  {
    "question": "Several students participated in a race. What is the mean of the numbers?",
    "choices": null,
    "answer": "24",
    "unit": null,
    "table_title": "Race results",
    "table": "Runner | Time (minutes)\nAlice | 23\nBrittany | 12\nRaymond | 24\nDeb | 26\nEli | 26\nHannah | 27\nKayla | 26\nJamal | 28",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n23, 12, 24, 26, 26, 27, 26, 28\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n23 + 12 + 24 + 26 + 26 + 27 + 26 + 28 = 192\n\nNow divide the sum by the number of numbers:\n\n192 \u00f7 8 = 24\n\nThe mean is 24.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "18636",
    "path": "data"
  },
  {
    "question": "A science teacher presented a balloon to his class, and posed the question, \"If I keep this balloon in the freezer overnight, what will occur?\" He followed up with, \"How certain are you of your answer?\" The teacher recorded his students' responses. What is the probability that a randomly selected student was certain and believes the balloon will stay the same? Simplify any fractions.",
    "choices": null,
    "answer": "1/11",
    "unit": null,
    "table_title": null,
    "table": " | Shrink | Stay the same\nCertain | 3 | 1\nUncertain | 3 | 4",
    "row_num": 3,
    "column_num": 3,
    "solution": "Let A be the event \"the student was certain\" and B be the event \"the student believes the balloon will stay the same\".\nTo find the probability that a student was certain and believes the balloon will stay the same, first identify the sample space and the event.\nThe outcomes in the sample space are the different students. Each student is equally likely to be selected, so this is a uniform probability model.\nThe event is A and B, \"the student was certain and believes the balloon will stay the same\".\nSince this is a uniform probability model, count the number of outcomes in the event A and B and count the total number of outcomes. Then, divide them to compute the probability.\n\nFind the number of outcomes in the event A and B.\nA and B is the event \"the student was certain and believes the balloon will stay the same\", so look at the table to see how many students were certain and believe the balloon will stay the same.\nThe number of students who were certain and believe the balloon will stay the same is 1.\n\nFind the total number of outcomes.\nAdd all the numbers in the table to find the total number of students.\n3 + 3 + 1 + 4 = 11\n\nFind P(A and B).\nSince all outcomes are equally likely, the probability of event A and B is the number of outcomes in event A and B divided by the total number of outcomes.\nP(A and B) = \\frac{# of outcomes in A and B}{total # of outcomes}\n = \\frac{1}{11}\nThe probability that a student was certain and believes the balloon will stay the same is \\frac{1}{11}.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 8,
    "split": "dev",
    "pid": "6578",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $1,000, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$820 | 17,000 | 1,000\n$910 | 14,100 | 5,800\n$1,000 | 11,200 | 10,600\n$1,090 | 8,300 | 15,400\n$1,180 | 5,400 | 20,200",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $1,000, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "11683",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n4 | 13\n5 | 10\n6 | 7",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{10 - 13}{5 - 4}\n = \\frac{-3}{1}\n = -3\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{7 - 13}{6 - 4}\n = \\frac{-6}{2}\n = -3\nThe two rates of change are the same.\n3.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "21503",
    "path": "data"
  },
  {
    "question": "The architecture student counted the number of bricks in each building in his neighborhood. How many buildings have exactly 53 bricks?",
    "choices": null,
    "answer": "1",
    "unit": "buildings",
    "table_title": "Bricks per building",
    "table": "Stem | Leaf \n1 | 4, 7, 9\n2 | 9, 9\n3 | 0, 8\n4 | 1, 2\n5 | 1, 3\n6 | 8\n7 | 9\n8 | 2, 4\n9 | 0",
    "row_num": 10,
    "column_num": 2,
    "solution": "For the number 53, the stem is 5, and the leaf is 3. Find the row where the stem is 5. In that row, count all the leaves equal to 3.\n\nYou counted 1 leaf, which is blue in the stem-and-leaf plot above. 1 building has exactly 53 bricks.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "22617",
    "path": "data"
  },
  {
    "question": "Some friends compared the sizes of their sticker collections. What is the range of the numbers?",
    "choices": null,
    "answer": "36",
    "unit": null,
    "table_title": "Sticker collections",
    "table": "Name | Number of stickers\nMalia | 45\nAusten | 67\nIvan | 44\nCooper | 57\nHakim | 49\nSophie | 57\nKate | 54\nJackie | 31",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n45, 67, 44, 57, 49, 57, 54, 31\n\nFirst, find the greatest number. The greatest number is 67.\n\nNext, find the least number. The least number is 31.\n\nSubtract the least number from the greatest number:\n\n67 \u2212 31 = 36\n\nThe range is 36.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "9030",
    "path": "data"
  },
  {
    "question": "As part of a food drive, five friends collected canned food. What fraction of the cans were collected by Emmet? Simplify your answer.",
    "choices": null,
    "answer": "68/217",
    "unit": null,
    "table_title": "Cans of food collected",
    "table": "Name | Number of cans of food\nEmmet | 680\nJustine | 350\nAntonio | 830\nKenji | 300\nHarper | 10",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find how many cans were collected by Emmet.\n\n680\n\nFind how many cans were collected in total.\n\n680 + 350 + 830 + 300 + 10 = 2,170\n\nDivide 680 by2,170.\n\n\\frac{680}{2,170}\n\nReduce the fraction.\n\n\\frac{680}{2,170} \u2192 \\frac{68}{217}\n\n\\frac{68}{217} of cans were collected by Emmet.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "30399",
    "path": "data"
  },
  {
    "question": "Mr. Elliott, a track coach, recorded the sizes of all the nearby track teams. What is the size of the largest team?",
    "choices": null,
    "answer": "90",
    "unit": "members",
    "table_title": "Track team sizes (number of members)",
    "table": "Stem | Leaf \n2 | 4\n3 | 0, 8\n4 | \n5 | 4, 8\n6 | 0\n7 | 7\n8 | 2, 3, 3\n9 | 0",
    "row_num": 9,
    "column_num": 2,
    "solution": "Look at the last row of the stem-and-leaf plot. The last row has the highest stem. The stem for the last row is 9.\n\nNow find the highest leaf in the last row. The highest leaf is 0.\n\nThe size of the largest team has a stem of 9 and a leaf of 0. Write the stem first, then the leaf: 90.\n\nThe size of the largest team is 90 members.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "19792",
    "path": "data"
  },
  {
    "question": "Pam buys 1 kilogram of semisweet chocolate and 3 kilograms of white chocolate. What is the total cost?",
    "choices": null,
    "answer": "6.86",
    "unit": "$",
    "table_title": null,
    "table": "white chocolate | $1.52/kg\nbittersweet chocolate | $2.88/kg\nsemisweet chocolate | $2.30/kg\nmilk chocolate | $2.40/kg\ndark chocolate | $1.53/kg\norange chocolate | $2.01/kg",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the semisweet chocolate. Multiply:\n\n$2.30 \u00d7 1 = $2.30\n\nFind the cost of the white chocolate. Multiply:\n\n$1.52 \u00d7 3 = $4.56\n\nNow find the total cost by adding:\n\n$2.30 + $4.56 = $6.86\n\nThe total cost is $6.86.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "37433",
    "path": "data"
  },
  {
    "question": "How much money does Myra need to buy a ticket for a South American cruise and a ticket for a Mexican cruise?",
    "choices": null,
    "answer": "9,098",
    "unit": "$",
    "table_title": null,
    "table": "ticket for an Australian cruise | $2,301.00\nticket for an Atlantic cruise | $2,827.00\nticket for a Mexican cruise | $7,201.00\nticket for a South American cruise | $1,897.00\nticket for a Caribbean cruise | $9,912.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a ticket for a South American cruise and the price of a ticket for a Mexican cruise:\n\n$1,897.00 + $7,201.00 = $9,098.00\n\nMyra needs $9,098.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "11728",
    "path": "data"
  },
  {
    "question": "The receptionist at a doctor's office kept track of each patient's wait time. How many people waited for exactly 57 minutes?",
    "choices": null,
    "answer": "0",
    "unit": null,
    "table_title": "Doctor's office wait times (minutes)",
    "table": "Stem | Leaf \n2 | 2, 7\n3 | 0, 2, 4, 6, 8, 8\n4 | 1, 9\n5 | 5",
    "row_num": 5,
    "column_num": 2,
    "solution": "For the number 57, the stem is 5, and the leaf is 7. Find the row where the stem is 5. In that row, count all the leaves equal to 7.\n\nYou counted 0 leaves. 0 people waited for exactly 57 minutes.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "32853",
    "path": "data"
  },
  {
    "question": "How much money does Scott need to buy a kayak and a dirt bike?",
    "choices": null,
    "answer": "1,855",
    "unit": "$",
    "table_title": null,
    "table": "dirt bike | $902.00\nsnowmobile | $892.00\nkayak | $953.00\nsailboat | $608.00\ncanoe | $724.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a kayak and the price of a dirt bike:\n\n$953.00 + $902.00 = $1,855.00\n\nScott needs $1,855.00.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "23044",
    "path": "data"
  },
  {
    "question": "Several people compared how many Web pages they had visited. What is the mode of the numbers?",
    "choices": null,
    "answer": "2",
    "unit": null,
    "table_title": "Web pages visited",
    "table": "Person | Number of Web pages\nTed | 10\nCarmen | 8\nMason | 2\nLisa | 10\nBobby | 2\nRobert | 2",
    "row_num": 7,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 8, 2, 10, 2, 2\n\nFirst, arrange the numbers from least to greatest:\n\n2, 2, 2, 8, 10, 10\n\nNow count how many times each number appears.\n\n2 appears 3 times.\n8 appears 1 time.\n10 appears 2 times.\n\nThe number that appears most often is 2.\n\nThe mode is 2.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "8821",
    "path": "data"
  },
  {
    "question": "Rachel measured the length of each scarf in the clothing store where she works. How many scarves are exactly 97 centimeters?",
    "choices": null,
    "answer": "0",
    "unit": null,
    "table_title": "Scarf lengths (centimeters)",
    "table": "Stem | Leaf \n6 | 9\n7 | 3, 5, 7, 7, 7, 8\n8 | 0, 0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 9\n9 | 0",
    "row_num": 5,
    "column_num": 2,
    "solution": "For the number 97, the stem is 9, and the leaf is 7. Find the row where the stem is 9. In that row, count all the leaves equal to 7.\n\nYou counted 0 leaves. 0 scarves are exactly 97 centimeters.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "16689",
    "path": "data"
  },
  {
    "question": "An office manager counts the number of letters sent by each of her company's employees each week. How many employees mailed exactly 2 letters last week?",
    "choices": null,
    "answer": "3",
    "unit": null,
    "table_title": "Mailing letters last week",
    "table": "Letters mailed | Frequency\n0 | 11\n1 | 7\n2 | 3\n3 | 2\n4 | 4\n5 | 9",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row for 2 letters and read the frequency. The frequency is 3.\n\n3 employees mailed exactly2 letters last week.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "13764",
    "path": "data"
  },
  {
    "question": "Some friends played a trivia game and recorded their scores. What is the range of the numbers?",
    "choices": null,
    "answer": "5",
    "unit": null,
    "table_title": "Trivia game scores",
    "table": "Name | Score\nReid | 10\nPablo | 5\nIvan | 9\nGabe | 5\nBernard | 10\nAriana | 9\nOlivia | 10\nSophia | 6",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n10, 5, 9, 5, 10, 9, 10, 6\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 5.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 5 = 5\n\nThe range is 5.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "18162",
    "path": "data"
  },
  {
    "question": "A dog show enthusiast recorded the weight of the winning dog at recent dog shows. According to the table, what was the rate of change between 2013 and 2014?",
    "choices": null,
    "answer": "-1",
    "unit": "kilograms per year",
    "table_title": "Weight of winning dog at a dog show",
    "table": "Year | Weight (kg)\n2013 | 24\n2014 | 23\n2015 | 21\n2016 | 21\n2017 | 23",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{23 kilograms - 24 kilograms}{2014 - 2013}\n = \\frac{23 kilograms - 24 kilograms}{1 year}\n = \\frac{-1 kilograms}{1 year}\n = -1 kilograms per year\nThe rate of change between 2013 and 2014 was - 1 kilograms per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "22686",
    "path": "data"
  },
  {
    "question": "Some teachers compared how many years they have been teaching. What is the mean of the numbers?",
    "choices": null,
    "answer": "4",
    "unit": null,
    "table_title": "Years of teaching",
    "table": "Teacher | Number of years\nMiss Torres | 4\nMr. Park | 1\nMr. Gutierrez | 4\nMiss Watson | 2\nMs. Chan | 8\nMr. Boone | 7\nMiss Lim | 2\nMr. Perez | 4",
    "row_num": 9,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n4, 1, 4, 2, 8, 7, 2, 4\n\nFirst, count how many numbers are in the group.\n\nThere are 8 numbers.\n\nNow add all the numbers together:\n\n4 + 1 + 4 + 2 + 8 + 7 + 2 + 4 = 32\n\nNow divide the sum by the number of numbers:\n\n32 \u00f7 8 = 4\n\nThe mean is 4.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "4744",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. When does the women's relay begin?",
    "choices": [
      "2:50 P.M.",
      "2:10 P.M.",
      "11:55 A.M.",
      "1:45 P.M."
    ],
    "answer": "2:10 P.M.",
    "unit": null,
    "table_title": "Track meet schedule",
    "table": "Event | Begin | End\ntriple jump | 10:30 A.M. | 10:45 A.M.\npole vault | 11:00 A.M. | 11:55 A.M.\nhurdles | 12:05 P.M. | 12:55 P.M.\nsteeplechase | 1:10 P.M. | 1:30 P.M.\nmen's relay | 1:45 P.M. | 1:55 P.M.\nwomen's relay | 2:10 P.M. | 2:50 P.M.\nhigh jump | 3:05 P.M. | 4:00 P.M.",
    "row_num": 8,
    "column_num": 3,
    "solution": "Find the women's relay on the schedule. Find the beginning time for the women's relay.\n\nwomen's relay: 2:10 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 3,
    "split": "dev",
    "pid": "1086",
    "path": "data"
  },
  {
    "question": "The parks department compared how many soccer fields there are at each park. What is the range of the numbers?",
    "choices": null,
    "answer": "7",
    "unit": null,
    "table_title": "Soccer fields",
    "table": "Park | Number of soccer fields\nCrane Park | 7\nMiddle Park | 4\nJuniper Park | 6\nLighthouse Park | 4\nCanyon Park | 10\nWindy Hill Park | 9\nMoon Park | 3",
    "row_num": 8,
    "column_num": 2,
    "solution": "Read the numbers from the table.\n\n7, 4, 6, 4, 10, 9, 3\n\nFirst, find the greatest number. The greatest number is 10.\n\nNext, find the least number. The least number is 3.\n\nSubtract the least number from the greatest number:\n\n10 \u2212 3 = 7\n\nThe range is 7.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "26656",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $315, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$195 | 19,900 | 9,300\n$255 | 17,900 | 12,200\n$315 | 15,900 | 15,100\n$375 | 13,900 | 18,000\n$435 | 11,900 | 20,900",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $315, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "7788",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "linear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n6 | 9\n7 | 8\n8 | 7",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{8 - 9}{7 - 6}\n = \\frac{-1}{1}\n = -1\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{7 - 9}{8 - 6}\n = \\frac{-2}{2}\n = -1\nThe two rates of change are the same.\n1.\nThis means the rate of change is the same for each pair of points. So, the function has a constant rate of change.\nThe function is linear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "4251",
    "path": "data"
  },
  {
    "question": "How much money does Chandler need to buy a piece of pink paper, a purple envelope, and a pale purple note card?",
    "choices": null,
    "answer": "0.20",
    "unit": "$",
    "table_title": null,
    "table": "pale purple note card | $0.09\npiece of pink paper | $0.08\npurple envelope | $0.03\npiece of red and purple stationery | $0.02\nwhite note card | $0.08",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of a piece of pink paper, a purple envelope, and a pale purple note card.\n\n$0.08 + $0.03 + $0.09 = $0.20\n\nChandler needs $0.20.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 5,
    "split": "dev",
    "pid": "4709",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "nonlinear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n15 | 19\n16 | 10\n17 | 7",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{10 - 19}{16 - 15}\n = \\frac{-9}{1}\n = -9\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the first row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{7 - 19}{17 - 15}\n = \\frac{-12}{2}\n = -6\nThe rate of change is not the same for each pair of points. So, the function does not have a constant rate of change.\nThe function is nonlinear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "565",
    "path": "data"
  },
  {
    "question": "Bella counted the number of ducks at each pond in the city. How many ponds had exactly 13 ducks?",
    "choices": null,
    "answer": "2",
    "unit": "ponds",
    "table_title": "Ducks per pond",
    "table": "Stem | Leaf \n0 | 4\n1 | 3, 3\n2 | 9\n3 | 9\n4 | 5\n5 | \n6 | \n7 | \n8 | 3",
    "row_num": 10,
    "column_num": 2,
    "solution": "For the number 13, the stem is 1, and the leaf is 3. Find the row where the stem is 1. In that row, count all the leaves equal to 3.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 ponds had exactly13 ducks.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "18029",
    "path": "data"
  },
  {
    "question": "A pumpkin patch monitored the number of pumpkins sold each day. On which day did the pumpkin patch sell the most pumpkins?",
    "choices": [
      "Friday",
      "Saturday",
      "Sunday",
      "Monday"
    ],
    "answer": "Saturday",
    "unit": null,
    "table_title": "Pumpkins sold",
    "table": "Day | Number of pumpkins\nFriday | 169\nSaturday | 186\nSunday | 111\nMonday | 181",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 186.\n\nNow find the corresponding day. Saturday corresponds to 186.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "36594",
    "path": "data"
  },
  {
    "question": "An actor was informed how many fan letters he received each day. How many fan letters total were received on Tuesday and Wednesday?",
    "choices": null,
    "answer": "511",
    "unit": "fan letters",
    "table_title": "Fan letters received",
    "table": "Day | Number of fan letters\nFriday | 335\nSaturday | 355\nMonday | 244\nTuesday | 110\nWednesday | 401",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the numbers in the table.\n\nTuesday: 110\nWednesday: 401\n\nNow add: 110 + 401 = 511.\n\n511 fan letters total were received on Tuesday and Wednesday.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 3,
    "split": "dev",
    "pid": "325",
    "path": "data"
  },
  {
    "question": "What is the total cost for 1/2 of a pound of cheddar popcorn?",
    "choices": null,
    "answer": "2",
    "unit": "$",
    "table_title": null,
    "table": "ranch popcorn | $1 per pound\nchocolate popcorn | $2 per pound\ncaramel corn | $3 per pound\ncheddar popcorn | $4 per pound\nkettle corn | $2 per pound\nParmesan popcorn | $3 per pound",
    "row_num": 6,
    "column_num": 2,
    "solution": "Find the cost of the cheddar popcorn. Multiply the price per pound by the number of pounds.\n$4 \u00d7 \\frac{1}{2} = $4 \u00d7 0.5 = $2\nThe total cost is $2.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "33646",
    "path": "data"
  },
  {
    "question": "Each van has 2 people. How many people are in 6 vans?",
    "choices": null,
    "answer": "12",
    "unit": null,
    "table_title": null,
    "table": "Number of vans | Number of people\n1 | 2\n2 | 4\n3 | 6\n4 | 8\n5 | 10\n6 | ?",
    "row_num": 7,
    "column_num": 2,
    "solution": "Count by twos. Use the chart: there are 12 people in 6 vans.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 2,
    "split": "dev",
    "pid": "3704",
    "path": "data"
  },
  {
    "question": "A machine at the candy factory dispensed different numbers of lemon-flavored candies into various bags. How many bags had exactly 22 lemon-flavored candies?",
    "choices": null,
    "answer": "2",
    "unit": "bags",
    "table_title": "Lemon-flavored candies per bag",
    "table": "Stem | Leaf \n1 | 0, 2\n2 | 2, 2, 9\n3 | \n4 | 6\n5 | \n6 | \n7 | 1",
    "row_num": 8,
    "column_num": 2,
    "solution": "For the number 22, the stem is 2, and the leaf is 2. Find the row where the stem is 2. In that row, count all the leaves equal to 2.\n\nYou counted 2 leaves, which are blue in the stem-and-leaf plot above. 2 bags had exactly22 lemon-flavored candies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 6,
    "split": "dev",
    "pid": "16103",
    "path": "data"
  },
  {
    "question": "For an economics project, Bridget determined the cost of ferry rides for bicycles and cars. On the Seattle-Bremerton ferry, how much higher is the fare for a car than for a bicycle?",
    "choices": null,
    "answer": "4",
    "unit": "$",
    "table_title": "Ferry fares",
    "table": "Ferry | Car | Bicycle\nSouthport-Fort Fisher | $5 | $2\nSeattle-Bremerton | $12 | $8\nFauntleroy-Vashon | $15 | $5\nOcracoke | $15 | $3\nMukilteu-Clinton | $7 | $5",
    "row_num": 6,
    "column_num": 3,
    "solution": "Find the Seattle-Bremerton row. Find the numbers in this row for car and bicycle.\n\ncar: $12.00\nbicycle: $8.00\n\nNow subtract:\n\n$12.00 \u2212 $8.00 = $4.00\n\nOn the Seattle-Bremerton ferry, the fare for a car is $4 higher than the fare for a bicycle.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "32632",
    "path": "data"
  },
  {
    "question": "How much more does a box of gingersnaps cost than a box of graham crackers?",
    "choices": null,
    "answer": "2.70",
    "unit": "$",
    "table_title": null,
    "table": "box of gingersnaps | $4.03\nbag of frozen vegetables | $1.97\nbox of lemon cookies | $4.88\nbag of rice | $2.37\npackage of oatmeal cookies | $1.12\nbox of graham crackers | $1.33",
    "row_num": 6,
    "column_num": 2,
    "solution": "Subtract the price of a box of graham crackers from the price of a box of gingersnaps.\n\n$4.03 - $1.33 = $2.70\n\nA box of gingersnaps costs $2.70 more than a box of graham crackers.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "5041",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "nonlinear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n10 | 16\n11 | 8\n12 | 4",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{8 - 16}{11 - 10}\n = \\frac{-8}{1}\n = -8\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{4 - 8}{12 - 11}\n = \\frac{-4}{1}\n = -4\nThe rate of change is not the same for each pair of points. So, the function does not have a constant rate of change.\nThe function is nonlinear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "4138",
    "path": "data"
  },
  {
    "question": "Mike has $55.00. How much money will Mike have left if he buys a book about Antarctica and a book about soccer?",
    "choices": null,
    "answer": "19",
    "unit": "$",
    "table_title": null,
    "table": "book about Antarctica | $13.00\nbook about soccer | $23.00\nbook about sharks | $20.00\nbook about dinosaurs | $22.00\nbook about hiking | $24.00",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the total cost of a book about Antarctica and a book about soccer.\n\n$13.00 + $23.00 = $36.00\n\nNow subtract the total cost from the starting amount.\n\n$55.00 - $36.00 = $19.00\n\nMike will have $19.00 left.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "15318",
    "path": "data"
  },
  {
    "question": "The parents running this year's craft sale counted the number of key chains made by volunteers. How many people are there in all?",
    "choices": null,
    "answer": "57",
    "unit": null,
    "table_title": "Making key chains",
    "table": "Key chains made | Frequency\n1 | 11\n2 | 15\n3 | 17\n4 | 12\n5 | 2",
    "row_num": 6,
    "column_num": 2,
    "solution": "Add the frequencies for each row.\n\nAdd:\n\n11 + 15 + 17 + 12 + 2 = 57\n\nThere are 57 people in all.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "32719",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $730, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$160 | 14,700 | 3,300\n$350 | 12,300 | 6,700\n$540 | 9,900 | 10,100\n$730 | 7,500 | 13,500\n$920 | 5,100 | 16,900",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $730, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "27869",
    "path": "data"
  },
  {
    "question": "While looking through an almanac at the library, Lamar noticed some data showing the population density of various states. How many people per square mile lived in Idaho in 1990?",
    "choices": null,
    "answer": "12",
    "unit": "people per square mile",
    "table_title": "Population per square mile",
    "table": "State | 1990 | 2000\nIdaho | 12 | 15\nNorth Dakota | 9 | 9\nNew Mexico | 12 | 15",
    "row_num": 4,
    "column_num": 3,
    "solution": "First, find the row for Idaho. Then find the number in the 1990 column.\n\nThis number is 12. In 1990, Idaho had 12 people per square mile.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "11522",
    "path": "data"
  },
  {
    "question": "Some travelers in an airport compared how far they had flown that day. Who flew the shortest distance?",
    "choices": [
      "Darius",
      "Leon",
      "Isabelle",
      "Justine"
    ],
    "answer": "Isabelle",
    "unit": null,
    "table_title": "Length of airplane flights",
    "table": "Name | Miles\nDarius | 943\nLeon | 949\nIsabelle | 934\nJustine | 993",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 934.\n\nNow find the corresponding name. Isabelle corresponds to 934.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "3205",
    "path": "data"
  },
  {
    "question": "Some friends went bowling and kept track of their scores. Who had the highest score?",
    "choices": [
      "Lara",
      "Tanner",
      "Russell",
      "Brenda"
    ],
    "answer": "Brenda",
    "unit": null,
    "table_title": "Bowling scores",
    "table": "Name | Score\nLara | 87\nTanner | 81\nRussell | 86\nBrenda | 88",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the greatest number in the table. Remember to compare the numbers starting with the highest place value. The greatest number is 88.\n\nNow find the corresponding name. Brenda corresponds to 88.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "24176",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $185, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "shortage",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$185 | 19,600 | 1,400\n$345 | 15,400 | 5,500\n$505 | 11,200 | 9,600\n$665 | 7,000 | 13,700\n$825 | 2,800 | 17,800",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $185, the quantity demanded is greater than the quantity supplied. There is not enough of the good or service for sale at that price. So, there is a shortage.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "4939",
    "path": "data"
  },
  {
    "question": "During health class, the students reported the number of times they ate fast food last month. How many students ate fast food exactly 5 times last month?",
    "choices": null,
    "answer": "0",
    "unit": null,
    "table_title": "Eating fast food last month",
    "table": "Times eaten | Frequency\n0 | 14\n1 | 8\n2 | 17\n3 | 4\n4 | 16\n5 | 0",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the row for 5 times and read the frequency. The frequency is 0.\n\n0 students ate fast food exactly 5 times last month.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "3646",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $710, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$390 | 19,600 | 5,900\n$470 | 15,100 | 9,700\n$550 | 10,600 | 13,500\n$630 | 6,100 | 17,300\n$710 | 1,600 | 21,100",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $710, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "3250",
    "path": "data"
  },
  {
    "question": "How much would it cost to buy 3+1/2 pounds of whole wheat pancake mix?",
    "choices": null,
    "answer": "10.50",
    "unit": "$",
    "table_title": null,
    "table": "plain pancake mix | $2 per pound\nraspberry pancake mix | $3 per pound\nblueberry pancake mix | $3 per pound\nwhole wheat pancake mix | $3 per pound\nbuttermilk pancake mix | $3 per pound",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the whole wheat pancake mix. Multiply the price per pound by the number of pounds.\n$3 \u00d7 3\\frac{1}{2} = $3 \u00d7 3.5 = $10.50\nIt would cost $10.50.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "28976",
    "path": "data"
  },
  {
    "question": "Look at the following schedule. Wayne just missed the 5.30 A.M. train at Rocky Ravine Town. What time is the next train?",
    "choices": [
      "3:45 A.M.",
      "12:15 P.M.",
      "6:00 A.M.",
      "12:45 A.M."
    ],
    "answer": "12:15 P.M.",
    "unit": null,
    "table_title": "Train schedule",
    "table": "Gecko Paradise | 3:00 A.M. | 4:45 A.M. | 11:30 A.M. | 12:00 A.M.\nRocky Ravine Town | 3:45 A.M. | 5:30 A.M. | 12:15 P.M. | 12:45 A.M.\nChickenville | 4:45 A.M. | 6:30 A.M. | 1:15 P.M. | 1:45 A.M.\nSnowy Mountain | 5:30 A.M. | 7:15 A.M. | 2:00 P.M. | 2:30 A.M.\nCity of Green Trees | 6:00 A.M. | 7:45 A.M. | 2:30 P.M. | 3:00 A.M.",
    "row_num": 5,
    "column_num": 5,
    "solution": "Find 5:30 A. M. in the row for Rocky Ravine Town.\n\nLook for the next train in that row.\n\nThe next train is at 12:15 P. M.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 4,
    "split": "dev",
    "pid": "19938",
    "path": "data"
  },
  {
    "question": "What is the total cost for 3.9 kilograms of scallops?",
    "choices": null,
    "answer": "15.60",
    "unit": "$",
    "table_title": null,
    "table": "shrimp | $3/kg\nmussels | $2/kg\ncrab meat | $4/kg\nscallops | $4/kg",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the cost of the scallops. Multiply the price per kilogram by the number of kilograms.\n$4 \u00d7 3.9 = $15.60\nThe total cost is $15.60.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "16565",
    "path": "data"
  },
  {
    "question": "Each year, the campers at Darrell's summer camp try to set that summer's record for finishing the obstacle course as quickly as possible. According to the table, what was the rate of change between 2012 and 2013?",
    "choices": null,
    "answer": "3",
    "unit": "minutes per year",
    "table_title": "Record obstacle course completion times",
    "table": "Year | Record time (minutes)\n2011 | 28\n2012 | 22\n2013 | 25\n2014 | 30\n2015 | 29",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{25 minutes - 22 minutes}{2013 - 2012}\n = \\frac{25 minutes - 22 minutes}{1 year}\n = \\frac{3 minutes}{1 year}\n = 3 minutes per year\nThe rate of change between 2012 and 2013 was 3 minutes per year.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "19561",
    "path": "data"
  },
  {
    "question": "Hakim kept track of how long it took to finish his homework each day. According to the table, what was the rate of change between Wednesday and Thursday?",
    "choices": null,
    "answer": "1",
    "unit": "minutes per day",
    "table_title": "Time Hakim spent on homework",
    "table": "Day | Minutes\nMonday | 28\nTuesday | 27\nWednesday | 22\nThursday | 23\nFriday | 29",
    "row_num": 6,
    "column_num": 2,
    "solution": "Plug the numbers into the formula for rate of change and simplify.\nRate of change\n = \\frac{change in value}{change in time}\n = \\frac{23 minutes - 22 minutes}{1 day}\n = \\frac{1 minute}{1 day}\n = 1 minute per day\nThe rate of change between Wednesday and Thursday was 1 minute per day.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "37358",
    "path": "data"
  },
  {
    "question": "The table shows a function. Is the function linear or nonlinear?",
    "choices": [
      "linear",
      "nonlinear"
    ],
    "answer": "nonlinear",
    "unit": null,
    "table_title": null,
    "table": "x | y\n6 | 7\n7 | 5\n8 | 4",
    "row_num": 4,
    "column_num": 2,
    "solution": "To determine whether the function is linear or nonlinear, see whether it has a constant rate of change.\nPick the points in any two rows of the table and calculate the rate of change between them. The first two rows are a good place to start.\nCall the values in the first row x1 and y1. Call the values in the second row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{5 - 7}{7 - 6}\n = \\frac{-2}{1}\n = -2\nNow pick any other two rows and calculate the rate of change between them.\nCall the values in the second row x1 and y1. Call the values in the third row x2 and y2.\nRate of change = \\frac{y2 - y1}{x2 - x1}\n = \\frac{4 - 5}{8 - 7}\n = \\frac{-1}{1}\n = -1\nThe rate of change is not the same for each pair of points. So, the function does not have a constant rate of change.\nThe function is nonlinear.",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 8,
    "split": "dev",
    "pid": "5519",
    "path": "data"
  },
  {
    "question": "At a candy factory, butterscotch candies were packaged into bags of different sizes. How many bags had exactly 16 butterscotch candies?",
    "choices": null,
    "answer": "1",
    "unit": "bags",
    "table_title": "Butterscotch candies per bag",
    "table": "Stem | Leaf \n1 | 2, 4, 6, 7\n2 | 2, 3\n3 | 3, 8\n4 | 1, 2, 3, 8\n5 | 2, 6, 9\n6 | 2, 4, 7",
    "row_num": 7,
    "column_num": 2,
    "solution": "For the number 16, the stem is 1, and the leaf is 6. Find the row where the stem is 1. In that row, count all the leaves equal to 6.\n\nYou counted 1 leaf, which is blue in the stem-and-leaf plot above. 1 bag had exactly16 butterscotch candies.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "2550",
    "path": "data"
  },
  {
    "question": "How much money does Matthew need to buy a ticket for an Atlantic cruise and a ticket for a Hawaiian cruise?",
    "choices": null,
    "answer": "663",
    "unit": "$",
    "table_title": null,
    "table": "ticket for a Hawaiian cruise | $239\nticket for an Atlantic cruise | $424\nticket for a Mediterranean cruise | $855\nticket for an Australian cruise | $817\nticket for a Caribbean cruise | $274",
    "row_num": 5,
    "column_num": 2,
    "solution": "Add the price of a ticket for an Atlantic cruise and the price of a ticket for a Hawaiian cruise:\n\n$424 + $239 = $663\n\nMatthew needs $663.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 7,
    "split": "dev",
    "pid": "33529",
    "path": "data"
  },
  {
    "question": "How much more does a sailboat cost than a kayak?",
    "choices": null,
    "answer": "257",
    "unit": "$",
    "table_title": null,
    "table": "dirt bike | $922.00\nkayak | $660.00\nmotorcycle | $628.00\nsailboat | $917.00\nsnowmobile | $753.00\ncanoe | $716.00",
    "row_num": 6,
    "column_num": 2,
    "solution": "Subtract the price of a kayak from the price of a sailboat.\n\n$917.00 - $660.00 = $257.00\n\nA sailboat costs $257.00 more than a kayak.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 4,
    "split": "dev",
    "pid": "10921",
    "path": "data"
  },
  {
    "question": "The shop teacher, Mr. Carlson, wrote down how many picture frames the students made last week. How many students made at least 4 picture frames?",
    "choices": null,
    "answer": "24",
    "unit": null,
    "table_title": "Making picture frames",
    "table": "Picture frames made | Frequency\n0 | 3\n1 | 16\n2 | 1\n3 | 7\n4 | 4\n5 | 20",
    "row_num": 7,
    "column_num": 2,
    "solution": "Find the rows for 4 and 5 picture frames. Add the frequencies for these rows.\n\nAdd:\n\n4 + 20 = 24\n\n24 students made at least 4 picture frames.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 8,
    "split": "dev",
    "pid": "27357",
    "path": "data"
  },
  {
    "question": "Look at the table. Then answer the question. At a price of $755, is there a shortage or a surplus?",
    "choices": [
      "shortage",
      "surplus"
    ],
    "answer": "surplus",
    "unit": null,
    "table_title": null,
    "table": "Price | Quantity demanded | Quantity supplied\n$245 | 20,900 | 6,200\n$415 | 17,600 | 9,700\n$585 | 14,300 | 13,200\n$755 | 11,000 | 16,700\n$925 | 7,700 | 20,200",
    "row_num": 6,
    "column_num": 3,
    "solution": "At the price of $755, the quantity demanded is less than the quantity supplied. There is too much of the good or service for sale at that price. So, there is a surplus.\n",
    "ques_type": "multi_choice",
    "ans_type": "boolean_text",
    "grade": 5,
    "split": "dev",
    "pid": "9188",
    "path": "data"
  },
  {
    "question": "Dylan has $17.00. How much money will Dylan have left if he buys a dog bowl and a box of dog biscuits?",
    "choices": null,
    "answer": "5",
    "unit": "$",
    "table_title": null,
    "table": "dog bowl | $5.00\nhamster wheel | $8.00\nbox of dog biscuits | $7.00\nbag of birdseed | $6.00",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of a dog bowl and a box of dog biscuits.\n\n$5.00 + $7.00 = $12.00\n\nNow subtract the total cost from the starting amount.\n\n$17.00 - $12.00 = $5.00\n\nDylan will have $5.00 left.",
    "ques_type": "free_text",
    "ans_type": "integer_number",
    "grade": 5,
    "split": "dev",
    "pid": "10890",
    "path": "data"
  },
  {
    "question": "The players on a quiz show received the following scores. Who had the lowest score?",
    "choices": [
      "Wayne",
      "Tori",
      "Luna",
      "Devin"
    ],
    "answer": "Tori",
    "unit": null,
    "table_title": "Quiz show scores",
    "table": "Name | Score\nWayne | 45\nTori | 42\nLuna | 43\nDevin | 49",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the least number in the table. Remember to compare the numbers starting with the highest place value. The least number is 42.\n\nNow find the corresponding name. Tori corresponds to 42.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 2,
    "split": "dev",
    "pid": "38181",
    "path": "data"
  },
  {
    "question": "An agricultural agency is researching how much cheese people have been eating in different parts of the world. Which country consumed the least cheese per capita in 2006?",
    "choices": [
      "Canada",
      "Germany",
      "Australia",
      "Austria"
    ],
    "answer": "Australia",
    "unit": null,
    "table_title": "Cheese consumption per capita (kg)",
    "table": "Country | 1996 | 2006\nCanada | 10 | 11\nAustria | 10 | 17\nArgentina | 11 | 11\nGermany | 12 | 20\nAustralia | 10 | 10",
    "row_num": 6,
    "column_num": 3,
    "solution": "Look at the numbers in the 2006 column. Find the least number in this column.\n\nThe least number is 10, which is in the Australia row. Australia consumed the least cheese per capita in 2006.",
    "ques_type": "multi_choice",
    "ans_type": "extractive_text",
    "grade": 5,
    "split": "dev",
    "pid": "11178",
    "path": "data"
  },
  {
    "question": "If Ann buys 1.6 pounds of turkey, how much will she spend?",
    "choices": null,
    "answer": "9.60",
    "unit": "$",
    "table_title": null,
    "table": "beef | $4 per lb\nchicken | $4 per lb\nduck | $7 per lb\nturkey | $6 per lb\npork | $6 per lb",
    "row_num": 5,
    "column_num": 2,
    "solution": "Find the cost of the turkey. Multiply the price per pound by the number of pounds.\n$6 \u00d7 1.6 = $9.60\nShe will spend $9.60.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 6,
    "split": "dev",
    "pid": "20216",
    "path": "data"
  },
  {
    "question": "How much money does Clarence need to buy 5 rolls of electrical tape?",
    "choices": null,
    "answer": "1.65",
    "unit": "$",
    "table_title": null,
    "table": "roll of electrical tape | $0.33\nelastic band | $0.50\npiece of rope | $0.28\nspool of gold wire | $0.98",
    "row_num": 4,
    "column_num": 2,
    "solution": "Find the total cost of 5 rolls of electrical tape by multiplying 5 times the price of a roll of electrical tape.\n\n$0.33 \u00d7 5 = $1.65\n\nClarence needs $1.65.",
    "ques_type": "free_text",
    "ans_type": "decimal_number",
    "grade": 7,
    "split": "dev",
    "pid": "34348",
    "path": "data"
  }
]