# Requirements
- Install the dependencies by:

```bash
conda create -n ehrdiff python=3.8
pip install torch==1.13.1+cu116 --extra-index-url https://download.pytorch.org/whl/cu116
pip install -r requirements.txt
```

# Training

The preprocessed data is located in the `proc_data` directory.

For running experiments on the MIMIC dataset:

```bash
bash mimic.sh
```

For running experiments on the CinC2012 dataset without conditioning:

```bash
bash icu_uncond.sh
```

or with conditioning:

```bash
bash icu_cond.sh
```

The classifier-free conditioning is controlled through `--if_cfg`, and `--cond_scale` modifies the conditioning scale.

For running experiments on the PTB-ECG dataset without conditioning:

```bash
bash ecg_uncond.sh
```

or with conditioning:

```bash
bash ecg_cond.sh
```



The `figs` directory contatins plots of dimension-wise probability and `logs` directory contatins training logs, both of which help to moniter the training process.



# Acknowledgements
Parts of our codes are modified from [lucidrains/denoising-diffusion-pytorch repo](https://github.com/lucidrains/denoising-diffusion-pytorch).