import json

import queue

def create_variable(n: int) -> int:
    return -n
def is_anchor(u):
    return u >= 0
def is_strint(s):
    try:
        int(s)
    except ValueError:
        return False
    else:
        return True
def qry_nestedlist_2_graph(qry_nestedlist) -> list:
    if qry_nestedlist == None:
        return None
    q = queue.Queue()

    n_indices = 0
    edge_list_id = []
    var2ent = {}

    def push(nestedlist, var_id=None):
        if var_id == None:
            nonlocal n_indices
            n_indices += 1
            var_id = create_variable(n_indices)
            var2ent[var_id] = var_id
        q.put((nestedlist, var_id))
        return var_id

    push(qry_nestedlist)

    while not q.empty():

        qry_nestedlist, tail_id = q.get()
        # print('now:', qry_nestedlist, tail_id)
        try:
            operator, *args = qry_nestedlist
        except:
            # print('# Warning: invalid syntax detected in qry_nestedlist_2_graph, return None')
            return None

        if operator == 'e': # ['e', [node]]
            try:
                [[head_ent]] = args
                if not isinstance(head_ent, int) or head_ent < 0:
                    return None
            except:
                # print('# Warning: invalid syntax detected in qry_nestedlist_2_graph, return None')
                return None
            var2ent[tail_id] = head_ent

        elif operator == 'p': # ['p', [rel], [query]]
            try:
                [rel], u_qry_nestedlist = args
                if not isinstance(rel, int) or rel > 0:
                    return None
            except:
                # print('# Warning: invalid syntax detected in qry_nestedlist_2_graph, return None')
                return None
            head_id = push(u_qry_nestedlist)
            edge_list_id.append((head_id, rel, tail_id))

        elif operator == 'i': # ['i', [query1], ..., [query2]]
            try:
                sub_queries = args
                if len(sub_queries) != 2: return None
            except:
                # print('# Warning: invalid syntax detected in recur_parse_str, return None')
                return None
            for sub_qry_nestedlist in sub_queries:
                # push(sub_qry_nestedlist, tail_id)
                head_id = push(sub_qry_nestedlist)
                edge_list_id.append((head_id, 'i', tail_id))

        elif operator == 'u':
            try:
                sub_queries = args
                if len(sub_queries) != 2: return None
            except:
                # print('# Warning: invalid syntax detected in recur_parse_str, return None')
                return None
            for sub_qry_nestedlist in sub_queries:
                head_id = push(sub_qry_nestedlist)
                edge_list_id.append((head_id, 'u', tail_id))

        elif operator == 'n': # ['n', [query]]
            try:
                if len(args) != 1: return None
                [head_qry_nestedlist] = args
            except:
                # print('# Warning: invalid syntax detected in qry_nestedlist_2_graph, return None')
                return None
            head_id = push(head_qry_nestedlist)
            edge_list_id.append((head_id, 'n', tail_id))

        else:
            # print(f'# Warning: Operator "{operator}" not supported')
            return None

    fixed_list = [ent for ent in var2ent.values() if ent >= 0]
    var_list = [ent for ent in var2ent.values() if ent < 0]
    edge_list = []
    for h, r, t in edge_list_id:
        # tran = lambda x : f'v{x}' if x in var_list else var2ent[x]
        hent = var2ent[h]
        tent = var2ent[t]
        if tent in var_list: # fixed -> var or var -> var
            edge_list.append((hent, r, tent))
        else:
            return None

    return {
        'edges': edge_list,
        'fixed': fixed_list,
        'var': var_list
    }

def qry_wordlist_2_nestedlist(qry_list):
    # print(qry_list)
    operator_list = ['p', 'i', 'u', 'n', 'e']
    jsonstr = ""
    for i, elem in enumerate(qry_list):
        if elem in operator_list:
            qry_list[i] = f'"{elem}"'
        elif elem == '(':
            qry_list[i] = '['
        elif elem == ')':
            qry_list[i] = ']'
    for i, elem in enumerate(qry_list):
        jsonstr += elem if type(elem) == str else str(elem)
        if elem == '[' or i == len(qry_list) - 1: continue
        if i+1 <= len(qry_list) - 1 and qry_list[i+1] == ']': continue
        jsonstr += ','
    # print(jsonstr)
    try:
        qry_nested = json.loads(jsonstr)
        # print(qry_nested)
        return qry_nested
    except:
        return None

import torch
def shift_entity_index(x: int) -> int:
    return abs(int(x)) + 1
def shift_relation_index(x: int) -> int:
    return -(abs(int(x)) + 1)
def unshift_entity_index(x: int) -> int:
    return abs(int(x)) - 1
def unshift_relation_index(x: int) -> int:
    return -(abs(int(x)) - 1)
def qry_shift_indices(qry_list: list) -> list:
    now_operator = None
    qry_list = qry_list[:]
    for i, s in enumerate(qry_list):
        if isinstance(s, int):
            # print('before', s)
            if now_operator == 'p': # relation
                qry_list[i] = shift_relation_index(s)
            else:
                qry_list[i] = shift_entity_index(s)
            # print('after', qry_list)
        elif s in ['p', 'e']:
            now_operator = s
    return qry_list
def qry_unshift_indices(qry_list: list) -> list:
    now_operator = None
    qry_list = qry_list[:]
    for i, s in enumerate(qry_list):
        if isinstance(s, int):
            if now_operator == 'p': # relation
                qry_list[i] = unshift_relation_index(s)
            else:
                qry_list[i] = unshift_entity_index(s)
        elif s in ['p', 'e']:
            now_operator = s
    return qry_list
def ans_shift_indices(ans_list: list) -> list:
    # ans_list = ans.split(' ')
    return [shift_entity_index(s) for s in sorted(ans_list)]
def ans_unshift_indices(ans_list: list) -> list:
    # ans_list = ans.split(' ')
    return [unshift_entity_index(s) for s in sorted(ans_list)]


def qry_wordlist_2_graph(input_tokens:list)->dict:
    # (S)
    if input_tokens == None: return None
    token_word = input_tokens[:]

    nested_list = qry_wordlist_2_nestedlist(token_word)
    graph = qry_nestedlist_2_graph(nested_list)

    return graph
def qry_str_2_wordlist(s:str) -> list:
    wordlist = s.split()
    return [int(w) if is_strint(w) else w for w in wordlist]

def qry_wordlist_2_actions_v2(wordlist:list):
    wordlist = [w for w in wordlist if w not in ['(', ')']]
    actions = []
    for i, w in enumerate(wordlist):
        if w in ['i', 'u', 'n']:
            actions.append(w)
        elif w == 'p':
            actions.append(str(wordlist[i+1]))
        elif w == 'e':
            actions.append(str(wordlist[i+1]))
    return actions
def qry_str_2_actionstr(qry:str):
    actionstr = qry.replace('(', '')
    actionstr = actionstr.replace(')', '')
    actionstr = actionstr.replace('p', '')
    actionstr = actionstr.replace('e', '')
    return ' '.join(actionstr.split())



def qry_actionlist_2_wordlist_v2(actions:list, return_stack:bool=False):
    # print('actions')
    # print(actions)
    stack = []
    deg = {
        'i': 2,
        'u': 2,
        'n': 1,
        'p': 1,
        'e': 0
    }
    wordlist = []
    for i, w in enumerate(actions):
        # if (not isinstance(w, tuple)) and (not w in ['i', 'u', 'n']):
        if (not isinstance(w, int)) and (not w in ['i', 'u', 'n']):
            return None
        # operator = w[0] if isinstance(w, tuple) else w
        operator = w
        # print(stack)
        wordlist.append('(')
        if operator in ['i', 'u', 'n']:
            wordlist.append(w)
        # elif operator in ['p', 'e']:
        else:
            operand = w
            if is_anchor(operand): operator = 'e'
            else: operator = 'p'
            # wordlist.extend([w[0], '(', w[1], ')'])
            wordlist.extend([operator, '(', operand, ')'])
        stack.append((operator, deg[operator]))

        if operator == 'e':
            wordlist.append(')')
            stack.pop()
            while stack:
                stack[-1] = (stack[-1][0], stack[-1][1] - 1)
                if stack[-1][1] == 0:
                    wordlist.append(')')
                    stack.pop()
                else:
                    break
    return wordlist if not return_stack else stack
def qry_actionstr_2_actionlist(s:str) -> list:
    actionlist = s.split()
    return [int(a) if is_strint(a) else a for a in actionlist]
def qry_actionstr_2_wordlist(actionstr, return_stack:bool=False):
    return qry_actionlist_2_wordlist_v2(
        actions=qry_actionstr_2_actionlist(actionstr),
        return_stack=return_stack
    )
def qry_tokenizer_2_kg_act(actionstr):
    return qry_unshift_indices(qry_actionstr_2_wordlist(actionstr))
def ans_tokenizer_2_kg(ans):
    return ans_unshift_indices(qry_actionstr_2_actionlist(ans))

def map_idlist_2_idnamelist(kg, idlist):
    idnamelist = []
    now_operator = 'e' # Compatible with both qry ans ans
    for id in idlist:
        if isinstance(id, int):
            # print('before', s)
            if now_operator == 'p': # relation
                idnamelist.append(str(id) + ':' + kg.rel_id2name[-id])
            else:
                idnamelist.append(str(id) + ':' + kg.ent_id2name[id])
            # print('after', qry_list)
        else:
            idnamelist.append(id)
            if id in ['p', 'e']:
                now_operator = id
    return idnamelist

def qry_actionprefix_get_branching(action_prefix: list):
    stack = qry_actionstr_2_wordlist(
        actionstr=action_prefix,
        return_stack=True)
    return 'EMPTY' if not stack else stack[-1]

def qry_actions_2_graph_wordlist(actions:list) -> list:
    if actions == None or None in actions:
        return (None, None)
    deg = {}
    stack = []
    V = []; E = []
    root = -1
    V.append(root)
    stack.append(root)
    last_rel = None
    wordlist = []
    for (operator, operand) in actions:
        top = stack[-1]
        if operator != 'e':
            if not top in deg:
                deg[top] = 2 if operator in ['i', 'u'] else 1
                wordlist.extend(
                    ['(', operator] if operator in ['i', 'u', 'n'] \
                        else ['(', 'p', '(', operator, ')'])
            if type(operator) != int or operand != 'anchor':
                E.append((operand, operator, top))
                V.append(operand)
                stack.append(operand)
            else:
                last_rel = operator
        else:
            if last_rel == None: # invalid representation
                return (None, None)
            wordlist.extend(['(', 'e', '(', operand, ')', ')'])
            E.append((operand, last_rel, top))
            V.append(operand)
            while stack:
                top = stack[-1]
                if (not top in deg) or deg[top] <= 0: # invalid representation
                    return (None, None)
                deg[top] -= 1
                if deg[top] > 0:
                    break
                if deg[top] == 0:
                    stack.pop()
                    wordlist.append(')')
    # print('parsed')
    if stack:
        return (None, None)
    return ({
        'edges': E,
        'fixed': [v for v in V if is_anchor(v)],
        'var': [v for v in V if not is_anchor(v)]
    }, wordlist)
def list_to_str(l: list) -> str:
    return ' '.join([str(x) if isinstance(x, int) else x for x in l])

