%% RDM of embeddings in three conditions
clear;clc;
cd('G:\EEG_AV_speech')
% load('G:\EEG_AV_speech\pca_multi_con_12layer_205.mat','pca_multi_con'); multi_outp = pca_multi_con;
% load('G:\EEG_AV_speech\pca_multi_incon_12layer_205.mat','pca_multi_incon');multi_outp = pca_multi_incon;
% load('G:\EEG_AV_speech\pca_multi_aonly_12layer_205.mat','pca_multi_aonly');multi_outp = pca_multi_aonly;

delay_A = 0.2; % delay of audio caused by the matlab function sound()

fs_d = 25;
clear model_multi
for lay = 1:12
    for j = 1:16
        clear temp len
        temp = multi_outp{j,lay}([(1+ceil((1-delay_A)*fs_d)):(end-fs_d*1)],:); % compensate time delay
        len = length(temp)./2-600;
        if mod(length(temp),2) == 0 
            model_multi{j,lay} = temp([1+len:end-len],:);
        else
            model_multi{j,lay} = temp([round(len):end-round(len)],:); % clip to get segments with identical duration based on the middle point
        end
    end
end 
% RDM multi
for lay = 1:12
    for j = 1:16
        for i = 1:16
            if i ~= j
                temp1 = model_multi{j,lay};
                temp2 = model_multi{i,lay};                  
                eud = sqrt(sum((temp1-temp2).^2,'all'));
                multi_eud_all{lay,1}(j,i) = eud;
            end
        end
    end
end
% multi_eud_con = multi_eud_all; save('G:\EEG_AV_speech\RDM_multi_con_eud_m205_multi_12layer_21subj_2d.mat','multi_eud_con');
% multi_eud_incon = multi_eud_all; save('G:\EEG_AV_speech\RDM_multi_incon_eud_m205_multi_12layer_21subj_2d.mat','multi_eud_incon');
% multi_eud_aonly = multi_eud_all; save('G:\EEG_AV_speech\RDM_multi_aonly_eud_m205_multi_12layer_21subj_2d.mat','multi_eud_aonly');


%% RDM of EEG in three conditions
clear;
cd('G:\EEG_AV_speech');
addpath G:\analysis_code
load(['G:\EEG_AV_speech\data_dsp.mat'],'data_dsp');
for j = 1:48
    data_dsp_2{j,1} = data_dsp{j,1}(:,:,[1:6 8:21]);
end

eeg_data(1:16,1) = data_dsp_2(1:16,1);
eeg_data(1:16,2) = data_dsp_2(17:32,1);
eeg_data(1:16,3) = data_dsp_2(33:48,1);

clearvars -except eeg_data

% RDM for EEG avcon
delay_A = 0.2; % delay of audio caused by the matlab function sound()
fs_d = 25;
nsubs = 20;

for j = 1:16
%     data_0 = eeg_data{j,2}; % av con
%     data_0 = eeg_data{j,3}; % av incon
    data_0 = eeg_data{j,1}; % a-only
    temp = data_0([1+fs_d*1]:[end-ceil((1-delay_A)*fs_d)],:,:);
    
    len = length(temp)./2-600;
    if mod(length(temp),2) == 0 
        EEG_condi{j,1} = temp([1+len:end-len],:,:);
    else
        EEG_condi{j,1} = temp([round(len):end-round(len)],:,:);
    end
end

for subj = 1:nsubs
    for j = 1:16
       for i = 1:16
           if i~=j
               temp1 = EEG_condi{j,1}(:,:,subj);
               temp2 = EEG_condi{i,1}(:,:,subj);
                for d = 1:size(temp1,2) % channel
                    eeg_eud(d) = sqrt(sum((temp1(:,d)-temp2(:,d)).^2));
                end
                xx(j,i,:,subj) = eeg_eud;
           end
       end
   end
end
eeg_multi_eud = xx;
eeg_multi_eud_all = mean(xx,4);
% save('G:\EEG_AV_speech\RDM_EEG_avcon_eud_21subj.mat','eeg_multi_eud_all','eeg_multi_eud');
% save('G:\EEG_AV_speech\RDM_EEG_avincon_eud_21subj.mat','eeg_multi_eud_all','eeg_multi_eud');
% save('G:\EEG_AV_speech\RDM_EEG_aonly_eud_21subj.mat','eeg_multi_eud_all','eeg_multi_eud');


%% RSA
clear;
condi = 2; step = 1;
path_eeg = 'G:\EEG_AV_speech\RDM_eeg\';
path_multi = 'G:\EEG_AV_speech\RDM_multi_2d_205\';
path_RSA = 'G:\EEG_AV_speech\RSA_2d_205\';

switch 1
    case condi == 1 && step == 1 % aonly post
        load([path_eeg 'RDM_EEG_aonly_eud_21subj.mat'],'eeg_multi_eud'); 
        load([path_multi 'RDM_multi_aonly_eud_m205_multi_12layer_21subj_2d.mat']);multi = multi_eud_aonly;
        savename = 'RSA_aonly_2d.tiff';
        savefile = 'RSA_aonly_2d.mat';
        
    case condi == 2 && step == 1 % av-con post
        load([path_eeg 'RDM_EEG_avcon_eud_21subj.mat'],'eeg_multi_eud'); 
        load([path_multi 'RDM_multi_con_eud_m205_multi_12layer_21subj_2d.mat']);multi = multi_eud_con;
        savename = 'RSA_con_2d.tiff';
        savefile = 'RSA_con_2d.mat';
    
    case condi == 3 && step == 1 % av-incon post
        load([path_eeg 'RDM_EEG_avincon_eud_21subj.mat'],'eeg_multi_eud');
        load([path_multi 'RDM_multi_incon_eud_m205_multi_12layer_21subj_2d.mat']);multi = multi_eud_incon;
        savename = 'RSA_incon_2d.tiff';
        savefile = 'RSA_incon_2d.mat';
end

for lay = 1:12
    clear temp2
    temp2 = multi{lay,1};
    for subj = 1:20
        for ch = 1:64
            clear temp1
            temp1 = eeg_multi_eud(:,:,ch,subj);
            xx1 = triu(temp1);
            id = find(xx1~=0);
            eeg = xx1(id);
            xx2 = triu(temp2);
            id = find(xx1~=0);
            model = xx2(id);
            [rho(ch,subj,lay) p(ch,subj,lay)] = corr(eeg,model,'Type','Spearman');
        end
    end
end
addpath  G:\analysis_code
[h, crit_p, adj_ci_cvrg, adj_p] = fdr_bh(p,0.05,'pdep','yes');
id2 = find(h~=1);
rho_2 = rho;
rho_2(id2) = 0;
rho_3 = squeeze(nanmean(rho_2,2)); % delete not-sig 
rho_4 = squeeze(nanmean(rho,2)); % original

figure;
set(gcf,'Position',[50 50 600 500],'color','w');
clim = 0.2;
for lay = 1:12
    subplot(3,4,lay)
    
    topoplot(rho_4(:,lay),'BioSemi64.loc','electrodes','off','maplimits',[-clim clim],...
    'emarker',{'.','k',[],1});
    colormap(jet);
    title(['Layer ' num2str(lay) ': ' num2str(roundn(nanmean(rho_4(:,lay)),-3))],'FontSize',10)
end

% save([path_RSA savefile],'rho','h','p','adj_p');


%% Significant test
clear;
condi = 3; step = 1;
path = 'G:\EEG_AV_speech\RSA_2d_205\';
switch 1
    case condi == 1 && step == 1
        load([path 'RSA_aonly_2d.mat']);
        load([path 'rand_RSA_aonly_2d.mat']);
        savename = 'sig_RSA_aonly_2d';
        
    case condi == 2 && step == 1
        load([path 'RSA_con_2d.mat']);
        load([path 'rand_RSA_con_2d.mat']);
        savename = 'sig_RSA_con_2d';
        
    case condi == 3 && step == 1
        load([path 'RSA_incon_2d.mat']);
        load([path 'rand_RSA_incon_2d.mat']);
        savename = 'sig_RSA_incon_2d';
end

rho_msubj = squeeze(mean(rho,2));

for s = 1:101
   rand_rho_msubj(:,:,s) = squeeze(mean(rand_rho_all{s},2)); 
end

for lay = 1:12
   for ch =1:64
       clear id
       id = find(squeeze(rand_rho_msubj(ch,lay,:))>rho_msubj(ch,lay)); 
       pvalue(ch,lay) = (length(id)+0.1)/(101+0.1);
   end
end
addpath  G:\analysis_code
 [h, crit_p, adj_ci_cvrg, adj_p] = fdr_bh(pvalue,0.05,'pdep','yes');
 
%  save([path savename '.mat'],'rho_msubj','adj_p','h');
 
%% plot topography
clear;clc
clear;
condi = 3; step = 1;

path = 'G:\EEG_AV_speech\RSA_2d_205\';
path_RSA_fig = 'G:\EEG_AV_speech\figure_RSA_2d_205\';
type = '_2d_205';

switch 1
    case condi == 1 && step == 1
        savename = 'sig_RSA_aonly';
        
    case condi == 2 && step == 1
        savename = 'sig_RSA_con';
        
    case condi == 3 && step == 1
        savename = 'sig_RSA_incon';
end

load([path savename type '.mat'],'rho_msubj','h');
figure;
set(gcf,'Position',[50 50 600 500],'color','w');
clim = 0.2;
for lay = 1:12
    subplot(3,4,lay)
    id = h(:,lay);
    id2 = find(id == 1);
    topoplot(rho_msubj(:,lay),'BioSemi64.loc','electrodes','off','maplimits',[-clim clim],...
    'emarker',{'.','k',[],1},'emarker2',{id2,'.','w',7});
    colormap(jet);
    title(['Layer ' num2str(lay) ': ' num2str(roundn(nanmean(rho_msubj(:,lay)),-3))],'FontSize',10)
end
% saveas(gcf,[path_RSA_fig savename '.tiff']);
% close;
