%% RSA for simulated response
clear;clc; 
condi = 3; feat = 4; step = 1;
switch 1
    case condi == 1 && feat == 1 && step == 1
        loadfile = 'RDM_sim_env_aonly';
        savefile = 'RSA_sim_env_aonly';
    case condi == 1 && feat == 2 && step == 1
        loadfile = 'RDM_sim_wonset_aonly';
        savefile = 'RSA_sim_wonset_aonly';
    case condi == 1 && feat == 3 && step == 1
        loadfile = 'RDM_sim_wsurp_aonly';
        savefile = 'RSA_sim_wsurp_aonly';
    case condi == 1 && feat == 4 && step == 1
        loadfile = 'RDM_sim_noise_aonly';
        savefile = 'RSA_sim_noise_aonly';
        
    case condi == 2 && feat == 1 && step == 1
        loadfile = 'RDM_sim_env_con';
        savefile = 'RSA_sim_env_con';
    case condi == 2 && feat == 2 && step == 1
        loadfile = 'RDM_sim_wonset_con';
        savefile = 'RSA_sim_wonset_con';
    case condi == 2 && feat == 3 && step == 1
        loadfile = 'RDM_sim_wsurp_con';
        savefile = 'RSA_sim_wsurp_con';
    case condi == 2 && feat == 4 && step == 1
        loadfile = 'RDM_sim_noise_con';
        savefile = 'RSA_sim_noise_con';
        
    case condi == 3 && feat == 1 && step == 1
        loadfile = 'RDM_sim_env_incon';
        savefile = 'RSA_sim_env_incon';
    case condi == 3 && feat == 2 && step == 1
        loadfile = 'RDM_sim_wonset_incon';
        savefile = 'RSA_sim_wonset_incon';
    case condi == 3 && feat == 3 && step == 1
        loadfile = 'RDM_sim_wsurp_incon';
        savefile = 'RSA_sim_wsurp_incon';
    case condi == 3 && feat == 4 && step == 1
        loadfile = 'RDM_sim_noise_incon';
        savefile = 'RSA_sim_noise_incon';
end

path = 'G:\EEG_AV_speech\RDM_multi_2d_205';
switch 1
    case condi == 1 && step == 1
        load([path 'RDM_multi_aonly_eud_m205_multi_12layer_21subj_2d.mat'],'multi_eud_aonly');multi = multi_eud_aonly;
    
    case condi == 2 && step == 1
        load([path 'RDM_multi_con_eud_m205_multi_12layer_21subj_2d.mat'],'multi_eud_con'); multi = multi_eud_con; 
    
    case condi == 3 && step == 1
        load([path 'RDM_multi_incon_eud_m205_multi_12layer_21subj_2d.mat'],'multi_eud_incon'); multi = multi_eud_incon; 
end

load(['G:\EEG_AV_speech\RDM_sim_noise\' loadfile '_new_onset_noise.mat'])

for lay = 1:12
    clear temp2
    temp2 = multi{lay,1};
    for subj = 1:20
        for ch = 1:64
            clear temp1 xx1 xx2 eeg model
            temp1 = sim_eeg_eud(:,:,ch,subj);
            xx1 = triu(temp1);
            id = find(xx1~=0);
            eeg = xx1(id);
            xx2 = triu(temp2);
            id = find(xx2~=0);
            model = xx2(id);
            [rho_sim(ch,subj,lay) p_sim(ch,subj,lay)] = corr(eeg,model,'Type','Spearman');
        end
    end
end

addpath  G:\analysis_code
 [h, crit_p, adj_ci_cvrg, adj_p] = fdr_bh(p_sim,0.05,'pdep','yes');
 
rho_sim_2 = rho_sim;
id = find(h == 0);
rho_sim_2(id) = 0;
rho_sim_3 = squeeze(nanmean(rho_sim_2,2)); 
rho_sim_4 = squeeze(nanmean(rho_sim,2));

figure;
set(gcf,'Position',[50 50 600 500],'color','w');
clim = 0.3;
for lay = 1:12
    subplot(3,4,lay)

    topoplot(double(rho_sim_4(:,lay)),'BioSemi64.loc','electrodes','off','maplimits',[-clim clim],...
    'emarker',{'.','k',[],1});
    colormap(jet);
    title([' Layer ' num2str(lay) ': ' num2str(roundn(nanmean(rho_sim_4(:,lay)),-3))],'FontSize',10)
end

save(['G:\EEG_AV_speech\RSA_sim_noise_2d_205\' savefile '_new_onset_noise_2d.mat'],'rho_sim','h','p_sim','adj_p')


%% Significance test
clear;clc; 
condi = 2; feat = 4; step = 1;
path = 'G:\EEG_AV_speech\RSA_sim_noise_2d_205\';
switch 1
    case condi == 1 && feat == 1 && step == 1
        loadfile = 'RSA_sim_env_aonly';
        loadrand = 'rand_RSA_sim_env_aonly';
        savename = 'sig_RSA_sim_A_aonly';
    case condi == 1 && feat == 2 && step == 1
        loadfile = 'RSA_sim_wonset_aonly';
        loadrand = 'rand_RSA_sim_wonset_aonly';
        savename = 'sig_RSA_sim_wonset_aonly';
    case condi == 1 && feat == 3 && step == 1
        loadfile = 'RSA_sim_wsurp_aonly';
        loadrand = 'rand_RSA_sim_wsurp_aonly';
        savename = 'sig_RSA_sim_wsurp_aonly';
    case condi == 1 && feat == 4 && step == 1
        loadfile = 'RSA_sim_noise_aonly';
        loadrand = 'rand_RSA_sim_noise_aonly';
        savename = 'sig_RSA_sim_noise_aonly';
        
    case condi == 2 && feat == 1 && step == 1
        loadfile = 'RSA_sim_env_con';
        loadrand = 'rand_RSA_sim_env_con';
        savename = 'sig_RSA_sim_A_con';
    case condi == 2 && feat == 2 && step == 1
        loadfile = 'RSA_sim_wonset_con';
        loadrand = 'rand_RSA_sim_wonset_con';
        savename = 'sig_RSA_sim_wonset_con';
    case condi == 2 && feat == 3 && step == 1
        loadfile = 'RSA_sim_wsurp_con';
        loadrand = 'rand_RSA_sim_wsurp_con';
        savename = 'sig_RSA_sim_wsurp_con';
    case condi == 2 && feat == 4 && step == 1
        loadfile = 'RSA_sim_noise_con';
        loadrand = 'rand_RSA_sim_noise_con';
        savename = 'sig_RSA_sim_noise_con';
        
    case condi == 3 && feat == 1 && step == 1
        loadfile = 'RSA_sim_env_incon';
        loadrand = 'rand_RSA_sim_env_incon';
        savename = 'sig_RSA_sim_A_incon';
    case condi == 3 && feat == 2 && step == 1
        loadfile = 'RSA_sim_wonset_incon';
        loadrand = 'rand_RSA_sim_wonset_incon';
        savename = 'sig_RSA_sim_wonset_incon';
    case condi == 3 && feat == 3 && step == 1
        loadfile = 'RSA_sim_wsurp_incon';
        loadrand = 'rand_RSA_sim_wsurp_incon';
        savename = 'sig_RSA_sim_wsurp_incon';
    case condi == 3 && feat == 4 && step == 1
        loadfile = 'RSA_sim_noise_incon';
        loadrand = 'rand_RSA_sim_noise_incon';
        savename = 'sig_RSA_sim_noise_incon';
end

load([path loadfile '_new_onset_noise_2d.mat'],'rho_sim');
load([path loadrand '_new_onset_noise_2d.mat'],'rand_rho_sim_all');

rho_msubj = squeeze(mean(rho_sim,2));

for s = 1:101
   rand_rho_msubj(:,:,s) = squeeze(mean(rand_rho_sim_all{s},2)); 
end

for lay = 1:12
   for ch =1:64
       clear id
       id = find(squeeze(rand_rho_msubj(ch,lay,:))>rho_msubj(ch,lay)); 
       pvalue(ch,lay) = (length(id)+0.1)/(101+0.1);
%        chance1(ch,lay) = prctile(rand_rho_msubj(ch,lay,:),95); 
% %       chance2(ch,lay) = prctile(rand_rho_msubj(ch,lay,:),0.25); 
   end
end
addpath  G:\analysis_code
 [h, crit_p, adj_ci_cvrg, adj_p] = fdr_bh(pvalue,0.05,'pdep','yes');

save([path savename '.mat'],'rho_msubj','adj_p','h');

%% plot topography
clear;clc; 
condi = 2; feat = 4; step = 1;
path = 'G:\EEG_AV_speech\RSA_sim_noise_2d_205\';
path_RSA_fig = 'G:\EEG_AV_speech\figure_RSA_sim_noise_2d_205\';
switch 1
    case condi == 1 && feat == 1 && step == 1
        savename = 'sig_RSA_sim_A_aonly';
    case condi == 1 && feat == 2 && step == 1
        savename = 'sig_RSA_sim_wonset_aonly';
    case condi == 1 && feat == 3 && step == 1
        savename = 'sig_RSA_sim_wsurp_aonly';
    case condi == 1 && feat == 4 && step == 1
        savename = 'sig_RSA_sim_noise_aonly';
        
    case condi == 2 && feat == 1 && step == 1
        savename = 'sig_RSA_sim_A_con';
    case condi == 2 && feat == 2 && step == 1
        savename = 'sig_RSA_sim_wonset_con';
    case condi == 2 && feat == 3 && step == 1
        savename = 'sig_RSA_sim_wsurp_con';
    case condi == 2 && feat == 4 && step == 1
        savename = 'sig_RSA_sim_noise_con';
        
    case condi == 3 && feat == 1 && step == 1
        savename = 'sig_RSA_sim_A_incon';
    case condi == 3 && feat == 2 && step == 1
        savename = 'sig_RSA_sim_wonset_incon';
    case condi == 3 && feat == 3 && step == 1
        savename = 'sig_RSA_sim_wsurp_incon';
    case condi == 3 && feat == 4 && step == 1
        savename = 'sig_RSA_sim_noise_incon';
end

load([path savename '.mat'],'rho_msubj','h');
figure;
set(gcf,'Position',[50 50 600 500],'color','w');
clim = 0.3;
for lay = 1:12
    subplot(3,4,lay)
    id = h(:,lay);
    id2 = find(id == 1);
    topoplot(rho_msubj(:,lay),'BioSemi64.loc','electrodes','off','maplimits',[-clim clim],...
    'emarker',{'.','k',[],1},'emarker2',{id2,'.','w',7});
    colormap(jet);
    title(['Layer ' num2str(lay) ': ' num2str(roundn(nanmean(rho_msubj(:,lay)),-3))],'FontSize',10)
end
saveas(gcf,[path_RSA_fig savename '.tiff']);
close;
