clear;
cd('G:\EEG_AV_speech');
addpath G:\analysis_code
load(['G:\EEG_AV_speech\data_dsp.mat'],'data_dsp');
for j = 1:48
    data_dsp_2{j,1} = data_dsp{j,1}(:,:,[1:6 8:21]);
end

eeg_data(1:16,1) = data_dsp_2(1:16,1);
eeg_data(1:16,2) = data_dsp_2(17:32,1);
eeg_data(1:16,3) = data_dsp_2(33:48,1);

clearvars -except eeg_data

%% simulated response to A, WO, and W in three conditions
clear;clc;
load('.\TRF_AVinput_21subj_3feat_impulse_new_onset_noise_bc.mat','h');

load(['G:\EEG_AV_speech\data_dsp.mat'],'env_dsp');

load('G:\EEG_AV_speech\stimuli feature\word_surprisal_new.mat','wsurp');
load('G:\EEG_AV_speech\stimuli feature\word_onset_new.mat','wonset');
load('G:\EEG_AV_speech\stimuli feature\noise_envelop_dsp.mat','noise_env_dsp');

clear sim_A_resp sim_WO_resp sim_W_resp sim_AN_resp resp_A_remove resp_W_remove
tic;
D = 25;
for c = 1:3
    for j = 1:16
       for ch = 1:64
           for subj = 1:20
               clear xx1 xx2 xx3 xx4
               xx1 = filter(h{1,c}([5:D],ch,subj),1,zscore(env_dsp{j,1})); % A
               xx2 = filter(h{2,c}([5:D],ch,subj),1,wonset{j,1}); % WO
               xx3 = filter(h{3,c}([5:D],ch,subj),1,wsurp{j,1});  % W
               xx5 = filter(h{4,c}([5:D],ch,subj),1,zscore(noise_env_dsp{j,1}));  % AN
               
               sim_A_resp{j,c}(:,ch,subj) = xx1; 
               sim_WO_resp{j,c}(:,ch,subj) = xx2;
               sim_W_resp{j,c}(:,ch,subj) = xx3;
               sim_AN_resp{j,c}(:,ch,subj) = xx5;
               
           end
       end
    end
end
toc;

save('simulated_response_AV_21subj_3feat_impulse_new_onset_noise.mat','sim_A_resp','sim_W_resp','sim_WO_resp','sim_AN_resp','eeg_data');

%% RDM for simulated response
clear;clc;
cd('G:\EEG_AV_speech');
load('simulated_response_AV_21subj_3feat_impulse_new_onset_noise.mat','sim_A_resp','sim_W_resp','sim_WO_resp','sim_AN_resp');
%%
clearvars -except sim_A_resp sim_W_resp sim_WO_resp sim_AN_resp
condi = 3; feat = 4;
switch 1
    case condi == 1 && feat == 1
    savefile = 'RDM_sim_env_aonly';
    case condi == 1 && feat == 2
    savefile = 'RDM_sim_wonset_aonly';
    case condi == 1 && feat == 3
    savefile = 'RDM_sim_wsurp_aonly';
    case condi == 1 && feat == 4
    savefile = 'RDM_sim_noise_aonly';
    
    case condi == 2 && feat == 1
    savefile = 'RDM_sim_env_con';
    case condi == 2 && feat == 2
    savefile = 'RDM_sim_wonset_con';
    case condi == 2 && feat == 3
    savefile = 'RDM_sim_wsurp_con';
    case condi == 2 && feat == 4
    savefile = 'RDM_sim_noise_con';
    
    case condi == 3 && feat == 1
    savefile = 'RDM_sim_env_incon';
    case condi == 3 && feat == 2
    savefile = 'RDM_sim_wonset_incon';
    case condi == 3 && feat == 3
    savefile = 'RDM_sim_wsurp_incon';
    case condi == 3 && feat == 4
    savefile = 'RDM_sim_noise_incon';
end
        
for j = 1:16
    clear temp
    switch feat
        case 1
            temp = sim_A_resp{j,condi};
        case 2
            temp = sim_WO_resp{j,condi};
        case 3
            temp = sim_W_resp{j,condi};
        case 4
            temp = sim_AN_resp{j,condi};
    end
    % normalized
    for ch = 1:64
        for subj = 1:20
            temp(:,ch,subj) = temp(:,ch,subj)./max(temp(:,ch,subj));
        end
    end
    len = length(temp)./2-600;
    if mod(length(temp),2) == 0 
        resp{j,1} = temp([1+len:end-len],:,:);
    else
        resp{j,1} = temp([round(len):end-round(len)],:,:);
    end
end

clear xx
for subj = 1:20
    for j = 1:16
       for i = 1:16
           if i~=j
               temp1 = resp{j,1}(:,:,subj);
               temp2 = resp{i,1}(:,:,subj);
                for d = 1:size(temp1,2) % channel
                    eeg_eud(d) = sqrt(sum((temp1(:,d)-temp2(:,d)).^2));
                end
                xx(j,i,:,subj) = eeg_eud;
           end
       end
   end
end
sim_eeg_eud_all = mean(xx,4);
sim_eeg_eud = xx;

save(['G:\EEG_AV_speech\RDM_sim_noise\' savefile '_new_onset_noise.mat'],'sim_eeg_eud','sim_eeg_eud_all');
