EXTRA_ARGS=""
MODEL=${MODEL:-google/vit-base-patch16-224}
DATA=${DATA:-cifar10}
SAVE_TO=${SAVE_TO:-hete_final_1}


if [  "$CLASSIFIER_ONLY" == "no"  ]; then
    CLASSIFIER_ONLY=""
elif [  "$CLASSIFIER_ONLY" == "yes"  ]; then
    CLASSIFIER_ONLY="--classifier_only"
fi



BS=${BS:-16}
ETA=${ETA:-1e-3}
MU=${MU:-1e-5}
N=${N:-35}
ALPHA=${ALPHA:-1}
RANDOM_SEED=${RANDOM_SEED:-0}

echo "extra args: $EXTRA_ARGS"
echo "classifier only: $CLASSIFIER_ONLY"
echo "alpha: $ALPHA"

python main_image.py --n_epoch $N --batch_size $BS --num_workers 16 --mu $MU --eta $ETA --alpha -1 --cuda_devices 5 --model_name $MODEL --dataset_name $DATA --save_to $SAVE_TO --comment baseline_iid --k 1 --random_seed $RANDOM_SEED $EXTRA_ARGS $CLASSIFIER_ONLY &
python main_image.py --n_epoch $N --batch_size $BS --num_workers 16 --mu $MU --eta $ETA --alpha -1 --cuda_devices 5 --model_name $MODEL --dataset_name $DATA --save_to $SAVE_TO --comment proposed_iid --k 1 --random_seed $RANDOM_SEED $EXTRA_ARGS $CLASSIFIER_ONLY --binary --onebit &
python main_image.py --n_epoch $N --batch_size $BS --num_workers 16 --mu $MU --eta $ETA --alpha $ALPHA --cuda_devices 4 --model_name $MODEL --dataset_name $DATA --save_to $SAVE_TO --comment baseline_noniid --k 1 --random_seed $RANDOM_SEED $EXTRA_ARGS $CLASSIFIER_ONLY &
python main_image.py --n_epoch $N --batch_size $BS --num_workers 16 --mu $MU --eta $ETA --alpha $ALPHA --cuda_devices 4 --model_name $MODEL --dataset_name $DATA --save_to $SAVE_TO --comment proposed_noniid --k 1 --random_seed $RANDOM_SEED $EXTRA_ARGS $CLASSIFIER_ONLY --binary --onebit &
python main_image.py --n_epoch $N --batch_size $BS --num_workers 16 --mu $MU --eta $ETA --alpha -1 --cuda_devices 3 --model_name $MODEL --dataset_name $DATA --save_to $SAVE_TO --comment baseline_iid_byzantine --k 1 --random_seed $RANDOM_SEED $EXTRA_ARGS $CLASSIFIER_ONLY --byzantine 1 &
python main_image.py --n_epoch $N --batch_size $BS --num_workers 16 --mu $MU --eta $ETA --alpha -1 --cuda_devices 3 --model_name $MODEL --dataset_name $DATA --save_to $SAVE_TO --comment proposed_iid_byzantine --k 1 --random_seed $RANDOM_SEED $EXTRA_ARGS $CLASSIFIER_ONLY --binary --onebit --byzantine 1 