# Prediction Error-based Classification for Class-Incremental Learning

Code is based on the following public repository: https://github.com/aimagelab/mammoth

## Installation
Install the required packages with:
`pip install -r requirements.txt`

## Running
Below are commands to run PEC experiments corresponding to main tables (1 & 2), for different datasets:

```
python utils/main.py --model=pec --n_epochs=1 --classes_per_task=1 --optim_kind=adam --optim_scheduler=linear \
    --ignore_other_metrics=1 --eval_every_n_task=1000 --force_no_augmentations=true --batch_size=1 \
    --dataset=seq-mnist --lr=0.01 --pec_architecture=mlp --pec_activation=gelu --pec_width=10 \
    --pec_teacher_width_multiplier=500 --pec_output_dim=99
```

```
python utils/main.py --model=pec --n_epochs=1 --classes_per_task=1 --optim_kind=adam --optim_scheduler=linear \
    --ignore_other_metrics=1 --eval_every_n_task=1000 --force_no_augmentations=true --batch_size=1 \
    --dataset=seq-svhn --balance_truncate_data=true --lr=0.0001 --pec_architecture=cnn --pec_conv_layers="(60, 3, 1)" \
    --pec_conv_reduce_spatial_to=5 --pec_teacher_width_multiplier=100 --pec_output_dim=743
```

```
python utils/main.py --model=pec --n_epochs=1 --classes_per_task=1 --optim_kind=adam --optim_scheduler=linear \
    --ignore_other_metrics=1 --eval_every_n_task=1000 --force_no_augmentations=true --batch_size=1 \
    --dataset=seq-cifar10 --lr=0.0003 --pec_architecture=cnn --pec_conv_layers="(60, 3, 1)" \
    --pec_conv_reduce_spatial_to=5 --pec_teacher_width_multiplier=100 --pec_output_dim=743
```

```
python utils/main.py --model=pec --n_epochs=1 --classes_per_task=1 --optim_kind=adam --optim_scheduler=linear \
    --ignore_other_metrics=1 --eval_every_n_task=1000 --force_no_augmentations=true --batch_size=1 \
    --dataset=seq-cifar100 --lr=0.001 --pec_architecture=cnn --pec_conv_layers="(40, 3, 1)" \
    --pec_conv_reduce_spatial_to=4 --pec_teacher_width_multiplier=100 --pec_output_dim=172
```

```
python utils/main.py --model=pec --n_epochs=1 --classes_per_task=1 --optim_kind=adam --optim_scheduler=linear \
    --ignore_other_metrics=1 --eval_every_n_task=1000 --force_no_augmentations=true --batch_size=1 \
    --dataset=seq-miniimg --lr=0.001 --pec_architecture=cnn --pec_conv_layers="(40, 3, 1)" \
    --pec_conv_reduce_spatial_to=4 --pec_teacher_width_multiplier=100 --pec_output_dim=172
```
