#!/bin/bash

#cd ../..

# custom config
DATA=data_path
TRAINER=PBPrompt

CFG=vit_b16

SAMPLE_NUMBER=10

for DATASET in ucf101
do
  for SEED in  1 2 4 3 5
  do
    SHOTS=16
    DIR=output/base2new/${CFG}/${TRAINER}/${DATASET}/shots_${SHOTS}/sample_${SAMPLE_NUMBER}/seed${SEED}
    python train_fsl.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    DATASET.NUM_SHOTS ${SHOTS} \
    DATASET.SUBSAMPLE_CLASSES base \
    TRAINER.PBPROMPT.TEXT_PROMPT_NUMBER ${SAMPLE_NUMBER}

  done
done