#!/bin/bash

#cd ../..

# custom config
DATA=data_path
TRAINER=PBPrompt
DATASET=$1

for SHOTS in 1 2 4 8 16
do
    for CFG in vit_b16
    do
        for SEED in 1 2 3
	        do
                DIR=output/fewshot/${CFG}/${DATASET}/${TRAINER}/shots_${SHOTS}/seed${SEED}
                python train.py \
                --root ${DATA} \
                --seed ${SEED} \
                --trainer ${TRAINER} \
                --dataset-config-file configs/datasets/${DATASET}.yaml \
                --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
                --output-dir ${DIR} \
                DATASET.NUM_SHOTS ${SHOTS} 
	        done
    done
done

