from seed_emulator import make_transit_as, makeStubAsWithHosts, make_service_as, PoAServer, WebService

transit_as = make_transit_as()
transit_as.create_internet_exchange("IX1")
transit_as.create_internet_exchange("IX2")
transit_as.create_internal_network("InternalNet1")
transit_as.create_internal_network("InternalNet2")
transit_as.create_internal_network("InternalNet3")
transit_as.create_router("Router1")
transit_as.create_router("Router2")
transit_as.create_router("Router3")
transit_as.create_router("Router4")
transit_as.link_routers_linearly(["Router1", "Router2", "Router3", "Router4"])

stub_as1 = makeStubAsWithHosts()
stub_as2 = makeStubAsWithHosts()
stub_as3 = make_service_as()
stub_as1.create_internal_network("InternalNet1")
stub_as1.create_router("Router1")
stub_as1.create_host_node("HostNode1")
stub_as1.create_host_node("HostNode2")
stub_as1.install_software("HostNode1", "Software1")
stub_as1.create_account("HostNode1", "NewAccount")
stub_as2.create_internal_network("InternalNet2")
stub_as2.create_router("Router2")
stub_as2.create_host_node("HostNode3")
stub_as2.create_host_node("HostNode4")
stub_as3.customize()

transit_as.set_isp_for_stubs([stub_as1, stub_as2, stub_as3])
stub_as1.create_direct_peering(stub_as2)

web_service_layer = make_service_as()
web_service_layer.create_web_service_node("WebServiceNode1")
web_service_layer.create_web_service_node("WebServiceNode2")
web_service_layer.bind_virtual_nodes_to_physical()

emulator = makeEmulatorBaseWith10StubASAndHosts()
emulator.add_layer(transit_as)
emulator.add_layer(stub_as1)
emulator.add_layer(stub_as2)
emulator.add_layer(stub_as3)
emulator.add_layer(web_service_layer)
emulator.save_to_component_file()
emulator.render()
emulator.change_display_names_for_web_service_nodes()

emulator.compile_with_docker(custom_images=["image1", "image2"], local_sources=True)
emulator.generate_docker_files()
emulator.copy_base_container_image_to_output_folder()