 Here is a basic example of how you might create a PyQtGraph application with the specified requirements. Please note that this is a simplified version and you may need to adjust it according to your specific needs.

```python
import sys
from pyqtgraph.Qt import QtCore, QtGui
from pyqtgraph.graphicsItems import ScatterPlotItem, GLScatterPlotItem
from pyqtgraph.QtWidgets import QApplication, QMainWindow, QVBoxLayout, QWidget

class ScatterPlotApp(QMainWindow):
    def __init__(self):
        super().__init__()

        self.main_widget = QWidget(self)
        self.layout = QVBoxLayout(self.main_widget)

        self.multi_plot = MultiPlotWidget(self.main_widget, nCols=2, nRows=2)

        self.layout.addWidget(self.multi_plot)
        self.setCentralWidget(self.main_widget)

        self.setup_plots()

        self.show()

    def setup_plots(self):
        for i in range(4):
            plot = self.multi_plot.plot(i+1, row=i//2, col=i%2)
            plot.setTitle(f"Plot {i+1}")

            data = self.generate_data(i+1)
            plot.setData(data[0], data[1])

            plot.sigClicked.connect(self.handle_click)

    def generate_data(self, plot_id):
        x = [i for i in range(100)]
        y = []

        if plot_id == 1:
            for _ in range(100):
                y.append(0)
        elif plot_id == 2:
            for _ in range(100):
                y.append(i**2 for i in x)
        elif plot_id == 3:
            for _ in range(100):
                x_offset = (i / 10) % 2 - 0.5
                y_offset = (i / 10) % 3 - 1.5
                y.append(x[i] + x_offset**2 + y_offset**2)
        elif plot_id == 4:
            x = list(range(10000))
            y = [i**2 for i in x]

        return x, y

    def handle_click(self, x, y):
        item = self.multi_plot.getPlot(x, y)
        if isinstance(item, ScatterPlotItem):
            item.setMarkerSize(10)
        elif isinstance(item, GLScatterPlotItem):
            item.setSize(10)

if __name__ == "__main__":
    app = QApplication(sys.argv)
    window = ScatterPlotApp()
    sys.exit(app.exec_())
```

This code creates a main window with a MultiPlotWidget, which is a layout that can hold multiple PlotWidgets. Four plots are created and filled with data generated by the `generate_data` function. Each plot is clickable, and clicking on a point will highlight it. The fourth plot demonstrates the performance of large scatterplots.