#!/bin/bash
export CUBLAS_WORKSPACE_CONFIG=":16:8" # https://docs.nvidia.com/cuda/cublas/index.html#cublasApi_reproducibility
export PYTHONHASHSEED=0
export base_dir="/system/user/publicwork/hauzenbe/eva_cache"


model_card='gpt2.md'
task_name='e2e_nlg'
# array params
seeds=(0 10 101) # 0 10 101
lora_dims=(16 8 4 2) # 16 8 4 2
learning_rates=(6e-2 6e-3 6e-4) # 6e-2 6e-3 6e-4
exp_names=('rand_init') # 'rand_init' 'pca_init' 'pca_init_adaptive'

target_file='beam_prediction.jsonl'


for seed in ${seeds[@]}
do
  for lora_dim in ${lora_dims[@]}
  do
    for lr in ${learning_rates[@]}
    do
      for experiment_name in ${exp_names[@]}
      do
        dir="r_${lora_dim}_lr_${lr}"
        work_dir=$base_dir/$model_card/$task_name/$experiment_name/$dir/$seed
        file_path="$work_dir/$target_file"

        if [ -f "$file_path" ]; then 
            last_modified=$(stat -c %Y "$file_path")  
            last_modified_date=$(date +"%Y-%m-%d %H:%M:%S" -d @$last_modified) 

            echo "Directory: $work_dir"
            echo "File: $target_file"
            echo "Last Modified: $last_modified_date"
            echo "---------------------"  
        else
            echo "File '$target_file' not found in directory '$dir'"
        fi
      done
    done
  done
done