#!/bin/bash
#SBATCH -A euhpc_d09_020
#SBATCH --job-name=gpt2_grid
#SBATCH --time=24:00:00
#SBATCH -N 1
#SBATCH --partition=boost_usr_prod
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=8
#SBATCH --output=/leonardo/home/userexternal/lhauzenb/git_repos/eva/slurm_outputs/%j.out

n_gpu=1
proc_per_gpu=3

nvidia-smi
unset CUDA_VISIBLE_DEVICES
cd /leonardo/home/userexternal/lhauzenb/git_repos/eva/examples/NLG
source /leonardo/home/userexternal/lhauzenb/venv/eva/bin/activate
which python

DEFAULT_SCRIPT="run_grid.sh"
SCRIPT_PATH=${1:-$DEFAULT_SCRIPT}
if [ ! -x "$SCRIPT_PATH" ]; then
    echo "Script at '$SCRIPT_PATH' is not executable or does not exist."
    exit 1
fi

echo "Executing script at: $SCRIPT_PATH"
$SCRIPT_PATH $n_gpu $proc_per_gpu
