#!/bin/bash
#SBATCH --account=DD-23-72
#SBATCH --partition=qgpu
##SBATCH --cpus-per-task=8
#SBATCH --nodes=1
#SBATCH --gpus=4
#SBATCH --time=2-00:00:00
#SBATCH --output=/home/it4i-schmied/eva/slurm_outputs/%j.out

nvidia-smi
unset CUDA_VISIBLE_DEVICES
cd /home/it4i-schmied/eva/examples/NLU
source /scratch/project/dd-23-72/miniconda3/etc/profile.d/conda.sh
source activate eva
which conda
which python

DEFAULT_SCRIPT="./roberta_base_cola.sh"
SCRIPT_PATH=${1:-$DEFAULT_SCRIPT}
if [ ! -x "$SCRIPT_PATH" ]; then
    echo "Script at '$SCRIPT_PATH' is not executable or does not exist."
    exit 1
fi

echo "Executing script at: $SCRIPT_PATH"
$SCRIPT_PATH
