import json

with open('gpt4score/gpt4_score_new.json', 'r', encoding='gb18030') as f:
    data = json.load(f)

annotations = data['annotations']

# Create a new list to store the extracted data
new_annotations = []

# Iterate through each annotation and extract the gpt_score
for annotation in annotations:
    gpt_score_str = annotation['gpt_score'][:2]
    try:
        # Try to convert the integer part to an integer
        gpt_score = int(gpt_score_str)
    except ValueError:
        # Handle the case where conversion fails and set gpt_score to 60
        gpt_score = 60
    if gpt_score == 10:
        gpt_score = 100
    #gpt_score_str = annotation['gpt_score'].split('\n')[0].strip()
    #gpt_score = int(gpt_score_str.split('.')[0])
    new_annotation = {
        "image_id": annotation["image_id"],
        "caption": annotation["caption"],
        "gpt_score": gpt_score,
    }
    new_annotations.append(new_annotation)

# Create a new dictionary with the annotations list
new_data = {'annotations': new_annotations}

# Save the new data as JSON in a new file
with open('gpt4score/gpt_final_score.json', 'w', encoding='utf-8') as f:
    json.dump(new_data, f, indent=4, ensure_ascii=False)