import os
import json
import shutil

with open('/path/to/test_dataset/random200_2/cc_sbu_align/filter_cap.json', 'r', encoding='utf-8') as f:
    data = json.load(f)

annotations = data['annotations']

image_ids = [annotation['image_id'] for annotation in annotations]

image_folder = 'image'  
target_folder = '/path/to/test_dataset/random200_2/cc_sbu_align/image'  
shutil.rmtree(target_folder, ignore_errors=True)
os.makedirs(target_folder, exist_ok=True)

for image_id in image_ids:
    image_filename = f'{image_id}.jpg'
    source_path = os.path.join(image_folder, image_filename)
    target_path = os.path.join(target_folder, image_filename)
    shutil.copyfile(source_path, target_path)

print('Selected images have been copied to the target folder.')
