# -*- coding: gb18030 -*-
import random
import json
import os
with open('filter_cap.json', 'r', encoding='gb18030') as f:
    data_origin = json.load(f)

origin_annotations = data_origin['annotations']

selected_annotations = random.sample(origin_annotations, 200)
final = sorted(selected_annotations, key=lambda x: int(x['image_id']))
new_data = {'annotations': final}
os.makedirs('/path/to/test_dataset/random200/cc_sbu_align/', exist_ok=True)
with open('/path/to/test_dataset/random200/cc_sbu_align/filter_cap.json', 'w', encoding='utf-8') as f:
    json.dump(new_data, f, indent=4, ensure_ascii=False)