from dataclasses import dataclass

from offline import base


@dataclass(frozen=True)
class Arguments(base.Arguments):
    batch_size: int
    hidden_features: int
    layer_norm: bool
    learning_rate: float
    num_layers: int


def build_argument_parser(**kwargs):
    parser = base.build_argument_parser(**kwargs)
    parser.add_argument("--batch-size", type=int, default=256)
    parser.add_argument("--hidden-features", type=int, default=256)
    parser.add_argument("--learning-rate", type=float, default=3e-4)
    parser.add_argument(
        "--no-layer-norm", action="store_false", dest="layer_norm"
    )
    parser.add_argument("--num-layers", type=int, default=4)
    return parser
