from dataclasses import dataclass

from offline import base
from offline.utils.parser import ArgumentParser


@dataclass(frozen=True)
class Arguments(base.Arguments):
    batch_size: int
    bc_steps: int
    clip_epsilon: float
    entropy_weight: float
    gamma: float
    hidden_features: int
    layer_norm: bool
    learning_rate: float
    max_gradient_norm: float
    num_layers: int
    omega: float
    sarsa_steps: int
    stochastic_update: bool
    tau: float
    update_every: int
    v_learning_steps: int


def build_argument_parser(parser: ArgumentParser | None = None, **kwargs):
    if parser is None:
        parser = base.build_argument_parser(**kwargs)

    parser.add_argument("--batch-size", type=int, default=256)
    parser.add_argument("--bc-steps", type=int, default=500000)
    parser.add_argument("--clip-epsilon", type=float, default=0.25)
    parser.add_argument("--entropy-weight", type=float, default=0)
    parser.add_argument("--gamma", type=float, default=0.99)
    parser.add_argument("--hidden-features", type=int, default=256)
    parser.add_argument("--learning-rate", type=float, default=3e-4)
    parser.add_argument("--max-gradient-norm", type=float, default=0.5)
    parser.add_argument(
        "--no-layer-norm", action="store_false", dest="layer_norm"
    )
    parser.add_argument("--num-layers", type=int, default=4)
    parser.add_argument("--omega", type=float, default=0.5)
    parser.add_argument("--sarsa-steps", type=int, default=500000)
    parser.add_argument("--stochastic-update", action="store_true")
    parser.add_argument("--tau", type=float, default=0.005)
    parser.add_argument("--update-every", type=int, default=2)
    parser.add_argument("--v-learning-steps", type=int, default=500000)
    parser.set_defaults(eval_freq=1, total_steps=100, unsquash=True)
    return parser
