from dataclasses import dataclass

from offline.bppo.tc import arguments as bppo_tc
from offline.utils.parser import ArgumentParser


@dataclass(frozen=True)
class Arguments(bppo_tc.Arguments):
    expectile: float


def build_argument_parser(parser: ArgumentParser | None = None, **kwargs):
    if parser is None:
        parser = bppo_tc.build_argument_parser(**kwargs)

    parser.add_argument("--expectile", type=float, default=0.7)
    return parser
