from typing import NamedTuple

from offline.types import BoolArray, FloatArray, IntArray


class BCBatch(NamedTuple):
    actions: FloatArray
    assignments: IntArray
    observations: FloatArray


class BPPOTCBatch(NamedTuple):
    assignments: IntArray
    means: FloatArray
    observations: FloatArray
    stds: FloatArray
    values: FloatArray


class HLQLearningBatch(NamedTuple):
    assignments: IntArray
    dones: BoolArray
    next_mask: BoolArray
    next_observations: FloatArray
    observations: FloatArray
    rewards: FloatArray


class SarsaBatch(NamedTuple):
    actions: FloatArray
    assignments: IntArray
    dones: BoolArray
    next_actions: FloatArray
    next_observations: FloatArray
    observations: FloatArray
    rewards: FloatArray
