from dataclasses import dataclass

from offline.diffusion import arguments as diffusion
from offline.utils.parser import ArgumentParser


@dataclass(frozen=True)
class Arguments(diffusion.Arguments):
    jump_length: int
    jump_samples: int


def build_argument_parser(parser: ArgumentParser | None = None, **kwargs):
    if parser is None:
        parser = diffusion.build_argument_parser(**kwargs)

    parser.add_argument("--jump-length", type=int, default=1)
    parser.add_argument("--jump-samples", type=int, default=1)
    return parser
