from dataclasses import dataclass

from offline.diffusion.ddim import arguments as ddim
from offline.diffusion.repaint import arguments as repaint
from offline.utils.parser import ArgumentParser


@dataclass(frozen=True)
class Arguments(ddim.Arguments, repaint.Arguments):
    pass


def build_argument_parser(parser: ArgumentParser | None = None, **kwargs):
    if parser is None:
        parser = ddim.build_argument_parser(**kwargs)
        parser = repaint.build_argument_parser(parser=parser, **kwargs)

    parser.set_defaults(
        diffusion_steps=200, inference_steps=50, jump_length=2, jump_samples=2
    )
    return parser
