import gymnasium_robotics  # register v2 environments


from offline.envs.d4rl.infos import (
    REF_MAX_SCORE_GYM_MUJOCO,
    REF_MIN_SCORE_GYM_MUJOCO,
)
from offline.envs.d4rl.utils import register_d4rl_dataset


del gymnasium_robotics


AGENTS = ["Hopper", "HalfCheetah", "Ant", "Walker2d"]
DATASETS = [
    "random",
    "medium",
    "expert",
    "medium-expert",
    "medium-replay",
    "full-replay",
]


def register_gym_mujoco_datasets():
    for agent in AGENTS:
        env_id = f"{agent}-v2"
        for dataset in DATASETS:
            register_d4rl_dataset(
                dataset_name=f"{agent.lower()}-{dataset}-v2",
                env_id=env_id,
                ref_max_score=REF_MAX_SCORE_GYM_MUJOCO[env_id],
                ref_min_score=REF_MIN_SCORE_GYM_MUJOCO[env_id],
            )
