from offline.envs.d4rl.infos import REF_MAX_SCORE, REF_MIN_SCORE
from offline.envs.d4rl.utils import register_d4rl_env_and_dataset

MAX_STEPS = {"hammer": 200, "relocate": 200, "door": 200, "pen": 100}
LONG_HORIZONS = {"hammer": 600, "pen": 200, "relocate": 500, "door": 300}


def register_hand_manipulation_suite_datasets():
    for version in ("v0", "v1"):
        for agent in ("hammer", "pen", "relocate", "door"):
            for dataset in ("human", "expert", "cloned"):
                env_name = f"{agent}-{dataset}-{version}"
                register_d4rl_env_and_dataset(
                    dataset_name=env_name, max_episode_steps=MAX_STEPS[agent]
                )
                if dataset == "human":
                    longhorizon_env_name = (
                        f"{agent}-human-longhorizon-{version}"
                    )
                    register_d4rl_env_and_dataset(
                        dataset_name=longhorizon_env_name,
                        max_episode_steps=LONG_HORIZONS[agent],
                        ref_max_score=REF_MAX_SCORE[env_name],
                        ref_min_score=REF_MIN_SCORE[env_name],
                    )
