"""This file holds all URLs and reference scores."""

from pathlib import Path

import tomlkit


def add_adroit_v1_envs_info(dataset_urls: dict[str, str]):
    for env in ["hammer", "pen", "relocate", "door"]:
        for dset in ["human", "expert", "cloned"]:
            env_name = env + "-" + dset + "-v1"
            dataset_urls[env_name] = (
                "http://rail.eecs.berkeley.edu/datasets/offline_rl/"
                f"hand_dapg_v1/{env_name}.hdf5"
            )


def add_gym_mujoco_envs_info(dataset_urls: dict[str, str]):
    datasets = [
        "random",
        "medium",
        "expert",
        "medium-replay",
        "full-replay",
        "medium-expert",
    ]
    for env in ["halfcheetah", "hopper", "walker2d", "ant"]:
        for dset in datasets:
            dset_name = env + "_" + dset.replace("-", "_") + "-v2"
            env_name = dset_name.replace("_", "-")
            dataset_urls[env_name] = (
                "http://rail.eecs.berkeley.edu/datasets/offline_rl/"
                f"gym_mujoco_v2/{dset_name}.hdf5"
            )


def load_dataset_urls() -> dict[str, str]:
    path = Path(__file__).parent / "urls.toml"
    dataset_urls: dict[str, str]
    with open(path, "r", encoding="utf-8") as file:
        dataset_urls = dict(tomlkit.load(file))  # type: ignore
    add_adroit_v1_envs_info(dataset_urls)
    add_gym_mujoco_envs_info(dataset_urls)
    return dataset_urls


DATASET_URLS = load_dataset_urls()

REF_MIN_SCORE = {
    "bullet-ant-expert-v0": 373.705955,
    "bullet-ant-medium-expert-v0": 373.705955,
    "bullet-ant-medium-replay-v0": 373.705955,
    "bullet-ant-medium-v0": 373.705955,
    "bullet-ant-random-v0": 373.705955,
    "bullet-halfcheetah-expert-v0": -1275.766996,
    "bullet-halfcheetah-medium-expert-v0": -1275.766996,
    "bullet-halfcheetah-medium-replay-v0": -1275.766996,
    "bullet-halfcheetah-medium-v0": -1275.766996,
    "bullet-halfcheetah-random-v0": -1275.766996,
    "bullet-hopper-expert-v0": 20.058972,
    "bullet-hopper-medium-expert-v0": 20.058972,
    "bullet-hopper-medium-replay-v0": 20.058972,
    "bullet-hopper-medium-v0": 20.058972,
    "bullet-hopper-random-v0": 20.058972,
    "bullet-maze2d-large-v0": 1.820000,
    "bullet-maze2d-medium-v0": 14.870000,
    "bullet-maze2d-open-v0": 8.750000,
    "bullet-maze2d-umaze-v0": 32.460000,
    "bullet-walker2d-expert-v0": 16.523877,
    "bullet-walker2d-medium-expert-v0": 16.523877,
    "bullet-walker2d-medium-replay-v0": 16.523877,
    "bullet-walker2d-medium-v0": 16.523877,
    "bullet-walker2d-random-v0": 16.523877,
    "carla-lane-v0": -0.8503839912088142,
    "carla-town-v0": -114.81579500772153,  # random score
    "door-cloned-v0": -56.512833,
    "door-cloned-v1": -56.512833,
    "door-expert-v0": -56.512833,
    "door-expert-v1": -56.512833,
    "door-human-v0": -56.512833,
    "door-human-v1": -56.512833,
    "flow-merge-controller-v0": 118.67993,
    "flow-merge-random-v0": 118.67993,
    "flow-ring-controller-v0": -165.22,
    "flow-ring-random-v0": -165.22,
    "hammer-cloned-v0": -274.856578,
    "hammer-cloned-v1": -274.856578,
    "hammer-expert-v0": -274.856578,
    "hammer-expert-v1": -274.856578,
    "hammer-human-v0": -274.856578,
    "hammer-human-v1": -274.856578,
    "kitchen-complete-v0": 0.0,
    "kitchen-mixed-v0": 0.0,
    "kitchen-partial-v0": 0.0,
    "maze2d-large-dense-v1": 30.569041,
    "maze2d-large-v1": 6.7,
    "maze2d-medium-dense-v1": 44.264742,
    "maze2d-medium-v1": 13.13,
    "maze2d-open-dense-v0": 11.17817,
    "maze2d-open-v0": 0.01,
    "maze2d-umaze-dense-v1": 68.537689,
    "maze2d-umaze-v1": 23.85,
    "minigrid-fourrooms-random-v0": 0.01442,
    "minigrid-fourrooms-v0": 0.01442,
    "pen-cloned-v0": 96.262799,
    "pen-cloned-v1": 96.262799,
    "pen-expert-v0": 96.262799,
    "pen-expert-v1": 96.262799,
    "pen-human-v0": 96.262799,
    "pen-human-v1": 96.262799,
    "relocate-cloned-v0": -6.425911,
    "relocate-cloned-v1": -6.425911,
    "relocate-expert-v0": -6.425911,
    "relocate-expert-v1": -6.425911,
    "relocate-human-v0": -6.425911,
    "relocate-human-v1": -6.425911,
}

REF_MIN_SCORE_GYM_MUJOCO = {
    "Ant-v2": -325.6,
    "HalfCheetah-v2": -280.178953,
    "Hopper-v2": -20.272305,
    "Walker2d-v2": 1.629008,
}

REF_MAX_SCORE = {
    "bullet-ant-expert-v0": 2650.495,
    "bullet-ant-medium-expert-v0": 2650.495,
    "bullet-ant-medium-replay-v0": 2650.495,
    "bullet-ant-medium-v0": 2650.495,
    "bullet-ant-random-v0": 2650.495,
    "bullet-halfcheetah-expert-v0": 2381.6725,
    "bullet-halfcheetah-medium-expert-v0": 2381.6725,
    "bullet-halfcheetah-medium-replay-v0": 2381.6725,
    "bullet-halfcheetah-medium-v0": 2381.6725,
    "bullet-halfcheetah-random-v0": 2381.6725,
    "bullet-hopper-expert-v0": 1441.8059623430963,
    "bullet-hopper-medium-expert-v0": 1441.8059623430963,
    "bullet-hopper-medium-replay-v0": 1441.8059623430963,
    "bullet-hopper-medium-v0": 1441.8059623430963,
    "bullet-hopper-random-v0": 1441.8059623430963,
    "bullet-maze2d-large-v0": 285.92,
    "bullet-maze2d-medium-v0": 238.05,
    "bullet-maze2d-open-v0": 64.15,
    "bullet-maze2d-umaze-v0": 153.99,
    "bullet-walker2d-expert-v0": 1623.6476303317536,
    "bullet-walker2d-medium-expert-v0": 1623.6476303317536,
    "bullet-walker2d-medium-replay-v0": 1623.6476303317536,
    "bullet-walker2d-medium-v0": 1623.6476303317536,
    "bullet-walker2d-random-v0": 1623.6476303317536,
    "carla-lane-v0": 1023.5784385429523,
    "carla-town-v0": 2440.1772022247314,  # avg dataset score
    "door-cloned-v0": 2880.5693087298737,
    "door-cloned-v1": 2880.5693087298737,
    "door-expert-v0": 2880.5693087298737,
    "door-expert-v1": 2880.5693087298737,
    "door-human-v0": 2880.5693087298737,
    "door-human-v1": 2880.5693087298737,
    "flow-merge-controller-v0": 330.03179,
    "flow-merge-random-v0": 330.03179,
    "flow-ring-controller-v0": 24.42,
    "flow-ring-random-v0": 24.42,
    "hammer-cloned-v0": 12794.134825156867,
    "hammer-cloned-v1": 12794.134825156867,
    "hammer-expert-v0": 12794.134825156867,
    "hammer-expert-v1": 12794.134825156867,
    "hammer-human-v0": 12794.134825156867,
    "hammer-human-v1": 12794.134825156867,
    "kitchen-complete-v0": 4.0,
    "kitchen-mixed-v0": 4.0,
    "kitchen-partial-v0": 4.0,
    "maze2d-large-dense-v1": 303.4857382709002,
    "maze2d-large-v1": 273.99,
    "maze2d-medium-dense-v1": 297.4552547777125,
    "maze2d-medium-v1": 277.39,
    "maze2d-open-dense-v0": 27.166538620695782,
    "maze2d-open-v0": 20.66,
    "maze2d-umaze-dense-v1": 193.66285642381482,
    "maze2d-umaze-v1": 161.86,
    "minigrid-fourrooms-random-v0": 2.89685,
    "minigrid-fourrooms-v0": 2.89685,
    "pen-cloned-v0": 3076.8331017826877,
    "pen-cloned-v1": 3076.8331017826877,
    "pen-expert-v0": 3076.8331017826877,
    "pen-expert-v1": 3076.8331017826877,
    "pen-human-v0": 3076.8331017826877,
    "pen-human-v1": 3076.8331017826877,
    "relocate-cloned-v0": 4233.877797728884,
    "relocate-cloned-v1": 4233.877797728884,
    "relocate-expert-v0": 4233.877797728884,
    "relocate-expert-v1": 4233.877797728884,
    "relocate-human-v0": 4233.877797728884,
    "relocate-human-v1": 4233.877797728884,
}

REF_MAX_SCORE_GYM_MUJOCO = {
    "Ant-v2": 3879.7,
    "HalfCheetah-v2": 12135.0,
    "Hopper-v2": 3234.3,
    "Walker2d-v2": 4592.3,
}
