from offline.envs.d4rl.utils import register_d4rl_env_and_dataset


def register_kitchen_datasets():
    # Smaller dataset with only positive demonstrations.
    register_d4rl_env_and_dataset(
        dataset_name="kitchen-complete-v0",
        max_episode_steps=280,
        ref_max_score=4.0,
        ref_min_score=0.0,
    )

    # Whole dataset with undirected demonstrations. A subset of the
    # demonstrations solve the task.
    register_d4rl_env_and_dataset(
        dataset_name="kitchen-partial-v0",
        max_episode_steps=280,
        ref_max_score=4.0,
        ref_min_score=0.0,
    )

    # Whole dataset with undirected demonstrations. No demonstration completely
    # solves the task, but each demonstration partially solves different
    # components of the task.
    register_d4rl_env_and_dataset(
        dataset_name="kitchen-mixed-v0",
        max_episode_steps=280,
        ref_max_score=4.0,
        ref_min_score=0.0,
    )
