from dataclasses import dataclass

from offline import base
from offline.utils.parser import ArgumentParser


@dataclass(frozen=True)
class Arguments(base.Arguments):
    batch_size: int
    bc_steps: int
    deterministic: bool
    ensemble_size: int
    gamma: float
    hidden_features: int
    layer_norm: bool
    learning_rate: float
    num_layers: int
    ood_probability: float
    tau: float
    update_every: int
    v_learning_steps: int


def build_argument_parser(parser: ArgumentParser | None = None, **kwargs):
    if parser is None:
        parser = base.build_argument_parser(**kwargs)

    parser.add_argument("--batch-size", type=int, default=256)
    parser.add_argument("--bc-steps", type=int, default=500000)
    parser.add_argument("--deterministic", action="store_true")
    parser.add_argument("--ensemble-size", type=int, default=4)
    parser.add_argument("--gamma", type=float, default=0.99)
    parser.add_argument("--hidden-features", type=int, default=256)
    parser.add_argument("--learning-rate", type=float, default=3e-4)
    parser.add_argument(
        "--no-layer-norm", action="store_false", dest="layer_norm"
    )
    parser.add_argument("--num-layers", type=int, default=4)
    parser.add_argument("--ood-probability", type=float, default=0.5)
    parser.add_argument("--tau", type=float, default=0.005)
    parser.add_argument("--update-every", type=int, default=2)
    parser.add_argument("--v-learning-steps", type=int, default=500000)
    parser.set_defaults(unsquash=True)
    return parser
