from typing import NamedTuple

from offline.types import BoolArray, FloatArray


class ActorBatch(NamedTuple):
    means: FloatArray
    observations: FloatArray
    stds: FloatArray


class QLearningBatch(NamedTuple):
    actions: FloatArray
    dones: BoolArray
    next_means: FloatArray
    next_observations: FloatArray
    next_stds: FloatArray
    next_values: FloatArray
    observations: FloatArray
    rewards: FloatArray
