from typing import NamedTuple

from offline.types import BoolArray, FloatArray, IntArray


class ActorBatch(NamedTuple):
    mask: BoolArray
    means: FloatArray
    observations: FloatArray


class AssignmentBatch(NamedTuple):
    assignments: IntArray
    observations: FloatArray


class QLearningBatch(NamedTuple):
    actions: FloatArray
    dones: BoolArray
    mask: BoolArray
    next_mask: BoolArray
    next_means: FloatArray
    next_observations: FloatArray
    observations: FloatArray
    rewards: FloatArray


class RegularizerBatch(NamedTuple):
    assignments: IntArray
    baseline: FloatArray
    mask: BoolArray
    means: FloatArray
    observations: FloatArray
    stds: FloatArray


class SaBatch(NamedTuple):
    actions: FloatArray
    assignments: IntArray
    observations: FloatArray


class VLearningBatch(NamedTuple):
    assignments: IntArray
    observations: FloatArray
    targets: FloatArray


class TCBatch(NamedTuple):
    actions: FloatArray
    observations: FloatArray
    rewards: FloatArray
