from typing import NamedTuple

from offline.types import BoolArray, FloatArray


class ActorBatch(NamedTuple):
    means: FloatArray
    observations: FloatArray


class QLearningBatch(NamedTuple):
    actions: FloatArray
    dones: BoolArray
    next_means: FloatArray
    next_observations: FloatArray
    observations: FloatArray
    rewards: FloatArray


class RegularizerBatch(NamedTuple):
    baseline: FloatArray
    means: FloatArray
    observations: FloatArray
    stds: FloatArray
