from dataclasses import dataclass

from offline import base
from offline.utils.parser import ArgumentParser


@dataclass(frozen=True)
class Arguments(base.Arguments):
    alpha: float
    batch_size: int
    bc_steps: int
    constant_schedule: bool
    ensemble_size: int
    gamma: float
    hidden_features: int
    layer_norm: bool
    learning_rate: float
    max_gradient_norm: float
    num_layers: int
    regularizer_weight: float
    sample_std: float
    tau: float
    update_every: int


def build_argument_parser(parser: ArgumentParser | None = None, **kwargs):
    if parser is None:
        parser = base.build_argument_parser(**kwargs)

    parser.add_argument("--alpha", type=float, default=2.5)
    parser.add_argument("--batch-size", type=int, default=256)
    parser.add_argument("--bc-steps", type=int, default=100000)
    parser.add_argument(
        "--cosine-schedule", action="store_false", dest="constant_schedule"
    )
    parser.add_argument("--ensemble-size", type=int, default=4)
    parser.add_argument("--gamma", type=float, default=0.99)
    parser.add_argument("--hidden-features", type=int, default=256)
    parser.add_argument("--learning-rate", type=float, default=3e-4)
    parser.add_argument("--max-gradient-norm", type=float, default=1)
    parser.add_argument(
        "--no-layer-norm", action="store_false", dest="layer_norm"
    )
    parser.add_argument("--num-layers", type=int, default=4)
    parser.add_argument("--regularizer-weight", type=float, default=0.001)
    parser.add_argument("--sample-std", type=float, default=0.2)
    parser.add_argument("--tau", type=float, default=0.005)
    parser.add_argument("--update-every", type=int, default=2)
    parser.set_defaults(normalize_rewards=False, unsquash=False)
    return parser
