from pathlib import Path
import subprocess
import sys


ROOT = Path(__file__).parents[2]


def run_command(*args, text=True, **kwargs):
    return subprocess.check_output(
        ("git", "-C", str(ROOT)) + args, text=text, **kwargs
    )


def get_unstaged_changes():
    output = run_command("status", "-s")
    return output.split()[1::2]


def get_sha():
    output = run_command("rev-parse", "HEAD")
    return output.strip()


def check_dirty_and_get_sha():
    unstaged_changes = get_unstaged_changes()
    if unstaged_changes:
        print("The following changes are not staged:")
        for changes in unstaged_changes:
            print(f"  {changes}")
        user_input = input("Proceed (y/[n])? ")
        if user_input.lower() != "y":
            sys.exit(1)
    return unstaged_changes, get_sha()


if __name__ == "__main__":
    print(check_dirty_and_get_sha())
