from argparse import Namespace
from collections.abc import Callable
import random
from typing import Any, TypeVar

import numpy.random as npr
import tensorflow as tf


T = TypeVar("T")


def assert_argument_validity(args: Namespace, key: str, value: Any):
    if getattr(args, key) != value:
        raise ValueError(f"Command line argument {key} must be {value}.")


def robustify(type_: Callable[[Any], T]) -> Callable[[Any], T | None]:
    return lambda x: None if x is None else type_(x)


def set_seed(seed: int) -> None:
    random.seed(seed)
    npr.seed(seed)
    tf.random.set_seed(seed)
