from contextlib import redirect_stderr, redirect_stdout
from os import devnull
from warnings import catch_warnings, filterwarnings

import absl.logging
from gymnasium import logger

with catch_warnings():
    filterwarnings("ignore", category=DeprecationWarning)
    filterwarnings("ignore", category=UserWarning, module="pygame.pkgdata")

    try:
        import mujoco_py
    except ImportError:
        pass
    with open(devnull, "w", encoding="utf-8") as devnullfile:
        with redirect_stderr(devnullfile):
            try:
                import gym
                import d4rl  # register d4rl envs
            except ImportError:
                pass
        with redirect_stdout(devnullfile):
            try:
                import pygame
            except ImportError:
                pass


__all__ = ["d4rl", "gym", "mujoco_py", "pygame"]


def suppress_absl_warnings():
    absl.logging.set_verbosity(absl.logging.ERROR)


def suppress_gymnasium_warnings():
    logger.min_level = logger.ERROR
