#!/bin/bash

display_usage() {
    echo "$0" [REPEAT] -m [MODULE] [OPTIONS]...
}

ROOT=$(date "+multiruns %F %H:%M:%S.%N")

if [ "$#" == 0 ]
then
    python mkdir.py $ROOT
    exit 0
fi

if [ "$#" -lt 3 ] || [ "$2" != "-m" ]
then
    display_usage
    exit 1
fi

REPEAT="$1"
MODULE="$3"
OPTIONS="${@:4}"

seed=0
while [ $seed -lt "$REPEAT" ]
do
    if python -m "$MODULE" --seed "$seed" --root $ROOT "$seed" $OPTIONS
    then
        seed=$(("$seed" + 1))
    else
        rm -rfv ${ROOT// /\/}
        exit 1
    fi
done
