## Datasets
- For MNIST Nearest Neighbor experiment, use `utils/generate_mnist.py` to generate 3 digit MNIST data
- For FashionMNIST/SIFT experiments, download the data from https://ann-benchmarks.com/index.html#datasets
- For CAIDA experiments you need to request access to the data here: https://www.caida.org/catalog/datasets/passive_dataset/
- All other experiments generate data from the code (see `utils/data_gen.py`)

## Running Experiment

The majority of nearest neighbor experiments (aside from MNIST) are run from the `nn.py` file. 

To run an experiment, e.g., NN search on the 1D uniform distribution, run the following:

`python nn.py --input_distribution_type uniform --dim 1 --max_queries 5 --n_inputs 50 `

To run the MNIST experiment:

`python nn_mnist.py `

## Running Frequency Estimation Experiments
To run a frequency estimation experiment:

`python freq_estimation.py `

## Credits
The NanoGPT code is taken from https://github.com/karpathy/nanoGPT

The Performer (Linear Attention) code is taken from https://github.com/lucidrains/performer-pytorch