# Version & Code

## version

- python                  3.10.13    

- brainpy                  2.4.6.post5

- brainpylib-cu11x         0.2.2

- jax                      0.4.23

- jaxlib                   0.4.23+cuda11.cudnn8

- numpy                    1.24.1

- torch                    2.1.2+cu118

  

## code

- config.py: Parameter settings for all networks, including Fashion MNIST, CIFAR10, DeepMind Lab, Google Street, MNIST-rot and TaxiBJ with different number of layers.
- tpcn.py: Network model architecture, based on brainpy.
- main.py: Network running on Fashion MNIST and CIFAR10 datasets. The selection of different states represents different running stages.
- main_lab.py: Network running on DeepMind Lab. The selection of different states represents different running stages.
- main_street.py: Network running on Google Street. The selection of different states represents different running stages.
- collect_street_view: Select different longitudes, latitudes and perspectives to generate Google Street datasets.
- main_rio.py: Network running on MNIST-rot. The selection of different states represents different running stages.
- main_taxi.py: Network running on TaxiBJ. The selection of different states represents different running stages.