# `op-ds`: Code for the Paper "Operator Deep Smoothing for Implied Volatility"

This repository contains the codebase used to produce the results for the submitted paper "Operator Deep Smoothing for Implied Volatility".
It contains `op_ds`, which contains a generic implementation of the graph neural operator suitable *operator deep smoothing*, a discretization-invariant data interpolation method, as well as the folder `volatility_smoothing`, which contains the code files used to produce the results for volatility smoothing presented in Section 4 (and Appendix) of the paper.

## Installation

Simply pip-install from the directory root in editable mode.
```
>>> pip install -e .
```

## Structure of `volatility_smoothing`

Our results are produced in the Jupyter notebooks contained in `volatility_smoothing` folder.
In particular:

* The training of the GNO is performed in `train.ipynb` from `volatility_smoothing/train`
* The evaluation (and finetuning) of the GNO for the smoothing task is performed in `eval.ipynb` from `volatility_smoothing/eval`
* The production of the SVI benchmark is performed in `benchmark_svi.ipynb` from `volatility_smoothing/benchmark`

The results of individual runs of these notebooks are placed into folder called `store` next to the respective notebook file.
We include the results of the final runs used to produce our results, but strip them of all files that would lead to identification of authors (log files) as well as files exposing the proprietary data (file dumps used for benchmarking).

All plots and tables are produced from the notebooks in `volatility_smoothing/plots`

## Data

The CBOE S&P 500 intraday training data we use is proprietary and we cannot include it.
It should reside in the `volatility_smoothing/data/cboe`, and be separated into a subfolders `train`, `dev`, `test_01` through `test_12`, according to the txt-files in `volatility_smoothing/data/cboe/split`.
Each file should be named according to `CBOEOptionsDataset_YYYY-mm-dd-HH-MM-SS.pt` and have the columns explained in `data/fields.json`.
For WRDS data check the README-files inside `volatility_smoothing/data/wrds`.
For more details inspect the `OptionsDataset` class in `volatility_smoothing/utils/options_data.py`.




