set -e
set -o pipefail

export CUDA_VISIBLE_DEVICES=0

MODEL_PATH=all-mpnet-base-v2

DATA_DIR=data
TRAIN_SETS="['UltraFeedback/Skywork-Reward-Gemma-2-27B-v0.2']"
TEST_SETS="['AlpacaEval', 'ArenaHard', 'MT-Bench', 'GSM8k', 'MATH', 'HumanEval', 'MBPP']"
CANDIDATE_LLMS="['Yi-1.5-34B-Chat', 'internlm2_5-20b-chat', 'Phi-3-medium-4k-instruct', 'Llama-3.1-8B-Instruct', 'Qwen2.5-Coder-7B-Instruct']"
BATCH_SIZE=128
K=100

model_name=$(basename $MODEL_PATH)
output_dir="output/baselines/${TRAIN_SETS//\//-}_${TRAIN_SLICE}/${model_name}/${K}NN_${model_name}"
output_dir=$(echo "$output_dir" | sed 's/ /-/g')

mkdir -p $output_dir
cp "$0" $output_dir/train.sh

python src/eval_baseline.py \
    --router_type knn \
    --candidate_llms "$CANDIDATE_LLMS" \
    --data_dir $DATA_DIR \
    --test_datasets "$TEST_SETS" \
    --output_dir $output_dir \
    --batch_size $BATCH_SIZE \
    --k $K \
    --train_datasets "$TRAIN_SETS" \
    --embedder $MODEL_PATH

