from dataclasses import dataclass

from tabicl.core.enums import GeneratorName, Task


@dataclass
class ConfigData():
    generator: GeneratorName
    min_samples_support: int
    max_samples_support: int
    n_samples_query: int
    min_features: int
    max_features: int
    max_classes: int
    generator_hyperparams: dict
    task: Task

    def __post_init__(self):

        assert self.min_samples_support <= self.max_samples_support
        assert self.min_features <= self.max_features
        
        match self.task:
            case Task.REGRESSION:
                assert self.max_classes == 0
            case Task.CLASSIFICATION:
                assert self.max_classes > 1
            case _:
                raise ValueError(f"Task {self.task} not supported")