from ExKMC.Tree import Tree
from sklearn.cluster import KMeans

def run(args, X):

    # create a tree that will partition the data into k clusters
    if args.max_leaves is None:
        max_leaves = 4*args.n_clusters
    else:
        max_leaves = args.max_leaves
    tree = Tree(args.n_clusters, max_leaves=max_leaves)

    # define a KMeans instance and feed it to the tree
    kmeans_base = KMeans(args.n_clusters)
    kmeans_base.fit(X)

    tree.fit(X, kmeans_base)

    return tree.predict(X), tree.tree